/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.TestLabels;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;

@DbmsExtension
@ExtendWith(value={RandomExtension.class})
class AllNodesInStoreExistInLabelIndexTest {
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    DatabaseManagementService managementService;
    @Inject
    GraphDatabaseAPI db;
    @Inject
    private Database database;
    @Inject
    private CheckPointer checkPointer;
    @Inject
    private RandomRule random;
    private final AssertableLogProvider log = new AssertableLogProvider();
    private static final Label[] LABEL_ALPHABET = new Label[]{TestLabels.LABEL_ONE, TestLabels.LABEL_TWO, TestLabels.LABEL_THREE};
    private static final Label EXTRA_LABEL = Label.label((String)"extra");
    private static final double DELETE_RATIO = 0.2;
    private static final double UPDATE_RATIO = 0.2;
    private static final int NODE_COUNT_BASELINE = 10;

    AllNodesInStoreExistInLabelIndexTest() {
    }

    @Test
    void mustReportSuccessfulForConsistentLabelScanStore() throws Exception {
        this.someData();
        this.managementService.shutdown();
        ConsistencyCheckService.Result result = this.fullConsistencyCheck();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)result.isSuccessful(), (String)"Expected consistency check to succeed");
    }

    @Test
    void reportNotCleanLabelIndex() throws IOException, ConsistencyCheckIncompleteException {
        DatabaseLayout databaseLayout = this.db.databaseLayout();
        this.someData();
        this.checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("forcedCheckpoint"));
        Path labelIndexFileCopy = databaseLayout.file("label_index_copy");
        FileUtils.copyFile((Path)databaseLayout.labelScanStore(), (Path)labelIndexFileCopy);
        try (Transaction tx = this.db.beginTx();){
            tx.createNode(new Label[]{TestLabels.LABEL_ONE});
            tx.commit();
        }
        this.managementService.shutdown();
        FileUtils.copyFile((Path)labelIndexFileCopy, (Path)databaseLayout.labelScanStore());
        ConsistencyCheckService.Result result = this.fullConsistencyCheck();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)result.isSuccessful(), (String)"Expected consistency check to fail");
        Assertions.assertThat((String)this.readReport(result)).contains(new CharSequence[]{"WARN  Index was dirty on startup which means it was not shutdown correctly and need to be cleaned up with a successful recovery."});
    }

    @Test
    void reportNotCleanLabelIndexWithCorrectData() throws IOException, ConsistencyCheckIncompleteException {
        DatabaseLayout databaseLayout = this.db.databaseLayout();
        this.someData();
        this.checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("forcedCheckpoint"));
        Path labelIndexFileCopy = databaseLayout.file("label_index_copy");
        FileUtils.copyFile((Path)databaseLayout.labelScanStore(), (Path)labelIndexFileCopy);
        this.managementService.shutdown();
        FileUtils.copyFile((Path)labelIndexFileCopy, (Path)databaseLayout.labelScanStore());
        ConsistencyCheckService.Result result = this.fullConsistencyCheck();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)result.isSuccessful(), (String)"Expected consistency check to fail");
        Assertions.assertThat((String)this.readReport(result)).contains(new CharSequence[]{"WARN  Index was dirty on startup which means it was not shutdown correctly and need to be cleaned up with a successful recovery."});
    }

    @Test
    void mustReportMissingNode() throws Exception {
        this.someData();
        Path labelIndexFileCopy = this.copyLabelIndexFile();
        try (Transaction tx = this.db.beginTx();){
            tx.createNode(new Label[]{TestLabels.LABEL_ONE});
            tx.commit();
        }
        this.replaceLabelIndexWithCopy(labelIndexFileCopy);
        ConsistencyCheckService.Result result = this.fullConsistencyCheck();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)result.isSuccessful(), (String)"Expected consistency check to fail");
    }

    @Test
    void mustReportMissingLabel() throws Exception {
        List<Pair<Long, Label[]>> nodesInStore = this.someData();
        Path labelIndexFileCopy = this.copyLabelIndexFile();
        try (Transaction tx = this.db.beginTx();){
            this.addLabelToExistingNode(tx, nodesInStore);
            tx.commit();
        }
        this.replaceLabelIndexWithCopy(labelIndexFileCopy);
        ConsistencyCheckService.Result result = this.fullConsistencyCheck();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)result.isSuccessful(), (String)"Expected consistency check to fail");
    }

    @Test
    void mustReportExtraLabelsOnExistingNode() throws Exception {
        List<Pair<Long, Label[]>> nodesInStore = this.someData();
        Path labelIndexFileCopy = this.copyLabelIndexFile();
        try (Transaction tx = this.db.beginTx();){
            this.removeLabelFromExistingNode(tx, nodesInStore);
            tx.commit();
        }
        this.replaceLabelIndexWithCopy(labelIndexFileCopy);
        ConsistencyCheckService.Result result = this.fullConsistencyCheck();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)result.isSuccessful(), (String)"Expected consistency check to fail");
    }

    @Test
    void mustReportExtraNode() throws Exception {
        List<Pair<Long, Label[]>> nodesInStore = this.someData();
        Path labelIndexFileCopy = this.copyLabelIndexFile();
        try (Transaction tx = this.db.beginTx();){
            this.removeExistingNode(tx, nodesInStore);
            tx.commit();
        }
        this.replaceLabelIndexWithCopy(labelIndexFileCopy);
        ConsistencyCheckService.Result result = this.fullConsistencyCheck();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)result.isSuccessful(), (String)"Expected consistency check to fail");
    }

    @Test
    void checkShouldBeSuccessfulIfNoNodeLabelIndexExist() throws ConsistencyCheckIncompleteException {
        try (Transaction tx = this.db.beginTx();){
            Iterable indexes = tx.schema().getIndexes();
            for (IndexDefinition index : indexes) {
                if (index.getIndexType() != IndexType.LOOKUP || !index.isNodeIndex()) continue;
                index.drop();
            }
            tx.commit();
        }
        this.someData();
        this.managementService.shutdown();
        ConsistencyCheckService.Result result = this.fullConsistencyCheck();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)result.isSuccessful(), (String)"Expected consistency check to succeed");
    }

    private String readReport(ConsistencyCheckService.Result result) throws IOException {
        return Files.readString(result.reportFile());
    }

    private void removeExistingNode(Transaction transaction, List<Pair<Long, Label[]>> nodesInStore) {
        Node node;
        Pair<Long, Label[]> existingNode;
        Label[] labels;
        do {
            int targetIndex = this.random.nextInt(nodesInStore.size());
            existingNode = nodesInStore.get(targetIndex);
            node = transaction.getNodeById(((Long)existingNode.first()).longValue());
        } while ((labels = (Label[])existingNode.other()).length == 0);
        node.delete();
    }

    private void addLabelToExistingNode(Transaction transaction, List<Pair<Long, Label[]>> nodesInStore) {
        int targetIndex = this.random.nextInt(nodesInStore.size());
        Pair<Long, Label[]> existingNode = nodesInStore.get(targetIndex);
        Node node = transaction.getNodeById(((Long)existingNode.first()).longValue());
        node.addLabel(EXTRA_LABEL);
    }

    private void removeLabelFromExistingNode(Transaction transaction, List<Pair<Long, Label[]>> nodesInStore) {
        Node node;
        Pair<Long, Label[]> existingNode;
        do {
            int targetIndex = this.random.nextInt(nodesInStore.size());
            existingNode = nodesInStore.get(targetIndex);
            node = transaction.getNodeById(((Long)existingNode.first()).longValue());
        } while (((Label[])existingNode.other()).length == 0);
        node.removeLabel(((Label[])existingNode.other())[0]);
    }

    private void replaceLabelIndexWithCopy(Path labelIndexFileCopy) throws IOException {
        this.managementService.shutdown();
        DatabaseLayout databaseLayout = this.db.databaseLayout();
        this.fs.deleteFile(databaseLayout.labelScanStore());
        this.fs.copyFile(labelIndexFileCopy, databaseLayout.labelScanStore());
    }

    private Path copyLabelIndexFile() throws IOException {
        DatabaseLayout databaseLayout = this.db.databaseLayout();
        Path labelIndexFileCopy = databaseLayout.file("label_index_copy");
        this.database.stop();
        this.fs.copyFile(databaseLayout.labelScanStore(), labelIndexFileCopy);
        this.database.start();
        return labelIndexFileCopy;
    }

    List<Pair<Long, Label[]>> someData() {
        return this.someData(50);
    }

    private List<Pair<Long, Label[]>> someData(int numberOfModifications) {
        ArrayList<Pair<Long, Label[]>> existingNodes = new ArrayList<Pair<Long, Label[]>>();
        try (Transaction tx = this.db.beginTx();){
            this.randomModifications(tx, existingNodes, numberOfModifications);
            tx.commit();
        }
        return existingNodes;
    }

    private void randomModifications(Transaction tx, List<Pair<Long, Label[]>> existingNodes, int numberOfModifications) {
        for (int i = 0; i < numberOfModifications; ++i) {
            double selectModification = this.random.nextDouble();
            if (existingNodes.size() < 10 || selectModification >= 0.4) {
                this.createNewNode(tx, existingNodes);
                continue;
            }
            if (selectModification < 0.2) {
                this.deleteExistingNode(tx, existingNodes);
                continue;
            }
            this.modifyLabelsOnExistingNode(tx, existingNodes);
        }
    }

    private void createNewNode(Transaction tx, List<Pair<Long, Label[]>> existingNodes) {
        Label[] labels = this.randomLabels();
        Node node = tx.createNode(labels);
        existingNodes.add((Pair<Long, Label[]>)Pair.of((Object)node.getId(), (Object)labels));
    }

    private void modifyLabelsOnExistingNode(Transaction transaction, List<Pair<Long, Label[]>> existingNodes) {
        Label[] newLabels;
        int targetIndex = this.random.nextInt(existingNodes.size());
        Pair<Long, Label[]> existingPair = existingNodes.get(targetIndex);
        long nodeId = (Long)existingPair.first();
        Node node = transaction.getNodeById(nodeId);
        node.getLabels().forEach(arg_0 -> ((Node)node).removeLabel(arg_0));
        for (Label label : newLabels = this.randomLabels()) {
            node.addLabel(label);
        }
        existingNodes.remove(targetIndex);
        existingNodes.add((Pair<Long, Label[]>)Pair.of((Object)nodeId, (Object)newLabels));
    }

    private void deleteExistingNode(Transaction transaction, List<Pair<Long, Label[]>> existingNodes) {
        int targetIndex = this.random.nextInt(existingNodes.size());
        Pair<Long, Label[]> existingPair = existingNodes.get(targetIndex);
        Node node = transaction.getNodeById(((Long)existingPair.first()).longValue());
        node.delete();
        existingNodes.remove(targetIndex);
    }

    private Label[] randomLabels() {
        ArrayList<Label> labels = new ArrayList<Label>(3);
        for (Label label : LABEL_ALPHABET) {
            if (!this.random.nextBoolean()) continue;
            labels.add(label);
        }
        return labels.toArray(new Label[0]);
    }

    Config addAdditionalConfigToCC(Config config) {
        return config;
    }

    ConsistencyCheckService.Result fullConsistencyCheck() throws ConsistencyCheckIncompleteException {
        ConsistencyCheckService service = new ConsistencyCheckService();
        DatabaseLayout databaseLayout = this.db.databaseLayout();
        Config config = Config.defaults((Setting)GraphDatabaseSettings.logs_directory, (Object)databaseLayout.databaseDirectory());
        return service.runFullConsistencyCheck(databaseLayout, this.addAdditionalConfigToCC(config), ProgressMonitorFactory.NONE, (LogProvider)this.log, false, ConsistencyFlags.DEFAULT);
    }
}

