/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.checking.GraphStoreFixture;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.mockito.mock.Property;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@TestDirectoryExtension
class SpecialisedIndexFullCheckTest {
    private static final String PROP1 = "key1";
    private static final String PROP2 = "key2";
    private static final String INDEXED_VALUE = "some text";
    private static final String ANOTHER_INDEXED_VALUE = "another piece of text";
    private static final int NOT_INDEXED_VALUE = 123;
    private final Map<Setting<?>, Object> settings = new HashMap();
    private GraphStoreFixture fixture;
    @Inject
    private TestDirectory testDirectory;

    SpecialisedIndexFullCheckTest() {
    }

    @BeforeEach
    protected void setUp() {
        this.fixture = this.createFixture();
    }

    @AfterEach
    void tearDown() {
        this.fixture.close();
    }

    @ParameterizedTest
    @EnumSource(value=IndexSize.class)
    void shouldReportNodesThatAreIndexedWhenTheyShouldNotBe(IndexSize indexSize) throws Exception {
        indexSize.createAdditionalData(this.fixture);
        long newNode = this.createOneNode();
        Iterator<IndexDescriptor> indexDescriptorIterator = this.getValueIndexDescriptors();
        while (indexDescriptorIterator.hasNext()) {
            IndexDescriptor indexDescriptor = indexDescriptorIterator.next();
            IndexAccessor accessor = this.fixture.indexAccessorLookup().apply(indexDescriptor);
            IndexUpdater updater = accessor.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);
            try {
                updater.process((IndexEntryUpdate)IndexEntryUpdate.add((long)newNode, (SchemaDescriptorSupplier)indexDescriptor, (Value[])this.values(indexDescriptor)));
            }
            finally {
                if (updater == null) continue;
                updater.close();
            }
        }
        ConsistencySummaryStatistics stats = this.check();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)stats.isConsistent());
        RecordType recordType = indexSize == IndexSize.SMALL_INDEX ? RecordType.INDEX : RecordType.NODE;
        Assertions.assertThat((int)stats.getInconsistencyCountForRecordType(recordType)).isEqualTo(2);
    }

    Value[] values(IndexDescriptor indexRule) {
        switch (indexRule.schema().getPropertyIds().length) {
            case 1: {
                return (Value[])Iterators.array((Object[])new Value[]{Values.of((Object)INDEXED_VALUE)});
            }
            case 2: {
                return (Value[])Iterators.array((Object[])new Value[]{Values.of((Object)INDEXED_VALUE), Values.of((Object)ANOTHER_INDEXED_VALUE)});
            }
        }
        throw new UnsupportedOperationException();
    }

    private Iterator<IndexDescriptor> getValueIndexDescriptors() {
        return Iterators.filter(descriptor -> !descriptor.isTokenIndex(), this.fixture.getIndexDescriptors());
    }

    private ConsistencySummaryStatistics check() throws ConsistencyCheckIncompleteException {
        this.fixture.close();
        Config config = Config.newBuilder().set(GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.homePath()).build();
        ConsistencyCheckService checkService = new ConsistencyCheckService();
        return checkService.runFullConsistencyCheck(Neo4jLayout.of((Config)config).databaseLayout("neo4j"), config, ProgressMonitorFactory.NONE, (LogProvider)NullLogProvider.getInstance(), false, ConsistencyFlags.DEFAULT).summary();
    }

    private GraphStoreFixture createFixture() {
        return new GraphStoreFixture("", this.testDirectory){

            @Override
            protected void generateInitialData(GraphDatabaseService db) {
                try (Transaction tx = db.beginTx();){
                    tx.schema().indexFor(Label.label((String)"Label1")).on(SpecialisedIndexFullCheckTest.PROP1).withIndexType(IndexType.FULLTEXT).create();
                    tx.schema().indexFor(Label.label((String)"Label1")).on(SpecialisedIndexFullCheckTest.PROP2).withIndexType(IndexType.FULLTEXT).create();
                    tx.commit();
                }
                tx = db.beginTx();
                try {
                    tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
                }
                finally {
                    if (tx != null) {
                        tx.close();
                    }
                }
                tx = db.beginTx();
                try {
                    Property.set((Entity)tx.createNode(new Label[]{Label.label((String)"Label1")}), (Property[])new Property[]{Property.property((String)SpecialisedIndexFullCheckTest.PROP1, (Object)SpecialisedIndexFullCheckTest.INDEXED_VALUE)});
                    Property.set((Entity)tx.createNode(new Label[]{Label.label((String)"Label1")}), (Property[])new Property[]{Property.property((String)SpecialisedIndexFullCheckTest.PROP1, (Object)SpecialisedIndexFullCheckTest.INDEXED_VALUE), Property.property((String)SpecialisedIndexFullCheckTest.PROP2, (Object)SpecialisedIndexFullCheckTest.ANOTHER_INDEXED_VALUE)});
                    Property.set((Entity)tx.createNode(new Label[]{Label.label((String)"Label1")}), (Property[])new Property[]{Property.property((String)SpecialisedIndexFullCheckTest.PROP1, (Object)123)});
                    Property.set((Entity)tx.createNode(new Label[]{Label.label((String)"AnotherLabel")}), (Property[])new Property[]{Property.property((String)SpecialisedIndexFullCheckTest.PROP1, (Object)SpecialisedIndexFullCheckTest.INDEXED_VALUE)});
                    Property.set((Entity)tx.createNode(new Label[]{Label.label((String)"Label1")}), (Property[])new Property[]{Property.property((String)"anotherProperty", (Object)SpecialisedIndexFullCheckTest.INDEXED_VALUE)});
                    tx.createNode();
                    tx.commit();
                }
                finally {
                    if (tx != null) {
                        tx.close();
                    }
                }
            }

            @Override
            protected Map<Setting<?>, Object> getConfig() {
                return SpecialisedIndexFullCheckTest.this.settings;
            }
        };
    }

    protected long createOneNode() {
        AtomicLong id = new AtomicLong();
        this.fixture.apply(tx -> id.set(tx.createNode().getId()));
        return id.get();
    }

    private static enum IndexSize {
        SMALL_INDEX{

            @Override
            public void createAdditionalData(GraphStoreFixture fixture) {
                fixture.apply(tx -> {
                    for (int i = 0; i < 80; ++i) {
                        tx.createNode();
                    }
                });
            }
        }
        ,
        LARGE_INDEX{

            @Override
            public void createAdditionalData(GraphStoreFixture fixture) {
            }
        };


        public abstract void createAdditionalData(GraphStoreFixture var1);
    }
}

