/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.checker.DebugContext;
import org.neo4j.consistency.checker.NodeBasedMemoryLimiter;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.consistency.checking.full.FullCheck;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.consistency.store.DirectStoreAccess;
import org.neo4j.counts.CountsStore;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.counts.RelationshipGroupDegreesStore;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.token.TokenHolders;

@TestDirectoryExtension
@ExtendWith(value={RandomExtension.class})
public class DetectAllRelationshipInconsistenciesIT {
    @Inject
    private TestDirectory directory;
    @Inject
    private RandomRule random;
    @Inject
    private DefaultFileSystemAbstraction fileSystem;
    private DatabaseManagementService managementService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldDetectSabotagedRelationshipWhereEverItIs() throws Exception {
        Sabotage sabotage;
        GraphDatabaseAPI db = this.getGraphDatabaseAPI();
        try {
            long additionalNodeId;
            Object[] nodes = new Node[1000];
            Object[] relationships = new Relationship[10000];
            try (Transaction tx = db.beginTx();){
                int i;
                for (i = 0; i < nodes.length; ++i) {
                    nodes[i] = tx.createNode(new Label[]{Label.label((String)"Foo")});
                }
                additionalNodeId = tx.createNode().getId();
                for (i = 0; i < 10000; ++i) {
                    relationships[i] = ((Node)this.random.among(nodes)).createRelationshipTo((Node)this.random.among(nodes), (RelationshipType)MyRelTypes.TEST);
                }
                tx.commit();
            }
            DependencyResolver resolver = db.getDependencyResolver();
            NeoStores neoStores = ((RecordStorageEngine)resolver.resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
            RelationshipStore relationshipStore = neoStores.getRelationshipStore();
            Relationship sabotagedRelationships = (Relationship)this.random.among(relationships);
            sabotage = this.sabotage(relationshipStore, sabotagedRelationships.getId(), additionalNodeId);
        }
        finally {
            this.managementService.shutdown();
        }
        db = this.getGraphDatabaseAPI();
        try {
            DependencyResolver resolver = db.getDependencyResolver();
            RecordStorageEngine storageEngine = (RecordStorageEngine)resolver.resolveDependency(RecordStorageEngine.class);
            NeoStores neoStores = storageEngine.testAccessNeoStores();
            CountsStore counts = (CountsStore)storageEngine.countsAccessor();
            RelationshipGroupDegreesStore groupDegreesStore = storageEngine.relationshipGroupDegreesStore();
            DirectStoreAccess directStoreAccess = new DirectStoreAccess(neoStores, (IndexProviderMap)db.getDependencyResolver().resolveDependency(IndexProviderMap.class), (TokenHolders)db.getDependencyResolver().resolveDependency(TokenHolders.class), (IndexStatisticsStore)db.getDependencyResolver().resolveDependency(IndexStatisticsStore.class), (IdGeneratorFactory)db.getDependencyResolver().resolveDependency(IdGeneratorFactory.class));
            int threads = this.random.intBetween(2, 10);
            FullCheck checker = new FullCheck(ProgressMonitorFactory.NONE, threads, ConsistencyFlags.DEFAULT, this.getTuningConfiguration(), DebugContext.NO_DEBUG, NodeBasedMemoryLimiter.DEFAULT);
            AssertableLogProvider logProvider = new AssertableLogProvider(true);
            ConsistencySummaryStatistics summary = checker.execute((PageCache)resolver.resolveDependency(PageCache.class), directStoreAccess, () -> counts, () -> groupDegreesStore, null, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE, logProvider.getLog(FullCheck.class));
            int relationshipInconsistencies = summary.getInconsistencyCountForRecordType(RecordType.RELATIONSHIP);
            Assertions.assertTrue((relationshipInconsistencies > 0 ? 1 : 0) != 0, (String)("Couldn't detect sabotaged relationship " + sabotage));
            LogAssertions.assertThat((AssertableLogProvider)logProvider).containsMessages(new String[]{sabotage.after.toString()});
        }
        finally {
            this.managementService.shutdown();
        }
    }

    private Config getTuningConfiguration() {
        return Config.newBuilder().set(GraphDatabaseSettings.pagecache_memory, (Object)"8m").set(this.getConfig()).build();
    }

    private GraphDatabaseAPI getGraphDatabaseAPI() {
        this.managementService = new TestDatabaseManagementServiceBuilder(this.directory.homePath()).setConfig(this.getConfig()).build();
        GraphDatabaseService database = this.managementService.database("neo4j");
        return (GraphDatabaseAPI)database;
    }

    protected String getRecordFormatName() {
        return "";
    }

    protected Map<Setting<?>, Object> getConfig() {
        return Map.of(GraphDatabaseSettings.record_format, this.getRecordFormatName());
    }

    private Sabotage sabotage(RelationshipStore store, long id, long lonelyNodeId) {
        RelationshipRecord before = (RelationshipRecord)store.getRecord(id, (AbstractBaseRecord)((RelationshipRecord)store.newRecord()), RecordLoad.NORMAL, CursorContext.NULL);
        RelationshipRecord after = before.copy();
        boolean sabotageSourceChain = this.random.nextBoolean();
        boolean sabotageNodeId = this.random.nextBoolean();
        long otherReference = Record.NULL_REFERENCE.longValue();
        if (sabotageNodeId) {
            boolean useLonelyNodeId = this.random.nextBoolean();
            if (sabotageSourceChain) {
                after.setFirstNode(useLonelyNodeId ? lonelyNodeId : after.getFirstNode() + 1L);
            } else {
                after.setSecondNode(useLonelyNodeId ? lonelyNodeId : after.getSecondNode() + 1L);
            }
        } else if (sabotageSourceChain) {
            if (!after.isFirstInFirstChain()) {
                otherReference = after.getFirstPrevRel() + 1L;
                after.setFirstPrevRel(otherReference);
            } else {
                otherReference = after.getFirstNextRel() + 1L;
                after.setFirstNextRel(otherReference);
            }
        } else if (!after.isFirstInSecondChain()) {
            otherReference = after.getSecondPrevRel() + 1L;
            after.setSecondPrevRel(otherReference);
        } else {
            otherReference = after.getSecondNextRel() + 1L;
            after.setSecondNextRel(otherReference);
        }
        store.prepareForCommit((AbstractBaseRecord)after, CursorContext.NULL);
        store.updateRecord((AbstractBaseRecord)after, CursorContext.NULL);
        RelationshipRecord other = Record.NULL_REFERENCE.is(otherReference) ? null : (RelationshipRecord)store.getRecord(otherReference, (AbstractBaseRecord)((RelationshipRecord)store.newRecord()), RecordLoad.FORCE, CursorContext.NULL);
        return new Sabotage(before, after, other);
    }

    private static class Sabotage {
        private final RelationshipRecord before;
        private final RelationshipRecord after;
        private final RelationshipRecord other;

        Sabotage(RelationshipRecord before, RelationshipRecord after, RelationshipRecord other) {
            this.before = before;
            this.after = after;
            this.other = other;
        }

        public String toString() {
            return "Sabotaged " + this.before + " --> " + this.after + ", other relationship " + this.other;
        }
    }
}

