/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checker;

import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.neo4j.consistency.checker.CheckerContext;
import org.neo4j.consistency.checker.CheckerTestBase;
import org.neo4j.consistency.checker.RelationshipChecker;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.helpers.collection.LongRange;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;

class RelationshipCheckerTest
extends CheckerTestBase {
    private int type;

    RelationshipCheckerTest() {
    }

    @Override
    void initialData(KernelTransaction tx) throws KernelException {
        this.type = tx.tokenWrite().relationshipTypeGetOrCreateForName("A");
    }

    @Test
    void shouldReportSourceNodeNotInUse() throws Exception {
        try (AutoCloseable ignored = this.tx();){
            long relationship = this.relationshipStore.nextId(CursorContext.NULL);
            long node = this.nodePlusCached(this.nodeStore.nextId(CursorContext.NULL), NULL, relationship, new int[0]);
            this.relationship(relationship, this.nodeStore.nextId(CursorContext.NULL), node, this.type, NULL, NULL, NULL, NULL, true, true);
        }
        this.check();
        this.expect(ConsistencyReport.RelationshipConsistencyReport.class, report -> report.sourceNodeNotInUse((NodeRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportTargetNodeNotInUse() throws Exception {
        try (AutoCloseable ignored = this.tx();){
            long relationship = this.relationshipStore.nextId(CursorContext.NULL);
            long node = this.nodePlusCached(this.nodeStore.nextId(CursorContext.NULL), NULL, relationship, new int[0]);
            this.relationship(relationship, node, this.nodeStore.nextId(CursorContext.NULL), this.type, NULL, NULL, NULL, NULL, true, true);
        }
        this.check();
        this.expect(ConsistencyReport.RelationshipConsistencyReport.class, report -> report.targetNodeNotInUse((NodeRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportSourceNodeNotInUseWhenAboveHighId() throws Exception {
        try (AutoCloseable ignored = this.tx();){
            long relationship = this.relationshipStore.nextId(CursorContext.NULL);
            long node = this.nodePlusCached(this.nodeStore.nextId(CursorContext.NULL), NULL, relationship, new int[0]);
            this.relationship(relationship, node + 10L, node, this.type, NULL, NULL, NULL, NULL, true, true);
        }
        this.check();
        this.expect(ConsistencyReport.RelationshipConsistencyReport.class, report -> report.sourceNodeNotInUse((NodeRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportTargetNodeNotInUseWhenAboveHighId() throws Exception {
        try (AutoCloseable ignored = this.tx();){
            long relationship = this.relationshipStore.nextId(CursorContext.NULL);
            long node = this.nodePlusCached(this.nodeStore.nextId(CursorContext.NULL), NULL, relationship, new int[0]);
            this.relationship(relationship, node, node + 10L, this.type, NULL, NULL, NULL, NULL, true, true);
        }
        this.check();
        this.expect(ConsistencyReport.RelationshipConsistencyReport.class, report -> report.targetNodeNotInUse((NodeRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportSourceNodeDoesNotReferenceBack() throws Exception {
        try (AutoCloseable ignored = this.tx();){
            long relationship = this.relationshipStore.nextId(CursorContext.NULL);
            long node1 = this.nodePlusCached(this.nodeStore.nextId(CursorContext.NULL), NULL, this.relationshipStore.nextId(CursorContext.NULL), new int[0]);
            long node2 = this.nodePlusCached(this.nodeStore.nextId(CursorContext.NULL), NULL, relationship, new int[0]);
            this.relationship(relationship, node1, node2, this.type, NULL, NULL, NULL, NULL, true, true);
        }
        this.check();
        this.expect(ConsistencyReport.RelationshipConsistencyReport.class, report -> report.sourceNodeDoesNotReferenceBack((NodeRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportTargetNodeDoesNotReferenceBack() throws Exception {
        try (AutoCloseable ignored = this.tx();){
            long relationship = this.relationshipStore.nextId(CursorContext.NULL);
            long node1 = this.nodePlusCached(this.nodeStore.nextId(CursorContext.NULL), NULL, relationship, new int[0]);
            long node2 = this.nodePlusCached(this.nodeStore.nextId(CursorContext.NULL), NULL, this.relationshipStore.nextId(CursorContext.NULL), new int[0]);
            this.relationship(relationship, node1, node2, this.type, NULL, NULL, NULL, NULL, true, true);
        }
        this.check();
        this.expect(ConsistencyReport.RelationshipConsistencyReport.class, report -> report.targetNodeDoesNotReferenceBack((NodeRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportRelationshipNotFirstInSourceChain() throws Exception {
        try (AutoCloseable ignored = this.tx();){
            long relationship = this.relationshipStore.nextId(CursorContext.NULL);
            long node1 = this.nodePlusCached(this.nodeStore.nextId(CursorContext.NULL), NULL, relationship, new int[0]);
            long node2 = this.nodePlusCached(this.nodeStore.nextId(CursorContext.NULL), NULL, relationship, new int[0]);
            this.relationship(relationship, node1, node2, this.type, NULL, NULL, NULL, NULL, false, true);
        }
        this.check();
        this.expect(ConsistencyReport.NodeConsistencyReport.class, report -> report.relationshipNotFirstInSourceChain((RelationshipRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportRelationshipNotFirstInTargetChain() throws Exception {
        try (AutoCloseable ignored = this.tx();){
            long relationship = this.relationshipStore.nextId(CursorContext.NULL);
            long node1 = this.nodePlusCached(this.nodeStore.nextId(CursorContext.NULL), NULL, relationship, new int[0]);
            long node2 = this.nodePlusCached(this.nodeStore.nextId(CursorContext.NULL), NULL, relationship, new int[0]);
            this.relationship(relationship, node1, node2, this.type, NULL, NULL, NULL, NULL, true, false);
        }
        this.check();
        this.expect(ConsistencyReport.NodeConsistencyReport.class, report -> report.relationshipNotFirstInTargetChain((RelationshipRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportSourceNodeHasNoRelationships() throws Exception {
        try (AutoCloseable ignored = this.tx();){
            long relationship = this.relationshipStore.nextId(CursorContext.NULL);
            long node1 = this.nodePlusCached(this.nodeStore.nextId(CursorContext.NULL), NULL, NULL, new int[0]);
            long node2 = this.nodePlusCached(this.nodeStore.nextId(CursorContext.NULL), NULL, relationship, new int[0]);
            this.relationship(relationship, node1, node2, this.type, NULL, NULL, NULL, NULL, true, true);
        }
        this.check();
        this.expect(ConsistencyReport.RelationshipConsistencyReport.class, report -> report.sourceNodeHasNoRelationships((NodeRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportTargetNodeHasNoRelationships() throws Exception {
        try (AutoCloseable ignored = this.tx();){
            long relationship = this.relationshipStore.nextId(CursorContext.NULL);
            long node1 = this.nodePlusCached(this.nodeStore.nextId(CursorContext.NULL), NULL, relationship, new int[0]);
            long node2 = this.nodePlusCached(this.nodeStore.nextId(CursorContext.NULL), NULL, NULL, new int[0]);
            this.relationship(relationship, node1, node2, this.type, NULL, NULL, NULL, NULL, true, true);
        }
        this.check();
        this.expect(ConsistencyReport.RelationshipConsistencyReport.class, report -> report.targetNodeHasNoRelationships((NodeRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportRelationshipTypeNotInUse() throws Exception {
        try (AutoCloseable ignored = this.tx();){
            long relationship = this.relationshipStore.nextId(CursorContext.NULL);
            long node1 = this.nodePlusCached(this.nodeStore.nextId(CursorContext.NULL), NULL, relationship, new int[0]);
            long node2 = this.nodePlusCached(this.nodeStore.nextId(CursorContext.NULL), NULL, relationship, new int[0]);
            this.relationship(relationship, node1, node2, this.type + 1, NULL, NULL, NULL, NULL, true, true);
        }
        this.check();
        this.expect(ConsistencyReport.RelationshipConsistencyReport.class, report -> report.relationshipTypeNotInUse((RelationshipTypeTokenRecord)ArgumentMatchers.any()));
    }

    private void check() throws Exception {
        this.check(this.context());
    }

    private void check(CheckerContext checkerContext) throws Exception {
        new RelationshipChecker(checkerContext, this.noMandatoryProperties).check(LongRange.range((long)0L, (long)this.nodeStore.getHighId()), true, true);
    }
}

