/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
public class FullCheckCompositeFusionIndex {
    @Inject
    TestDirectory dir;

    @Test
    void checkCompositeFusionIndexCorrectly() throws ConsistencyCheckIncompleteException {
        Label myLabel = Label.label((String)"myLabel");
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder().setDatabaseRootDirectory(this.dir.homePath()).build();
        GraphDatabaseService neo4j = managementService.database("neo4j");
        try (Transaction tx = neo4j.beginTx();){
            tx.execute("CREATE INDEX fusionIndex FOR (n:myLabel) ON (n.prop1, n.prop2) OPTIONS {indexProvider:'lucene+native-3.0'}");
            tx.commit();
        }
        tx = neo4j.beginTx();
        try {
            tx.schema().awaitIndexesOnline(5L, TimeUnit.MINUTES);
            Node node = tx.createNode(new Label[]{myLabel});
            node.setProperty("prop1", (Object)"hej");
            node.setProperty("prop2", (Object)"hi");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        managementService.shutdown();
        ConsistencyCheckService.Result result = this.runFullConsistencyCheck(this.dir.homePath());
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    private ConsistencyCheckService.Result runFullConsistencyCheck(Path path) throws ConsistencyCheckIncompleteException {
        Config config = Config.newBuilder().set(GraphDatabaseSettings.neo4j_home, (Object)path).build();
        ConsistencyCheckService checkService = new ConsistencyCheckService();
        return checkService.runFullConsistencyCheck(Neo4jLayout.of((Config)config).databaseLayout("neo4j"), config, ProgressMonitorFactory.NONE, (LogProvider)NullLogProvider.getInstance(), false, ConsistencyFlags.DEFAULT);
    }
}

