/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checker;

import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.factory.primitive.IntObjectMaps;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.common.DependencyResolver;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.consistency.LookupAccessorsFromRunningDb;
import org.neo4j.consistency.checker.CheckerContext;
import org.neo4j.consistency.checker.CountsState;
import org.neo4j.consistency.checker.DebugContext;
import org.neo4j.consistency.checker.NodeBasedMemoryLimiter;
import org.neo4j.consistency.checker.ParallelExecution;
import org.neo4j.consistency.checker.RecordLoading;
import org.neo4j.consistency.checker.RecordStorageConsistencyChecker;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.cache.CacheSlots;
import org.neo4j.consistency.checking.cache.DefaultCacheAccess;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.consistency.checking.index.IndexAccessors;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.report.ConsistencyReporter;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.consistency.report.InconsistencyLogger;
import org.neo4j.consistency.report.InconsistencyMessageLogger;
import org.neo4j.consistency.report.InconsistencyReport;
import org.neo4j.consistency.statistics.Counts;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.batchimport.cache.NumberArrayFactories;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.internal.recordstorage.SchemaStorage;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.store.InlineNodeLabels;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.KernelVersionRepository;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.token.TokenHolders;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@EphemeralTestDirectoryExtension
class CheckerTestBase {
    static final int NUMBER_OF_THREADS = 4;
    static final long NULL = Record.NULL_REFERENCE.longValue();
    static final int IDS_PER_CHUNK = 100;
    @Inject
    TestDirectory directory;
    MutableIntObjectMap<MutableIntSet> noMandatoryProperties = IntObjectMaps.mutable.empty();
    GraphDatabaseAPI db;
    NeoStores neoStores;
    NodeStore nodeStore;
    PropertyStore propertyStore;
    RelationshipGroupStore relationshipGroupStore;
    RelationshipStore relationshipStore;
    SchemaStore schemaStore;
    ConsistencyReporter reporter;
    ConsistencyReporter.Monitor monitor;
    SchemaStorage schemaStorage;
    private DatabaseManagementService dbms;
    private CheckerContext context;
    private CountsState countsState;
    private CacheAccess cacheAccess;
    private TokenHolders tokenHolders;
    private PageCache pageCache;

    CheckerTestBase() {
    }

    @BeforeEach
    void setUpDb() throws Exception {
        TestDatabaseManagementServiceBuilder builder = new TestDatabaseManagementServiceBuilder(this.directory.homePath());
        builder.setFileSystem(this.directory.getFileSystem());
        this.dbms = builder.build();
        this.db = (GraphDatabaseAPI)this.dbms.database("neo4j");
        Kernel kernel = (Kernel)this.db.getDependencyResolver().resolveDependency(Kernel.class);
        try (KernelTransaction tx = kernel.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);){
            this.initialData(tx);
            tx.commit();
        }
        DependencyResolver dependencies = this.db.getDependencyResolver();
        this.neoStores = ((RecordStorageEngine)dependencies.resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
        this.nodeStore = this.neoStores.getNodeStore();
        this.relationshipGroupStore = this.neoStores.getRelationshipGroupStore();
        this.propertyStore = this.neoStores.getPropertyStore();
        this.relationshipStore = this.neoStores.getRelationshipStore();
        this.schemaStore = this.neoStores.getSchemaStore();
        this.tokenHolders = (TokenHolders)dependencies.resolveDependency(TokenHolders.class);
        this.schemaStorage = new SchemaStorage(this.schemaStore, this.tokenHolders, (KernelVersionRepository)this.neoStores.getMetaDataStore());
        this.cacheAccess = new DefaultCacheAccess(NumberArrayFactories.HEAP.newDynamicByteArray(10000L, new byte[11], (MemoryTracker)EmptyMemoryTracker.INSTANCE), Counts.NONE, 4);
        this.cacheAccess.setCacheSlotSizes(RecordStorageConsistencyChecker.DEFAULT_SLOT_SIZES);
        this.pageCache = (PageCache)dependencies.resolveDependency(PageCache.class);
    }

    @AfterEach
    void tearDownDb() {
        this.countsState.close();
        this.dbms.shutdown();
    }

    IndexUpdater labelIndexWriter() {
        IndexProxy indexProxy;
        IndexingService indexingService = (IndexingService)this.db.getDependencyResolver().resolveDependency(IndexingService.class);
        IndexDescriptor[] indexDescriptors = this.schemaStorage.indexGetForSchema((SchemaDescriptorSupplier)SchemaDescriptor.forAnyEntityTokens((EntityType)EntityType.NODE), CursorContext.NULL);
        Assertions.assertThat((int)indexDescriptors.length).isEqualTo(1);
        IndexDescriptor nli = indexDescriptors[0];
        try {
            indexProxy = indexingService.getIndexProxy(nli);
        }
        catch (IndexNotFoundKernelException e) {
            throw new RuntimeException(e);
        }
        return indexProxy.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);
    }

    void initialData(KernelTransaction tx) throws KernelException {
    }

    CheckerContext context() throws Exception {
        return this.context(4, ConsistencyFlags.DEFAULT);
    }

    CheckerContext context(ConsistencyFlags consistencyFlags) throws Exception {
        return this.context(4, consistencyFlags);
    }

    CheckerContext context(int numberOfThreads) throws Exception {
        return this.context(numberOfThreads, ConsistencyFlags.DEFAULT);
    }

    CheckerContext context(int numberOfThreads, ConsistencyFlags consistencyFlags) throws Exception {
        if (this.context != null) {
            return this.context;
        }
        Config config = Config.defaults((Setting)GraphDatabaseSettings.neo4j_home, (Object)this.directory.homePath());
        DependencyResolver dependencies = this.db.getDependencyResolver();
        IndexProviderMap indexProviders = (IndexProviderMap)dependencies.resolveDependency(IndexProviderMap.class);
        IndexingService indexingService = (IndexingService)dependencies.resolveDependency(IndexingService.class);
        IndexAccessors indexAccessors = new IndexAccessors(indexProviders, this.neoStores, new IndexSamplingConfig(config), (IndexAccessors.IndexAccessorLookup)new LookupAccessorsFromRunningDb(indexingService), PageCacheTracer.NULL, (TokenNameLookup)this.tokenHolders, (KernelVersionRepository)this.neoStores.getMetaDataStore());
        ConsistencySummaryStatistics inconsistenciesSummary = new ConsistencySummaryStatistics();
        InconsistencyReport report = new InconsistencyReport((InconsistencyLogger)new InconsistencyMessageLogger((Log)NullLog.getInstance()), inconsistenciesSummary);
        this.monitor = (ConsistencyReporter.Monitor)Mockito.mock(ConsistencyReporter.Monitor.class);
        this.reporter = new ConsistencyReporter(report, this.monitor);
        this.countsState = new CountsState(this.neoStores, this.cacheAccess, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        NodeBasedMemoryLimiter limiter = new NodeBasedMemoryLimiter((long)this.pageCache.pageSize() * this.pageCache.maxCachedPages(), Runtime.getRuntime().maxMemory(), Long.MAX_VALUE, CacheSlots.CACHE_LINE_SIZE_BYTES, this.nodeStore.getHighId(), 1.0);
        ProgressMonitorFactory.MultiPartBuilder progress = ProgressMonitorFactory.NONE.multipleParts("Test");
        ParallelExecution execution = new ParallelExecution(numberOfThreads, ParallelExecution.NOOP_EXCEPTION_HANDLER, 100);
        this.context = new CheckerContext(this.neoStores, indexAccessors, execution, (ConsistencyReport.Reporter)this.reporter, this.cacheAccess, this.tokenHolders, new RecordLoading(this.neoStores), this.countsState, limiter, progress, this.pageCache, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE, DebugContext.NO_DEBUG, consistencyFlags);
        this.context.initialize();
        return this.context;
    }

    static Value stringValueOfLength(int length) {
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = (char)(97 + i % 10);
        }
        return Values.stringValue((String)String.valueOf(chars));
    }

    static Value intArrayValueOfLength(int length) {
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = Integer.MAX_VALUE - i;
        }
        return Values.intArray((int[])array);
    }

    static Value stringArrayValueOfLength(int stringLength, int arrayLength) {
        String[] array = new String[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            char c = (char)(97 + i % 20);
            array[i] = String.valueOf(c).repeat(stringLength);
        }
        return Values.stringArray((String[])array);
    }

    <T extends ConsistencyReport> void expect(Class<T> cls, Consumer<T> methodCall) {
        methodCall.accept((ConsistencyReport)Mockito.mock(cls, invocation -> {
            this.expect(cls, invocation.getMethod().getName());
            return null;
        }));
    }

    private void expect(Class<? extends ConsistencyReport> reportClass, String reportMethod) {
        ((ConsistencyReporter.Monitor)Mockito.verify((Object)this.monitor, (VerificationMode)Mockito.atLeastOnce())).reported((Class)ArgumentMatchers.eq(reportClass), (String)ArgumentMatchers.eq((Object)reportMethod), ArgumentMatchers.anyString());
    }

    long index(SchemaDescriptor descriptor) throws KernelException {
        long indexId;
        try (KernelTransaction tx = this.ktx();){
            IndexDescriptor index = tx.schemaWrite().indexCreate(descriptor, "the index");
            tx.commit();
            indexId = index.getId();
        }
        this.awaitIndexesOnline();
        return indexId;
    }

    long uniqueIndex(SchemaDescriptor descriptor) throws KernelException {
        long indexId;
        String constraintName = "me";
        try (KernelTransaction tx = this.ktx();){
            tx.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)descriptor).withName(constraintName));
            tx.commit();
        }
        tx = this.ktx();
        try {
            ConstraintDescriptor constraint = tx.schemaRead().constraintGetForName(constraintName);
            indexId = constraint.asUniquenessConstraint().ownedIndexId();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.awaitIndexesOnline();
        return indexId;
    }

    private void awaitIndexesOnline() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.commit();
        }
    }

    KernelTransaction ktx() throws TransactionFailureException {
        Kernel kernel = (Kernel)this.db.getDependencyResolver().resolveDependency(Kernel.class);
        return kernel.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);
    }

    AutoCloseable tx() throws TransactionFailureException {
        Kernel kernel = (Kernel)this.db.getDependencyResolver().resolveDependency(Kernel.class);
        KernelTransaction tx = kernel.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);
        return () -> {
            tx.commit();
            tx.close();
        };
    }

    PropertyBlock propertyValue(int propertyKey, Value value) {
        PropertyBlock propertyBlock = new PropertyBlock();
        this.neoStores.getPropertyStore().encodeValue(propertyBlock, propertyKey, value, CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        return propertyBlock;
    }

    long[] nodeLabels(NodeRecord node) {
        return NodeLabelsField.get((NodeRecord)node, (NodeStore)this.neoStores.getNodeStore(), (CursorContext)CursorContext.NULL);
    }

    NodeRecord loadNode(long id) {
        return (NodeRecord)this.neoStores.getNodeStore().getRecord(id, (AbstractBaseRecord)((NodeRecord)this.neoStores.getNodeStore().newRecord()), RecordLoad.NORMAL, CursorContext.NULL);
    }

    long node(long id, long nextProp, long nextRel, int ... labels) {
        NodeRecord node = new NodeRecord(id).initialize(true, nextProp, false, NULL, 0L);
        long[] labelIds = CheckerTestBase.toLongs(labels);
        InlineNodeLabels.putSorted((NodeRecord)node, (long[])labelIds, (NodeStore)this.nodeStore, null, (CursorContext)CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        this.nodeStore.updateRecord((AbstractBaseRecord)node, CursorContext.NULL);
        return id;
    }

    long relationship(long id, long startNode, long endNode, int type, long startPrev, long startNext, long endPrev, long endNext, boolean firstInStart, boolean firstInEnd) {
        RelationshipRecord relationship = new RelationshipRecord(id).initialize(true, NULL, startNode, endNode, type, startPrev, startNext, endPrev, endNext, firstInStart, firstInEnd);
        this.relationshipStore.updateRecord((AbstractBaseRecord)relationship, CursorContext.NULL);
        return id;
    }

    long relationshipGroup(long id, long next, long owningNode, int type, long firstOut, long firstIn, long firstLoop) {
        RelationshipGroupRecord group = new RelationshipGroupRecord(id).initialize(true, type, firstOut, firstIn, firstLoop, owningNode, next);
        this.relationshipGroupStore.updateRecord((AbstractBaseRecord)group, CursorContext.NULL);
        return id;
    }

    long nodePlusCached(long id, long nextProp, long nextRel, int ... labels) {
        long node = this.node(id, nextProp, NULL, labels);
        CacheAccess.Client client = this.cacheAccess.client();
        client.putToCacheSingle(id, 2, 1L);
        client.putToCacheSingle(id, 0, nextRel);
        return node;
    }

    static long[] toLongs(int[] ints) {
        long[] longs = new long[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            longs[i] = ints[i];
        }
        return longs;
    }

    protected void property(long id, long prev, long next, PropertyBlock ... properties) {
        PropertyRecord prop = new PropertyRecord(id).initialize(true, prev, next);
        for (PropertyBlock property : properties) {
            prop.addPropertyBlock(property);
        }
        this.propertyStore.updateRecord((AbstractBaseRecord)prop, CursorContext.NULL);
    }
}

