/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.LookupAccessorsFromRunningDb;
import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.checker.DebugContext;
import org.neo4j.consistency.checker.NodeBasedMemoryLimiter;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.consistency.checking.full.FullCheck;
import org.neo4j.consistency.checking.index.IndexAccessors;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.consistency.store.DirectStoreAccess;
import org.neo4j.counts.CountsAccessor;
import org.neo4j.counts.CountsStore;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.counts.RelationshipGroupDegreesStore;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.log4j.Log4jLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.Unzip;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.token.TokenHolders;

@TestDirectoryExtension
public class FullCheckTokenIndexIT {
    @Inject
    private TestDirectory testDirectory;
    private final ByteArrayOutputStream logStream = new ByteArrayOutputStream();
    private final Log4jLogProvider logProvider = new Log4jLogProvider((OutputStream)this.logStream);
    private DatabaseManagementService managementService;
    private Config config;

    @BeforeEach
    void setUp() {
        this.config = Config.newBuilder().set(GraphDatabaseSettings.allow_single_automatic_upgrade, (Object)false).set(GraphDatabaseSettings.allow_upgrade, (Object)true).set(GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.homePath()).build();
    }

    @AfterEach
    void tearDown() {
        if (this.managementService != null) {
            this.managementService.shutdown();
            this.managementService = null;
        }
    }

    @Test
    void shouldBeConsistentWithCompleteInjectedTokenIndex() throws Throwable {
        GraphDatabaseAPI database = this.createDatabaseOfOlderVersion();
        this.verifyInjectedNLIExistAndOnline(database);
        ConsistencySummaryStatistics check = this.check(database, this.config);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)check.isConsistent());
    }

    @Test
    void shouldBeInconsistentWithInjectedTokenIndexNotMatchingNodeStore() throws Throwable {
        GraphDatabaseAPI database = this.createDatabaseOfOlderVersion();
        this.verifyInjectedNLIExistAndOnline(database);
        this.updateNodeLabelIndex(database, IndexDescriptor.INJECTED_NLI);
        ConsistencySummaryStatistics check = this.check(database, this.config);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)check.isConsistent());
        Assertions.assertThat((String)this.logStream.toString()).contains(new CharSequence[]{"refers to a node record that is not in use"});
        Assertions.assertThat((long)check.getTotalInconsistencyCount()).isEqualTo(1L);
        Assertions.assertThat((int)check.getInconsistencyCountForRecordType(RecordType.LABEL_SCAN_DOCUMENT)).isEqualTo(1);
    }

    @Test
    void shouldBeConsistentWithCompletePersistedTokenIndex() throws Throwable {
        this.config.set(GraphDatabaseSettings.allow_single_automatic_upgrade, (Object)true);
        GraphDatabaseAPI database = this.createDatabaseOfOlderVersion();
        IndexDescriptor persistedNLI = IndexDescriptor.NLI_PROTOTYPE.materialise(1L);
        this.upgradeDatabase(database, persistedNLI);
        ConsistencySummaryStatistics check = this.check(database, this.config);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)check.isConsistent());
    }

    @Test
    void shouldBeInconsistentWithPersistedTokenIndexNotMatchingNodeStore() throws Throwable {
        this.config.set(GraphDatabaseSettings.allow_single_automatic_upgrade, (Object)true);
        GraphDatabaseAPI database = this.createDatabaseOfOlderVersion();
        IndexDescriptor persistedNLI = IndexDescriptor.NLI_PROTOTYPE.materialise(1L);
        this.upgradeDatabase(database, persistedNLI);
        this.updateNodeLabelIndex(database, persistedNLI);
        ConsistencySummaryStatistics check = this.check(database, this.config);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)check.isConsistent());
        Assertions.assertThat((String)this.logStream.toString()).contains(new CharSequence[]{"refers to a node record that is not in use"});
        Assertions.assertThat((long)check.getTotalInconsistencyCount()).isEqualTo(1L);
        Assertions.assertThat((int)check.getInconsistencyCountForRecordType(RecordType.LABEL_SCAN_DOCUMENT)).isEqualTo(1);
    }

    void updateNodeLabelIndex(GraphDatabaseAPI database, IndexDescriptor index) throws IOException, IndexEntryConflictException {
        DependencyResolver dependencyResolver = database.getDependencyResolver();
        IndexingService indexingService = (IndexingService)dependencyResolver.resolveDependency(IndexingService.class);
        LookupAccessorsFromRunningDb indexAccessorLookup = new LookupAccessorsFromRunningDb(indexingService);
        IndexAccessor accessor = indexAccessorLookup.apply(index);
        try (IndexUpdater indexUpdater = accessor.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);){
            indexUpdater.process((IndexEntryUpdate)IndexEntryUpdate.change((long)100L, (SchemaDescriptorSupplier)index, (long[])new long[0], (long[])new long[]{1L}));
        }
    }

    private void upgradeDatabase(GraphDatabaseAPI database, IndexDescriptor persistedNLI) {
        this.verifyInjectedNLIExistAndOnline(database);
        try (Transaction tx = database.beginTx();){
            tx.createNode();
            tx.commit();
        }
        this.verifyIndexExistAndOnline(database, persistedNLI);
    }

    private GraphDatabaseAPI createDatabaseOfOlderVersion() throws IOException {
        Unzip.unzip(this.getClass(), (String)"4-2-data-10-nodes-rels.zip", (Path)this.testDirectory.homePath());
        this.managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath()).setConfig(this.config).build();
        return (GraphDatabaseAPI)this.managementService.database("neo4j");
    }

    private ConsistencySummaryStatistics check(GraphDatabaseAPI database, Config config) throws ConsistencyCheckIncompleteException {
        DependencyResolver dependencyResolver = database.getDependencyResolver();
        RecordStorageEngine storageEngine = (RecordStorageEngine)dependencyResolver.resolveDependency(RecordStorageEngine.class);
        NeoStores neoStores = storageEngine.testAccessNeoStores();
        IndexingService indexingService = (IndexingService)dependencyResolver.resolveDependency(IndexingService.class);
        DirectStoreAccess directStoreAccess = new DirectStoreAccess(neoStores, (IndexProviderMap)dependencyResolver.resolveDependency(IndexProviderMap.class), (TokenHolders)dependencyResolver.resolveDependency(TokenHolders.class), (IndexStatisticsStore)dependencyResolver.resolveDependency(IndexStatisticsStore.class), (IdGeneratorFactory)dependencyResolver.resolveDependency(IdGeneratorFactory.class));
        CountsAccessor countsStore = storageEngine.countsAccessor();
        RelationshipGroupDegreesStore groupDegreesStore = storageEngine.relationshipGroupDegreesStore();
        PageCache pageCache = (PageCache)dependencyResolver.resolveDependency(PageCache.class);
        LookupAccessorsFromRunningDb indexAccessorLookup = new LookupAccessorsFromRunningDb(indexingService);
        FullCheck checker = new FullCheck(ProgressMonitorFactory.NONE, ConsistencyCheckService.defaultConsistencyCheckThreadsNumber(), ConsistencyFlags.DEFAULT, config, DebugContext.NO_DEBUG, NodeBasedMemoryLimiter.DEFAULT);
        return checker.execute(pageCache, directStoreAccess, () -> (CountsStore)countsStore, () -> groupDegreesStore, (IndexAccessors.IndexAccessorLookup)indexAccessorLookup, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.logProvider.getLog("test"));
    }

    private static void awaitIndexesOnline(GraphDatabaseAPI database) {
        try (Transaction transaction = database.beginTx();){
            transaction.schema().awaitIndexesOnline(10L, TimeUnit.MINUTES);
            transaction.commit();
        }
    }

    private void verifyInjectedNLIExistAndOnline(GraphDatabaseAPI db) {
        this.verifyIndexExistAndOnline(db, IndexDescriptor.INJECTED_NLI);
    }

    private void verifyIndexExistAndOnline(GraphDatabaseAPI db, IndexDescriptor index) {
        FullCheckTokenIndexIT.awaitIndexesOnline(db);
        try (Transaction tx = db.beginTx();){
            List indexes = StreamSupport.stream(tx.schema().getIndexes().spliterator(), false).map(IndexDefinitionImpl.class::cast).map(IndexDefinitionImpl::getIndexReference).collect(Collectors.toList());
            Assertions.assertThat(indexes).hasSize(1);
            Assertions.assertThat((Object)((IndexDescriptor)indexes.get(0))).isEqualTo((Object)index);
        }
    }
}

