/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checker;

import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.LookupAccessorsFromRunningDb;
import org.neo4j.consistency.checker.DebugContext;
import org.neo4j.consistency.checker.NodeBasedMemoryLimiter;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.consistency.checking.full.FullCheck;
import org.neo4j.consistency.checking.index.IndexAccessors;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.consistency.store.DirectStoreAccess;
import org.neo4j.counts.CountsAccessor;
import org.neo4j.counts.CountsStore;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.counts.RelationshipGroupDegreesStore;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryPools;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.time.Clocks;
import org.neo4j.token.TokenHolders;

@DbmsExtension
class IndexCheckingSelectorTest {
    private static final Label label1 = Label.label((String)"Label1");
    private static final String property1 = "property1";
    private final StringJoiner output = new StringJoiner(System.lineSeparator());
    private final DebugContext debugContext = new DebugContext(){

        public boolean debugEnabled() {
            return true;
        }

        public void debug(String message) {
            IndexCheckingSelectorTest.this.output.add(message);
        }
    };
    @Inject
    private DatabaseManagementService dbms;
    @Inject
    private GraphDatabaseService db;
    @Inject
    private DatabaseLayout layout;
    @Inject
    private PageCache pageCache;
    @Inject
    private IndexingService indexingService;
    @Inject
    private RecordStorageEngine recordStorageEngine;
    @Inject
    private IndexProviderMap indexProviderMap;
    @Inject
    private TokenHolders tokenHolders;
    @Inject
    private IndexStatisticsStore indexStatisticsStore;
    @Inject
    private IdGeneratorFactory idGeneratorFactory;
    @Inject
    private FileSystemAbstraction fs;

    IndexCheckingSelectorTest() {
    }

    @Test
    void checkLargeNodeIndexesWithIndexChecker() throws Exception {
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode(new Label[]{label1});
            node.setProperty(property1, (Object)"value");
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().indexFor(label1).on(property1).create();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.runConsistencyCheck();
        ((AbstractStringAssert)Assertions.assertThat((String)this.output.toString()).contains(new CharSequence[]{"IndexChecker[entityType:NODE,indexesToCheck:1]"})).containsPattern((CharSequence)"NodeChecker\\[highId:.,indexesToCheck:0\\]");
    }

    @Test
    void checkSmallNodeIndexesWithNodeChecker() throws Exception {
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode(new Label[]{label1});
            node.setProperty(property1, (Object)"value");
            for (int i = 0; i < 20; ++i) {
                tx.createNode();
            }
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().indexFor(label1).on(property1).create();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.runConsistencyCheck();
        ((AbstractStringAssert)Assertions.assertThat((String)this.output.toString()).contains(new CharSequence[]{"IndexChecker[entityType:NODE,indexesToCheck:0]"})).containsPattern((CharSequence)"NodeChecker\\[highId:..,indexesToCheck:1\\]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void checkIndexesWithoutValuesWithNodeChecker() throws Exception {
        ConsistencyCheckService.Result result;
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode(new Label[]{label1});
            node.setProperty(property1, (Object)"value");
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.execute("CREATE FULLTEXT INDEX FOR (n:Label1) ON EACH [n.property1]");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.dbms.shutdown();
        Config config = Config.defaults((Setting)GraphDatabaseSettings.logs_directory, (Object)this.layout.databaseDirectory());
        JobScheduler jobScheduler = JobSchedulerFactory.createInitialisedScheduler();
        ConfiguringPageCacheFactory pageCacheFactory = new ConfiguringPageCacheFactory(this.fs, config, PageCacheTracer.NULL, (Log)NullLog.getInstance(), jobScheduler, Clocks.nanoClock(), new MemoryPools(((Boolean)config.get(GraphDatabaseSettings.memory_tracking)).booleanValue()));
        PageCache pageCache = pageCacheFactory.getOrCreatePageCache();
        try {
            result = new ConsistencyCheckService().runFullConsistencyCheck(this.layout, config, ProgressMonitorFactory.NONE, (LogProvider)NullLogProvider.nullLogProvider(), this.fs, pageCache, this.debugContext, this.layout.databaseDirectory(), ConsistencyFlags.DEFAULT, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
        finally {
            pageCache.close();
            jobScheduler.close();
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)result.isSuccessful());
        ((AbstractStringAssert)Assertions.assertThat((String)this.output.toString()).contains(new CharSequence[]{"IndexChecker[entityType:NODE,indexesToCheck:1]"})).containsPattern((CharSequence)"NodeChecker\\[highId:.,indexesToCheck:0\\]");
    }

    @Test
    void checkAllRelationshipIndexesWithRelationshipChecker() throws ConsistencyCheckIncompleteException {
        RelationshipType relType1 = RelationshipType.withName((String)"RelType1");
        RelationshipType relType2 = RelationshipType.withName((String)"RelType2");
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode(new Label[]{label1});
            Relationship relationship = node.createRelationshipTo(node, relType1);
            relationship.setProperty(property1, (Object)"value");
            for (int i = 0; i < 20; ++i) {
                Node node2 = tx.createNode(new Label[]{label1});
                Relationship relationship2 = node2.createRelationshipTo(node2, relType2);
                relationship2.setProperty(property1, (Object)"value");
            }
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().indexFor(relType1).on(property1).create();
            tx.schema().indexFor(relType2).on(property1).create();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.runConsistencyCheck();
        Assertions.assertThat((String)this.output.toString()).containsPattern((CharSequence)"RelationshipChecker\\[highId:..,indexesToCheck:2\\]");
    }

    private void runConsistencyCheck() throws ConsistencyCheckIncompleteException {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.commit();
        }
        ConsistencySummaryStatistics result = this.checkIndex();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)result.isConsistent());
    }

    private ConsistencySummaryStatistics checkIndex() throws ConsistencyCheckIncompleteException {
        NeoStores neoStores = this.recordStorageEngine.testAccessNeoStores();
        DirectStoreAccess directStoreAccess = new DirectStoreAccess(neoStores, this.indexProviderMap, this.tokenHolders, this.indexStatisticsStore, this.idGeneratorFactory);
        CountsAccessor countsStore = this.recordStorageEngine.countsAccessor();
        RelationshipGroupDegreesStore groupDegreesStore = this.recordStorageEngine.relationshipGroupDegreesStore();
        LookupAccessorsFromRunningDb indexAccessorLookup = new LookupAccessorsFromRunningDb(this.indexingService);
        FullCheck checker = new FullCheck(ProgressMonitorFactory.NONE, ConsistencyCheckService.defaultConsistencyCheckThreadsNumber(), ConsistencyFlags.DEFAULT, Config.defaults(), this.debugContext, NodeBasedMemoryLimiter.DEFAULT);
        return checker.execute(this.pageCache, directStoreAccess, () -> (CountsStore)countsStore, () -> groupDegreesStore, (IndexAccessors.IndexAccessorLookup)indexAccessorLookup, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE, (Log)NullLog.getInstance());
    }
}

