/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.mutable.MutableInt;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.block.procedure.primitive.IntObjectProcedure;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.checker.DebugContext;
import org.neo4j.consistency.checker.NodeBasedMemoryLimiter;
import org.neo4j.consistency.checking.GraphStoreFixture;
import org.neo4j.consistency.checking.SchemaRuleUtil;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.consistency.checking.full.ExtendFailureMessageWatcher;
import org.neo4j.consistency.checking.full.FullCheck;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.consistency.store.DirectStoreAccess;
import org.neo4j.counts.CountsStore;
import org.neo4j.exceptions.KernelException;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.counts.RelationshipGroupDegreesStore;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.recordstorage.SchemaRuleAccess;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.internal.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.internal.schema.constraints.NodeKeyConstraintDescriptor;
import org.neo4j.internal.schema.constraints.UniquenessConstraintDescriptor;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.SchemaTestUtil;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;
import org.neo4j.kernel.impl.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.DynamicNodeLabels;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.DynamicStringStore;
import org.neo4j.kernel.impl.store.LabelIdArray;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.RelationshipTypeTokenStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.StandardDynamicRecordAllocator;
import org.neo4j.kernel.impl.store.allocator.ReusableRecordsAllocator;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.logging.log4j.Log4jLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.EntityTokenUpdate;
import org.neo4j.storageengine.api.EntityUpdates;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.string.UTF8;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.test.mockito.mock.Property;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.token.TokenHolders;
import org.neo4j.util.Bits;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@EphemeralTestDirectoryExtension
public class FullCheckIntegrationTest {
    private static final IndexProviderDescriptor DESCRIPTOR = GenericNativeIndexProvider.DESCRIPTOR;
    private static final String PROP1 = "key1";
    private static final String PROP2 = "key2";
    private static final Object VALUE1 = "value1";
    private static final Object VALUE2 = "value2";
    private final TokenNameLookup tokenNameLookup = SchemaTestUtil.SIMPLE_NAME_LOOKUP;
    @Inject
    private TestDirectory testDirectory;
    protected GraphStoreFixture fixture;
    private final ByteArrayOutputStream logStream = new ByteArrayOutputStream();
    private final Log4jLogProvider logProvider = new Log4jLogProvider((OutputStream)this.logStream);
    @RegisterExtension
    ExtendFailureMessageWatcher watcher = new ExtendFailureMessageWatcher(() -> String.format("%n%s%n", this.logStream.toString()));
    protected int label1;
    protected int label2;
    protected int label3;
    protected int draconian;
    protected int key1;
    protected int mandatory;
    protected int C;
    protected int T;
    protected int M;
    protected final List<Long> indexedNodes = new ArrayList<Long>();
    private final Map<Setting<?>, Object> settings = new HashMap();

    @BeforeEach
    protected void setUp() {
        this.fixture = this.createFixture();
    }

    @AfterEach
    void tearDown() {
        this.fixture.close();
    }

    @Test
    void shouldCheckConsistencyOfAConsistentStore() throws Exception {
        ConsistencySummaryStatistics result = this.check();
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)result.getTotalInconsistencyCount(), (String)result.toString());
    }

    @Test
    void shouldReportNodeInconsistencies() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                tx.create(new NodeRecord(next.node()).initialize(false, -1L, false, next.relationship(), 0L));
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.NODE, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportInlineNodeLabelInconsistencies() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                NodeRecord nodeRecord = new NodeRecord(next.node()).initialize(false, -1L, false, -1L, 0L);
                NodeLabelsField.parseLabelsField((NodeRecord)nodeRecord).add(10L, null, null, CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
                tx.create(nodeRecord);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.NODE, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportNodeDynamicLabelContainingUnknownLabelAsNodeInconsistency() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                NodeRecord nodeRecord = new NodeRecord(next.node()).initialize(false, -1L, false, -1L, 0L);
                DynamicRecord record = FullCheckIntegrationTest.inUse(new DynamicRecord(next.nodeLabel()));
                ArrayList newRecords = new ArrayList();
                DynamicArrayStore.allocateFromNumbers(newRecords, (Object)LabelIdArray.prependNodeId((long)nodeRecord.getId(), (long[])new long[]{42L}), (DynamicRecordAllocator)new ReusableRecordsAllocator(60, new DynamicRecord[]{record}), (CursorContext)CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
                nodeRecord.setLabelField(DynamicNodeLabels.dynamicPointer(newRecords), newRecords);
                tx.create(nodeRecord);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.NODE, 1).andThatsAllFolks();
    }

    @Test
    void shouldNotReportAnythingForNodeWithConsistentChainOfDynamicRecordsWithLabels() throws Exception {
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)((List)this.chainOfDynamicRecordsWithLabelsForANode(130).first()).size());
        ConsistencySummaryStatistics stats = this.check();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)stats.isConsistent(), (String)"should be consistent");
    }

    @Test
    void shouldReportLabelScanStoreInconsistencies() throws Exception {
        GraphStoreFixture.IdGenerator idGenerator = this.fixture.idGenerator();
        long nodeId1 = idGenerator.node();
        long labelId = idGenerator.label() - 1;
        Iterable nodeLabelUpdates = Iterables.asIterable((Object[])new EntityTokenUpdate[]{EntityTokenUpdate.tokenChanges((long)nodeId1, (long[])new long[0], (long[])new long[]{labelId})});
        this.writeToNodeLabelStructure(this.fixture, nodeLabelUpdates);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.LABEL_SCAN_DOCUMENT, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportRelationshipTypeIndexInconsistencies1() throws Exception {
        GraphStoreFixture.IdGenerator idGenerator = this.fixture.idGenerator();
        long relationshipId = idGenerator.relationship();
        long relationshipTypeId = idGenerator.relationshipType() - 1;
        IndexDescriptor rtiDescriptor = this.findTokenIndex(this.fixture, EntityType.RELATIONSHIP);
        IndexAccessor accessor = this.fixture.indexAccessorLookup().apply(rtiDescriptor);
        try (IndexUpdater indexUpdater = accessor.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);){
            indexUpdater.process((IndexEntryUpdate)IndexEntryUpdate.change((long)relationshipId, (SchemaDescriptorSupplier)rtiDescriptor, (long[])new long[0], (long[])new long[]{relationshipTypeId}));
        }
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.RELATIONSHIP_TYPE_SCAN_DOCUMENT, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportRelationshipTypeIndexInconsistencies2() throws Exception {
        RelationshipStore relationshipStore = this.fixture.directStoreAccess().nativeStores().getRelationshipStore();
        GraphStoreFixture.IdGenerator idGenerator = this.fixture.idGenerator();
        RelationshipRecord relationshipRecord = new RelationshipRecord(0L);
        long relationshipId = idGenerator.relationship() - 1L;
        relationshipStore.getRecord(relationshipId, (AbstractBaseRecord)relationshipRecord, RecordLoad.NORMAL, CursorContext.NULL);
        relationshipRecord.setType(relationshipRecord.getType() + 1);
        relationshipStore.updateRecord((AbstractBaseRecord)relationshipRecord, CursorContext.NULL);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.RELATIONSHIP_TYPE_SCAN_DOCUMENT, 2).verify(RecordType.COUNTS, 2).andThatsAllFolks();
    }

    private IndexDescriptor findTokenIndex(GraphStoreFixture fixture, EntityType entityType) {
        Iterator<IndexDescriptor> indexDescriptors = fixture.getIndexDescriptors();
        while (indexDescriptors.hasNext()) {
            IndexDescriptor next = indexDescriptors.next();
            if (!next.isTokenIndex() || next.schema().entityType() != entityType) continue;
            return next;
        }
        throw new RuntimeException(entityType + " index missing");
    }

    void writeToNodeLabelStructure(GraphStoreFixture fixture, Iterable<EntityTokenUpdate> entityTokenUpdates) throws IOException, IndexEntryConflictException {
        IndexDescriptor tokenIndex = this.findTokenIndex(fixture, EntityType.NODE);
        IndexAccessor accessor = fixture.indexAccessorLookup().apply(tokenIndex);
        try (IndexUpdater indexUpdater = accessor.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);){
            for (EntityTokenUpdate entityTokenUpdate : entityTokenUpdates) {
                indexUpdater.process((IndexEntryUpdate)IndexEntryUpdate.change((long)entityTokenUpdate.getEntityId(), (SchemaDescriptorSupplier)tokenIndex, (long[])entityTokenUpdate.getTokensBefore(), (long[])entityTokenUpdate.getTokensAfter()));
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=IndexSize.class)
    void shouldReportIndexInconsistencies(IndexSize indexSize) throws Exception {
        indexSize.createAdditionalData(this.fixture);
        for (Long indexedNodeId : this.indexedNodes) {
            this.fixture.directStoreAccess().nativeStores().getNodeStore().updateRecord((AbstractBaseRecord)FullCheckIntegrationTest.notInUse(new NodeRecord(indexedNodeId.longValue()).initialize(false, -1L, false, -1L, 0L)), CursorContext.NULL);
        }
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.INDEX, 3).verify(RecordType.LABEL_SCAN_DOCUMENT, 2).verify(RecordType.COUNTS, 2).andThatsAllFolks();
    }

    @Test
    void shouldNotReportIndexInconsistenciesIfIndexIsFailed() throws Exception {
        DirectStoreAccess storeAccess = this.fixture.directStoreAccess();
        Iterator<IndexDescriptor> rules = this.getValueIndexDescriptors();
        while (rules.hasNext()) {
            IndexDescriptor rule = rules.next();
            IndexSamplingConfig samplingConfig = new IndexSamplingConfig(Config.defaults());
            IndexPopulator populator = storeAccess.indexes().lookup(rule.getIndexProvider()).getPopulator(rule, samplingConfig, ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.tokenNameLookup);
            populator.markAsFailed("Oh noes! I was a shiny index and then I was failed");
            populator.close(false, CursorContext.NULL);
        }
        for (Long indexedNodeId : this.indexedNodes) {
            storeAccess.nativeStores().getNodeStore().updateRecord((AbstractBaseRecord)FullCheckIntegrationTest.notInUse(new NodeRecord(indexedNodeId.longValue()).initialize(false, -1L, false, -1L, 0L)), CursorContext.NULL);
        }
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.LABEL_SCAN_DOCUMENT, 2).verify(RecordType.COUNTS, 2).andThatsAllFolks();
    }

    @Test
    void shouldReportMismatchedLabels() throws Exception {
        final ArrayList labels = new ArrayList();
        final Pair<List<DynamicRecord>, List<Integer>> pair = this.chainOfDynamicRecordsWithLabelsForANode(3);
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                NodeRecord node = new NodeRecord(42L).initialize(false, -1L, false, -1L, 0L);
                node.setInUse(true);
                List dynamicRecords = (List)pair.first();
                labels.addAll((Collection)pair.other());
                node.setLabelField(DynamicNodeLabels.dynamicPointer((Collection)dynamicRecords), (Collection)dynamicRecords);
                tx.create(node);
            }
        });
        long[] before = this.asArray(labels);
        labels.remove(1);
        long[] after = this.asArray(labels);
        this.writeToNodeLabelStructure(this.fixture, Collections.singletonList(EntityTokenUpdate.tokenChanges((long)42L, (long[])before, (long[])after)));
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.LABEL_SCAN_DOCUMENT, 1).andThatsAllFolks();
    }

    private long[] asArray(List<? extends Number> in) {
        long[] longs = new long[in.size()];
        for (int i = 0; i < in.size(); ++i) {
            longs[i] = in.get(i).longValue();
        }
        return longs;
    }

    @Test
    void shouldReportMismatchedInlinedLabels() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                NodeRecord node = new NodeRecord(42L).initialize(false, -1L, false, -1L, 0L);
                node.setInUse(true);
                node.setLabelField(FullCheckIntegrationTest.this.inlinedLabelsLongRepresentation(FullCheckIntegrationTest.this.label1, FullCheckIntegrationTest.this.label2), Collections.emptySet());
                tx.create(node);
            }
        });
        EntityTokenUpdate update = EntityTokenUpdate.tokenChanges((long)42L, (long[])new long[]{this.label1, this.label2}, (long[])new long[]{this.label1});
        this.writeToNodeLabelStructure(this.fixture, Collections.singletonList(update));
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.LABEL_SCAN_DOCUMENT, 1).andThatsAllFolks();
    }

    @ParameterizedTest
    @EnumSource(value=IndexSize.class)
    void shouldReportNodesThatAreNotIndexed(IndexSize indexSize) throws Exception {
        indexSize.createAdditionalData(this.fixture);
        Iterator<IndexDescriptor> indexDescriptorIterator = this.getValueIndexDescriptors();
        while (indexDescriptorIterator.hasNext()) {
            IndexDescriptor indexDescriptor = indexDescriptorIterator.next();
            IndexAccessor accessor = this.fixture.indexAccessorLookup().apply(indexDescriptor);
            IndexUpdater updater = accessor.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);
            try {
                for (long nodeId : this.indexedNodes) {
                    EntityUpdates updates = this.fixture.nodeAsUpdates(nodeId);
                    for (IndexEntryUpdate update : updates.valueUpdatesForIndexKeys(Collections.singletonList(indexDescriptor))) {
                        updater.process((IndexEntryUpdate)IndexEntryUpdate.remove((long)nodeId, (SchemaDescriptorSupplier)indexDescriptor, (Value[])((ValueIndexEntryUpdate)update).values()));
                    }
                }
            }
            finally {
                if (updater == null) continue;
                updater.close();
            }
        }
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.NODE, 3).andThatsAllFolks();
    }

    @ParameterizedTest
    @EnumSource(value=IndexSize.class)
    void shouldReportNodesWithDuplicatePropertyValueInUniqueIndex(IndexSize indexSize) throws Exception {
        indexSize.createAdditionalData(this.fixture);
        Iterator<IndexDescriptor> indexRuleIterator = this.getValueIndexDescriptors();
        long nodeId = this.createOneNode();
        while (indexRuleIterator.hasNext()) {
            IndexDescriptor indexRule = indexRuleIterator.next();
            IndexAccessor accessor = this.fixture.indexAccessorLookup().apply(indexRule);
            try (IndexUpdater updater = accessor.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);){
                updater.process((IndexEntryUpdate)IndexEntryUpdate.add((long)nodeId, (SchemaDescriptorSupplier)indexRule.schema(), (Value[])this.values(indexRule)));
            }
            accessor.force(CursorContext.NULL);
        }
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.NODE, 1).verify(RecordType.INDEX, 3).andThatsAllFolks();
    }

    protected long createOneNode() {
        AtomicLong id = new AtomicLong();
        this.fixture.apply(tx -> id.set(tx.createNode().getId()));
        return id.get();
    }

    protected Value[] values(IndexDescriptor indexRule) {
        switch (indexRule.schema().getPropertyIds().length) {
            case 1: {
                return (Value[])Iterators.array((Object[])new Value[]{Values.of((Object)VALUE1)});
            }
            case 2: {
                return (Value[])Iterators.array((Object[])new Value[]{Values.of((Object)VALUE1), Values.of((Object)VALUE2)});
            }
        }
        throw new UnsupportedOperationException();
    }

    @Test
    void shouldReportMissingMandatoryNodeProperty() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                NodeRecord node = new NodeRecord(next.node()).initialize(false, next.property(), false, -1L, 0L);
                node.setInUse(true);
                node.setLabelField(FullCheckIntegrationTest.this.inlinedLabelsLongRepresentation(FullCheckIntegrationTest.this.draconian), Collections.emptySet());
                PropertyRecord property = new PropertyRecord(node.getNextProp(), (PrimitiveRecord)node);
                property.setInUse(true);
                PropertyBlock block = new PropertyBlock();
                block.setSingleBlock((long)FullCheckIntegrationTest.this.key1 | (long)PropertyType.INT.intValue() << 24 | 0x5390000000L);
                property.addPropertyBlock(block);
                tx.create(node);
                tx.create(property);
            }
        });
        this.createNodePropertyExistenceConstraint(this.draconian, this.mandatory);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.NODE, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportMissingMandatoryRelationshipProperty() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long nodeId1 = next.node();
                long nodeId2 = next.node();
                long relId = next.relationship();
                long propId = next.property();
                NodeRecord node1 = new NodeRecord(nodeId1).initialize(true, (long)Record.NO_NEXT_PROPERTY.intValue(), false, relId, (long)Record.NO_LABELS_FIELD.intValue());
                NodeRecord node2 = new NodeRecord(nodeId2).initialize(true, (long)Record.NO_NEXT_PROPERTY.intValue(), false, relId, (long)Record.NO_LABELS_FIELD.intValue());
                RelationshipRecord relationship = new RelationshipRecord(relId);
                relationship.initialize(true, 0L, nodeId1, nodeId2, FullCheckIntegrationTest.this.M, 1L, (long)Record.NO_NEXT_RELATIONSHIP.intValue(), 1L, (long)Record.NO_NEXT_RELATIONSHIP.intValue(), true, true);
                relationship.setNextProp(propId);
                PropertyRecord property = new PropertyRecord(propId, (PrimitiveRecord)relationship);
                property.setInUse(true);
                PropertyBlock block = new PropertyBlock();
                block.setSingleBlock((long)FullCheckIntegrationTest.this.key1 | (long)PropertyType.INT.intValue() << 24 | 0x5390000000L);
                property.addPropertyBlock(block);
                tx.create(node1);
                tx.create(node2);
                tx.create(relationship);
                tx.create(property);
                tx.incrementRelationshipCount(-1, -1, -1, 1L);
                tx.incrementRelationshipCount(-1, FullCheckIntegrationTest.this.M, -1, 1L);
            }
        });
        this.createRelationshipPropertyExistenceConstraint(this.M, this.mandatory);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.RELATIONSHIP, 1).andThatsAllFolks();
    }

    private long inlinedLabelsLongRepresentation(long ... labelIds) {
        long header = (long)labelIds.length << 36;
        byte bitsPerLabel = (byte)(36 / labelIds.length);
        Bits bits = Bits.bits((int)5);
        for (long labelId : labelIds) {
            bits.put(labelId, (int)bitsPerLabel);
        }
        return header | bits.getLongs()[0];
    }

    @Test
    void shouldReportCyclesInDynamicRecordsWithLabels() throws Exception {
        final List chain = (List)this.chainOfDynamicRecordsWithLabelsForANode(176).first();
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)chain.size(), (String)"number of records in chain");
        org.junit.jupiter.api.Assertions.assertEquals((int)((DynamicRecord)chain.get(0)).getLength(), (int)((DynamicRecord)chain.get(2)).getLength(), (String)"all records full");
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long nodeId = ((long[])DynamicArrayStore.getRightArray((Pair)AbstractDynamicStore.readFullByteArrayFromHeavyRecords((Iterable)chain, (PropertyType)PropertyType.ARRAY)).asObject())[0];
                NodeRecord before = FullCheckIntegrationTest.inUse(new NodeRecord(nodeId).initialize(false, -1L, false, -1L, 0L));
                NodeRecord after = FullCheckIntegrationTest.inUse(new NodeRecord(nodeId).initialize(false, -1L, false, -1L, 0L));
                DynamicRecord record1 = FullCheckIntegrationTest.this.cloneRecord((DynamicRecord)chain.get(0));
                DynamicRecord record2 = FullCheckIntegrationTest.this.cloneRecord((DynamicRecord)chain.get(1));
                DynamicRecord record3 = FullCheckIntegrationTest.this.cloneRecord((DynamicRecord)chain.get(2));
                record3.setNextBlock(record2.getId());
                before.setLabelField(DynamicNodeLabels.dynamicPointer((Collection)chain), (Collection)chain);
                after.setLabelField(DynamicNodeLabels.dynamicPointer((Collection)chain), Arrays.asList(record1, record2, record3));
                tx.update(before, after);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.NODE, 1).verify(RecordType.COUNTS, 176).andThatsAllFolks();
    }

    private Pair<List<DynamicRecord>, List<Integer>> chainOfDynamicRecordsWithLabelsForANode(int labelCount) throws KernelException {
        final long[] labels = new long[labelCount + 1];
        final ArrayList createdLabels = new ArrayList();
        int i = 1;
        while (i < labels.length) {
            final int offset = i++;
            this.fixture.apply(new GraphStoreFixture.Transaction(){

                @Override
                protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                    Integer label = next.label();
                    labels[offset] = label.intValue();
                    tx.nodeLabel((int)labels[offset], "label:" + offset, false);
                    createdLabels.add(label);
                }
            });
        }
        final ArrayList chain = new ArrayList();
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                NodeRecord nodeRecord = new NodeRecord(next.node()).initialize(false, -1L, false, -1L, 0L);
                DynamicRecord record1 = FullCheckIntegrationTest.inUse(new DynamicRecord(next.nodeLabel()));
                DynamicRecord record2 = FullCheckIntegrationTest.inUse(new DynamicRecord(next.nodeLabel()));
                DynamicRecord record3 = FullCheckIntegrationTest.inUse(new DynamicRecord(next.nodeLabel()));
                labels[0] = nodeRecord.getId();
                ReusableRecordsAllocator allocator = new ReusableRecordsAllocator(60, new DynamicRecord[]{record1, record2, record3});
                DynamicArrayStore.allocateFromNumbers((Collection)chain, (Object)labels, (DynamicRecordAllocator)allocator, (CursorContext)CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
                nodeRecord.setLabelField(DynamicNodeLabels.dynamicPointer((Collection)chain), (Collection)chain);
                tx.create(nodeRecord);
            }
        });
        return Pair.of(chain, createdLabels);
    }

    @Test
    void shouldReportNodeDynamicLabelContainingDuplicateLabelAsNodeInconsistency() throws Exception {
        final int nodeId = 1000;
        final ArrayList duplicatedLabel = new ArrayList();
        final Pair<List<DynamicRecord>, List<Integer>> labels = this.chainOfDynamicRecordsWithLabelsForANode(1);
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                NodeRecord node = new NodeRecord((long)nodeId).initialize(false, -1L, false, -1L, 0L);
                node.setInUse(true);
                List labelRecords = (List)labels.first();
                node.setLabelField(DynamicNodeLabels.dynamicPointer((Collection)labelRecords), (Collection)labelRecords);
                tx.create(node);
                Integer labelId = (Integer)((List)labels.other()).get(0);
                DynamicRecord record = FullCheckIntegrationTest.inUse(new DynamicRecord((long)labelId.intValue()));
                DynamicArrayStore.allocateFromNumbers((Collection)duplicatedLabel, (Object)new long[]{nodeId, labelId.intValue(), labelId.intValue()}, (DynamicRecordAllocator)new ReusableRecordsAllocator(60, new DynamicRecord[]{record}), (CursorContext)CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            }
        });
        NeoStores neoStores = this.fixture.directStoreAccess().nativeStores();
        NodeRecord nodeRecord = new NodeRecord((long)nodeId);
        neoStores.getNodeStore().getRecord((long)nodeId, (AbstractBaseRecord)nodeRecord, RecordLoad.FORCE, CursorContext.NULL);
        nodeRecord.setLabelField(DynamicNodeLabels.dynamicPointer(duplicatedLabel), duplicatedLabel);
        nodeRecord.setInUse(true);
        neoStores.getNodeStore().updateRecord((AbstractBaseRecord)nodeRecord, CursorContext.NULL);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.NODE, 1).verify(RecordType.COUNTS, 0).andThatsAllFolks();
    }

    @Test
    void shouldReportRelationshipInconsistencies() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                RelationshipRecord relationship = new RelationshipRecord(next.relationship());
                relationship.setLinks(1L, 2L, FullCheckIntegrationTest.this.C);
                tx.create(relationship);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.RELATIONSHIP, 2).verify(RecordType.COUNTS, 4).andThatsAllFolks();
    }

    @Test
    void shouldReportRelationshipOtherNodeInconsistencies() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long node1 = next.node();
                long node2 = next.node();
                long rel = next.relationship();
                RelationshipRecord relationship = new RelationshipRecord(rel);
                relationship.setLinks(node1, node2, 0);
                tx.create(FullCheckIntegrationTest.inUse(relationship));
                tx.create(FullCheckIntegrationTest.inUse(new NodeRecord(node1).initialize(false, -1L, false, rel + 1L, 0L)));
                tx.create(FullCheckIntegrationTest.inUse(new NodeRecord(node2).initialize(false, -1L, false, rel + 2L, 0L)));
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.RELATIONSHIP, 2).verify(RecordType.NODE, 2).verify(RecordType.COUNTS, 2).andThatsAllFolks();
    }

    @Test
    void shouldReportPropertyInconsistencies() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                NodeRecord node = new NodeRecord(next.node());
                PropertyRecord property = new PropertyRecord(next.property());
                node.setNextProp(property.getId());
                property.setNextProp(1000L);
                PropertyBlock block = new PropertyBlock();
                block.setSingleBlock((long)next.propertyKey() | (long)PropertyType.INT.intValue() << 24 | 0x29A0000000L);
                property.addPropertyBlock(block);
                tx.create(node);
                tx.create(property);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.PROPERTY, 2).verify(RecordType.NODE, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportStringPropertyInconsistencies() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                DynamicRecord string = new DynamicRecord(next.stringProperty());
                string.setInUse(true);
                string.setCreated();
                string.setType(PropertyType.STRING.intValue());
                string.setNextBlock(next.stringProperty());
                string.setData(UTF8.encode((String)"hello world"));
                PropertyBlock block = new PropertyBlock();
                block.setSingleBlock((long)PropertyType.STRING.intValue() << 24 | string.getId() << 28);
                block.addValueRecord(string);
                block.setKeyIndexId(FullCheckIntegrationTest.this.key1);
                PropertyRecord property = new PropertyRecord(next.property());
                property.addPropertyBlock(block);
                NodeRecord node = new NodeRecord(next.node());
                node.initialize(true, property.getId(), false, Record.NO_NEXT_RELATIONSHIP.longValue(), Record.NO_LABELS_FIELD.longValue());
                property.setNodeId(node.getId());
                tx.create(property);
                tx.create(node);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.STRING_PROPERTY, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportBrokenSchemaRecordChain() throws Exception {
        final AtomicReference descriptor = new AtomicReference();
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                SchemaRecord before = new SchemaRecord(next.schema());
                SchemaRecord after = FullCheckIntegrationTest.this.cloneRecord(before);
                after.initialize(true, next.property());
                IndexDescriptor rule = SchemaRuleUtil.indexRule((long)after.getId(), (int)FullCheckIntegrationTest.this.label1, (int)FullCheckIntegrationTest.this.key1, (IndexProviderDescriptor)DESCRIPTOR);
                rule = tx.completeConfiguration(rule);
                tx.createSchema(before, after, (SchemaRule)rule);
                descriptor.set(rule);
            }
        });
        this.fixture.indexingService().activateIndex((IndexDescriptor)descriptor.get());
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.SCHEMA, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportDuplicateConstraintReferences() throws Exception {
        final AtomicReference descriptor1 = new AtomicReference();
        final AtomicReference descriptor2 = new AtomicReference();
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) throws KernelException {
                int ruleId1 = (int)next.schema();
                int ruleId2 = (int)next.schema();
                int labelId = next.label();
                int propertyKeyId = next.propertyKey();
                SchemaRecord before1 = new SchemaRecord((long)ruleId1);
                SchemaRecord before2 = new SchemaRecord((long)ruleId2);
                SchemaRecord after1 = FullCheckIntegrationTest.this.cloneRecord(before1).initialize(true, 0L);
                SchemaRecord after2 = FullCheckIntegrationTest.this.cloneRecord(before2).initialize(true, 0L);
                IndexDescriptor rule1 = SchemaRuleUtil.constraintIndexRule((long)ruleId1, (int)labelId, (int)propertyKeyId, (IndexProviderDescriptor)DESCRIPTOR, (long)ruleId1);
                rule1 = tx.completeConfiguration(rule1);
                IndexDescriptor rule2 = SchemaRuleUtil.constraintIndexRule((long)ruleId2, (int)labelId, (int)propertyKeyId, (IndexProviderDescriptor)DESCRIPTOR, (long)ruleId1);
                rule2 = tx.completeConfiguration(rule2);
                FullCheckIntegrationTest.this.serializeRule((SchemaRule)rule1, after1, tx, next);
                FullCheckIntegrationTest.this.serializeRule((SchemaRule)rule2, after2, tx, next);
                tx.nodeLabel(labelId, "label", false);
                tx.propertyKey(propertyKeyId, "property", false);
                tx.createSchema(before1, after1, (SchemaRule)rule1);
                tx.createSchema(before2, after2, (SchemaRule)rule2);
                descriptor1.set(rule1);
                descriptor2.set(rule2);
            }
        });
        this.fixture.indexingService().activateIndex((IndexDescriptor)descriptor1.get());
        this.fixture.indexingService().activateIndex((IndexDescriptor)descriptor2.get());
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.SCHEMA, 4).andThatsAllFolks();
        String logContents = this.logStream.toString();
        Assertions.assertThat((String)logContents).contains(new CharSequence[]{((IndexDescriptor)descriptor1.get()).userDescription((TokenNameLookup)this.fixture.directStoreAccess().tokenHolders())});
        Assertions.assertThat((String)logContents).contains(new CharSequence[]{((IndexDescriptor)descriptor2.get()).userDescription((TokenNameLookup)this.fixture.directStoreAccess().tokenHolders())});
    }

    @Test
    void shouldReportInvalidConstraintBackReferences() throws Exception {
        final AtomicReference descriptor = new AtomicReference();
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) throws KernelException {
                int ruleId1 = (int)next.schema();
                int ruleId2 = (int)next.schema();
                int labelId = next.label();
                int propertyKeyId = next.propertyKey();
                SchemaRecord before1 = new SchemaRecord((long)ruleId1);
                SchemaRecord before2 = new SchemaRecord((long)ruleId2);
                SchemaRecord after1 = FullCheckIntegrationTest.this.cloneRecord(before1).initialize(true, 0L);
                SchemaRecord after2 = FullCheckIntegrationTest.this.cloneRecord(before2).initialize(true, 0L);
                IndexDescriptor rule1 = SchemaRuleUtil.constraintIndexRule((long)ruleId1, (int)labelId, (int)propertyKeyId, (IndexProviderDescriptor)DESCRIPTOR, (long)ruleId2);
                rule1 = tx.completeConfiguration(rule1);
                ConstraintDescriptor rule2 = SchemaRuleUtil.uniquenessConstraintRule((long)ruleId2, (int)labelId, (int)propertyKeyId, (long)ruleId2);
                FullCheckIntegrationTest.this.serializeRule((SchemaRule)rule1, after1, tx, next);
                FullCheckIntegrationTest.this.serializeRule((SchemaRule)rule2, after2, tx, next);
                tx.nodeLabel(labelId, "label", false);
                tx.propertyKey(propertyKeyId, "property", false);
                tx.createSchema(before1, after1, (SchemaRule)rule1);
                tx.createSchema(before2, after2, (SchemaRule)rule2);
                descriptor.set(rule1);
            }
        });
        this.fixture.indexingService().activateIndex((IndexDescriptor)descriptor.get());
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.SCHEMA, 2).andThatsAllFolks();
    }

    @Test
    void shouldReportArrayPropertyInconsistencies() throws Exception {
        final int recordDataSize = 116;
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, final GraphStoreFixture.IdGenerator next) {
                ArrayList allocatedRecords = new ArrayList();
                long[] arrayValue = new long[70];
                for (int i = 0; i < arrayValue.length; ++i) {
                    arrayValue[i] = i * 10000;
                }
                DynamicArrayStore.allocateRecords(allocatedRecords, (Object)arrayValue, (DynamicRecordAllocator)new DynamicRecordAllocator(){

                    public int getRecordDataSize() {
                        return recordDataSize;
                    }

                    public DynamicRecord nextRecord(CursorContext cursorContext) {
                        return StandardDynamicRecordAllocator.allocateRecord((long)next.arrayProperty());
                    }
                }, (boolean)true, (CursorContext)CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
                Assertions.assertThat((int)allocatedRecords.size()).isGreaterThan(1);
                DynamicRecord array = (DynamicRecord)allocatedRecords.get(0);
                array.setType(PropertyType.ARRAY.intValue());
                PropertyBlock block = new PropertyBlock();
                block.setSingleBlock((long)PropertyType.ARRAY.intValue() << 24 | array.getId() << 28);
                block.addValueRecord(array);
                block.setKeyIndexId(FullCheckIntegrationTest.this.key1);
                PropertyRecord property = new PropertyRecord(next.property());
                property.addPropertyBlock(block);
                NodeRecord node = new NodeRecord(next.node());
                node.initialize(true, property.getId(), false, Record.NO_NEXT_RELATIONSHIP.longValue(), Record.NO_LABELS_FIELD.longValue());
                property.setNodeId(node.getId());
                tx.create(property);
                tx.create(node);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.ARRAY_PROPERTY, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportRelationshipLabelNameInconsistencies() throws Exception {
        final Reference inconsistentName = new Reference();
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                inconsistentName.set(next.relationshipType());
                tx.relationshipType((Integer)inconsistentName.get(), "FOO", false);
            }
        });
        NeoStores neoStores = this.fixture.directStoreAccess().nativeStores();
        DynamicStringStore nameStore = neoStores.getRelationshipTypeTokenStore().getNameStore();
        DynamicRecord record = (DynamicRecord)nameStore.getRecord((long)((Integer)inconsistentName.get()).intValue(), (AbstractBaseRecord)((DynamicRecord)nameStore.newRecord()), RecordLoad.FORCE, CursorContext.NULL);
        record.setNextBlock(record.getId());
        nameStore.updateRecord((AbstractBaseRecord)record, CursorContext.NULL);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.RELATIONSHIP_TYPE_NAME, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportPropertyKeyNameInconsistencies() throws Exception {
        final Reference propertyKeyNameIds = new Reference();
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                int[] dynamicIds = tx.propertyKey(next.propertyKey(), "FOO", false);
                propertyKeyNameIds.set(dynamicIds);
            }
        });
        NeoStores neoStores = this.fixture.directStoreAccess().nativeStores();
        DynamicStringStore nameStore = neoStores.getPropertyKeyTokenStore().getNameStore();
        DynamicRecord record = (DynamicRecord)nameStore.getRecord((long)((int[])propertyKeyNameIds.get())[0], (AbstractBaseRecord)((DynamicRecord)nameStore.newRecord()), RecordLoad.FORCE, CursorContext.NULL);
        record.setNextBlock(record.getId());
        nameStore.updateRecord((AbstractBaseRecord)record, CursorContext.NULL);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.PROPERTY_KEY_NAME, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportRelationshipTypeInconsistencies() throws Exception {
        NeoStores neoStores = this.fixture.directStoreAccess().nativeStores();
        RelationshipTypeTokenStore relTypeStore = neoStores.getRelationshipTypeTokenStore();
        RelationshipTypeTokenRecord record = (RelationshipTypeTokenRecord)relTypeStore.getRecord((long)((int)relTypeStore.nextId(CursorContext.NULL)), (AbstractBaseRecord)((RelationshipTypeTokenRecord)relTypeStore.newRecord()), RecordLoad.FORCE, CursorContext.NULL);
        record.setNameId(20);
        record.setInUse(true);
        relTypeStore.updateRecord((AbstractBaseRecord)record, CursorContext.NULL);
        ConsistencySummaryStatistics stats = this.check();
        neoStores.close();
        FullCheckIntegrationTest.on(stats).verify(RecordType.RELATIONSHIP_TYPE, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportLabelInconsistencies() throws Exception {
        NeoStores neoStores = this.fixture.directStoreAccess().nativeStores();
        LabelTokenRecord record = (LabelTokenRecord)neoStores.getLabelTokenStore().getRecord(1L, (AbstractBaseRecord)((LabelTokenRecord)neoStores.getLabelTokenStore().newRecord()), RecordLoad.FORCE, CursorContext.NULL);
        record.setNameId(20);
        record.setInUse(true);
        neoStores.getLabelTokenStore().updateRecord((AbstractBaseRecord)record, CursorContext.NULL);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.LABEL, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportPropertyKeyInconsistencies() throws Exception {
        final Reference propertyKeyNameIds = new Reference();
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                int[] nameIds = tx.propertyKey(next.propertyKey(), "FOO", false);
                propertyKeyNameIds.set(nameIds);
            }
        });
        NeoStores neoStores = this.fixture.directStoreAccess().nativeStores();
        DynamicStringStore nameStore = neoStores.getPropertyKeyTokenStore().getNameStore();
        DynamicRecord record = (DynamicRecord)nameStore.getRecord((long)((int[])propertyKeyNameIds.get())[0], (AbstractBaseRecord)((DynamicRecord)nameStore.newRecord()), RecordLoad.FORCE, CursorContext.NULL);
        record.setInUse(false);
        nameStore.updateRecord((AbstractBaseRecord)record, CursorContext.NULL);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.PROPERTY_KEY, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportRelationshipGroupTypeInconsistencies() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long node = next.node();
                long group = next.relationshipGroup();
                int nonExistentType = next.relationshipType() + 1;
                tx.create(FullCheckIntegrationTest.inUse(new NodeRecord(node).initialize(false, (long)Record.NO_NEXT_PROPERTY.intValue(), true, group, 0L)));
                tx.create(FullCheckIntegrationTest.withOwner(FullCheckIntegrationTest.inUse(FullCheckIntegrationTest.relationshipGroupRecord(group, nonExistentType)), node));
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.RELATIONSHIP_GROUP, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportRelationshipGroupChainInconsistencies() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long node = next.node();
                long group = next.relationshipGroup();
                tx.create(FullCheckIntegrationTest.inUse(new NodeRecord(node).initialize(false, (long)Record.NO_NEXT_PROPERTY.intValue(), true, group, 0L)));
                tx.create(FullCheckIntegrationTest.withOwner(FullCheckIntegrationTest.withNext(FullCheckIntegrationTest.inUse(FullCheckIntegrationTest.relationshipGroupRecord(group, FullCheckIntegrationTest.this.C)), group + 1L), node));
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.RELATIONSHIP_GROUP, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportRelationshipGroupUnsortedChainInconsistencies() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long node = next.node();
                long firstGroupId = next.relationshipGroup();
                long otherGroupId = next.relationshipGroup();
                tx.create(FullCheckIntegrationTest.inUse(new NodeRecord(node).initialize(false, (long)Record.NO_NEXT_PROPERTY.intValue(), true, firstGroupId, 0L)));
                tx.create(FullCheckIntegrationTest.withOwner(FullCheckIntegrationTest.withNext(FullCheckIntegrationTest.inUse(FullCheckIntegrationTest.relationshipGroupRecord(firstGroupId, FullCheckIntegrationTest.this.T)), otherGroupId), node));
                tx.create(FullCheckIntegrationTest.withOwner(FullCheckIntegrationTest.inUse(FullCheckIntegrationTest.relationshipGroupRecord(otherGroupId, FullCheckIntegrationTest.this.C)), node));
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.RELATIONSHIP_GROUP, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportRelationshipGroupRelationshipNotInUseInconsistencies() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long node = next.node();
                long groupId = next.relationshipGroup();
                long rel = next.relationship();
                tx.create(FullCheckIntegrationTest.inUse(new NodeRecord(node).initialize(false, (long)Record.NO_NEXT_PROPERTY.intValue(), true, groupId, 0L)));
                tx.create(FullCheckIntegrationTest.withOwner(FullCheckIntegrationTest.withRelationships(FullCheckIntegrationTest.inUse(FullCheckIntegrationTest.relationshipGroupRecord(groupId, FullCheckIntegrationTest.this.C)), rel, rel, rel), node));
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.RELATIONSHIP_GROUP, 3).andThatsAllFolks();
    }

    @Test
    void shouldReportRelationshipGroupRelationshipNotFirstInconsistencies() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long node = next.node();
                long otherNode = next.node();
                long group = next.relationshipGroup();
                long relA = next.relationship();
                long relB = next.relationship();
                tx.create(FullCheckIntegrationTest.inUse(new NodeRecord(node).initialize(false, (long)Record.NO_NEXT_PROPERTY.intValue(), true, group, 0L)));
                tx.create(FullCheckIntegrationTest.inUse(new NodeRecord(otherNode).initialize(false, (long)Record.NO_NEXT_PROPERTY.intValue(), false, relA, 0L)));
                RelationshipRecord relationshipA = new RelationshipRecord(relA);
                relationshipA.setLinks(otherNode, node, FullCheckIntegrationTest.this.C);
                tx.create(FullCheckIntegrationTest.this.withNext(FullCheckIntegrationTest.inUse(relationshipA), relB));
                RelationshipRecord relationshipB = new RelationshipRecord(relB);
                relationshipB.setLinks(node, otherNode, FullCheckIntegrationTest.this.C);
                tx.create(FullCheckIntegrationTest.this.withPrev(FullCheckIntegrationTest.inUse(relationshipB), relA));
                tx.create(FullCheckIntegrationTest.withOwner(FullCheckIntegrationTest.withRelationships(FullCheckIntegrationTest.inUse(FullCheckIntegrationTest.relationshipGroupRecord(group, FullCheckIntegrationTest.this.C)), relB, relB, relB), node));
                tx.incrementRelationshipCount(-1, -1, -1, 2L);
                tx.incrementRelationshipCount(-1, FullCheckIntegrationTest.this.C, -1, 2L);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.RELATIONSHIP_GROUP, 3).andThatsAllFolks();
    }

    @Test
    void shouldReportFirstRelationshipGroupOwnerInconsistency() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long node = next.node();
                long otherNode = next.node();
                long group = next.relationshipGroup();
                tx.create(new NodeRecord(node).initialize(true, (long)Record.NO_NEXT_PROPERTY.intValue(), true, group, 0L));
                tx.create(new NodeRecord(otherNode).initialize(true, (long)Record.NO_NEXT_PROPERTY.intValue(), false, (long)Record.NO_NEXT_RELATIONSHIP.intValue(), 0L));
                tx.create(new RelationshipGroupRecord(group).initialize(true, FullCheckIntegrationTest.this.C, -1L, -1L, -1L, otherNode, -1L));
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.NODE, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportChainedRelationshipGroupOwnerInconsistency() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long node = next.node();
                long otherNode = next.node();
                long groupA = next.relationshipGroup();
                long groupB = next.relationshipGroup();
                tx.create(FullCheckIntegrationTest.inUse(new NodeRecord(node).initialize(false, (long)Record.NO_NEXT_PROPERTY.intValue(), true, groupA, 0L)));
                tx.create(FullCheckIntegrationTest.inUse(new NodeRecord(otherNode).initialize(false, (long)Record.NO_NEXT_PROPERTY.intValue(), false, (long)Record.NO_NEXT_RELATIONSHIP.intValue(), 0L)));
                tx.create(FullCheckIntegrationTest.withNext(FullCheckIntegrationTest.withOwner(FullCheckIntegrationTest.inUse(FullCheckIntegrationTest.relationshipGroupRecord(groupA, FullCheckIntegrationTest.this.C)), node), groupB));
                tx.create(FullCheckIntegrationTest.withOwner(FullCheckIntegrationTest.inUse(FullCheckIntegrationTest.relationshipGroupRecord(groupB, FullCheckIntegrationTest.this.T)), otherNode));
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.RELATIONSHIP_GROUP, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportRelationshipGroupOwnerNotInUse() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long node = next.node();
                long group = next.relationshipGroup();
                tx.create(FullCheckIntegrationTest.withOwner(FullCheckIntegrationTest.inUse(FullCheckIntegrationTest.relationshipGroupRecord(group, FullCheckIntegrationTest.this.C)), node));
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.RELATIONSHIP_GROUP, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportRelationshipGroupOwnerInvalidValue() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long group = next.relationshipGroup();
                tx.create(FullCheckIntegrationTest.withOwner(FullCheckIntegrationTest.inUse(FullCheckIntegrationTest.relationshipGroupRecord(group, FullCheckIntegrationTest.this.C)), -1L));
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.RELATIONSHIP_GROUP, 1).andThatsAllFolks();
    }

    private RelationshipRecord withNext(RelationshipRecord relationship, long next) {
        relationship.setFirstNextRel(next);
        relationship.setSecondNextRel(next);
        return relationship;
    }

    private RelationshipRecord withPrev(RelationshipRecord relationship, long prev) {
        relationship.setFirstInFirstChain(false);
        relationship.setFirstInSecondChain(false);
        relationship.setFirstPrevRel(prev);
        relationship.setSecondPrevRel(prev);
        return relationship;
    }

    @Test
    void shouldReportRelationshipGroupRelationshipOfOtherTypeInconsistencies() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long node = next.node();
                long otherNode = next.node();
                long group = next.relationshipGroup();
                long rel = next.relationship();
                tx.create(new NodeRecord(node).initialize(false, (long)Record.NO_NEXT_PROPERTY.intValue(), true, group, 0L));
                tx.create(new NodeRecord(otherNode).initialize(false, (long)Record.NO_NEXT_PROPERTY.intValue(), false, rel, 0L));
                RelationshipRecord relationship = new RelationshipRecord(rel);
                relationship.setLinks(node, otherNode, FullCheckIntegrationTest.this.T);
                tx.create(relationship);
                tx.create(FullCheckIntegrationTest.withOwner(FullCheckIntegrationTest.withRelationships(FullCheckIntegrationTest.relationshipGroupRecord(group, FullCheckIntegrationTest.this.C), rel, rel, rel), node));
                tx.incrementRelationshipCount(-1, -1, -1, 1L);
                tx.incrementRelationshipCount(-1, FullCheckIntegrationTest.this.T, -1, 1L);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.RELATIONSHIP_GROUP, 3).andThatsAllFolks();
    }

    @Test
    void shouldNotReportRelationshipGroupInconsistenciesForConsistentRecords() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long nodeA = next.node();
                long nodeB = next.node();
                long rel = next.relationship();
                long groupA = next.relationshipGroup();
                long groupB = next.relationshipGroup();
                tx.create(new NodeRecord(nodeA).initialize(false, (long)Record.NO_NEXT_PROPERTY.intValue(), true, groupA, 0L));
                tx.create(new NodeRecord(nodeB).initialize(false, (long)Record.NO_NEXT_PROPERTY.intValue(), false, rel, 0L));
                RelationshipRecord relationship = new RelationshipRecord(rel);
                relationship.setLinks(nodeA, nodeB, FullCheckIntegrationTest.this.C);
                tx.create(FullCheckIntegrationTest.firstInChains(relationship, 1));
                tx.incrementRelationshipCount(-1, -1, -1, 1L);
                tx.incrementRelationshipCount(-1, FullCheckIntegrationTest.this.C, -1, 1L);
                tx.create(FullCheckIntegrationTest.withOwner(FullCheckIntegrationTest.withRelationship(FullCheckIntegrationTest.withNext(FullCheckIntegrationTest.relationshipGroupRecord(groupA, FullCheckIntegrationTest.this.C), groupB), Direction.OUTGOING, rel), nodeA));
                tx.create(FullCheckIntegrationTest.withOwner(FullCheckIntegrationTest.relationshipGroupRecord(groupB, FullCheckIntegrationTest.this.T), nodeA));
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)stats.isConsistent(), (String)"should be consistent");
    }

    @Test
    void shouldReportWrongNodeCountsEntries() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                tx.incrementNodeCount(FullCheckIntegrationTest.this.label3, 1L);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.COUNTS, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportWrongRelationshipCountsEntries() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                tx.incrementRelationshipCount(FullCheckIntegrationTest.this.label1, FullCheckIntegrationTest.this.C, -1, 1L);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.COUNTS, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportIfSomeKeysAreMissing() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                tx.incrementNodeCount(FullCheckIntegrationTest.this.label3, -1L);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.COUNTS, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportIfThereAreExtraKeys() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                tx.incrementNodeCount(1024, 1L);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.COUNTS, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportDuplicatedIndexRules() throws Exception {
        int labelId = this.createLabel();
        int propertyKeyId = this.createPropertyKey();
        this.createIndexRule(labelId, propertyKeyId);
        this.createIndexRule(labelId, propertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.SCHEMA, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportDuplicatedCompositeIndexRules() throws Exception {
        int labelId = this.createLabel();
        int propertyKeyId1 = this.createPropertyKey("p1");
        int propertyKeyId2 = this.createPropertyKey("p2");
        int propertyKeyId3 = this.createPropertyKey("p3");
        this.createIndexRule(labelId, propertyKeyId1, propertyKeyId2, propertyKeyId3);
        this.createIndexRule(labelId, propertyKeyId1, propertyKeyId2, propertyKeyId3);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.SCHEMA, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportDuplicatedUniquenessConstraintRules() throws Exception {
        int labelId = this.createLabel();
        int propertyKeyId = this.createPropertyKey();
        this.createUniquenessConstraintRule(labelId, propertyKeyId);
        this.createUniquenessConstraintRule(labelId, propertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.SCHEMA, 2).andThatsAllFolks();
    }

    @Test
    void shouldReportDuplicatedCompositeUniquenessConstraintRules() throws Exception {
        int labelId = this.createLabel();
        int propertyKeyId1 = this.createPropertyKey("p1");
        int propertyKeyId2 = this.createPropertyKey("p2");
        this.createUniquenessConstraintRule(labelId, propertyKeyId1, propertyKeyId2);
        this.createUniquenessConstraintRule(labelId, propertyKeyId1, propertyKeyId2);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.SCHEMA, 2).andThatsAllFolks();
    }

    @Test
    void shouldReportDuplicatedNodeKeyConstraintRules() throws Exception {
        int labelId = this.createLabel();
        int propertyKeyId1 = this.createPropertyKey("p1");
        int propertyKeyId2 = this.createPropertyKey("p2");
        this.createNodeKeyConstraintRule(labelId, propertyKeyId1, propertyKeyId2);
        this.createNodeKeyConstraintRule(labelId, propertyKeyId1, propertyKeyId2);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.SCHEMA, 2).andThatsAllFolks();
    }

    @Test
    void shouldReportDuplicatedNodePropertyExistenceConstraintRules() throws Exception {
        int labelId = this.createLabel();
        int propertyKeyId = this.createPropertyKey();
        this.createNodePropertyExistenceConstraint(labelId, propertyKeyId);
        this.createNodePropertyExistenceConstraint(labelId, propertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.SCHEMA, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportDuplicatedRelationshipPropertyExistenceConstraintRules() throws Exception {
        int relTypeId = this.createRelType();
        int propertyKeyId = this.createPropertyKey();
        this.createRelationshipPropertyExistenceConstraint(relTypeId, propertyKeyId);
        this.createRelationshipPropertyExistenceConstraint(relTypeId, propertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.SCHEMA, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportInvalidLabelIdInIndexRule() throws Exception {
        int labelId = this.fixture.idGenerator().label();
        int propertyKeyId = this.createPropertyKey();
        this.createIndexRule(labelId, propertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.SCHEMA, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportInvalidLabelIdInUniquenessConstraintRule() throws Exception {
        int badLabelId = this.fixture.idGenerator().label();
        int propertyKeyId = this.createPropertyKey();
        this.createUniquenessConstraintRule(badLabelId, propertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.SCHEMA, 2).andThatsAllFolks();
    }

    @Test
    void shouldReportInvalidLabelIdInNodeKeyConstraintRule() throws Exception {
        int badLabelId = this.fixture.idGenerator().label();
        int propertyKeyId = this.createPropertyKey();
        this.createNodeKeyConstraintRule(badLabelId, propertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.SCHEMA, 2).andThatsAllFolks();
    }

    @Test
    void shouldReportInvalidLabelIdInNodePropertyExistenceConstraintRule() throws Exception {
        int badLabelId = this.fixture.idGenerator().label();
        int propertyKeyId = this.createPropertyKey();
        this.createNodePropertyExistenceConstraint(badLabelId, propertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.SCHEMA, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportInvalidPropertyKeyIdInIndexRule() throws Exception {
        int labelId = this.createLabel();
        int badPropertyKeyId = this.fixture.idGenerator().propertyKey();
        this.createIndexRule(labelId, badPropertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.SCHEMA, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportInvalidSecondPropertyKeyIdInIndexRule() throws Exception {
        int labelId = this.createLabel();
        int propertyKeyId = this.createPropertyKey();
        int badPropertyKeyId = this.fixture.idGenerator().propertyKey();
        this.createIndexRule(labelId, propertyKeyId, badPropertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.SCHEMA, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportInvalidPropertyKeyIdInUniquenessConstraintRule() throws Exception {
        int labelId = this.createLabel();
        int badPropertyKeyId = this.fixture.idGenerator().propertyKey();
        this.createUniquenessConstraintRule(labelId, badPropertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.SCHEMA, 2).andThatsAllFolks();
    }

    @Test
    void shouldReportInvalidSecondPropertyKeyIdInUniquenessConstraintRule() throws Exception {
        int labelId = this.createLabel();
        int propertyKeyId = this.createPropertyKey();
        int badPropertyKeyId = this.fixture.idGenerator().propertyKey();
        this.createUniquenessConstraintRule(labelId, propertyKeyId, badPropertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.SCHEMA, 2).andThatsAllFolks();
    }

    @Test
    void shouldReportInvalidSecondPropertyKeyIdInNodeKeyConstraintRule() throws Exception {
        int labelId = this.createLabel();
        int propertyKeyId = this.createPropertyKey();
        int badPropertyKeyId = this.fixture.idGenerator().propertyKey();
        this.createNodeKeyConstraintRule(labelId, propertyKeyId, badPropertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.SCHEMA, 2).andThatsAllFolks();
    }

    @Test
    void shouldReportInvalidPropertyKeyIdInNodePropertyExistenceConstraintRule() throws Exception {
        int labelId = this.createLabel();
        int badPropertyKeyId = this.fixture.idGenerator().propertyKey();
        this.createNodePropertyExistenceConstraint(labelId, badPropertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.SCHEMA, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportInvalidRelTypeIdInRelationshipPropertyExistenceConstraintRule() throws Exception {
        int badRelTypeId = this.fixture.idGenerator().relationshipType();
        int propertyKeyId = this.createPropertyKey();
        this.createRelationshipPropertyExistenceConstraint(badRelTypeId, propertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.SCHEMA, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportNothingForUniquenessAndPropertyExistenceConstraintOnSameLabelAndProperty() throws Exception {
        int labelId = this.createLabel();
        int propertyKeyId = this.createPropertyKey();
        this.createUniquenessConstraintRule(labelId, propertyKeyId);
        this.createNodePropertyExistenceConstraint(labelId, propertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)stats.isConsistent());
    }

    @Test
    void shouldReportNothingForNodeKeyAndPropertyExistenceConstraintOnSameLabelAndProperty() throws Exception {
        int labelId = this.createLabel();
        int propertyKeyId = this.createPropertyKey();
        this.createNodeKeyConstraintRule(labelId, propertyKeyId);
        this.createNodePropertyExistenceConstraint(labelId, propertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)stats.isConsistent());
    }

    @Test
    void shouldManageUnusedRecordsWithWeirdDataIn() throws Exception {
        final AtomicLong id = new AtomicLong();
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                id.set(next.relationship());
                RelationshipRecord relationship = new RelationshipRecord(id.get());
                relationship.setFirstNode(-1L);
                relationship.setSecondNode(-1L);
                relationship.setInUse(true);
                tx.create(relationship);
            }
        });
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                RelationshipRecord relationship = new RelationshipRecord(id.get());
                tx.delete(relationship);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)stats.isConsistent());
    }

    @Test
    void shouldReportCircularNodePropertyRecordChain() throws Exception {
        this.shouldReportCircularPropertyRecordChain(RecordType.NODE, (tx, next, propertyRecordId) -> tx.create(new NodeRecord(next.node()).initialize(true, propertyRecordId, false, -1L, Record.NO_LABELS_FIELD.longValue())));
    }

    @Test
    void shouldReportCircularRelationshipPropertyRecordChain() throws Exception {
        int relType = this.createRelType();
        this.shouldReportCircularPropertyRecordChain(RecordType.RELATIONSHIP, (tx, next, propertyRecordId) -> {
            long node = next.node();
            long relationship = next.relationship();
            tx.create(new NodeRecord(node).initialize(true, -1L, false, relationship, Record.NO_LABELS_FIELD.longValue()));
            RelationshipRecord relationshipRecord = new RelationshipRecord(relationship);
            relationshipRecord.setFirstNode(node);
            relationshipRecord.setSecondNode(node);
            relationshipRecord.setType(relType);
            relationshipRecord.setNextProp(propertyRecordId);
            tx.create(relationshipRecord);
        });
    }

    @Test
    void shouldOnlyReportFirstNodeInconsistencyOnFailFast() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                tx.create(new NodeRecord(next.node()).initialize(false, -1L, false, next.relationship(), 0L));
                tx.create(new NodeRecord(next.node()).initialize(false, -1L, false, next.relationship(), 0L));
            }
        });
        this.settings.put(GraphDatabaseInternalSettings.consistency_checker_fail_fast_threshold, 1);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.NODE, 1).andThatsAllFolks();
    }

    @Test
    void shouldOnlyReportFirstRelationshipInconsistenciesOnFailFast() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                RelationshipRecord relationshipA = new RelationshipRecord(next.relationship());
                relationshipA.setLinks(1L, 2L, FullCheckIntegrationTest.this.C);
                tx.create(relationshipA);
                RelationshipRecord relationshipB = new RelationshipRecord(next.relationship());
                relationshipB.setLinks(1L, 2L, FullCheckIntegrationTest.this.C);
                tx.create(relationshipB);
            }
        });
        this.settings.put(GraphDatabaseInternalSettings.consistency_checker_fail_fast_threshold, 1);
        ConsistencySummaryStatistics stats = this.check();
        int relationshipInconsistencies = stats.getInconsistencyCountForRecordType(RecordType.RELATIONSHIP);
        Assertions.assertThat((int)relationshipInconsistencies).isIn(new Object[]{1, 2});
        org.junit.jupiter.api.Assertions.assertEquals((long)stats.getTotalInconsistencyCount(), (long)relationshipInconsistencies);
    }

    @Test
    void shouldReportRelationshipGroupRelationshipDoesNotShareOwner() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long node = next.node();
                long otherNode = next.node();
                long group = next.relationshipGroup();
                long rel = next.relationship();
                tx.create(new NodeRecord(node).initialize(false, (long)Record.NO_NEXT_PROPERTY.intValue(), true, group, 0L));
                tx.create(new NodeRecord(otherNode).initialize(false, (long)Record.NO_NEXT_PROPERTY.intValue(), false, rel, 0L));
                RelationshipRecord relationship = new RelationshipRecord(rel);
                relationship.setLinks(otherNode, otherNode, FullCheckIntegrationTest.this.C);
                tx.create(relationship);
                tx.create(new RelationshipGroupRecord(group).initialize(false, FullCheckIntegrationTest.this.C, rel, rel, rel, node, Record.NULL_REFERENCE.longValue()));
                tx.incrementRelationshipCount(-1, -1, -1, 1L);
                tx.incrementRelationshipCount(-1, FullCheckIntegrationTest.this.C, -1, 1L);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.RELATIONSHIP_GROUP, 3).andThatsAllFolks();
    }

    @Test
    void shouldHandleNegativeRelationshipPointers() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long node = next.node();
                long otherNode = next.node();
                long rel = next.relationship();
                tx.create(new NodeRecord(node).initialize(false, (long)Record.NO_NEXT_PROPERTY.intValue(), false, rel, 0L));
                tx.create(new NodeRecord(otherNode).initialize(false, (long)Record.NO_NEXT_PROPERTY.intValue(), false, rel, 0L));
                RelationshipRecord relationship = new RelationshipRecord(rel);
                relationship.setLinks(node, otherNode, FullCheckIntegrationTest.this.C);
                relationship.setFirstNextRel(-3L);
                relationship.setFirstPrevRel(-4L);
                relationship.setSecondNextRel(-5L);
                relationship.setSecondPrevRel(-6L);
                tx.create(relationship);
                tx.incrementRelationshipCount(-1, -1, -1, 1L);
                tx.incrementRelationshipCount(-1, FullCheckIntegrationTest.this.C, -1, 1L);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.RELATIONSHIP, this.expectedNumberOfErrorsForNegativeRelationshipPointerInconsistency()).andThatsAllFolks();
    }

    protected int expectedNumberOfErrorsForNegativeRelationshipPointerInconsistency() {
        return 2;
    }

    @Test
    void shouldHandleNegativeNodeRelationshipPointer() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                tx.create(new NodeRecord(next.node()).initialize(false, (long)Record.NO_NEXT_PROPERTY.intValue(), false, -6L, 0L));
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.NODE, 1).andThatsAllFolks();
    }

    @Test
    void shouldHandleNegativeRelationshipNodePointers() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                RelationshipRecord relationship = new RelationshipRecord(next.relationship());
                relationship.setLinks(-2L, -3L, FullCheckIntegrationTest.this.C);
                tx.create(relationship);
                tx.incrementRelationshipCount(-1, -1, -1, 1L);
                tx.incrementRelationshipCount(-1, FullCheckIntegrationTest.this.C, -1, 1L);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.RELATIONSHIP, 2).andThatsAllFolks();
    }

    @Test
    void shouldDetectInvalidUseOfInternalPropertyKeyTokens() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                int propertyKey = next.propertyKey();
                tx.propertyKey(propertyKey, "FOO", true);
                long nextProp = next.property();
                PropertyRecord property = new PropertyRecord(nextProp).initialize(true, Record.NO_PREVIOUS_PROPERTY.longValue(), Record.NO_NEXT_PROPERTY.longValue());
                PropertyBlock block = new PropertyBlock();
                block.setSingleBlock((long)propertyKey | (long)PropertyType.INT.intValue() << 24 | 0x29A0000000L);
                property.addPropertyBlock(block);
                tx.create(property);
                tx.create(new NodeRecord(next.node()).initialize(true, nextProp, false, Record.NO_NEXT_RELATIONSHIP.longValue(), Record.NO_LABELS_FIELD.longValue()));
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)stats.isConsistent());
        FullCheckIntegrationTest.on(stats).verify(RecordType.PROPERTY, 1).andThatsAllFolks();
    }

    @Test
    void shouldDetectCutOffRelationshipGroupChains() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long nodeId = next.node();
                long group1Id = next.relationshipGroup();
                long group2Id = next.relationshipGroup();
                long group3Id = next.relationshipGroup();
                long group4Id = next.relationshipGroup();
                int type1 = next.relationshipType();
                int type2 = next.relationshipType();
                int type3 = next.relationshipType();
                int type4 = next.relationshipType();
                NodeRecord node = new NodeRecord(nodeId).initialize(true, Record.NULL_REFERENCE.longValue(), true, group1Id, Record.NO_LABELS_FIELD.longValue());
                RelationshipGroupRecord group1 = new RelationshipGroupRecord(group1Id).initialize(true, type1, Record.NULL_REFERENCE.longValue(), Record.NULL_REFERENCE.longValue(), Record.NULL_REFERENCE.longValue(), nodeId, group2Id);
                RelationshipGroupRecord group2 = new RelationshipGroupRecord(group2Id).initialize(true, type2, Record.NULL_REFERENCE.longValue(), Record.NULL_REFERENCE.longValue(), Record.NULL_REFERENCE.longValue(), nodeId, Record.NULL_REFERENCE.longValue());
                RelationshipGroupRecord group3 = new RelationshipGroupRecord(group3Id).initialize(true, type3, Record.NULL_REFERENCE.longValue(), Record.NULL_REFERENCE.longValue(), Record.NULL_REFERENCE.longValue(), nodeId, group4Id);
                RelationshipGroupRecord group4 = new RelationshipGroupRecord(group3Id).initialize(true, type4, Record.NULL_REFERENCE.longValue(), Record.NULL_REFERENCE.longValue(), Record.NULL_REFERENCE.longValue(), nodeId, Record.NULL_REFERENCE.longValue());
                tx.create(node);
                tx.relationshipType(type1, "T1", false);
                tx.relationshipType(type2, "T2", false);
                tx.relationshipType(type3, "T3", false);
                tx.relationshipType(type4, "T4", false);
                tx.create(group1);
                tx.create(group2);
                tx.create(group3);
                tx.create(group4);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)stats.isConsistent());
        FullCheckIntegrationTest.on(stats).verify(RecordType.RELATIONSHIP_GROUP, 1).andThatsAllFolks();
    }

    protected Map<Setting<?>, Object> getSettings() {
        return this.settings;
    }

    private GraphStoreFixture createFixture() {
        return new GraphStoreFixture(this.getRecordFormatName(), this.testDirectory){

            @Override
            protected void generateInitialData(GraphDatabaseService db) {
                Transaction tx;
                try {
                    tx = db.beginTx();
                    try {
                        KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
                        TokenWrite tokenWrite = ktx.tokenWrite();
                        FullCheckIntegrationTest.this.label1 = tokenWrite.labelGetOrCreateForName("label1");
                        FullCheckIntegrationTest.this.label2 = tokenWrite.labelGetOrCreateForName("label2");
                        FullCheckIntegrationTest.this.label3 = tokenWrite.labelGetOrCreateForName("label3");
                        tokenWrite.labelGetOrCreateForName("label4");
                        FullCheckIntegrationTest.this.draconian = tokenWrite.labelGetOrCreateForName("draconian");
                        FullCheckIntegrationTest.this.key1 = tokenWrite.propertyKeyGetOrCreateForName(FullCheckIntegrationTest.PROP1);
                        FullCheckIntegrationTest.this.mandatory = tokenWrite.propertyKeyGetOrCreateForName("mandatory");
                        FullCheckIntegrationTest.this.C = tokenWrite.relationshipTypeGetOrCreateForName("C");
                        FullCheckIntegrationTest.this.T = tokenWrite.relationshipTypeGetOrCreateForName("T");
                        FullCheckIntegrationTest.this.M = tokenWrite.relationshipTypeGetOrCreateForName("M");
                        tx.commit();
                    }
                    finally {
                        if (tx != null) {
                            tx.close();
                        }
                    }
                }
                catch (KernelException e) {
                    throw new RuntimeException(e);
                }
                tx = db.beginTx();
                try {
                    tx.schema().indexFor(Label.label((String)"label3")).on(FullCheckIntegrationTest.PROP1).create();
                    tx.schema().indexFor(Label.label((String)"label3")).on(FullCheckIntegrationTest.PROP1).on(FullCheckIntegrationTest.PROP2).create();
                    tx.schema().constraintFor(Label.label((String)"label4")).assertPropertyIsUnique(FullCheckIntegrationTest.PROP1).create();
                    tx.commit();
                }
                finally {
                    if (tx != null) {
                        tx.close();
                    }
                }
                tx = db.beginTx();
                try {
                    tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
                }
                finally {
                    if (tx != null) {
                        tx.close();
                    }
                }
                tx = db.beginTx();
                try {
                    Node node1 = (Node)Property.set((Entity)tx.createNode(new Label[]{Label.label((String)"label1")}), (Property[])new Property[0]);
                    Node node2 = (Node)Property.set((Entity)tx.createNode(new Label[]{Label.label((String)"label2")}), (Property[])new Property[]{Property.property((String)FullCheckIntegrationTest.PROP1, (Object)VALUE1)});
                    node1.createRelationshipTo(node2, RelationshipType.withName((String)"C"));
                    tx.createNode().createRelationshipTo(tx.createNode(), RelationshipType.withName((String)"T"));
                    FullCheckIntegrationTest.this.indexedNodes.add(((Node)Property.set((Entity)tx.createNode(new Label[]{Label.label((String)"label3")}), (Property[])new Property[]{Property.property((String)FullCheckIntegrationTest.PROP1, (Object)VALUE1)})).getId());
                    FullCheckIntegrationTest.this.indexedNodes.add(((Node)Property.set((Entity)tx.createNode(new Label[]{Label.label((String)"label3")}), (Property[])new Property[]{Property.property((String)FullCheckIntegrationTest.PROP1, (Object)VALUE1), Property.property((String)FullCheckIntegrationTest.PROP2, (Object)VALUE2)})).getId());
                    Property.set((Entity)tx.createNode(new Label[]{Label.label((String)"label4")}), (Property[])new Property[]{Property.property((String)FullCheckIntegrationTest.PROP1, (Object)VALUE1)});
                    tx.commit();
                }
                finally {
                    if (tx != null) {
                        tx.close();
                    }
                }
            }

            @Override
            protected Map<Setting<?>, Object> getConfig() {
                return FullCheckIntegrationTest.this.getSettings();
            }
        };
    }

    private void shouldReportCircularPropertyRecordChain(RecordType expectedInconsistentRecordType, final EntityCreator entityCreator) throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long a = next.property();
                long b = next.property();
                long c = next.property();
                long d = next.property();
                tx.create(this.propertyRecordWithSingleIntProperty(a, next.propertyKey(), -1L, b));
                tx.create(this.propertyRecordWithSingleIntProperty(b, next.propertyKey(), a, c));
                tx.create(this.propertyRecordWithSingleIntProperty(c, next.propertyKey(), b, d));
                tx.create(this.propertyRecordWithSingleIntProperty(d, next.propertyKey(), c, b));
                entityCreator.create(tx, next, a);
            }

            private PropertyRecord propertyRecordWithSingleIntProperty(long id, int propertyKeyId, long prev, long next) {
                PropertyRecord record = new PropertyRecord(id).initialize(true, prev, next);
                PropertyBlock block = new PropertyBlock();
                PropertyStore.encodeValue((PropertyBlock)block, (int)propertyKeyId, (Value)Values.intValue((int)10), null, null, (boolean)false, (CursorContext)CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
                record.addPropertyBlock(block);
                return record;
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(expectedInconsistentRecordType, 1);
    }

    protected ConsistencySummaryStatistics check() throws ConsistencyCheckIncompleteException {
        DirectStoreAccess stores = this.fixture.readOnlyDirectStoreAccess();
        return this.check(this.fixture.getInstantiatedPageCache(), stores, this.fixture.counts(), this.fixture.groupDegrees());
    }

    private ConsistencySummaryStatistics check(PageCache pageCache, DirectStoreAccess stores, ThrowingSupplier<CountsStore, IOException> counts, ThrowingSupplier<RelationshipGroupDegreesStore, IOException> groupDegrees) throws ConsistencyCheckIncompleteException {
        Config config = this.config();
        return this.check(pageCache, stores, counts, groupDegrees, config);
    }

    private ConsistencySummaryStatistics check(PageCache pageCache, DirectStoreAccess stores, ThrowingSupplier<CountsStore, IOException> counts, ThrowingSupplier<RelationshipGroupDegreesStore, IOException> groupDegrees, Config config) throws ConsistencyCheckIncompleteException {
        ConsistencyFlags consistencyFlags = new ConsistencyFlags(true, true, true);
        FullCheck checker = new FullCheck(ProgressMonitorFactory.NONE, ConsistencyCheckService.defaultConsistencyCheckThreadsNumber(), consistencyFlags, config, DebugContext.NO_DEBUG, this.memoryLimit());
        return checker.execute(pageCache, stores, counts, groupDegrees, this.fixture.indexAccessorLookup(), PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.logProvider.getLog("test"));
    }

    protected NodeBasedMemoryLimiter.Factory memoryLimit() {
        return NodeBasedMemoryLimiter.DEFAULT;
    }

    private Config config() {
        return Config.newBuilder().set(GraphDatabaseSettings.record_format, (Object)this.getRecordFormatName()).set(this.getSettings()).build();
    }

    protected static RelationshipGroupRecord withRelationships(RelationshipGroupRecord group, long out, long in, long loop) {
        group.setFirstOut(out);
        group.setFirstIn(in);
        group.setFirstLoop(loop);
        return group;
    }

    private static RelationshipGroupRecord withRelationship(RelationshipGroupRecord group, Direction direction, long rel) {
        switch (direction) {
            case OUTGOING: {
                group.setFirstOut(rel);
                break;
            }
            case INCOMING: {
                group.setFirstIn(rel);
                break;
            }
            case BOTH: {
                group.setFirstLoop(rel);
                break;
            }
            default: {
                throw new IllegalArgumentException(direction.name());
            }
        }
        return group;
    }

    private static RelationshipRecord firstInChains(RelationshipRecord relationship, int count) {
        relationship.setFirstInFirstChain(true);
        relationship.setFirstPrevRel((long)count);
        relationship.setFirstInSecondChain(true);
        relationship.setSecondPrevRel((long)count);
        return relationship;
    }

    private static RelationshipGroupRecord withNext(RelationshipGroupRecord group, long next) {
        group.setNext(next);
        return group;
    }

    protected static RelationshipGroupRecord withOwner(RelationshipGroupRecord record, long owner) {
        record.setOwningNode(owner);
        return record;
    }

    protected String getRecordFormatName() {
        return "";
    }

    private int createLabel() throws Exception {
        final MutableInt id = new MutableInt(-1);
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                int labelId = next.label();
                tx.nodeLabel(labelId, "label_" + labelId, false);
                id.setValue(labelId);
            }
        });
        return id.intValue();
    }

    private int createPropertyKey() throws Exception {
        return this.createPropertyKey("property");
    }

    private int createPropertyKey(final String propertyKey) throws Exception {
        final MutableInt id = new MutableInt(-1);
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                int propertyKeyId = next.propertyKey();
                tx.propertyKey(propertyKeyId, propertyKey + "_" + propertyKeyId, false);
                id.setValue(propertyKeyId);
            }
        });
        return id.intValue();
    }

    private int createRelType() throws Exception {
        final MutableInt id = new MutableInt(-1);
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                int relTypeId = next.relationshipType();
                tx.relationshipType(relTypeId, "relType", false);
                id.setValue(relTypeId);
            }
        });
        return id.intValue();
    }

    private void createIndexRule(final int labelId, final int ... propertyKeyIds) throws Exception {
        final AtomicReference indexName = new AtomicReference();
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) throws KernelException {
                int id = (int)next.schema();
                String name = "index_" + id;
                IndexDescriptor index = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)labelId, (int[])propertyKeyIds), (IndexProviderDescriptor)DESCRIPTOR).withName(name).materialise((long)id);
                indexName.set(name);
                index = tx.completeConfiguration(index);
                SchemaRecord before = new SchemaRecord((long)id);
                SchemaRecord after = FullCheckIntegrationTest.this.cloneRecord(before);
                FullCheckIntegrationTest.this.serializeRule((SchemaRule)index, after, tx, next);
                tx.createSchema(before, after, (SchemaRule)index);
            }
        });
        this.fixture.apply(tx -> {
            block2: {
                try {
                    tx.schema().awaitIndexOnline((String)indexName.get(), 1L, TimeUnit.MINUTES);
                }
                catch (RuntimeException e) {
                    if (e.getCause() instanceof KernelException) break block2;
                    throw e;
                }
            }
        });
    }

    private void createUniquenessConstraintRule(int labelId, int ... propertyKeyIds) throws KernelException {
        SchemaStore schemaStore = this.fixture.directStoreAccess().nativeStores().getSchemaStore();
        long ruleId1 = schemaStore.nextId(CursorContext.NULL);
        long ruleId2 = schemaStore.nextId(CursorContext.NULL);
        String name = "constraint_" + ruleId2;
        IndexDescriptor indexRule = IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)labelId, (int[])propertyKeyIds), (IndexProviderDescriptor)DESCRIPTOR).withName(name).materialise(ruleId1).withOwningConstraintId(ruleId2);
        UniquenessConstraintDescriptor uniqueRule = ConstraintDescriptorFactory.uniqueForLabel((int)labelId, (int[])propertyKeyIds).withId(ruleId2).withName(name).withOwnedIndexId(ruleId1);
        this.writeToSchemaStore(schemaStore, (SchemaRule)indexRule);
        this.writeToSchemaStore(schemaStore, (SchemaRule)uniqueRule);
    }

    private void createNodeKeyConstraintRule(int labelId, int ... propertyKeyIds) throws KernelException {
        SchemaStore schemaStore = this.fixture.directStoreAccess().nativeStores().getSchemaStore();
        long ruleId1 = schemaStore.nextId(CursorContext.NULL);
        long ruleId2 = schemaStore.nextId(CursorContext.NULL);
        String name = "constraint_" + ruleId2;
        IndexDescriptor indexRule = IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)labelId, (int[])propertyKeyIds), (IndexProviderDescriptor)DESCRIPTOR).withName(name).materialise(ruleId1).withOwningConstraintId(ruleId2);
        NodeKeyConstraintDescriptor nodeKeyRule = ConstraintDescriptorFactory.nodeKeyForLabel((int)labelId, (int[])propertyKeyIds).withId(ruleId2).withName(name).withOwnedIndexId(ruleId1);
        this.writeToSchemaStore(schemaStore, (SchemaRule)indexRule);
        this.writeToSchemaStore(schemaStore, (SchemaRule)nodeKeyRule);
    }

    private void createNodePropertyExistenceConstraint(int labelId, int propertyKeyId) throws KernelException {
        SchemaStore schemaStore = this.fixture.directStoreAccess().nativeStores().getSchemaStore();
        long ruleId = schemaStore.nextId(CursorContext.NULL);
        ConstraintDescriptor rule = SchemaRuleUtil.nodePropertyExistenceConstraintRule((long)ruleId, (int)labelId, (int)propertyKeyId).withName("constraint_" + ruleId);
        this.writeToSchemaStore(schemaStore, (SchemaRule)rule);
    }

    private void createRelationshipPropertyExistenceConstraint(int relTypeId, int propertyKeyId) throws KernelException {
        SchemaStore schemaStore = this.fixture.directStoreAccess().nativeStores().getSchemaStore();
        ConstraintDescriptor rule = SchemaRuleUtil.relPropertyExistenceConstraintRule((long)schemaStore.nextId(CursorContext.NULL), (int)relTypeId, (int)propertyKeyId);
        this.writeToSchemaStore(schemaStore, (SchemaRule)rule);
    }

    private void writeToSchemaStore(SchemaStore schemaStore, SchemaRule rule) throws KernelException {
        SchemaRuleAccess schemaRuleAccess = SchemaRuleAccess.getSchemaRuleAccess((SchemaStore)schemaStore, (TokenHolders)this.fixture.writableTokenHolders(), () -> KernelVersion.LATEST);
        schemaRuleAccess.writeSchemaRule(rule, CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    protected Iterator<IndexDescriptor> getValueIndexDescriptors() {
        return Iterators.filter(descriptor -> !descriptor.isTokenIndex(), this.fixture.getIndexDescriptors());
    }

    protected static ConsistencySummaryVerifier on(ConsistencySummaryStatistics stats) {
        return new ConsistencySummaryVerifier(stats);
    }

    private void serializeRule(SchemaRule rule, SchemaRecord schemaRecord, GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) throws KernelException {
        IntObjectMap protoProperties = SchemaStore.convertSchemaRuleToMap((SchemaRule)rule, (TokenHolders)tx.tokenHolders());
        ArrayList blocks = new ArrayList();
        DynamicRecordAllocator stringAllocator = null;
        DynamicRecordAllocator arrayAllocator = null;
        protoProperties.forEachKeyValue((IntObjectProcedure & Serializable)(keyId, value) -> {
            PropertyBlock block = new PropertyBlock();
            PropertyStore.encodeValue((PropertyBlock)block, (int)keyId, (Value)value, (DynamicRecordAllocator)stringAllocator, (DynamicRecordAllocator)arrayAllocator, (boolean)true, (CursorContext)CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            blocks.add(block);
        });
        long nextPropId = Record.NO_NEXT_PROPERTY.longValue();
        PropertyRecord currRecord = this.newInitialisedPropertyRecord(next, rule);
        for (PropertyBlock block : blocks) {
            if (!currRecord.hasSpaceFor(block)) {
                PropertyRecord nextRecord = this.newInitialisedPropertyRecord(next, rule);
                this.linkAndWritePropertyRecord(currRecord, nextRecord.getId(), nextPropId, tx);
                nextPropId = currRecord.getId();
                currRecord = nextRecord;
            }
            currRecord.addPropertyBlock(block);
        }
        this.linkAndWritePropertyRecord(currRecord, Record.NO_PREVIOUS_PROPERTY.longValue(), nextPropId, tx);
        nextPropId = currRecord.getId();
        schemaRecord.initialize(true, nextPropId);
        schemaRecord.setId(rule.getId());
    }

    private <T extends AbstractBaseRecord> T cloneRecord(T record) {
        return (T)record.copy();
    }

    private PropertyRecord newInitialisedPropertyRecord(GraphStoreFixture.IdGenerator next, SchemaRule rule) {
        PropertyRecord record = new PropertyRecord(next.property());
        record.setSchemaRuleId(rule.getId());
        return record;
    }

    private void linkAndWritePropertyRecord(PropertyRecord record, long prevPropId, long nextProp, GraphStoreFixture.TransactionDataBuilder tx) {
        record.setInUse(true);
        record.setPrevProp(prevPropId);
        record.setNextProp(nextProp);
        tx.update(this.cloneRecord(record).initialize(false, Record.NO_PREVIOUS_PROPERTY.longValue(), Record.NO_PREVIOUS_PROPERTY.longValue()), record);
    }

    private static RelationshipGroupRecord relationshipGroupRecord(long id, int type) {
        return new RelationshipGroupRecord(id).initialize(false, type, Record.NULL_REFERENCE.longValue(), Record.NULL_REFERENCE.longValue(), Record.NULL_REFERENCE.longValue(), Record.NULL_REFERENCE.longValue(), Record.NULL_REFERENCE.longValue());
    }

    public static <R extends AbstractBaseRecord> R inUse(R record) {
        record.setInUse(true);
        return record;
    }

    public static <R extends AbstractBaseRecord> R notInUse(R record) {
        record.setInUse(false);
        return record;
    }

    private static enum IndexSize {
        SMALL_INDEX{

            @Override
            public void createAdditionalData(GraphStoreFixture fixture) {
                fixture.apply(tx -> {
                    for (int i = 0; i < 60; ++i) {
                        tx.createNode();
                    }
                });
            }
        }
        ,
        LARGE_INDEX{

            @Override
            public void createAdditionalData(GraphStoreFixture fixture) {
            }
        };


        public abstract void createAdditionalData(GraphStoreFixture var1);
    }

    protected static final class ConsistencySummaryVerifier {
        private final ConsistencySummaryStatistics stats;
        private final Set<RecordType> types = new HashSet<RecordType>();
        private long total;

        private ConsistencySummaryVerifier(ConsistencySummaryStatistics stats) {
            this.stats = stats;
        }

        public ConsistencySummaryVerifier verify(RecordType type, int inconsistencies) {
            if (!this.types.add(type)) {
                throw new IllegalStateException("Tried to verify the same type twice: " + type);
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)inconsistencies, (int)this.stats.getInconsistencyCountForRecordType(type), (String)("Inconsistencies of type: " + type));
            this.total += (long)inconsistencies;
            return this;
        }

        public void andThatsAllFolks() {
            org.junit.jupiter.api.Assertions.assertEquals((long)this.total, (long)this.stats.getTotalInconsistencyCount(), (String)("Total number of inconsistencies: " + this.stats));
        }
    }

    private static class Reference<T> {
        private T value;

        private Reference() {
        }

        void set(T value) {
            this.value = value;
        }

        T get() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @FunctionalInterface
    private static interface EntityCreator {
        public void create(GraphStoreFixture.TransactionDataBuilder var1, GraphStoreFixture.IdGenerator var2, long var3);
    }
}

