/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.neo4j.common.EntityType;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.checking.GraphStoreFixture;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.internal.recordstorage.RecordCursorTypes;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.log4j.Log4jLogProvider;
import org.neo4j.storageengine.api.EntityUpdates;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.storageengine.api.cursor.CursorType;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.mockito.mock.Property;
import org.neo4j.test.utils.TestDirectory;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class SpecialisedIndexFullCheckTest {
    SpecialisedIndexFullCheckTest() {
    }

    private static enum IndexSize {
        SMALL_INDEX{

            @Override
            public void createAdditionalData(GraphStoreFixture fixture) {
                fixture.apply(tx -> {
                    for (int i = 0; i < 80; ++i) {
                        tx.createNode();
                    }
                });
            }
        }
        ,
        LARGE_INDEX{

            @Override
            public void createAdditionalData(GraphStoreFixture fixture) {
            }
        };


        public abstract void createAdditionalData(GraphStoreFixture var1);
    }

    @Nested
    class FullTextIndex
    extends TestBase {
        FullTextIndex() {
        }

        @Override
        IndexType type() {
            return IndexType.FULLTEXT;
        }

        @Override
        Object indexedValue() {
            return "some text";
        }

        @Override
        Object anotherIndexedValue() {
            return "another piece of text";
        }

        @Override
        Object notIndexedValue() {
            return 123;
        }
    }

    @Nested
    class TextIndex
    extends TestBase {
        TextIndex() {
        }

        @Override
        IndexType type() {
            return IndexType.TEXT;
        }

        @Override
        Object indexedValue() {
            return "some text";
        }

        @Override
        Object anotherIndexedValue() {
            return "another piece of text";
        }

        @Override
        Object notIndexedValue() {
            return 123;
        }
    }

    @Nested
    class PointIndex
    extends TestBase {
        PointIndex() {
        }

        @Override
        IndexType type() {
            return IndexType.POINT;
        }

        @Override
        Object indexedValue() {
            return Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{1.0, 2.0});
        }

        @Override
        Object anotherIndexedValue() {
            return Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84_3D, (double[])new double[]{1.0, 2.0, 3.0});
        }

        @Override
        Object notIndexedValue() {
            return "some string";
        }
    }

    @TestDirectoryExtension
    abstract class TestBase {
        private static final String PROP1 = "key1";
        private static final String PROP2 = "key2";
        @Inject
        private TestDirectory testDirectory;
        protected GraphStoreFixture fixture;
        private final ByteArrayOutputStream logStream = new ByteArrayOutputStream();
        private final Log4jLogProvider logProvider = new Log4jLogProvider((OutputStream)this.logStream);
        protected final List<Long> indexedNodes = new ArrayList<Long>();
        private final List<Long> indexedRelationships = new ArrayList<Long>();
        private final Map<Setting<?>, Object> settings = new HashMap();

        TestBase() {
        }

        abstract IndexType type();

        abstract Object indexedValue();

        abstract Object anotherIndexedValue();

        abstract Object notIndexedValue();

        @BeforeEach
        protected void setUp() {
            this.fixture = this.createFixture();
        }

        @AfterEach
        void tearDown() {
            this.fixture.close();
        }

        @Test
        void shouldCheckConsistencyOfAConsistentStore() throws Exception {
            ConsistencySummaryStatistics result = this.check();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)result.isConsistent(), (String)result.toString());
        }

        @ParameterizedTest
        @EnumSource(value=IndexSize.class)
        void shouldReportIndexInconsistencies(IndexSize indexSize) throws Exception {
            indexSize.createAdditionalData(this.fixture);
            NodeStore nodeStore = this.fixture.directStoreAccess().nativeStores().getNodeStore();
            StoreCursors storeCursors = this.fixture.getStoreCursors();
            try (PageCursor cursor = storeCursors.writeCursor((CursorType)RecordCursorTypes.NODE_CURSOR);){
                for (Long id : this.indexedNodes) {
                    NodeRecord nodeRecord = new NodeRecord(id.longValue());
                    nodeRecord.clear();
                    nodeStore.updateRecord((AbstractBaseRecord)nodeRecord, cursor, CursorContext.NULL, storeCursors);
                }
            }
            ConsistencySummaryStatistics stats = this.check();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)stats.isConsistent());
            Assertions.assertThat((String)this.logStream.toString()).contains(new CharSequence[]{"This index entry refers to a node record that is not in use"});
            Assertions.assertThat((int)stats.getInconsistencyCountForRecordType(RecordType.INDEX)).isEqualTo(3);
        }

        @ParameterizedTest
        @EnumSource(value=IndexSize.class)
        void shouldReportNodesThatAreNotIndexed(IndexSize indexSize) throws Exception {
            indexSize.createAdditionalData(this.fixture);
            Iterator<IndexDescriptor> indexDescriptorIterator = this.getValueIndexDescriptors();
            while (indexDescriptorIterator.hasNext()) {
                IndexDescriptor indexDescriptor = indexDescriptorIterator.next();
                if (indexDescriptor.schema().entityType() != EntityType.NODE) continue;
                IndexAccessor accessor = this.fixture.indexAccessorLookup().apply(indexDescriptor);
                IndexUpdater updater = accessor.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);
                try {
                    for (long nodeId : this.indexedNodes) {
                        EntityUpdates updates = this.fixture.nodeAsUpdates(nodeId);
                        for (IndexEntryUpdate update : updates.valueUpdatesForIndexKeys(Collections.singletonList(indexDescriptor))) {
                            updater.process((IndexEntryUpdate)IndexEntryUpdate.remove((long)nodeId, (SchemaDescriptorSupplier)indexDescriptor, (Value[])((ValueIndexEntryUpdate)update).values()));
                        }
                    }
                }
                finally {
                    if (updater == null) continue;
                    updater.close();
                }
            }
            ConsistencySummaryStatistics stats = this.check();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)stats.isConsistent());
            Assertions.assertThat((String)this.logStream.toString()).contains(new CharSequence[]{"This node was not found in the expected index"});
            Assertions.assertThat((int)stats.getInconsistencyCountForRecordType(RecordType.NODE)).isEqualTo(3);
        }

        @Test
        void shouldReportRelationshipsThatAreNotIndexed() throws Exception {
            Iterator<IndexDescriptor> indexDescriptorIterator = this.getValueIndexDescriptors();
            while (indexDescriptorIterator.hasNext()) {
                IndexDescriptor indexDescriptor = indexDescriptorIterator.next();
                if (indexDescriptor.schema().entityType() != EntityType.RELATIONSHIP) continue;
                IndexAccessor accessor = this.fixture.indexAccessorLookup().apply(indexDescriptor);
                IndexUpdater updater = accessor.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);
                try {
                    for (long relId : this.indexedRelationships) {
                        EntityUpdates updates = this.fixture.relationshipAsUpdates(relId);
                        for (IndexEntryUpdate update : updates.valueUpdatesForIndexKeys(Collections.singletonList(indexDescriptor))) {
                            updater.process((IndexEntryUpdate)IndexEntryUpdate.remove((long)relId, (SchemaDescriptorSupplier)indexDescriptor, (Value[])((ValueIndexEntryUpdate)update).values()));
                        }
                    }
                }
                finally {
                    if (updater == null) continue;
                    updater.close();
                }
            }
            ConsistencySummaryStatistics stats = this.check();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)stats.isConsistent());
            Assertions.assertThat((String)this.logStream.toString()).contains(new CharSequence[]{"This relationship was not found in the expected index"});
            Assertions.assertThat((int)stats.getInconsistencyCountForRecordType(RecordType.RELATIONSHIP)).isEqualTo(3);
        }

        @ParameterizedTest
        @EnumSource(value=IndexSize.class)
        void shouldReportNodesThatAreIndexedWhenTheyShouldNotBe(IndexSize indexSize) throws Exception {
            indexSize.createAdditionalData(this.fixture);
            long newNode = this.createOneNode();
            Iterator<IndexDescriptor> indexDescriptorIterator = this.getValueIndexDescriptors();
            while (indexDescriptorIterator.hasNext()) {
                IndexDescriptor indexDescriptor = indexDescriptorIterator.next();
                if (indexDescriptor.schema().entityType() != EntityType.NODE || indexDescriptor.isUnique()) continue;
                IndexAccessor accessor = this.fixture.indexAccessorLookup().apply(indexDescriptor);
                IndexUpdater updater = accessor.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);
                try {
                    updater.process((IndexEntryUpdate)IndexEntryUpdate.add((long)newNode, (SchemaDescriptorSupplier)indexDescriptor, (Value[])this.values(indexDescriptor)));
                }
                finally {
                    if (updater == null) continue;
                    updater.close();
                }
            }
            ConsistencySummaryStatistics stats = this.check();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)stats.isConsistent());
            Assertions.assertThat((int)stats.getInconsistencyCountForRecordType(RecordType.INDEX)).isEqualTo(2);
        }

        Value[] values(IndexDescriptor indexRule) {
            switch (indexRule.schema().getPropertyIds().length) {
                case 1: {
                    return (Value[])Iterators.array((Object[])new Value[]{Values.of((Object)this.indexedValue())});
                }
                case 2: {
                    return (Value[])Iterators.array((Object[])new Value[]{Values.of((Object)this.indexedValue()), Values.of((Object)this.anotherIndexedValue())});
                }
            }
            throw new UnsupportedOperationException();
        }

        private Iterator<IndexDescriptor> getValueIndexDescriptors() {
            return Iterators.filter(descriptor -> !descriptor.isTokenIndex(), this.fixture.getIndexDescriptors());
        }

        private ConsistencySummaryStatistics check() throws ConsistencyCheckIncompleteException {
            this.fixture.close();
            Config config = Config.newBuilder().set(GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.homePath()).build();
            ConsistencyCheckService checkService = new ConsistencyCheckService();
            return checkService.runFullConsistencyCheck(Neo4jLayout.of((Config)config).databaseLayout("neo4j"), config, ProgressMonitorFactory.NONE, (LogProvider)this.logProvider, false, ConsistencyFlags.DEFAULT).summary();
        }

        private GraphStoreFixture createFixture() {
            return new GraphStoreFixture("", this.testDirectory){

                @Override
                protected void generateInitialData(GraphDatabaseService db) {
                    try (Transaction tx = db.beginTx();){
                        tx.schema().indexFor(Label.label((String)"Label1")).on(TestBase.PROP1).withIndexType(TestBase.this.type()).create();
                        tx.schema().indexFor(Label.label((String)"Label1")).on(TestBase.PROP2).withIndexType(TestBase.this.type()).create();
                        tx.schema().indexFor(RelationshipType.withName((String)"Type1")).on(TestBase.PROP1).withIndexType(TestBase.this.type()).create();
                        tx.schema().indexFor(RelationshipType.withName((String)"Type1")).on(TestBase.PROP2).withIndexType(TestBase.this.type()).create();
                        tx.commit();
                    }
                    tx = db.beginTx();
                    try {
                        tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
                    }
                    finally {
                        if (tx != null) {
                            tx.close();
                        }
                    }
                    tx = db.beginTx();
                    try {
                        Node node1 = (Node)Property.set((Entity)tx.createNode(new Label[]{Label.label((String)"Label1")}), (Property[])new Property[]{Property.property((String)TestBase.PROP1, (Object)TestBase.this.indexedValue())});
                        Node node2 = (Node)Property.set((Entity)tx.createNode(new Label[]{Label.label((String)"Label1")}), (Property[])new Property[]{Property.property((String)TestBase.PROP1, (Object)TestBase.this.indexedValue()), Property.property((String)TestBase.PROP2, (Object)TestBase.this.anotherIndexedValue())});
                        Node node3 = (Node)Property.set((Entity)tx.createNode(new Label[]{Label.label((String)"Label1")}), (Property[])new Property[]{Property.property((String)TestBase.PROP1, (Object)TestBase.this.notIndexedValue())});
                        Property.set((Entity)tx.createNode(new Label[]{Label.label((String)"AnotherLabel")}), (Property[])new Property[]{Property.property((String)TestBase.PROP1, (Object)TestBase.this.indexedValue())});
                        Property.set((Entity)tx.createNode(new Label[]{Label.label((String)"Label1")}), (Property[])new Property[]{Property.property((String)"anotherProperty", (Object)TestBase.this.indexedValue())});
                        Node node6 = tx.createNode();
                        TestBase.this.indexedNodes.add(node1.getId());
                        TestBase.this.indexedNodes.add(node2.getId());
                        Property.set((Entity)tx.createNode(new Label[]{Label.label((String)"Label1")}), (Property[])new Property[]{Property.property((String)TestBase.PROP1, (Object)TestBase.this.indexedValue()), Property.property((String)TestBase.PROP2, (Object)TestBase.this.anotherIndexedValue())});
                        TestBase.this.indexedRelationships.add(((Relationship)Property.set((Entity)node1.createRelationshipTo(node6, RelationshipType.withName((String)"Type1")), (Property[])new Property[]{Property.property((String)TestBase.PROP1, (Object)TestBase.this.indexedValue())})).getId());
                        TestBase.this.indexedRelationships.add(((Relationship)Property.set((Entity)node2.createRelationshipTo(node6, RelationshipType.withName((String)"Type1")), (Property[])new Property[]{Property.property((String)TestBase.PROP1, (Object)TestBase.this.indexedValue()), Property.property((String)TestBase.PROP2, (Object)TestBase.this.anotherIndexedValue())})).getId());
                        TestBase.this.indexedRelationships.add(((Relationship)Property.set((Entity)node3.createRelationshipTo(node6, RelationshipType.withName((String)"Type1")), (Property[])new Property[]{Property.property((String)TestBase.PROP1, (Object)TestBase.this.notIndexedValue())})).getId());
                        tx.commit();
                    }
                    finally {
                        if (tx != null) {
                            tx.close();
                        }
                    }
                }

                @Override
                protected Map<Setting<?>, Object> getConfig() {
                    return TestBase.this.settings;
                }
            };
        }

        protected long createOneNode() {
            AtomicLong id = new AtomicLong();
            this.fixture.apply(tx -> id.set(tx.createNode().getId()));
            return id.get();
        }
    }
}

