/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.neo4j.common.EntityType;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.TestLabels;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.mockito.mock.Property;

@DbmsExtension
@ExtendWith(value={RandomExtension.class})
class IndexConsistencyIT {
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private DatabaseManagementService managementService;
    @Inject
    private CheckPointer checkPointer;
    @Inject
    private IndexProviderMap indexProviderMap;
    @Inject
    private RandomSupport random;
    private final AssertableLogProvider log = new AssertableLogProvider();
    private static final Label[] LABELS = new Label[]{TestLabels.LABEL_ONE, TestLabels.LABEL_TWO, TestLabels.LABEL_THREE};
    private static final RelationshipType TYPE_ONE = RelationshipType.withName((String)"TYPE_ONE");
    private static final RelationshipType TYPE_TWO = RelationshipType.withName((String)"TYPE_TWO");
    private static final RelationshipType[] TYPES = new RelationshipType[]{TYPE_ONE, TYPE_TWO};
    private static final String PROPERTY_KEY = "numericProperty";
    private static final String PROPERTY_KEY2 = "property2";
    private static final String[] PROPERTY_KEYS = new String[]{"numericProperty", "property2"};
    private static final double DELETE_RATIO = 0.2;
    private static final double UPDATE_RATIO = 0.2;
    private static final int ENTITY_COUNT_BASELINE = 10;
    private final Predicate<Path> SOURCE_COPY_FILE_FILTER = path -> Files.isDirectory(path, new LinkOption[0]) || path.getFileName().toString().startsWith("index");

    IndexConsistencyIT() {
    }

    @ParameterizedTest
    @EnumSource(value=EntityType.class)
    void reportNotCleanNativeIndex(EntityType entityType) throws IOException, ConsistencyCheckIncompleteException {
        DatabaseLayout databaseLayout = this.db.databaseLayout();
        this.someData(entityType);
        this.checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("forcedCheckpoint"));
        Path indexesCopy = databaseLayout.file("indexesCopy");
        Path indexSources = this.indexProviderMap.getDefaultProvider().directoryStructure().rootDirectory();
        FileUtils.copyDirectory((Path)indexSources, (Path)indexesCopy, this.SOURCE_COPY_FILE_FILTER);
        try (Transaction tx = this.db.beginTx();){
            this.createNewEntity(tx, entityType);
            tx.commit();
        }
        this.managementService.shutdown();
        FileUtils.copyDirectory((Path)indexesCopy, (Path)indexSources);
        ConsistencyCheckService.Result result = this.fullConsistencyCheck();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)result.isSuccessful(), (String)"Expected consistency check to fail");
        Assertions.assertThat((String)IndexConsistencyIT.readReport(result)).contains(new CharSequence[]{"WARN  Index was dirty on startup which means it was not shutdown correctly and need to be cleaned up with a successful recovery."});
    }

    @ParameterizedTest
    @EnumSource(value=EntityType.class)
    void reportNotCleanNativeIndexWithCorrectData(EntityType entityType) throws IOException, ConsistencyCheckIncompleteException {
        DatabaseLayout databaseLayout = this.db.databaseLayout();
        this.someData(entityType);
        this.checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("forcedCheckpoint"));
        Path indexesCopy = databaseLayout.file("indexesCopy");
        Path indexSources = this.indexProviderMap.getDefaultProvider().directoryStructure().rootDirectory();
        FileUtils.copyDirectory((Path)indexSources, (Path)indexesCopy, this.SOURCE_COPY_FILE_FILTER);
        this.managementService.shutdown();
        FileUtils.copyDirectory((Path)indexesCopy, (Path)indexSources);
        ConsistencyCheckService.Result result = this.fullConsistencyCheck();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)result.isSuccessful(), (String)"Expected consistency check to succeed");
        Assertions.assertThat((String)IndexConsistencyIT.readReport(result)).contains(new CharSequence[]{"WARN  Index was dirty on startup which means it was not shutdown correctly and need to be cleaned up with a successful recovery."});
    }

    private static String readReport(ConsistencyCheckService.Result result) throws IOException {
        return Files.readString(result.reportFile());
    }

    void someData(EntityType entityType) {
        this.someData(50, entityType);
    }

    void someData(int numberOfModifications, EntityType entityType) {
        try (Transaction tx = this.db.beginTx();){
            this.randomModifications(tx, numberOfModifications, entityType);
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            this.createIndex(tx, entityType);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private void createIndex(Transaction tx, EntityType entityType) {
        if (entityType.equals((Object)EntityType.NODE)) {
            tx.schema().indexFor(TestLabels.LABEL_ONE).on(PROPERTY_KEY).create();
        } else {
            tx.schema().indexFor(TYPE_ONE).on(PROPERTY_KEY).create();
        }
    }

    private void randomModifications(Transaction tx, int numberOfModifications, EntityType entityType) {
        if (entityType.equals((Object)EntityType.NODE)) {
            this.randomNodeModifications(tx, numberOfModifications);
        } else {
            this.randomRelationshipModifications(tx, numberOfModifications);
        }
    }

    private void randomNodeModifications(Transaction tx, int numberOfModifications) {
        ArrayList<Pair<Long, Label[]>> existingNodes = new ArrayList<Pair<Long, Label[]>>();
        for (int i = 0; i < numberOfModifications; ++i) {
            double selectModification = this.random.nextDouble();
            if (existingNodes.size() < 10 || selectModification >= 0.4) {
                this.createNewNode(tx, existingNodes);
                continue;
            }
            if (selectModification < 0.2) {
                this.deleteExistingNode(tx, existingNodes);
                continue;
            }
            this.modifyLabelsOnExistingNode(tx, existingNodes);
        }
    }

    private void randomRelationshipModifications(Transaction tx, int numberOfModifications) {
        ArrayList<Long> existingRelationships = new ArrayList<Long>();
        for (int i = 0; i < numberOfModifications; ++i) {
            double selectModification = this.random.nextDouble();
            if (existingRelationships.size() < 10 || selectModification >= 0.4) {
                this.createNewRelationship(tx, existingRelationships);
                continue;
            }
            if (selectModification < 0.2) {
                this.deleteExistingRelationship(tx, existingRelationships);
                continue;
            }
            this.modifyPropertiesOnExistingRelationship(tx, existingRelationships);
        }
    }

    private void createNewNode(Transaction transaction, List<Pair<Long, Label[]>> existingNodes) {
        Label[] labels = this.randomLabels();
        Node node = this.createNewNode(transaction, labels);
        existingNodes.add((Pair<Long, Label[]>)Pair.of((Object)node.getId(), (Object)labels));
    }

    private Node createNewNode(Transaction tx, Label[] labels) {
        Node node = tx.createNode(labels);
        node.setProperty(PROPERTY_KEY, (Object)this.random.nextInt());
        return node;
    }

    private void createNewEntity(Transaction tx, EntityType entityType) {
        if (entityType.equals((Object)EntityType.NODE)) {
            this.createNewNode(tx, new Label[]{TestLabels.LABEL_ONE});
        } else {
            Node node = tx.createNode();
            Property.set((Entity)node.createRelationshipTo(node, TYPE_ONE), (Property[])new Property[]{Property.property((String)PROPERTY_KEY, (Object)this.random.nextInt())});
        }
    }

    private void createNewRelationship(Transaction transaction, List<Long> existingRelationships) {
        Node node = transaction.createNode();
        existingRelationships.add(((Relationship)Property.set((Entity)node.createRelationshipTo(node, (RelationshipType)this.random.among((Object[])TYPES)), (Property[])new Property[]{Property.property((String)((String)this.random.among((Object[])PROPERTY_KEYS)), (Object)this.random.nextInt())})).getId());
    }

    private void modifyLabelsOnExistingNode(Transaction transaction, List<Pair<Long, Label[]>> existingNodes) {
        Label[] newLabels;
        int targetIndex = this.random.nextInt(existingNodes.size());
        Pair<Long, Label[]> existingPair = existingNodes.get(targetIndex);
        long nodeId = (Long)existingPair.first();
        Node node = transaction.getNodeById(nodeId);
        node.getLabels().forEach(arg_0 -> ((Node)node).removeLabel(arg_0));
        for (Label label : newLabels = this.randomLabels()) {
            node.addLabel(label);
        }
        existingNodes.remove(targetIndex);
        existingNodes.add((Pair<Long, Label[]>)Pair.of((Object)nodeId, (Object)newLabels));
    }

    private void modifyPropertiesOnExistingRelationship(Transaction transaction, List<Long> existingRelationships) {
        String[] properties;
        int targetIndex = this.random.nextInt(existingRelationships.size());
        long relId = existingRelationships.get(targetIndex);
        Relationship relationship = transaction.getRelationshipById(relId);
        relationship.getPropertyKeys().forEach(arg_0 -> ((Relationship)relationship).removeProperty(arg_0));
        for (String property : properties = (String[])this.random.selection((Object[])PROPERTY_KEYS, 0, PROPERTY_KEYS.length, false)) {
            relationship.setProperty(property, (Object)this.random.nextInt());
        }
    }

    private void deleteExistingNode(Transaction transaction, List<Pair<Long, Label[]>> existingNodes) {
        int targetIndex = this.random.nextInt(existingNodes.size());
        Pair<Long, Label[]> existingPair = existingNodes.get(targetIndex);
        Node node = transaction.getNodeById(((Long)existingPair.first()).longValue());
        node.delete();
        existingNodes.remove(targetIndex);
    }

    private void deleteExistingRelationship(Transaction transaction, List<Long> existingRelationship) {
        int targetIndex = this.random.nextInt(existingRelationship.size());
        Relationship relationship = transaction.getRelationshipById(existingRelationship.get(targetIndex).longValue());
        relationship.delete();
        existingRelationship.remove(targetIndex);
    }

    private Label[] randomLabels() {
        ArrayList<Label> labels = new ArrayList<Label>(LABELS.length);
        for (Label label : LABELS) {
            if (!this.random.nextBoolean()) continue;
            labels.add(label);
        }
        return labels.toArray(new Label[0]);
    }

    private ConsistencyCheckService.Result fullConsistencyCheck() throws ConsistencyCheckIncompleteException, IOException {
        try (DefaultFileSystemAbstraction fsa = new DefaultFileSystemAbstraction();){
            ConsistencyCheckService service = new ConsistencyCheckService();
            DatabaseLayout databaseLayout = this.db.databaseLayout();
            Config config = Config.defaults((Setting)GraphDatabaseSettings.logs_directory, (Object)databaseLayout.databaseDirectory());
            ConsistencyCheckService.Result result = service.runFullConsistencyCheck(databaseLayout, config, ProgressMonitorFactory.NONE, (LogProvider)this.log, (FileSystemAbstraction)fsa, false, ConsistencyFlags.DEFAULT);
            return result;
        }
    }
}

