/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checker.full;

import java.io.IOException;
import java.util.Iterator;
import org.junit.jupiter.api.Test;
import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.checker.NodeBasedMemoryLimiter;
import org.neo4j.consistency.checking.cache.CacheSlots;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.FullCheckIntegrationTest;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.values.storable.Value;

class LimitedFullCheckIT
extends FullCheckIntegrationTest {
    LimitedFullCheckIT() {
    }

    @Override
    protected NodeBasedMemoryLimiter.Factory memoryLimit() {
        return (pageCacheMemory, highNodeId) -> new NodeBasedMemoryLimiter(pageCacheMemory, 0L, pageCacheMemory + highNodeId * CacheSlots.CACHE_LINE_SIZE_BYTES / 3L, CacheSlots.CACHE_LINE_SIZE_BYTES, highNodeId, 1.0);
    }

    @Test
    void shouldFindDuplicatesInUniqueIndexEvenWhenInDifferentRanges() throws ConsistencyCheckIncompleteException, IndexEntryConflictException, IOException {
        Iterator<IndexDescriptor> indexRuleIterator = this.getValueIndexDescriptors();
        this.createOneNode();
        this.createOneNode();
        long nodeId = this.createOneNode();
        while (indexRuleIterator.hasNext()) {
            IndexDescriptor indexRule = indexRuleIterator.next();
            IndexAccessor accessor = this.fixture.indexAccessorLookup().apply(indexRule);
            try (IndexUpdater updater = accessor.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);){
                updater.process((IndexEntryUpdate)IndexEntryUpdate.add((long)nodeId, (SchemaDescriptorSupplier)indexRule, (Value[])LimitedFullCheckIT.values(indexRule)));
            }
            accessor.force(CursorContext.NULL);
        }
        ConsistencySummaryStatistics stats = this.check();
        LimitedFullCheckIT.on(stats).verify(RecordType.NODE, 2).verify(RecordType.INDEX, 6).andThatsAllFolks();
    }
}

