/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checker;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.consistency.checker.CheckerTestBase;
import org.neo4j.consistency.checker.NodeChecker;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.LongRange;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.recordstorage.RecordCursorTypes;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.InlineNodeLabels;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.cursor.CursorType;
import org.neo4j.storageengine.api.cursor.StoreCursors;

class NodeCheckerTest
extends CheckerTestBase {
    private int label1;
    private int label2;
    private int label3;
    private int[] otherLabels;
    private int unusedLabel;

    NodeCheckerTest() {
    }

    @Override
    void initialData(KernelTransaction tx) throws KernelException {
        TokenWrite tokenWrite = tx.tokenWrite();
        int[] labelIds = new int[300];
        for (int i = 0; i < labelIds.length; ++i) {
            labelIds[i] = tokenWrite.labelGetOrCreateForName(String.valueOf(i));
        }
        Arrays.sort(labelIds);
        this.label1 = labelIds[0];
        this.label2 = labelIds[1];
        this.label3 = labelIds[2];
        this.otherLabels = Arrays.copyOfRange(labelIds, 3, labelIds.length);
        this.unusedLabel = labelIds[labelIds.length - 1] + 99;
    }

    void testReportLabelInconsistency(Consumer<ConsistencyReport.NodeConsistencyReport> report, int ... labels) throws Exception {
        try (AutoCloseable ignored = this.tx();){
            this.node(this.nodeStore.nextId(CursorContext.NULL), NULL, NULL, labels);
        }
        this.check();
        this.expect(ConsistencyReport.NodeConsistencyReport.class, report);
    }

    @Test
    void shouldReportLabelNotInUse() throws Exception {
        this.testReportLabelInconsistency(report -> report.labelNotInUse((LabelTokenRecord)ArgumentMatchers.any()), this.label1, this.unusedLabel);
    }

    @Test
    void shouldReportLabelDuplicate() throws Exception {
        this.testReportLabelInconsistency(report -> report.labelDuplicate((long)ArgumentMatchers.anyInt()), this.label1, this.label1, this.label2);
    }

    @Test
    void shouldReportLabelsOutOfOrder() throws Exception {
        this.testReportLabelInconsistency(report -> report.labelsOutOfOrder(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong()), this.label3, this.label1, this.label2);
    }

    @Test
    void shouldReportNodeNotInUseOnEmptyStore() throws Exception {
        try (AutoCloseable ignored = this.tx();
             IndexUpdater writer = this.labelIndexWriter();){
            writer.process((IndexEntryUpdate)IndexEntryUpdate.change((long)this.nodeStore.nextId(CursorContext.NULL), (SchemaDescriptorSupplier)IndexDescriptor.NO_INDEX, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])new long[]{this.label1}));
        }
        this.check();
        this.expect(ConsistencyReport.LabelScanConsistencyReport.class, report -> report.nodeNotInUse((NodeRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportNodeNotInUse() throws Exception {
        try (AutoCloseable ignored = this.tx();){
            try (IndexUpdater writer = this.labelIndexWriter();){
                for (int i = 0; i < 10; ++i) {
                    long nodeId = this.node(this.nodeStore.nextId(CursorContext.NULL), NULL, NULL, this.label1);
                    writer.process((IndexEntryUpdate)IndexEntryUpdate.change((long)nodeId, (SchemaDescriptorSupplier)IndexDescriptor.NO_INDEX, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])new long[]{this.label1}));
                }
            }
            writer = this.labelIndexWriter();
            try {
                writer.process((IndexEntryUpdate)IndexEntryUpdate.change((long)this.nodeStore.nextId(CursorContext.NULL), (SchemaDescriptorSupplier)IndexDescriptor.NO_INDEX, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])new long[]{this.label1}));
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        this.check();
        this.expect(ConsistencyReport.LabelScanConsistencyReport.class, report -> report.nodeNotInUse((NodeRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportDynamicRecordChainCycle() throws Exception {
        this.testDynamicRecordChain(node -> {
            List dynamicLabelRecords = node.getDynamicLabelRecords();
            ((DynamicRecord)Iterables.last((Iterable)dynamicLabelRecords)).setNextBlock(((DynamicRecord)Iterables.first((Iterable)dynamicLabelRecords)).getId());
        }, ConsistencyReport.NodeConsistencyReport.class, report -> report.dynamicRecordChainCycle((DynamicRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportFirstDynamicLabelRecordNotInUse() throws Exception {
        this.testDynamicRecordChain(node -> {
            List dynamicLabelRecords = node.getDynamicLabelRecords();
            ((DynamicRecord)Iterables.first((Iterable)dynamicLabelRecords)).setInUse(false);
        }, ConsistencyReport.NodeConsistencyReport.class, report -> report.dynamicLabelRecordNotInUse((DynamicRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportConsecutiveDynamicLabelRecordNotInUse() throws Exception {
        this.testDynamicRecordChain(node -> {
            List dynamicLabelRecords = node.getDynamicLabelRecords();
            ((DynamicRecord)Iterables.last((Iterable)dynamicLabelRecords)).setInUse(false);
        }, ConsistencyReport.NodeConsistencyReport.class, report -> report.dynamicLabelRecordNotInUse((DynamicRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportEmptyDynamicLabelRecord() throws Exception {
        this.testDynamicRecordChain(node -> ((DynamicRecord)Iterables.last((Iterable)node.getDynamicLabelRecords())).setData(DynamicRecord.NO_DATA), ConsistencyReport.DynamicConsistencyReport.class, ConsistencyReport.DynamicConsistencyReport::emptyBlock);
    }

    @Test
    void shouldReportRecordNotFullReferencesNext() throws Exception {
        this.testDynamicRecordChain(node -> {
            DynamicRecord first = (DynamicRecord)Iterables.first((Iterable)node.getDynamicLabelRecords());
            first.setData(Arrays.copyOf(first.getData(), first.getLength() / 2));
        }, ConsistencyReport.DynamicConsistencyReport.class, ConsistencyReport.DynamicConsistencyReport::recordNotFullReferencesNext);
    }

    private <T extends ConsistencyReport> void testDynamicRecordChain(Consumer<NodeRecord> vandal, Class<T> expectedReportClass, Consumer<T> report) throws Exception {
        try (AutoCloseable ignored = this.tx();){
            long nodeId = this.nodeStore.nextId(CursorContext.NULL);
            NodeRecord node = new NodeRecord(nodeId).initialize(true, NULL, false, NULL, 0L);
            new InlineNodeLabels(node).put(NodeCheckerTest.toLongs(this.otherLabels), this.nodeStore, (DynamicRecordAllocator)this.nodeStore.getDynamicLabelStore(), CursorContext.NULL, StoreCursors.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            Assertions.assertThat((int)node.getDynamicLabelRecords().size()).isGreaterThanOrEqualTo(2);
            try (PageCursor storeCursor = this.storeCursors.writeCursor((CursorType)RecordCursorTypes.NODE_CURSOR);){
                this.nodeStore.updateRecord((AbstractBaseRecord)node, storeCursor, CursorContext.NULL, (StoreCursors)this.storeCursors);
            }
            vandal.accept(node);
            storeCursor = this.storeCursors.writeCursor((CursorType)RecordCursorTypes.NODE_CURSOR);
            try {
                this.nodeStore.updateRecord((AbstractBaseRecord)node, storeCursor, CursorContext.NULL, (StoreCursors)this.storeCursors);
            }
            finally {
                if (storeCursor != null) {
                    storeCursor.close();
                }
            }
        }
        this.check();
        this.expect(expectedReportClass, report);
    }

    @Test
    void shouldReportNodeDoesNotHaveExpectedLabel() throws Exception {
        try (AutoCloseable ignored = this.tx();){
            long nodeId = this.node(this.nodeStore.nextId(CursorContext.NULL), NULL, NULL, new int[0]);
            try (IndexUpdater writer = this.labelIndexWriter();){
                writer.process((IndexEntryUpdate)IndexEntryUpdate.change((long)nodeId, (SchemaDescriptorSupplier)IndexDescriptor.NO_INDEX, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])new long[]{this.label1}));
            }
        }
        this.check();
        this.expect(ConsistencyReport.LabelScanConsistencyReport.class, report -> report.nodeDoesNotHaveExpectedLabel((NodeRecord)ArgumentMatchers.any(), ArgumentMatchers.anyLong()));
    }

    @Test
    void shouldReportNodeLabelNotInIndexFirstNode() throws Exception {
        try (AutoCloseable ignored = this.tx();){
            this.node(this.nodeStore.nextId(CursorContext.NULL), NULL, NULL, this.label1);
        }
        this.check();
        this.expect(ConsistencyReport.LabelScanConsistencyReport.class, report -> report.nodeLabelNotInIndex((NodeRecord)ArgumentMatchers.any(), ArgumentMatchers.anyLong()));
    }

    @Test
    void shouldReportNodeLabelNotInIndexMiddleNode() throws Exception {
        try (AutoCloseable ignored = this.tx();
             IndexUpdater writer = this.labelIndexWriter();){
            for (int i = 0; i < 20; ++i) {
                long[] lArray;
                long nodeId = this.node(this.nodeStore.nextId(CursorContext.NULL), NULL, NULL, this.label1, this.label2);
                if (i == 10) {
                    long[] lArray2 = new long[1];
                    lArray = lArray2;
                    lArray2[0] = this.label1;
                } else {
                    long[] lArray3 = new long[2];
                    lArray3[0] = this.label1;
                    lArray = lArray3;
                    lArray3[1] = this.label2;
                }
                writer.process((IndexEntryUpdate)IndexEntryUpdate.change((long)nodeId, (SchemaDescriptorSupplier)IndexDescriptor.NO_INDEX, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])lArray));
            }
        }
        this.check();
        this.expect(ConsistencyReport.LabelScanConsistencyReport.class, report -> report.nodeLabelNotInIndex((NodeRecord)ArgumentMatchers.any(), ArgumentMatchers.anyLong()));
    }

    @Test
    void shouldReportNodeLabelHigherThanInt() throws Exception {
        try (AutoCloseable ignored = this.tx();){
            NodeRecord node = new NodeRecord(this.nodeStore.nextId(CursorContext.NULL)).initialize(true, NULL, false, NULL, 99310358657L);
            try (PageCursor storeCursor = this.storeCursors.writeCursor((CursorType)RecordCursorTypes.NODE_CURSOR);){
                this.nodeStore.updateRecord((AbstractBaseRecord)node, storeCursor, CursorContext.NULL, (StoreCursors)this.storeCursors);
            }
        }
        this.check();
        this.expect(ConsistencyReport.NodeConsistencyReport.class, ConsistencyReport.NodeConsistencyReport::illegalLabel);
    }

    @Test
    void shouldNotThrowOnCreation() throws Exception {
        NodeChecker checker = new NodeChecker(this.context(new ConsistencyFlags(false, true, false)), this.noMandatoryProperties);
        checker.check(LongRange.range((long)0L, (long)this.nodeStore.getHighId()), true, true);
    }

    private void check() throws Exception {
        NodeChecker checker = new NodeChecker(this.context(), this.noMandatoryProperties);
        checker.check(LongRange.range((long)0L, (long)this.nodeStore.getHighId()), true, true);
    }
}

