/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import java.io.OutputStream;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.log4j.Log4jLogProvider;
import org.neo4j.test.Race;
import org.neo4j.test.TestLabels;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.SuppressOutputExtension;
import org.neo4j.test.utils.TestDirectory;

@DbmsExtension
@ExtendWith(value={SuppressOutputExtension.class})
@ResourceLock(value="java.lang.System.out")
class LabelScanStoreTxApplyRaceIT {
    private static final int NUMBER_OF_DELETORS = 2;
    private static final int NUMBER_OF_CREATORS = Integer.max(2, Runtime.getRuntime().availableProcessors() - 2);
    private static final float CHANCE_LARGE_TX = 0.1f;
    private static final float CHANCE_TO_DELETE_BY_SAME_THREAD = 0.9f;
    private static final int LARGE_TX_SIZE = 3000;
    private static final Label[] LABELS = new Label[]{TestLabels.LABEL_ONE, TestLabels.LABEL_TWO, TestLabels.LABEL_THREE};
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private DatabaseManagementService managementService;
    @Inject
    private TestDirectory testDirectory;

    LabelScanStoreTxApplyRaceIT() {
    }

    @Test
    void shouldStressIt() throws Throwable {
        Race race = new Race().withMaxDuration(5L, TimeUnit.SECONDS);
        AtomicReferenceArray<Node> nodeHeads = new AtomicReferenceArray<Node>(NUMBER_OF_CREATORS);
        for (int i = 0; i < NUMBER_OF_CREATORS; ++i) {
            race.addContestant(this.creator(nodeHeads, i));
        }
        race.addContestants(2, this.deleter(nodeHeads));
        race.go();
        RecordDatabaseLayout dbLayout = (RecordDatabaseLayout)this.db.databaseLayout();
        this.managementService.shutdown();
        Assertions.assertTrue((boolean)new ConsistencyCheckService().runFullConsistencyCheck((DatabaseLayout)dbLayout, Config.defaults((Setting)GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.homePath()), ProgressMonitorFactory.NONE, (LogProvider)new Log4jLogProvider((OutputStream)System.out), false, new ConsistencyFlags(true, true, true)).isSuccessful());
    }

    private Runnable creator(final AtomicReferenceArray<Node> nodeHeads, final int guy) {
        return new Runnable(){
            private final ThreadLocalRandom random = ThreadLocalRandom.current();

            @Override
            public void run() {
                Node node;
                if (this.random.nextFloat() < 0.1f) {
                    try (Transaction tx = LabelScanStoreTxApplyRaceIT.this.db.beginTx();){
                        for (int i = 0; i < 3000; ++i) {
                            tx.createNode(this.randomLabels()).setProperty("name", (Object)UUID.randomUUID().toString());
                        }
                        tx.commit();
                    }
                }
                try (Transaction tx = LabelScanStoreTxApplyRaceIT.this.db.beginTx();){
                    node = tx.createNode(this.randomLabels());
                    nodeHeads.set(guy, node);
                    tx.commit();
                }
                if (this.random.nextFloat() < 0.9f && nodeHeads.getAndSet(guy, null) != null) {
                    tx = LabelScanStoreTxApplyRaceIT.this.db.beginTx();
                    try {
                        tx.getNodeById(node.getId()).delete();
                        tx.commit();
                    }
                    finally {
                        if (tx != null) {
                            tx.close();
                        }
                    }
                }
            }

            private Label[] randomLabels() {
                Label[] labels = new Label[LABELS.length];
                int cursor = 0;
                for (int i = 0; i < labels.length; ++i) {
                    if (!this.random.nextBoolean()) continue;
                    labels[cursor++] = LABELS[i];
                }
                if (cursor == 0) {
                    labels[cursor++] = LABELS[0];
                }
                return Arrays.copyOf(labels, cursor);
            }
        };
    }

    private Runnable deleter(final AtomicReferenceArray<Node> nodeHeads) {
        return new Runnable(){
            ThreadLocalRandom random = ThreadLocalRandom.current();

            @Override
            public void run() {
                int guy = this.random.nextInt(NUMBER_OF_CREATORS);
                Node node = nodeHeads.getAndSet(guy, null);
                if (node != null) {
                    try (Transaction tx = LabelScanStoreTxApplyRaceIT.this.db.beginTx();){
                        tx.getNodeById(node.getId()).delete();
                        tx.commit();
                    }
                    catch (NotFoundException notFoundException) {
                        // empty catch block
                    }
                }
            }
        };
    }
}

