/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import org.junit.jupiter.api.Assertions;
import org.neo4j.consistency.checking.index.IndexAccessors;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.impl.api.index.AbstractDelegatingIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.OnlineIndexProxy;

public class LookupAccessorsFromRunningDb
implements IndexAccessors.IndexAccessorLookup {
    private final IndexingService indexingService;

    public LookupAccessorsFromRunningDb(IndexingService indexingService) {
        this.indexingService = indexingService;
    }

    public IndexAccessor apply(IndexDescriptor indexDescriptor) {
        try {
            IndexProxy proxy = this.indexingService.getIndexProxy(indexDescriptor);
            while (proxy instanceof AbstractDelegatingIndexProxy) {
                proxy = ((AbstractDelegatingIndexProxy)proxy).getDelegate();
            }
            Assertions.assertEquals((Object)InternalIndexState.ONLINE, (Object)proxy.getState());
            return ((OnlineIndexProxy)proxy).accessor();
        }
        catch (IndexNotFoundKernelException e) {
            throw new RuntimeException(e);
        }
    }
}

