/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checker;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongConsumer;
import java.util.function.LongPredicate;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.ToLongFunction;
import java.util.stream.Stream;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.common.DependencyResolver;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.api.DatabaseManagementServiceBuilder;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.schema.ConstraintCreator;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.internal.recordstorage.RecordCursorTypes;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexEntriesReader;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.AbstractDelegatingIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.OnlineIndexProxy;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.impl.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.store.DynamicNodeLabels;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeLabels;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.cursor.CursorType;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.extension.testdirectory.TestDirectorySupportExtension;
import org.neo4j.test.utils.TestDirectory;
import org.neo4j.token.TokenHolders;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@ExtendWith(value={TestDirectorySupportExtension.class, RandomExtension.class})
public class DetectRandomSabotageIT {
    private static final int SOME_WAY_TOO_HIGH_ID = 10000000;
    private static final int NUMBER_OF_NODES = 1000;
    private static final int NUMBER_OF_INDEXES = 7;
    private static final String[] TOKEN_NAMES = new String[]{"One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight"};
    @Inject
    TestDirectory directory;
    @Inject
    protected RandomSupport random;
    private DatabaseManagementService dbms;
    private GraphDatabaseAPI db;
    private NeoStores neoStores;
    private DependencyResolver resolver;
    private StoreCursors storageCursors;

    private DatabaseManagementService getDbms(Path home) {
        return this.addConfig((DatabaseManagementServiceBuilder)this.createBuilder(home)).build();
    }

    protected TestDatabaseManagementServiceBuilder createBuilder(Path home) {
        return new TestDatabaseManagementServiceBuilder(home);
    }

    @BeforeEach
    protected void setUp() {
        this.dbms = this.getDbms(this.directory.homePath());
        this.db = (GraphDatabaseAPI)this.dbms.database("neo4j");
        MutableLongList nodeIds = this.createNodes(this.db);
        MutableLongSet singleRelationshipNodes = LongSets.mutable.empty();
        MutableLongSet denseNodes = LongSets.mutable.empty();
        while (singleRelationshipNodes.size() < 5) {
            singleRelationshipNodes.add(nodeIds.get(this.random.nextInt(nodeIds.size())));
        }
        while (denseNodes.size() < 5) {
            long nodeId = nodeIds.get(this.random.nextInt(nodeIds.size()));
            if (singleRelationshipNodes.contains(nodeId)) continue;
            denseNodes.add(nodeId);
        }
        this.createRelationships(this.db, nodeIds, singleRelationshipNodes);
        this.createAdditionalRelationshipsForDenseNodes(this.db, nodeIds, denseNodes);
        this.deleteSomeEntities(this.db, nodeIds, singleRelationshipNodes, denseNodes);
        this.createSchema(this.db);
        RecordStorageEngine recordStorageEngine = (RecordStorageEngine)this.db.getDependencyResolver().resolveDependency(RecordStorageEngine.class);
        this.neoStores = recordStorageEngine.testAccessNeoStores();
        this.storageCursors = recordStorageEngine.createStorageCursors(CursorContext.NULL);
        this.resolver = this.db.getDependencyResolver();
    }

    @AfterEach
    void tearDown() {
        this.storageCursors.close();
        this.dbms.shutdown();
    }

    @Test
    void shouldDetectRandomSabotage() throws Exception {
        SabotageType type = (SabotageType)((Object)this.random.among((Object[])SabotageType.values()));
        Sabotage sabotage = type.run(this.random, this.neoStores, this.resolver, this.db, this.storageCursors);
        ConsistencyCheckService.Result result = this.shutDownAndRunConsistencyChecker();
        boolean hasSomeErrorOrWarning = result.summary().getTotalInconsistencyCount() > 0L || result.summary().getTotalWarningCount() > 0L;
        Assertions.assertTrue((boolean)hasSomeErrorOrWarning);
    }

    @Test
    void shouldDetectIndexConfigCorruption() throws Exception {
        SchemaStore schemaStore = this.neoStores.getSchemaStore();
        PropertyStore propertyStore = schemaStore.propertyStore();
        long indexId = ((IndexingService)this.resolver.resolveDependency(IndexingService.class)).getIndexIds().longIterator().next();
        SchemaRecord schemaRecord = (SchemaRecord)schemaStore.newRecord();
        PageCursor cursor = this.storageCursors.readCursor((CursorType)RecordCursorTypes.SCHEMA_CURSOR);
        schemaStore.getRecordByCursor(indexId, (AbstractBaseRecord)schemaRecord, RecordLoad.FORCE, cursor);
        PropertyRecord indexConfigPropertyRecord = propertyStore.newRecord();
        PageCursor propertyCursor = this.storageCursors.readCursor((CursorType)RecordCursorTypes.PROPERTY_CURSOR);
        propertyStore.getRecordByCursor(schemaRecord.getNextProp(), (AbstractBaseRecord)indexConfigPropertyRecord, RecordLoad.FORCE, propertyCursor);
        propertyStore.ensureHeavy(indexConfigPropertyRecord, this.storageCursors);
        int[] tokenId = new int[1];
        ((TokenHolders)this.resolver.resolveDependency(TokenHolders.class)).propertyKeyTokens().getOrCreateInternalIds(new String[]{"foo"}, tokenId);
        PropertyBlock block = (PropertyBlock)indexConfigPropertyRecord.iterator().next();
        indexConfigPropertyRecord.removePropertyBlock(block.getKeyIndexId());
        PropertyBlock newBlock = new PropertyBlock();
        propertyStore.encodeValue(newBlock, tokenId[0], (Value)Values.intValue((int)11), CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        indexConfigPropertyRecord.addPropertyBlock(newBlock);
        try (PageCursor storeCursor = this.storageCursors.writeCursor((CursorType)RecordCursorTypes.PROPERTY_CURSOR);){
            propertyStore.updateRecord((AbstractBaseRecord)indexConfigPropertyRecord, storeCursor, CursorContext.NULL, this.storageCursors);
        }
        ConsistencyCheckService.Result result = this.shutDownAndRunConsistencyChecker();
        boolean hasSomeErrorOrWarning = result.summary().getTotalInconsistencyCount() > 0L || result.summary().getTotalWarningCount() > 0L;
        Assertions.assertTrue((boolean)hasSomeErrorOrWarning);
    }

    private void createSchema(GraphDatabaseAPI db) {
        for (int i = 0; i < 7; ++i) {
            String entityToken = (String)this.random.among((Object[])TOKEN_NAMES);
            String[] keys = (String[])this.random.selection((Object[])TOKEN_NAMES, 1, 3, false);
            if (this.random.nextBoolean()) {
                this.createNodeIndexAndConstraint(db, entityToken, keys);
                continue;
            }
            this.createRelationshipIndex(db, entityToken, keys);
        }
        try (Transaction tx = db.beginTx();){
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            tx.commit();
        }
    }

    private void createNodeIndexAndConstraint(GraphDatabaseAPI db, String entityToken, String[] keys) {
        Label label = Label.label((String)entityToken);
        this.createIndex(db, schema -> schema.indexFor(label), keys);
        if (keys.length == 1 && (double)this.random.nextFloat() < 0.3) {
            try (Transaction tx = db.beginTx();){
                ConstraintCreator constraintCreator = tx.schema().constraintFor(label);
                for (String key : keys) {
                    constraintCreator = constraintCreator.assertPropertyIsUnique(key);
                }
                if (this.random.nextBoolean()) {
                    constraintCreator = constraintCreator.withIndexType(org.neo4j.graphdb.schema.IndexType.RANGE);
                }
                constraintCreator.create();
                tx.commit();
            }
            catch (ConstraintViolationException constraintViolationException) {
                // empty catch block
            }
        }
    }

    private void createRelationshipIndex(GraphDatabaseAPI db, String entityToken, String[] keys) {
        RelationshipType type = RelationshipType.withName((String)entityToken);
        this.createIndex(db, schema -> schema.indexFor(type), keys);
    }

    private void createIndex(GraphDatabaseAPI db, Function<Schema, IndexCreator> indexFunc, String[] keys) {
        try (Transaction tx = db.beginTx();){
            IndexCreator indexCreator = indexFunc.apply(tx.schema());
            for (String key : keys) {
                indexCreator = indexCreator.on(key);
            }
            if (this.random.nextBoolean()) {
                indexCreator = indexCreator.withIndexType(org.neo4j.graphdb.schema.IndexType.RANGE);
            }
            indexCreator.create();
            tx.commit();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    private void deleteSomeEntities(GraphDatabaseAPI db, MutableLongList nodeIds, MutableLongSet singleRelationshipNodes, MutableLongSet denseNodes) {
        int nodesToDelete = 10;
        try (Transaction tx = db.beginTx();){
            for (int i = 0; i < nodesToDelete; ++i) {
                long nodeId;
                while (singleRelationshipNodes.contains(nodeId = nodeIds.get(this.random.nextInt(nodeIds.size()))) || denseNodes.contains(nodeId)) {
                }
                nodeIds.remove(nodeId);
                Node node = tx.getNodeById(nodeId);
                node.getRelationships().forEach(Relationship::delete);
                node.delete();
            }
            tx.commit();
        }
    }

    private void createAdditionalRelationshipsForDenseNodes(GraphDatabaseAPI db, MutableLongList nodeIds, MutableLongSet denseNodes) {
        try (Transaction tx = db.beginTx();){
            int additionalRelationships = denseNodes.size() * (Integer)GraphDatabaseSettings.dense_node_threshold.defaultValue();
            long[] denseNodeIds = denseNodes.toArray();
            for (int i = 0; i < additionalRelationships; ++i) {
                Node denseNode = tx.getNodeById(denseNodeIds[i % denseNodeIds.length]);
                Node otherNode = tx.getNodeById(nodeIds.get(this.random.nextInt(nodeIds.size())));
                Node startNode = this.random.nextBoolean() ? denseNode : otherNode;
                Node endNode = startNode == denseNode ? otherNode : denseNode;
                startNode.createRelationshipTo(endNode, RelationshipType.withName((String)((String)this.random.among((Object[])TOKEN_NAMES))));
            }
            tx.commit();
        }
    }

    private void createRelationships(GraphDatabaseAPI db, MutableLongList nodeIds, MutableLongSet singleRelationshipNodes) {
        try (Transaction tx = db.beginTx();){
            int numberOfRelationships = (int)(1000.0f * (10.0f + 10.0f * this.random.nextFloat()));
            for (int i = 0; i < numberOfRelationships; ++i) {
                Node startNode = tx.getNodeById(nodeIds.get(this.random.nextInt(nodeIds.size())));
                Node endNode = tx.getNodeById(nodeIds.get(this.random.nextInt(nodeIds.size())));
                Relationship relationship = startNode.createRelationshipTo(endNode, RelationshipType.withName((String)((String)this.random.among((Object[])TOKEN_NAMES))));
                this.setRandomProperties((Entity)relationship);
                if (singleRelationshipNodes.remove(startNode.getId())) {
                    nodeIds.remove(startNode.getId());
                }
                if (!singleRelationshipNodes.remove(endNode.getId())) continue;
                nodeIds.remove(endNode.getId());
            }
            tx.commit();
        }
    }

    private MutableLongList createNodes(GraphDatabaseAPI db) {
        MutableLongList nodeIds = LongLists.mutable.empty();
        try (Transaction tx = db.beginTx();){
            for (int i = 0; i < 1000; ++i) {
                Node node = tx.createNode(DetectRandomSabotageIT.labels((String[])this.random.selection((Object[])TOKEN_NAMES, 0, TOKEN_NAMES.length, false)));
                this.setRandomProperties((Entity)node);
                nodeIds.add(node.getId());
            }
            tx.commit();
        }
        return nodeIds;
    }

    private void setRandomProperties(Entity entity) {
        for (String key : (String[])this.random.selection((Object[])TOKEN_NAMES, 0, TOKEN_NAMES.length, false)) {
            entity.setProperty(key, this.randomValue().asObjectCopy());
        }
    }

    private Value randomValue() {
        switch (this.random.nextInt(100)) {
            case 0: {
                return this.random.nextAlphaNumericTextValue(300, 500);
            }
            case 1: {
                int arrayLength = this.random.nextInt(20, 40);
                String[] array = new String[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    array[i] = this.random.nextAlphaNumericTextValue(10, 20).stringValue();
                }
                return Values.stringArray((String[])array);
            }
        }
        return this.random.nextValue();
    }

    private static Label[] labels(String[] names) {
        return (Label[])Stream.of(names).map(Label::label).toArray(Label[]::new);
    }

    private ConsistencyCheckService.Result shutDownAndRunConsistencyChecker() throws ConsistencyCheckIncompleteException {
        this.dbms.shutdown();
        Config.Builder builder = Config.newBuilder().set(GraphDatabaseSettings.neo4j_home, (Object)this.directory.homePath());
        Config config = this.addConfig(builder).build();
        return new ConsistencyCheckService().runFullConsistencyCheck((DatabaseLayout)RecordDatabaseLayout.of((Config)config), config, ProgressMonitorFactory.NONE, (LogProvider)NullLogProvider.getInstance(), false, ConsistencyFlags.DEFAULT);
    }

    protected <T> T addConfig(T t, SetConfigAction<T> action) {
        return t;
    }

    private DatabaseManagementServiceBuilder addConfig(DatabaseManagementServiceBuilder builder) {
        return this.addConfig(builder, DatabaseManagementServiceBuilder::setConfig);
    }

    private Config.Builder addConfig(Config.Builder builder) {
        return this.addConfig(builder, Config.Builder::set);
    }

    private static class Sabotage {
        private final String description;
        private final String record;

        Sabotage(String description, String record) {
            this.description = description;
            this.record = record;
        }

        String description() {
            return this.description;
        }

        String record() {
            return this.record;
        }
    }

    static enum SabotageType {
        NODE_PROP{

            @Override
            Sabotage run(RandomSupport random, NeoStores stores, DependencyResolver otherDependencies, GraphDatabaseAPI db, StoreCursors storageCursors) {
                return 1.loadChangeUpdate(random, stores.getNodeStore(), SabotageType.usedRecord(), PrimitiveRecord::getNextProp, PrimitiveRecord::setNextProp, () -> 1.randomLargeSometimesNegative(random), storageCursors, (CursorType)RecordCursorTypes.NODE_CURSOR);
            }
        }
        ,
        NODE_REL{

            @Override
            Sabotage run(RandomSupport random, NeoStores stores, DependencyResolver otherDependencies, GraphDatabaseAPI db, StoreCursors storageCursors) {
                return 2.loadChangeUpdate(random, stores.getNodeStore(), SabotageType.usedRecord(), NodeRecord::getNextRel, NodeRecord::setNextRel, storageCursors, (CursorType)RecordCursorTypes.NODE_CURSOR);
            }
        }
        ,
        NODE_LABELS{

            @Override
            Sabotage run(RandomSupport random, NeoStores stores, DependencyResolver otherDependencies, GraphDatabaseAPI db, StoreCursors storageCursors) {
                NodeStore store = stores.getNodeStore();
                PageCursor nodeCursor = storageCursors.readCursor((CursorType)RecordCursorTypes.NODE_CURSOR);
                NodeRecord node = (NodeRecord)3.randomRecord(random, store, SabotageType.usedRecord(), nodeCursor);
                NodeRecord before = (NodeRecord)store.newRecord();
                store.getRecordByCursor(node.getId(), (AbstractBaseRecord)before, RecordLoad.NORMAL, nodeCursor);
                NodeLabels nodeLabels = NodeLabelsField.parseLabelsField((NodeRecord)node);
                long[] existing = nodeLabels.get(store, storageCursors);
                if (random.nextBoolean()) {
                    do {
                        long labelField;
                        if (NodeLabelsField.fieldPointsToDynamicRecordOfLabels((long)(labelField = random.nextLong(0xFFFFFFFFFFL)))) continue;
                        node.setLabelField(labelField, node.getDynamicLabelRecords());
                    } while (Arrays.equals(existing, NodeLabelsField.get((NodeRecord)node, (NodeStore)store, (StoreCursors)storageCursors)));
                } else {
                    long existingLabelField = node.getLabelField();
                    do {
                        node.setLabelField(DynamicNodeLabels.dynamicPointer((long)3.randomLargeSometimesNegative(random)), node.getDynamicLabelRecords());
                    } while (existingLabelField == node.getLabelField());
                }
                try (PageCursor storeCursor = storageCursors.writeCursor((CursorType)RecordCursorTypes.NODE_CURSOR);){
                    store.updateRecord((AbstractBaseRecord)node, storeCursor, CursorContext.NULL, storageCursors);
                }
                return SabotageType.recordSabotage(before, node);
            }
        }
        ,
        NODE_IN_USE{

            @Override
            Sabotage run(RandomSupport random, NeoStores stores, DependencyResolver otherDependencies, GraphDatabaseAPI db, StoreCursors storageCursors) {
                return 4.setRandomRecordNotInUse(random, stores.getNodeStore(), storageCursors, (CursorType)RecordCursorTypes.NODE_CURSOR);
            }
        }
        ,
        RELATIONSHIP_CHAIN{

            @Override
            Sabotage run(RandomSupport random, NeoStores stores, DependencyResolver otherDependencies, GraphDatabaseAPI db, StoreCursors storageCursors) {
                RelationshipStore store = stores.getRelationshipStore();
                PageCursor relCursor = storageCursors.readCursor((CursorType)RecordCursorTypes.RELATIONSHIP_CURSOR);
                RelationshipRecord relationship = (RelationshipRecord)5.randomRecord(random, store, SabotageType.usedRecord(), relCursor);
                RelationshipRecord before = (RelationshipRecord)store.newRecord();
                store.getRecordByCursor(relationship.getId(), (AbstractBaseRecord)before, RecordLoad.NORMAL, relCursor);
                LongSupplier rng = () -> 5.randomIdOrSometimesDefault(random, Record.NULL_REFERENCE.longValue(), id -> true);
                switch (random.nextInt(4)) {
                    case 0: {
                        if (!relationship.isFirstInFirstChain()) {
                            5.guaranteedChangedId(() -> ((RelationshipRecord)relationship).getFirstPrevRel(), arg_0 -> ((RelationshipRecord)relationship).setFirstPrevRel(arg_0), rng);
                            break;
                        }
                    }
                    case 1: {
                        5.guaranteedChangedId(() -> ((RelationshipRecord)relationship).getFirstNextRel(), arg_0 -> ((RelationshipRecord)relationship).setFirstNextRel(arg_0), rng);
                        break;
                    }
                    case 2: {
                        if (!relationship.isFirstInSecondChain()) {
                            5.guaranteedChangedId(() -> ((RelationshipRecord)relationship).getSecondPrevRel(), arg_0 -> ((RelationshipRecord)relationship).setSecondPrevRel(arg_0), rng);
                            break;
                        }
                    }
                    default: {
                        5.guaranteedChangedId(() -> ((RelationshipRecord)relationship).getSecondNextRel(), arg_0 -> ((RelationshipRecord)relationship).setSecondNextRel(arg_0), rng);
                    }
                }
                try (PageCursor storeCursor = storageCursors.writeCursor((CursorType)RecordCursorTypes.RELATIONSHIP_CURSOR);){
                    store.updateRecord((AbstractBaseRecord)relationship, storeCursor, CursorContext.NULL, storageCursors);
                }
                return SabotageType.recordSabotage(before, relationship);
            }
        }
        ,
        RELATIONSHIP_NODES{

            @Override
            Sabotage run(RandomSupport random, NeoStores stores, DependencyResolver otherDependencies, GraphDatabaseAPI db, StoreCursors storageCursors) {
                boolean startNode = random.nextBoolean();
                ToLongFunction<RelationshipRecord> getter = startNode ? RelationshipRecord::getFirstNode : RelationshipRecord::getSecondNode;
                BiConsumer<RelationshipRecord, Long> setter = startNode ? RelationshipRecord::setFirstNode : RelationshipRecord::setSecondNode;
                return 6.loadChangeUpdate(random, stores.getRelationshipStore(), SabotageType.usedRecord(), getter, setter, storageCursors, (CursorType)RecordCursorTypes.RELATIONSHIP_CURSOR);
            }
        }
        ,
        RELATIONSHIP_PROP{

            @Override
            Sabotage run(RandomSupport random, NeoStores stores, DependencyResolver otherDependencies, GraphDatabaseAPI db, StoreCursors storageCursors) {
                return 7.loadChangeUpdate(random, stores.getRelationshipStore(), SabotageType.usedRecord(), PrimitiveRecord::getNextProp, PrimitiveRecord::setNextProp, () -> 7.randomLargeSometimesNegative(random, propertyId -> {
                    if (Record.NULL_REFERENCE.is(propertyId)) {
                        return false;
                    }
                    if (propertyId < 0L) {
                        return true;
                    }
                    PropertyStore propertyStore = stores.getPropertyStore();
                    PropertyRecord record = propertyStore.newRecord();
                    propertyStore.getRecordByCursor(propertyId, (AbstractBaseRecord)record, RecordLoad.CHECK, storageCursors.readCursor((CursorType)RecordCursorTypes.PROPERTY_CURSOR));
                    return !record.inUse() || !Record.NULL_REFERENCE.is(record.getPrevProp());
                }), storageCursors, (CursorType)RecordCursorTypes.RELATIONSHIP_CURSOR);
            }
        }
        ,
        RELATIONSHIP_TYPE{

            @Override
            Sabotage run(RandomSupport random, NeoStores stores, DependencyResolver otherDependencies, GraphDatabaseAPI db, StoreCursors storageCursors) {
                return 8.loadChangeUpdate(random, stores.getRelationshipStore(), SabotageType.usedRecord(), RelationshipRecord::getType, (relationship, type) -> relationship.setType(type.intValue()), () -> random.nextInt(TOKEN_NAMES.length * 2) - 1, storageCursors, (CursorType)RecordCursorTypes.RELATIONSHIP_CURSOR);
            }
        }
        ,
        RELATIONSHIP_IN_USE{

            @Override
            Sabotage run(RandomSupport random, NeoStores stores, DependencyResolver otherDependencies, GraphDatabaseAPI db, StoreCursors storageCursors) {
                return 9.setRandomRecordNotInUse(random, stores.getRelationshipStore(), storageCursors, (CursorType)RecordCursorTypes.RELATIONSHIP_CURSOR);
            }
        }
        ,
        PROPERTY_CHAIN{

            @Override
            Sabotage run(RandomSupport random, NeoStores stores, DependencyResolver otherDependencies, GraphDatabaseAPI db, StoreCursors storageCursors) {
                boolean prev = random.nextBoolean();
                if (prev) {
                    return 10.loadChangeUpdate(random, stores.getPropertyStore(), SabotageType.usedRecord(), PropertyRecord::getPrevProp, PropertyRecord::setPrevProp, storageCursors, (CursorType)RecordCursorTypes.PROPERTY_CURSOR);
                }
                return 10.loadChangeUpdate(random, stores.getPropertyStore(), SabotageType.usedRecord(), PropertyRecord::getNextProp, PropertyRecord::setNextProp, () -> 10.randomLargeSometimesNegative(random), storageCursors, (CursorType)RecordCursorTypes.PROPERTY_CURSOR);
            }
        }
        ,
        PROPERTY_IN_USE{

            @Override
            Sabotage run(RandomSupport random, NeoStores stores, DependencyResolver otherDependencies, GraphDatabaseAPI db, StoreCursors storageCursors) {
                return 11.setRandomRecordNotInUse(random, stores.getPropertyStore(), storageCursors, (CursorType)RecordCursorTypes.PROPERTY_CURSOR);
            }
        }
        ,
        STRING_LENGTH{

            @Override
            Sabotage run(RandomSupport random, NeoStores stores, DependencyResolver otherDependencies, GraphDatabaseAPI db, StoreCursors storageCursors) {
                return SabotageType.loadChangeUpdateDynamicChain(random, stores.getPropertyStore(), (AbstractDynamicStore)stores.getPropertyStore().getStringStore(), PropertyType.STRING, record -> record.setData(Arrays.copyOf(record.getData(), random.nextInt(record.getLength()))), v -> true, storageCursors, (CursorType)RecordCursorTypes.DYNAMIC_STRING_STORE_CURSOR);
            }
        }
        ,
        STRING_IN_USE{

            @Override
            Sabotage run(RandomSupport random, NeoStores stores, DependencyResolver otherDependencies, GraphDatabaseAPI db, StoreCursors storageCursors) {
                return 13.setRandomRecordNotInUse(random, stores.getPropertyStore().getStringStore(), storageCursors, (CursorType)RecordCursorTypes.DYNAMIC_STRING_STORE_CURSOR);
            }
        }
        ,
        ARRAY_CHAIN{

            @Override
            Sabotage run(RandomSupport random, NeoStores stores, DependencyResolver otherDependencies, GraphDatabaseAPI db, StoreCursors storageCursors) {
                return SabotageType.loadChangeUpdateDynamicChain(random, stores.getPropertyStore(), (AbstractDynamicStore)stores.getPropertyStore().getArrayStore(), PropertyType.ARRAY, record -> record.setData(Arrays.copyOf(record.getData(), random.nextInt(record.getLength()))), v -> v.asObjectCopy() instanceof String[], storageCursors, (CursorType)RecordCursorTypes.DYNAMIC_ARRAY_STORE_CURSOR);
            }
        }
        ,
        ARRAY_LENGTH{

            @Override
            Sabotage run(RandomSupport random, NeoStores stores, DependencyResolver otherDependencies, GraphDatabaseAPI db, StoreCursors storageCursors) {
                return SabotageType.loadChangeUpdateDynamicChain(random, stores.getPropertyStore(), (AbstractDynamicStore)stores.getPropertyStore().getArrayStore(), PropertyType.ARRAY, record -> record.setData(Arrays.copyOf(record.getData(), random.nextInt(record.getLength()))), v -> true, storageCursors, (CursorType)RecordCursorTypes.DYNAMIC_ARRAY_STORE_CURSOR);
            }
        }
        ,
        ARRAY_IN_USE{

            @Override
            Sabotage run(RandomSupport random, NeoStores stores, DependencyResolver otherDependencies, GraphDatabaseAPI db, StoreCursors storageCursors) {
                return 16.setRandomRecordNotInUse(random, stores.getPropertyStore().getArrayStore(), storageCursors, (CursorType)RecordCursorTypes.DYNAMIC_ARRAY_STORE_CURSOR);
            }
        }
        ,
        RELATIONSHIP_GROUP_CHAIN{

            @Override
            Sabotage run(RandomSupport random, NeoStores stores, DependencyResolver otherDependencies, GraphDatabaseAPI db, StoreCursors storageCursors) {
                return 17.loadChangeUpdate(random, stores.getRelationshipGroupStore(), SabotageType.usedRecord(), RelationshipGroupRecord::getNext, RelationshipGroupRecord::setNext, () -> 17.randomIdOrSometimesDefault(random, Record.NULL_REFERENCE.longValue(), id -> true), storageCursors, (CursorType)RecordCursorTypes.GROUP_CURSOR);
            }
        }
        ,
        RELATIONSHIP_GROUP_TYPE{

            @Override
            Sabotage run(RandomSupport random, NeoStores stores, DependencyResolver otherDependencies, GraphDatabaseAPI db, StoreCursors storageCursors) {
                return 18.loadChangeUpdate(random, stores.getRelationshipGroupStore(), SabotageType.usedRecord(), RelationshipGroupRecord::getType, (group, type) -> group.setType(type.intValue()), () -> random.nextInt(TOKEN_NAMES.length * 2) - 1, storageCursors, (CursorType)RecordCursorTypes.GROUP_CURSOR);
            }
        }
        ,
        RELATIONSHIP_GROUP_FIRST_RELATIONSHIP{

            @Override
            Sabotage run(RandomSupport random, NeoStores stores, DependencyResolver otherDependencies, GraphDatabaseAPI db, StoreCursors storageCursors) {
                BiConsumer<RelationshipGroupRecord, Long> setter;
                ToLongFunction<RelationshipGroupRecord> getter;
                switch (random.nextInt(3)) {
                    case 0: {
                        getter = RelationshipGroupRecord::getFirstOut;
                        setter = RelationshipGroupRecord::setFirstOut;
                        break;
                    }
                    case 1: {
                        getter = RelationshipGroupRecord::getFirstIn;
                        setter = RelationshipGroupRecord::setFirstIn;
                        break;
                    }
                    default: {
                        getter = RelationshipGroupRecord::getFirstLoop;
                        setter = RelationshipGroupRecord::setFirstLoop;
                    }
                }
                return 19.loadChangeUpdate(random, stores.getRelationshipGroupStore(), SabotageType.usedRecord(), getter, setter, () -> 19.randomLargeSometimesNegative(random), storageCursors, (CursorType)RecordCursorTypes.GROUP_CURSOR);
            }
        }
        ,
        RELATIONSHIP_GROUP_IN_USE{

            @Override
            Sabotage run(RandomSupport random, NeoStores stores, DependencyResolver otherDependencies, GraphDatabaseAPI db, StoreCursors storageCursors) {
                return 20.setRandomRecordNotInUse(random, stores.getRelationshipGroupStore(), storageCursors, (CursorType)RecordCursorTypes.GROUP_CURSOR);
            }
        }
        ,
        SCHEMA_INDEX_ENTRY{

            @Override
            Sabotage run(RandomSupport random, NeoStores stores, DependencyResolver otherDependencies, GraphDatabaseAPI db, StoreCursors storageCursors) throws Exception {
                IndexingService indexing = (IndexingService)otherDependencies.resolveDependency(IndexingService.class);
                long[] indexIds = indexing.getIndexIds().toArray();
                IndexProxy indexProxy = null;
                while (indexProxy == null) {
                    long indexId = indexIds[random.nextInt(indexIds.length)];
                    indexProxy = indexing.getIndexProxy(indexId);
                    while (indexProxy instanceof AbstractDelegatingIndexProxy) {
                        indexProxy = ((AbstractDelegatingIndexProxy)indexProxy).getDelegate();
                    }
                    IndexType type = indexProxy.getDescriptor().getIndexType();
                    if (type == IndexType.BTREE || type == IndexType.RANGE) continue;
                    indexProxy = null;
                }
                IndexAccessor accessor = ((OnlineIndexProxy)indexProxy).accessor();
                long selectedEntityId = -1L;
                Object[] selectedValues = null;
                try (IndexEntriesReader reader = accessor.newAllEntriesValueReader(1, CursorContext.NULL)[0];){
                    long entityId = -1L;
                    Object[] values = null;
                    while (reader.hasNext()) {
                        entityId = reader.next();
                        values = reader.values();
                        if (!((double)random.nextFloat() < 0.01)) continue;
                        selectedEntityId = entityId;
                        selectedValues = values;
                    }
                    if (selectedValues == null && entityId != -1L) {
                        selectedEntityId = entityId;
                        selectedValues = values;
                    }
                }
                if (selectedEntityId == -1L) {
                    throw new UnsupportedOperationException("Something is wrong with the test, could not find index entry to sabotage");
                }
                boolean add = random.nextBoolean();
                if (indexProxy.getDescriptor().schema().entityType() == EntityType.RELATIONSHIP) {
                    add = false;
                }
                try (IndexUpdater updater = accessor.newUpdater(IndexUpdateMode.ONLINE_IDEMPOTENT, CursorContext.NULL);){
                    if (add) {
                        selectedEntityId = random.nextLong(10000000L);
                        updater.process((IndexEntryUpdate)IndexEntryUpdate.add((long)selectedEntityId, (SchemaDescriptorSupplier)indexProxy.getDescriptor(), (Value[])selectedValues));
                    } else {
                        updater.process((IndexEntryUpdate)IndexEntryUpdate.remove((long)selectedEntityId, (SchemaDescriptorSupplier)indexProxy.getDescriptor(), (Value[])selectedValues));
                    }
                }
                TokenNameLookup tokenNameLookup = (TokenNameLookup)otherDependencies.resolveDependency(TokenNameLookup.class);
                String userDescription = indexProxy.getDescriptor().userDescription(tokenNameLookup);
                return new Sabotage(String.format("%s entityId:%d values:%s index:%s", add ? "Add" : "Remove", selectedEntityId, Arrays.toString(selectedValues), userDescription), userDescription);
            }
        }
        ,
        NODE_LABEL_INDEX_ENTRY{

            @Override
            Sabotage run(RandomSupport random, NeoStores stores, DependencyResolver otherDependencies, GraphDatabaseAPI db, StoreCursors storageCursors) throws Exception {
                int labelId;
                IndexDescriptor nliDescriptor = null;
                try (Transaction tx = db.beginTx();){
                    Iterable indexes = tx.schema().getIndexes();
                    for (IndexDefinition indexDefinition : indexes) {
                        if (indexDefinition.getIndexType() != org.neo4j.graphdb.schema.IndexType.LOOKUP || !indexDefinition.isNodeIndex()) continue;
                        nliDescriptor = ((IndexDefinitionImpl)indexDefinition).getIndexReference();
                        break;
                    }
                    tx.commit();
                }
                Assertions.assertNotNull(nliDescriptor);
                IndexingService indexingService = (IndexingService)otherDependencies.resolveDependency(IndexingService.class);
                IndexProxy nliProxy = indexingService.getIndexProxy(nliDescriptor);
                boolean add = random.nextBoolean();
                NodeStore store = stores.getNodeStore();
                NodeRecord nodeRecord = 22.randomRecord(random, store, r -> add || r.inUse() && r.getLabelField() != Record.NO_LABELS_FIELD.longValue(), storageCursors.readCursor((CursorType)RecordCursorTypes.NODE_CURSOR));
                TokenHolders tokenHolders = (TokenHolders)otherDependencies.resolveDependency(TokenHolders.class);
                HashSet<String> labelNames = new HashSet<String>(Arrays.asList(TOKEN_NAMES));
                try (IndexUpdater writer = nliProxy.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);){
                    if (nodeRecord.inUse()) {
                        long[] labelsBefore;
                        NodeLabels labelsField = NodeLabelsField.parseLabelsField((NodeRecord)nodeRecord);
                        for (long labelIdBefore : labelsBefore = labelsField.get(store, storageCursors)) {
                            labelNames.remove(tokenHolders.labelTokens().getTokenById((int)labelIdBefore).name());
                        }
                        if (add) {
                            labelId = labelNames.isEmpty() ? 9999 : tokenHolders.labelTokens().getIdByName((String)random.among(new ArrayList<String>(labelNames)));
                            long[] labelsAfter = Arrays.copyOf(labelsBefore, labelsBefore.length + 1);
                            labelsAfter[labelsBefore.length] = labelId;
                            Arrays.sort(labelsAfter);
                            writer.process((IndexEntryUpdate)IndexEntryUpdate.change((long)nodeRecord.getId(), (SchemaDescriptorSupplier)nliDescriptor, (long[])labelsBefore, (long[])labelsAfter));
                        } else {
                            MutableLongList labels = LongLists.mutable.of(Arrays.copyOf(labelsBefore, labelsBefore.length));
                            labelId = (int)labels.removeAtIndex(random.nextInt(labels.size()));
                            long[] labelsAfter = labels.toSortedArray();
                            writer.process((IndexEntryUpdate)IndexEntryUpdate.change((long)nodeRecord.getId(), (SchemaDescriptorSupplier)nliDescriptor, (long[])labelsBefore, (long[])labelsAfter));
                        }
                    } else {
                        labelId = tokenHolders.labelTokens().getIdByName((String)random.among((Object[])TOKEN_NAMES));
                        writer.process((IndexEntryUpdate)IndexEntryUpdate.change((long)nodeRecord.getId(), (SchemaDescriptorSupplier)nliDescriptor, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])new long[]{labelId}));
                    }
                }
                return new Sabotage(String.format("%s labelId:%d node:%s", add ? "Add" : "Remove", labelId, nodeRecord), nodeRecord.toString());
            }
        }
        ,
        RELATIONSHIP_TYPE_INDEX_ENTRY{

            @Override
            Sabotage run(RandomSupport random, NeoStores stores, DependencyResolver otherDependencies, GraphDatabaseAPI db, StoreCursors storageCursors) throws Exception {
                String operation;
                int typeId;
                IndexDescriptor rtiDescriptor = null;
                try (Transaction tx = db.beginTx();){
                    Iterable indexes = tx.schema().getIndexes();
                    for (IndexDefinition indexDefinition : indexes) {
                        if (indexDefinition.getIndexType() != org.neo4j.graphdb.schema.IndexType.LOOKUP || !indexDefinition.isRelationshipIndex()) continue;
                        rtiDescriptor = ((IndexDefinitionImpl)indexDefinition).getIndexReference();
                        break;
                    }
                    tx.commit();
                }
                Assertions.assertNotNull(rtiDescriptor);
                IndexingService indexingService = (IndexingService)otherDependencies.resolveDependency(IndexingService.class);
                IndexProxy rtiProxy = indexingService.getIndexProxy(rtiDescriptor);
                RelationshipStore store = stores.getRelationshipStore();
                RelationshipRecord relationshipRecord = 23.randomRecord(random, store, r -> true, storageCursors.readCursor((CursorType)RecordCursorTypes.RELATIONSHIP_CURSOR));
                TokenHolders tokenHolders = (TokenHolders)otherDependencies.resolveDependency(TokenHolders.class);
                HashSet<String> relationshipTypeNames = new HashSet<String>(Arrays.asList(TOKEN_NAMES));
                int typeBefore = relationshipRecord.getType();
                long[] typesBefore = new long[]{typeBefore};
                try (IndexUpdater writer = rtiProxy.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);){
                    if (relationshipRecord.inUse()) {
                        long[] typesAfter;
                        int mode = random.nextInt(3);
                        if (mode < 2) {
                            relationshipTypeNames.remove(tokenHolders.relationshipTypeTokens().getTokenById(typeBefore).name());
                            typeId = tokenHolders.relationshipTypeTokens().getIdByName((String)random.among(new ArrayList<String>(relationshipTypeNames)));
                            if (mode == 0) {
                                operation = "Replace relationship type in index with a new type";
                                typesAfter = new long[]{typeId};
                            } else {
                                operation = "Add additional relationship type in index";
                                typesAfter = new long[]{typeId, typeBefore};
                                Arrays.sort(typesAfter);
                            }
                        } else {
                            operation = "Remove relationship type from index";
                            typeId = typeBefore;
                            typesAfter = PrimitiveLongCollections.EMPTY_LONG_ARRAY;
                        }
                        writer.process((IndexEntryUpdate)IndexEntryUpdate.change((long)relationshipRecord.getId(), (SchemaDescriptorSupplier)rtiDescriptor, (long[])typesBefore, (long[])typesAfter));
                    } else {
                        operation = "Add relationship type to a non-existing relationship (in relationship type index only)";
                        typeId = tokenHolders.labelTokens().getIdByName((String)random.among((Object[])TOKEN_NAMES));
                        writer.process((IndexEntryUpdate)IndexEntryUpdate.change((long)relationshipRecord.getId(), (SchemaDescriptorSupplier)rtiDescriptor, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])new long[]{typeId}));
                    }
                }
                String description = String.format("%s relationshipTypeId:%d relationship:%s", operation, typeId, relationshipRecord);
                return new Sabotage(description, relationshipRecord.toString());
            }
        }
        ,
        GRAPH_ENTITY_USES_INTERNAL_TOKEN{

            @Override
            Sabotage run(RandomSupport random, NeoStores stores, DependencyResolver otherDependencies, GraphDatabaseAPI db, StoreCursors storageCursors) throws Exception {
                TokenHolders tokenHolders = (TokenHolders)otherDependencies.resolveDependency(TokenHolders.class);
                String tokenName = "Token-" + System.currentTimeMillis();
                int[] tokenId = new int[1];
                switch (random.nextInt(3)) {
                    case 0: {
                        tokenHolders.labelTokens().getOrCreateInternalIds(new String[]{tokenName}, tokenId);
                        NodeStore nodeStore = stores.getNodeStore();
                        NodeRecord node = (NodeRecord)24.randomRecord(random, nodeStore, SabotageType.usedRecord(), storageCursors.readCursor((CursorType)RecordCursorTypes.NODE_CURSOR));
                        NodeLabelsField.parseLabelsField((NodeRecord)node).add((long)tokenId[0], nodeStore, (DynamicRecordAllocator)nodeStore.getDynamicLabelStore(), CursorContext.NULL, storageCursors, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
                        try (PageCursor storeCursor = storageCursors.writeCursor((CursorType)RecordCursorTypes.NODE_CURSOR);){
                            nodeStore.updateRecord((AbstractBaseRecord)node, storeCursor, CursorContext.NULL, storageCursors);
                        }
                        return new Sabotage("Node has label token which is internal", node.toString());
                    }
                    case 1: {
                        tokenHolders.propertyKeyTokens().getOrCreateInternalIds(new String[]{tokenName}, tokenId);
                        PropertyStore propertyStore = stores.getPropertyStore();
                        PropertyRecord property = (PropertyRecord)24.randomRecord(random, propertyStore, SabotageType.usedRecord(), storageCursors.readCursor((CursorType)RecordCursorTypes.PROPERTY_CURSOR));
                        PropertyBlock block = (PropertyBlock)property.iterator().next();
                        property.removePropertyBlock(block.getKeyIndexId());
                        PropertyBlock newBlock = new PropertyBlock();
                        propertyStore.encodeValue(newBlock, tokenId[0], (Value)Values.intValue((int)11), CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
                        property.addPropertyBlock(newBlock);
                        try (PageCursor storeCursor = storageCursors.writeCursor((CursorType)RecordCursorTypes.PROPERTY_CURSOR);){
                            propertyStore.updateRecord((AbstractBaseRecord)property, storeCursor, CursorContext.NULL, storageCursors);
                        }
                        return new Sabotage("Property has key which is internal", property.toString());
                    }
                }
                tokenHolders.relationshipTypeTokens().getOrCreateInternalIds(new String[]{tokenName}, tokenId);
                RelationshipStore relationshipStore = stores.getRelationshipStore();
                RelationshipRecord relationship = (RelationshipRecord)24.randomRecord(random, relationshipStore, SabotageType.usedRecord(), storageCursors.readCursor((CursorType)RecordCursorTypes.RELATIONSHIP_CURSOR));
                relationship.setType(tokenId[0]);
                try (PageCursor storeCursor = storageCursors.writeCursor((CursorType)RecordCursorTypes.RELATIONSHIP_CURSOR);){
                    relationshipStore.updateRecord((AbstractBaseRecord)relationship, storeCursor, CursorContext.NULL, storageCursors);
                }
                return new Sabotage("Relationship has type which is internal", relationship.toString());
            }
        };


        protected static <T extends AbstractBaseRecord> Sabotage setRandomRecordNotInUse(RandomSupport random, RecordStore<T> store, StoreCursors storeCursors, CursorType cursorType) {
            PageCursor readCursor = storeCursors.readCursor(cursorType);
            T before = SabotageType.randomRecord(random, store, SabotageType.usedRecord(), readCursor);
            AbstractBaseRecord record = store.newRecord();
            store.getRecordByCursor(before.getId(), record, RecordLoad.NORMAL, readCursor);
            record.setInUse(false);
            try (PageCursor storeCursor = storeCursors.writeCursor(cursorType);){
                store.updateRecord(record, storeCursor, CursorContext.NULL, storeCursors);
            }
            return SabotageType.recordSabotage(before, record);
        }

        private static <T extends AbstractBaseRecord> Predicate<T> usedRecord() {
            return AbstractBaseRecord::inUse;
        }

        protected static <T extends AbstractBaseRecord> Sabotage loadChangeUpdate(RandomSupport random, RecordStore<T> store, Predicate<T> filter, ToLongFunction<T> idGetter, BiConsumer<T, Long> idSetter, StoreCursors storeCursors, CursorType cursorType) {
            return SabotageType.loadChangeUpdate(random, store, filter, idGetter, idSetter, () -> SabotageType.randomIdOrSometimesDefault(random, Record.NULL_REFERENCE.longValue(), id -> true), storeCursors, cursorType);
        }

        protected static <T extends AbstractBaseRecord> Sabotage loadChangeUpdate(RandomSupport random, RecordStore<T> store, Predicate<T> filter, ToLongFunction<T> idGetter, BiConsumer<T, Long> idSetter, LongSupplier rng, StoreCursors storeCursors, CursorType cursorType) {
            PageCursor readCursor = storeCursors.readCursor(cursorType);
            T before = SabotageType.randomRecord(random, store, filter, readCursor);
            AbstractBaseRecord record = store.newRecord();
            store.getRecordByCursor(before.getId(), record, RecordLoad.NORMAL, readCursor);
            SabotageType.guaranteedChangedId(() -> idGetter.applyAsLong(record), changedId -> idSetter.accept(record, changedId), rng);
            try (PageCursor storeCursor = storeCursors.writeCursor(cursorType);){
                store.updateRecord(record, storeCursor, CursorContext.NULL, storeCursors);
            }
            return SabotageType.recordSabotage(before, record);
        }

        private static <T extends AbstractBaseRecord> Sabotage recordSabotage(T before, T after) {
            return new Sabotage(String.format("%s --> %s", before, after), after.toString());
        }

        protected static void guaranteedChangedId(LongSupplier getter, LongConsumer setter, LongSupplier rng) {
            long nextProp = getter.getAsLong();
            while (getter.getAsLong() == nextProp) {
                setter.accept(rng.getAsLong());
            }
        }

        private static Sabotage loadChangeUpdateDynamicChain(RandomSupport random, PropertyStore propertyStore, AbstractDynamicStore dynamicStore, PropertyType valueType, Consumer<DynamicRecord> vandal, Predicate<Value> checkability, StoreCursors storeCursors, CursorType dynamicCursorType) {
            PropertyRecord propertyRecord = propertyStore.newRecord();
            PageCursor propertyCursor = storeCursors.readCursor((CursorType)RecordCursorTypes.PROPERTY_CURSOR);
            block6: while (true) {
                propertyStore.getRecordByCursor(random.nextLong(propertyStore.getHighId()), (AbstractBaseRecord)propertyRecord, RecordLoad.CHECK, propertyCursor);
                if (!propertyRecord.inUse()) continue;
                PageCursor dynamicCursor = storeCursors.writeCursor(dynamicCursorType);
                try {
                    Iterator iterator = propertyRecord.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block6;
                        PropertyBlock block = (PropertyBlock)iterator.next();
                        if (block.getType() != valueType || !checkability.test(block.getType().value(block, propertyStore, storeCursors))) continue;
                        propertyStore.ensureHeavy(block, storeCursors);
                        if (block.getValueRecords().size() <= 1) continue;
                        DynamicRecord dynamicRecord = (DynamicRecord)block.getValueRecords().get(random.nextInt(block.getValueRecords().size() - 1));
                        DynamicRecord before = (DynamicRecord)dynamicStore.newRecord();
                        dynamicStore.getRecordByCursor(dynamicRecord.getId(), (AbstractBaseRecord)before, RecordLoad.NORMAL, storeCursors.readCursor(dynamicCursorType));
                        vandal.accept(dynamicRecord);
                        dynamicStore.updateRecord((AbstractBaseRecord)dynamicRecord, dynamicCursor, CursorContext.NULL, storeCursors);
                        Sabotage sabotage = SabotageType.recordSabotage(before, dynamicRecord);
                        return sabotage;
                    }
                }
                finally {
                    if (dynamicCursor == null) continue;
                    dynamicCursor.close();
                    continue;
                }
                break;
            }
        }

        protected static long randomIdOrSometimesDefault(RandomSupport random, long defaultValue, LongPredicate filter) {
            return (double)random.nextFloat() < 0.1 ? defaultValue : SabotageType.randomLargeSometimesNegative(random, filter);
        }

        protected static long randomLargeSometimesNegative(RandomSupport random) {
            return SabotageType.randomLargeSometimesNegative(random, id -> true);
        }

        protected static long randomLargeSometimesNegative(RandomSupport random, LongPredicate filter) {
            long value;
            do {
                value = random.nextLong(10000000L);
            } while (!filter.test(value = (double)random.nextFloat() < 0.2 ? -value : value));
            return value;
        }

        protected static <T extends AbstractBaseRecord> T randomRecord(RandomSupport random, RecordStore<T> store, Predicate<T> filter, PageCursor readCursor) {
            long highId = store.getHighId();
            AbstractBaseRecord record = store.newRecord();
            do {
                store.getRecordByCursor(random.nextLong(highId), record, RecordLoad.FORCE, readCursor);
            } while (!filter.test(record));
            return (T)record;
        }

        abstract Sabotage run(RandomSupport var1, NeoStores var2, DependencyResolver var3, GraphDatabaseAPI var4, StoreCursors var5) throws Exception;
    }

    @FunctionalInterface
    protected static interface SetConfigAction<TARGET> {
        public <VALUE> void setConfig(TARGET var1, Setting<VALUE> var2, VALUE var3);
    }
}

