/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checker;

import java.util.function.Function;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.impl.factory.primitive.IntObjectMaps;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.neo4j.common.EntityType;
import org.neo4j.consistency.checker.CheckerTestBase;
import org.neo4j.consistency.checker.SafePropertyChainReader;
import org.neo4j.consistency.checker.SchemaComplianceChecker;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.report.ConsistencyReporter;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.cursor.CachedStoreCursors;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class SchemaComplianceCheckerTest
extends CheckerTestBase {
    private int propertyKey1;
    private int propertyKey2;
    private int propertyKey3;
    private int label1;
    private int label2;
    private int label3;
    private int relType1;

    SchemaComplianceCheckerTest() {
    }

    @Override
    void initialData(KernelTransaction tx) throws KernelException {
        TokenWrite tokenWrite = tx.tokenWrite();
        this.propertyKey1 = tokenWrite.propertyKeyGetOrCreateForName("1");
        this.propertyKey2 = tokenWrite.propertyKeyGetOrCreateForName("2");
        this.propertyKey3 = tokenWrite.propertyKeyGetOrCreateForName("3");
        this.label1 = tokenWrite.labelGetOrCreateForName("A");
        this.label2 = tokenWrite.labelGetOrCreateForName("B");
        this.label3 = tokenWrite.labelGetOrCreateForName("C");
        this.relType1 = tokenWrite.relationshipTypeGetOrCreateForName("R");
    }

    @Test
    void shouldReportMissingMandatoryProperty() throws Exception {
        long nodeId = 0L;
        IntObjectHashMap propertyValues = new IntObjectHashMap();
        propertyValues.put(this.propertyKey2, (Object)Values.intValue((int)99));
        long[] labels = new long[]{this.label1, this.label3};
        MutableIntObjectMap mandatoryProperties = IntObjectMaps.mutable.empty();
        mandatoryProperties.put(this.label1, (Object)IntSets.mutable.of(new int[]{this.propertyKey1, this.propertyKey2}));
        mandatoryProperties.put(this.label2, (Object)IntSets.mutable.of(new int[]{this.propertyKey1, this.propertyKey3}));
        mandatoryProperties.put(this.label3, (Object)IntSets.mutable.of(new int[]{this.propertyKey1}));
        try (SchemaComplianceChecker checker = new SchemaComplianceChecker(this.context(), mandatoryProperties, (Iterable)this.context().indexAccessors.onlineRules(EntityType.NODE), CursorContext.NULL, (StoreCursors)this.storeCursors, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            checker.checkContainsMandatoryProperties((PrimitiveRecord)new NodeRecord(nodeId), labels, (IntObjectMap)propertyValues, arg_0 -> ((ConsistencyReporter)this.reporter).forNode(arg_0));
        }
        this.expect(ConsistencyReport.NodeConsistencyReport.class, report -> report.missingMandatoryProperty(ArgumentMatchers.anyInt()));
    }

    @Test
    void shouldReportNotUniquelyIndexed() throws Exception {
        long nodeId;
        LabelSchemaDescriptor descriptor = SchemaDescriptors.forLabel((int)this.label1, (int[])new int[]{this.propertyKey1});
        long indexId = this.uniqueIndex((SchemaDescriptor)descriptor);
        try (AutoCloseable ignored = this.tx();){
            TextValue value = Values.stringValue((String)"a");
            long propId = this.propertyStore.nextId(CursorContext.NULL);
            nodeId = this.node(this.nodeStore.nextId(CursorContext.NULL), propId, NULL, this.label1);
            this.property(propId, NULL, NULL, this.propertyValue(this.propertyKey1, (Value)value));
            this.indexValue(descriptor, indexId, nodeId, (Value)value);
            propId = this.propertyStore.nextId(CursorContext.NULL);
            long nodeId2 = this.node(this.nodeStore.nextId(CursorContext.NULL), propId, NULL, this.label1);
            this.property(propId, NULL, NULL, this.propertyValue(this.propertyKey1, (Value)value));
            this.indexValue(descriptor, indexId, nodeId2, (Value)value);
        }
        this.checkIndexed(nodeId);
        this.expect(ConsistencyReport.NodeConsistencyReport.class, report -> report.uniqueIndexNotUnique((IndexDescriptor)ArgumentMatchers.any(), (Object[])ArgumentMatchers.any(), ArgumentMatchers.anyLong()));
    }

    @Test
    void shouldReportNotIndexed() throws Exception {
        long nodeId;
        LabelSchemaDescriptor descriptor = SchemaDescriptors.forLabel((int)this.label1, (int[])new int[]{this.propertyKey1});
        this.index((SchemaDescriptor)descriptor);
        try (AutoCloseable ignored = this.tx();){
            long propId = this.propertyStore.nextId(CursorContext.NULL);
            nodeId = this.node(this.nodeStore.nextId(CursorContext.NULL), propId, NULL, this.label1);
            this.property(propId, NULL, NULL, this.propertyValue(this.propertyKey1, (Value)Values.stringValue((String)"a")));
        }
        this.checkIndexed(nodeId);
        this.expect(ConsistencyReport.NodeConsistencyReport.class, report -> report.notIndexed((IndexDescriptor)ArgumentMatchers.any(), (Object[])ArgumentMatchers.any()));
    }

    @Test
    void shouldReportNotIndexedRelationship() throws Exception {
        long relId;
        RelationTypeSchemaDescriptor descriptor = SchemaDescriptors.forRelType((int)this.relType1, (int[])new int[]{this.propertyKey1});
        this.index((SchemaDescriptor)descriptor);
        try (AutoCloseable ignored = this.tx();){
            long propId = this.propertyStore.nextId(CursorContext.NULL);
            relId = this.relationshipStore.nextId(CursorContext.NULL);
            long nodeId = this.node(this.nodeStore.nextId(CursorContext.NULL), NULL, relId, new int[0]);
            this.relationship(relId, nodeId, nodeId, this.relType1, propId, NULL, NULL, NULL, NULL, true, true);
            this.property(propId, NULL, NULL, this.propertyValue(this.propertyKey1, (Value)Values.stringValue((String)"a")));
        }
        this.checkRelationshipIndexed(relId);
        this.expect(ConsistencyReport.RelationshipConsistencyReport.class, report -> report.notIndexed((IndexDescriptor)ArgumentMatchers.any(), (Object[])ArgumentMatchers.any()));
    }

    @Test
    void shouldCheckIndexesWithLookupFiltering() throws Exception {
        long nodeId;
        LabelSchemaDescriptor descriptor = SchemaDescriptors.forLabel((int)this.label1, (int[])new int[]{this.propertyKey1});
        long indexId = this.uniqueIndex((SchemaDescriptor)descriptor);
        try (AutoCloseable ignored = this.tx();){
            PointValue value = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{2.0, 4.0});
            long propId = this.propertyStore.nextId(CursorContext.NULL);
            nodeId = this.node(this.nodeStore.nextId(CursorContext.NULL), propId, NULL, this.label1);
            this.property(propId, NULL, NULL, this.propertyValue(this.propertyKey1, (Value)value));
            this.indexValue(descriptor, indexId, nodeId, (Value)value);
            propId = this.propertyStore.nextId(CursorContext.NULL);
            long nodeId2 = this.node(this.nodeStore.nextId(CursorContext.NULL), propId, NULL, this.label1);
            this.property(propId, NULL, NULL, this.propertyValue(this.propertyKey1, (Value)value));
            this.indexValue(descriptor, indexId, nodeId2, (Value)value);
        }
        this.checkIndexed(nodeId);
        this.expect(ConsistencyReport.NodeConsistencyReport.class, report -> report.uniqueIndexNotUnique((IndexDescriptor)ArgumentMatchers.any(), (Object[])ArgumentMatchers.any(), ArgumentMatchers.anyLong()));
    }

    private void indexValue(LabelSchemaDescriptor descriptor, long indexId, long nodeId, Value value) throws IndexNotFoundKernelException, IndexEntryConflictException {
        IndexingService indexingService = (IndexingService)this.db.getDependencyResolver().resolveDependency(IndexingService.class);
        try (IndexUpdater indexUpdater = indexingService.getIndexProxy(indexId).newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);){
            indexUpdater.process((IndexEntryUpdate)IndexEntryUpdate.add((long)nodeId, () -> descriptor, (Value[])new Value[]{value}));
        }
    }

    private void checkIndexed(long nodeId) throws Exception {
        try (SchemaComplianceChecker checker = new SchemaComplianceChecker(this.context(), (MutableIntObjectMap)new IntObjectHashMap(), (Iterable)this.context().indexAccessors.onlineRules(EntityType.NODE), CursorContext.NULL, (StoreCursors)this.storeCursors, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            NodeRecord node = this.loadNode(nodeId);
            checker.checkCorrectlyIndexed((PrimitiveRecord)node, this.nodeLabels(node), this.readPropertyValues(node, arg_0 -> ((ConsistencyReporter)this.reporter).forNode(arg_0)), arg_0 -> ((ConsistencyReporter)this.reporter).forNode(arg_0));
        }
    }

    private void checkRelationshipIndexed(long relId) throws Exception {
        try (CachedStoreCursors storeCursors = new CachedStoreCursors(this.neoStores, CursorContext.NULL);
             SchemaComplianceChecker checker = new SchemaComplianceChecker(this.context(), (MutableIntObjectMap)new IntObjectHashMap(), (Iterable)this.context().indexAccessors.onlineRules(EntityType.RELATIONSHIP), CursorContext.NULL, (StoreCursors)storeCursors, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            RelationshipRecord record;
            RelationshipStore relationshipStore = this.neoStores.getRelationshipStore();
            try (PageCursor cursor = relationshipStore.openPageCursorForReading(relId, CursorContext.NULL);){
                record = (RelationshipRecord)relationshipStore.getRecordByCursor(relId, (AbstractBaseRecord)((RelationshipRecord)relationshipStore.newRecord()), RecordLoad.NORMAL, cursor);
            }
            checker.checkCorrectlyIndexed((PrimitiveRecord)record, new long[]{record.getType()}, this.readPropertyValues(record, arg_0 -> ((ConsistencyReporter)this.reporter).forRelationship(arg_0)), arg_0 -> ((ConsistencyReporter)this.reporter).forRelationship(arg_0));
        }
    }

    private <PRIMITIVE extends PrimitiveRecord> MutableIntObjectMap<Value> readPropertyValues(PRIMITIVE entity, Function<PRIMITIVE, ConsistencyReport.PrimitiveConsistencyReport> primitiveReporter) throws Exception {
        try (SafePropertyChainReader reader = new SafePropertyChainReader(this.context().withoutReporting(), CursorContext.NULL);){
            IntObjectHashMap values = new IntObjectHashMap();
            reader.read((MutableIntObjectMap)values, entity, primitiveReporter, (StoreCursors)this.storeCursors);
            IntObjectHashMap intObjectHashMap = values;
            return intObjectHashMap;
        }
    }
}

