/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.commons.lang3.mutable.MutableInt;
import org.eclipse.collections.api.iterator.LongIterator;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.consistency.LookupAccessorsFromRunningDb;
import org.neo4j.consistency.checking.TransactionWriter;
import org.neo4j.consistency.checking.index.IndexAccessors;
import org.neo4j.consistency.store.DirectStoreAccess;
import org.neo4j.counts.CountsAccessor;
import org.neo4j.counts.CountsStore;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.exceptions.KernelException;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.counts.RelationshipGroupDegreesStore;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.internal.recordstorage.StoreTokens;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.api.InternalTransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.cursor.CachedStoreCursors;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.storageengine.api.EntityUpdates;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.utils.TestDirectory;
import org.neo4j.token.DelegatingTokenHolder;
import org.neo4j.token.TokenCreator;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.NamedToken;
import org.neo4j.token.api.TokenHolder;
import org.neo4j.util.Preconditions;

public abstract class GraphStoreFixture
implements AutoCloseable {
    private DirectStoreAccess directStoreAccess;
    private final long[] highIds = new long[StoreType.values().length];
    private final String formatName;
    private PageCache pageCache;
    private final TestDirectory testDirectory;
    private DatabaseManagementService managementService;
    private GraphDatabaseAPI database;
    private InternalTransactionCommitProcess commitProcess;
    private TransactionIdStore transactionIdStore;
    private NeoStores neoStores;
    private IndexingService indexingService;
    private RecordStorageEngine storageEngine;
    private CountsAccessor countsStore;
    private RelationshipGroupDegreesStore groupDegreesStore;
    private StoreCursors storeCursors;

    protected GraphStoreFixture(String formatName, TestDirectory testDirectory) {
        this.formatName = formatName;
        this.testDirectory = testDirectory;
        this.startDatabaseAndExtractComponents();
        this.generateInitialData();
    }

    private void startDatabaseAndExtractComponents() {
        this.managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath()).setFileSystem(this.testDirectory.getFileSystem()).setConfig(GraphDatabaseSettings.record_format, (Object)this.formatName).setConfig(GraphDatabaseInternalSettings.label_block_size, (Object)60).setConfig(GraphDatabaseInternalSettings.consistency_check_on_apply, (Object)false).setConfig(this.getConfig()).build();
        this.database = (GraphDatabaseAPI)this.managementService.database("neo4j");
        DependencyResolver dependencyResolver = this.database.getDependencyResolver();
        this.commitProcess = new InternalTransactionCommitProcess((TransactionAppender)dependencyResolver.resolveDependency(TransactionAppender.class), (StorageEngine)dependencyResolver.resolveDependency(StorageEngine.class), (DatabaseHealth)dependencyResolver.resolveDependency(DatabaseHealth.class));
        this.transactionIdStore = (TransactionIdStore)this.database.getDependencyResolver().resolveDependency(TransactionIdStore.class);
        this.storageEngine = (RecordStorageEngine)dependencyResolver.resolveDependency(RecordStorageEngine.class);
        this.neoStores = this.storageEngine.testAccessNeoStores();
        this.indexingService = (IndexingService)dependencyResolver.resolveDependency(IndexingService.class);
        this.directStoreAccess = new DirectStoreAccess(this.neoStores, (IndexProviderMap)dependencyResolver.resolveDependency(IndexProviderMap.class), (TokenHolders)dependencyResolver.resolveDependency(TokenHolders.class), (IndexStatisticsStore)dependencyResolver.resolveDependency(IndexStatisticsStore.class), (IdGeneratorFactory)dependencyResolver.resolveDependency(IdGeneratorFactory.class));
        this.countsStore = this.storageEngine.countsAccessor();
        this.storeCursors = this.storageEngine.createStorageCursors(CursorContext.NULL);
        this.groupDegreesStore = this.storageEngine.relationshipGroupDegreesStore();
        this.pageCache = (PageCache)dependencyResolver.resolveDependency(PageCache.class);
    }

    @Override
    public void close() {
        this.managementService.shutdown();
    }

    public void apply(Transaction transaction) throws KernelException {
        TransactionRepresentation representation = transaction.representation(this.idGenerator(), this.transactionIdStore.getLastCommittedTransactionId(), this.neoStores, this.indexingService);
        try (StoreCursors storeCursors = this.storageEngine.createStorageCursors(CursorContext.NULL);){
            this.commitProcess.commit(new TransactionToApply(representation, CursorContext.NULL, storeCursors), CommitEvent.NULL, TransactionApplicationMode.EXTERNAL);
        }
    }

    public void apply(Consumer<org.neo4j.graphdb.Transaction> tx) {
        try (org.neo4j.graphdb.Transaction transaction = this.database.beginTx();){
            tx.accept(transaction);
            transaction.commit();
        }
    }

    public DirectStoreAccess directStoreAccess() {
        return this.directStoreAccess(false);
    }

    public DirectStoreAccess readOnlyDirectStoreAccess() {
        return this.directStoreAccess(false);
    }

    public PageCache getInstantiatedPageCache() {
        return this.pageCache;
    }

    private DirectStoreAccess directStoreAccess(boolean readOnly) {
        Preconditions.checkState((!readOnly ? 1 : 0) != 0, (String)"Doesn't support read-only yet");
        return this.directStoreAccess;
    }

    public ThrowingSupplier<CountsStore, IOException> counts() {
        return () -> (CountsStore)this.countsStore;
    }

    public ThrowingSupplier<RelationshipGroupDegreesStore, IOException> groupDegrees() {
        return () -> this.groupDegreesStore;
    }

    public IndexAccessors.IndexAccessorLookup indexAccessorLookup() {
        return new LookupAccessorsFromRunningDb(this.indexingService);
    }

    public DatabaseLayout databaseLayout() {
        return Neo4jLayout.of((Path)this.testDirectory.homePath()).databaseLayout("neo4j");
    }

    public IndexingService indexingService() {
        return this.indexingService;
    }

    public StoreCursors getStoreCursors() {
        return this.storeCursors;
    }

    /*
     * Exception decompiling
     */
    public EntityUpdates nodeAsUpdates(long nodeId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public EntityUpdates relationshipAsUpdates(long relId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Iterator<IndexDescriptor> getIndexDescriptors() {
        final LongIterator ids = this.indexingService.getIndexIds().longIterator();
        return new PrefetchingIterator<IndexDescriptor>(){

            protected IndexDescriptor fetchNextOrNull() {
                if (ids.hasNext()) {
                    long indexId = ids.next();
                    try {
                        return GraphStoreFixture.this.indexingService.getIndexProxy(indexId).getDescriptor();
                    }
                    catch (IndexNotFoundKernelException e) {
                        throw new IllegalStateException(e);
                    }
                }
                return null;
            }
        };
    }

    public NeoStores neoStores() {
        return this.neoStores;
    }

    public TokenHolders writableTokenHolders() {
        DelegatingTokenHolder propertyKeyTokens = new DelegatingTokenHolder(this.buildTokenCreator((name, internal, tx, next) -> {
            int id = next.propertyKey();
            tx.propertyKey(id, name, internal);
            return id;
        }), "PropertyKey");
        DelegatingTokenHolder labelTokens = new DelegatingTokenHolder(this.buildTokenCreator((name, internal, tx, next) -> {
            int id = next.label();
            tx.nodeLabel(id, name, internal);
            return id;
        }), "Label");
        DelegatingTokenHolder relationshipTypeTokens = new DelegatingTokenHolder(this.buildTokenCreator((name, internal, tx, next) -> {
            int id = next.relationshipType();
            tx.relationshipType(id, name, internal);
            return id;
        }), "RelationshipType");
        TokenHolders tokenHolders = new TokenHolders((TokenHolder)propertyKeyTokens, (TokenHolder)labelTokens, (TokenHolder)relationshipTypeTokens);
        try (CachedStoreCursors storeCursors = new CachedStoreCursors(this.neoStores, CursorContext.NULL);){
            tokenHolders.setInitialTokens(StoreTokens.allReadableTokens((NeoStores)this.directStoreAccess().nativeStores()), (StoreCursors)storeCursors);
        }
        return tokenHolders;
    }

    private TokenCreator buildTokenCreator(final TokenChange propChange) {
        return (name, internal) -> {
            final MutableInt keyId = new MutableInt();
            this.apply(new Transaction(){

                @Override
                protected void transactionData(TransactionDataBuilder tx, IdGenerator next) {
                    keyId.setValue(propChange.createToken(name, internal, tx, next));
                }
            });
            return keyId.intValue();
        };
    }

    public IdGenerator idGenerator() {
        return new IdGenerator();
    }

    protected abstract void generateInitialData(GraphDatabaseService var1);

    private void generateInitialData() {
        this.generateInitialData((GraphDatabaseService)this.database);
        this.keepHighId(StoreType.SCHEMA, (RecordStore<? extends AbstractBaseRecord>)this.neoStores.getSchemaStore());
        this.keepHighId(StoreType.NODE, (RecordStore<? extends AbstractBaseRecord>)this.neoStores.getNodeStore());
        this.keepHighId(StoreType.LABEL_TOKEN, (RecordStore<? extends AbstractBaseRecord>)this.neoStores.getLabelTokenStore());
        this.keepHighId(StoreType.NODE_LABEL, (RecordStore<? extends AbstractBaseRecord>)this.neoStores.getNodeStore().getDynamicLabelStore());
        this.keepHighId(StoreType.RELATIONSHIP, (RecordStore<? extends AbstractBaseRecord>)this.neoStores.getRelationshipStore());
        this.keepHighId(StoreType.RELATIONSHIP_GROUP, (RecordStore<? extends AbstractBaseRecord>)this.neoStores.getRelationshipGroupStore());
        this.keepHighId(StoreType.PROPERTY, (RecordStore<? extends AbstractBaseRecord>)this.neoStores.getPropertyStore());
        this.keepHighId(StoreType.PROPERTY_STRING, (RecordStore<? extends AbstractBaseRecord>)this.neoStores.getPropertyStore().getStringStore());
        this.keepHighId(StoreType.PROPERTY_ARRAY, (RecordStore<? extends AbstractBaseRecord>)this.neoStores.getPropertyStore().getArrayStore());
        this.keepHighId(StoreType.RELATIONSHIP_TYPE_TOKEN, (RecordStore<? extends AbstractBaseRecord>)this.neoStores.getRelationshipTypeTokenStore());
        this.keepHighId(StoreType.PROPERTY_KEY_TOKEN, (RecordStore<? extends AbstractBaseRecord>)this.neoStores.getPropertyKeyTokenStore());
    }

    private void keepHighId(StoreType storeType, RecordStore<? extends AbstractBaseRecord> store) {
        this.highIds[storeType.ordinal()] = store.getHighId();
    }

    protected abstract Map<Setting<?>, Object> getConfig();

    public static final class TransactionDataBuilder {
        private final TransactionWriter writer;
        private final NodeStore nodes;
        private final IndexingService indexingService;
        private final TokenHolders tokenHolders;
        private final AtomicInteger propKeyDynIds;
        private final AtomicInteger labelDynIds;
        private final AtomicInteger relTypeDynIds;

        TransactionDataBuilder(TransactionWriter writer, NeoStores neoStores, IdGenerator next, IndexingService indexingService) {
            this.propKeyDynIds = new AtomicInteger((int)neoStores.getPropertyKeyTokenStore().getNameStore().getHighId());
            this.labelDynIds = new AtomicInteger((int)neoStores.getLabelTokenStore().getNameStore().getHighId());
            this.relTypeDynIds = new AtomicInteger((int)neoStores.getRelationshipTypeTokenStore().getNameStore().getHighId());
            this.writer = writer;
            this.nodes = neoStores.getNodeStore();
            this.indexingService = indexingService;
            DelegatingTokenHolder propTokens = new DelegatingTokenHolder((name, internal) -> {
                int id = next.propertyKey();
                writer.propertyKey(id, name, internal, TransactionDataBuilder.dynIds(0, this.propKeyDynIds, name));
                return id;
            }, "PropertyKey");
            DelegatingTokenHolder labelTokens = new DelegatingTokenHolder((name, internal) -> {
                int id = next.label();
                writer.label(id, name, internal, TransactionDataBuilder.dynIds(0, this.labelDynIds, name));
                return id;
            }, "Label");
            DelegatingTokenHolder relTypeTokens = new DelegatingTokenHolder((name, internal) -> {
                int id = next.relationshipType();
                writer.relationshipType(id, name, internal, TransactionDataBuilder.dynIds(0, this.relTypeDynIds, name));
                return id;
            }, "RelationshipType");
            this.tokenHolders = new TokenHolders((TokenHolder)propTokens, (TokenHolder)labelTokens, (TokenHolder)relTypeTokens);
            try (CachedStoreCursors storeCursors = new CachedStoreCursors(neoStores, CursorContext.NULL);){
                this.tokenHolders.setInitialTokens(StoreTokens.allReadableTokens((NeoStores)neoStores), (StoreCursors)storeCursors);
                this.tokenHolders.propertyKeyTokens().getAllTokens().forEach(token -> this.propKeyDynIds.getAndUpdate(id -> Math.max(id, token.id() + 1)));
                this.tokenHolders.labelTokens().getAllTokens().forEach(token -> this.labelDynIds.getAndUpdate(id -> Math.max(id, token.id() + 1)));
                this.tokenHolders.relationshipTypeTokens().getAllTokens().forEach(token -> this.relTypeDynIds.getAndUpdate(id -> Math.max(id, token.id() + 1)));
            }
        }

        private static int[] dynIds(int externalBase, AtomicInteger idGenerator, String name) {
            if (idGenerator.get() <= externalBase) {
                idGenerator.set(externalBase + 1);
            }
            byte[] bytes = name.getBytes(StandardCharsets.UTF_8);
            int blocks = 1 + bytes.length / 30;
            int base = idGenerator.getAndAdd(blocks);
            int[] ids = new int[blocks];
            for (int i = 0; i < blocks; ++i) {
                ids[i] = base + i;
            }
            return ids;
        }

        public TokenHolders tokenHolders() {
            return this.tokenHolders;
        }

        public void createSchema(SchemaRecord before, SchemaRecord after, SchemaRule rule) {
            this.writer.createSchema(before, after, rule);
        }

        public int[] propertyKey(int id, String key, boolean internal) {
            int[] dynamicIds = TransactionDataBuilder.dynIds(id, this.propKeyDynIds, key);
            this.writer.propertyKey(id, key, internal, dynamicIds);
            this.tokenHolders.propertyKeyTokens().addToken(new NamedToken(key, id));
            return dynamicIds;
        }

        public int[] nodeLabel(int id, String name, boolean internal) {
            int[] dynamicIds = TransactionDataBuilder.dynIds(id, this.labelDynIds, name);
            this.writer.label(id, name, internal, dynamicIds);
            this.tokenHolders.labelTokens().addToken(new NamedToken(name, id));
            return dynamicIds;
        }

        public int[] relationshipType(int id, String relationshipType, boolean internal) {
            int[] dynamicIds = TransactionDataBuilder.dynIds(id, this.relTypeDynIds, relationshipType);
            this.writer.relationshipType(id, relationshipType, internal, dynamicIds);
            this.tokenHolders.relationshipTypeTokens().addToken(new NamedToken(relationshipType, id));
            return dynamicIds;
        }

        public void create(NodeRecord node) {
            this.updateCounts(node, 1);
            this.writer.create(node);
        }

        public void update(NodeRecord before, NodeRecord after) {
            this.updateCounts(before, -1);
            this.updateCounts(after, 1);
            this.writer.update(before, after);
        }

        public void delete(NodeRecord node) {
            this.updateCounts(node, -1);
            this.writer.delete(node);
        }

        public void create(RelationshipRecord relationship) {
            this.writer.create(relationship);
        }

        public void update(RelationshipRecord before, RelationshipRecord after) {
            this.writer.update(before, after);
        }

        public void delete(RelationshipRecord relationship) {
            this.writer.delete(relationship);
        }

        public void create(RelationshipGroupRecord group) {
            this.writer.create(group);
        }

        public void update(RelationshipGroupRecord before, RelationshipGroupRecord after) {
            this.writer.update(before, after);
        }

        public void delete(RelationshipGroupRecord group) {
            this.writer.delete(group);
        }

        public void create(PropertyRecord property) {
            this.writer.create(property);
        }

        public void update(PropertyRecord before, PropertyRecord property) {
            this.writer.update(before, property);
        }

        public void delete(PropertyRecord before, PropertyRecord property) {
            this.writer.delete(before, property);
        }

        private void updateCounts(NodeRecord node, int delta) {
            this.writer.incrementNodeCount(-1, delta);
            for (long label : NodeLabelsField.parseLabelsField((NodeRecord)node).get(this.nodes, StoreCursors.NULL)) {
                this.writer.incrementNodeCount((int)label, delta);
            }
        }

        public void incrementNodeCount(int labelId, long delta) {
            this.writer.incrementNodeCount(labelId, delta);
        }

        public void incrementRelationshipCount(int startLabelId, int typeId, int endLabelId, long delta) {
            this.writer.incrementRelationshipCount(startLabelId, typeId, endLabelId, delta);
        }

        public IndexDescriptor completeConfiguration(IndexDescriptor indexDescriptor) {
            return this.indexingService.completeConfiguration(indexDescriptor);
        }
    }

    public class IdGenerator {
        private long nextId(StoreType type) {
            int n = type.ordinal();
            long l = GraphStoreFixture.this.highIds[n];
            GraphStoreFixture.this.highIds[n] = l + 1L;
            return l;
        }

        public long schema() {
            return this.nextId(StoreType.SCHEMA);
        }

        public long node() {
            return this.nextId(StoreType.NODE);
        }

        public int label() {
            return (int)this.nextId(StoreType.LABEL_TOKEN);
        }

        public long nodeLabel() {
            return this.nextId(StoreType.NODE_LABEL);
        }

        public long relationship() {
            return this.nextId(StoreType.RELATIONSHIP);
        }

        public long relationshipGroup() {
            return this.nextId(StoreType.RELATIONSHIP_GROUP);
        }

        public long property() {
            return this.nextId(StoreType.PROPERTY);
        }

        public long stringProperty() {
            return this.nextId(StoreType.PROPERTY_STRING);
        }

        public long arrayProperty() {
            return this.nextId(StoreType.PROPERTY_ARRAY);
        }

        public int relationshipType() {
            return (int)this.nextId(StoreType.RELATIONSHIP_TYPE_TOKEN);
        }

        public int propertyKey() {
            return (int)this.nextId(StoreType.PROPERTY_KEY_TOKEN);
        }

        void updateCorrespondingIdGenerators(NeoStores neoStores) {
            neoStores.getNodeStore().setHighestPossibleIdInUse(GraphStoreFixture.this.highIds[StoreType.NODE.ordinal()]);
            neoStores.getRelationshipStore().setHighestPossibleIdInUse(GraphStoreFixture.this.highIds[StoreType.RELATIONSHIP.ordinal()]);
            neoStores.getRelationshipGroupStore().setHighestPossibleIdInUse(GraphStoreFixture.this.highIds[StoreType.RELATIONSHIP_GROUP.ordinal()]);
        }
    }

    public static abstract class Transaction {
        final long startTimestamp = System.currentTimeMillis();

        protected abstract void transactionData(TransactionDataBuilder var1, IdGenerator var2) throws KernelException;

        public TransactionRepresentation representation(IdGenerator idGenerator, long lastCommittedTx, NeoStores neoStores, IndexingService indexingService) throws KernelException {
            TransactionWriter writer = new TransactionWriter(neoStores);
            this.transactionData(new TransactionDataBuilder(writer, neoStores, idGenerator, indexingService), idGenerator);
            idGenerator.updateCorrespondingIdGenerators(neoStores);
            return writer.representation(new byte[0], this.startTimestamp, lastCommittedTx, System.currentTimeMillis());
        }
    }

    @FunctionalInterface
    static interface TokenChange {
        public int createToken(String var1, boolean var2, TransactionDataBuilder var3, IdGenerator var4);
    }
}

