/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.io.IOException;
import java.nio.file.Path;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.checker.DebugContext;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryPools;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.Unzip;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;
import org.neo4j.time.Clocks;

@TestDirectoryExtension
public class FullCheckFulltextIndexEmptyDocs {
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private FileSystemAbstraction fs;

    @Test
    void shouldNotReportEmptyDocsInFulltextIndexAsInconsistencies() throws Throwable {
        Config config = Config.newBuilder().set(GraphDatabaseSettings.allow_upgrade, (Object)true).set(GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.homePath()).build();
        DatabaseManagementService managementService = this.startUp42Db(config);
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
        DatabaseLayout layout = db.databaseLayout();
        managementService.shutdown();
        ConsistencyCheckService.Result result = this.check(config, layout);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConsistencyCheckService.Result check(Config config, DatabaseLayout layout) throws Exception {
        ConsistencyCheckService.Result result;
        JobScheduler jobScheduler = JobSchedulerFactory.createInitialisedScheduler();
        ConfiguringPageCacheFactory pageCacheFactory = new ConfiguringPageCacheFactory(this.fs, config, PageCacheTracer.NULL, (Log)NullLog.getInstance(), jobScheduler, Clocks.nanoClock(), new MemoryPools(((Boolean)config.get(GraphDatabaseSettings.memory_tracking)).booleanValue()));
        PageCache pageCache = pageCacheFactory.getOrCreatePageCache();
        try {
            result = new ConsistencyCheckService().runFullConsistencyCheck(layout, config, ProgressMonitorFactory.NONE, (LogProvider)NullLogProvider.getInstance(), this.fs, pageCache, DebugContext.NO_DEBUG, layout.databaseDirectory(), ConsistencyFlags.DEFAULT, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
        finally {
            pageCache.close();
            jobScheduler.close();
        }
        return result;
    }

    private DatabaseManagementService startUp42Db(Config config) throws IOException {
        Unzip.unzip(this.getClass(), (String)"SF4.0.0_fulltextWithEmptyDocs.zip", (Path)this.testDirectory.homePath());
        return new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath()).setConfig(config).build();
    }
}

