/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.mockito.Mockito;
import org.neo4j.bolt.protocol.common.message.request.connection.RoutingContext;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Session;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.exceptions.ArithmeticException;
import org.neo4j.fabric.DriverUtils;
import org.neo4j.fabric.bookmark.TransactionBookmarkManager;
import org.neo4j.fabric.executor.FabricExecutor;
import org.neo4j.fabric.transaction.FabricTransaction;
import org.neo4j.fabric.transaction.FabricTransactionInfo;
import org.neo4j.fabric.transaction.TransactionManager;
import org.neo4j.internal.helpers.Strings;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.DatabaseReferenceImpl;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.kernel.impl.query.QueryExecutionConfiguration;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.BoltDbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.values.virtual.MapValue;

@BoltDbmsExtension
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
class CommunityEditionEndToEndTest {
    @Inject
    private static GraphDatabaseAPI graphDatabase;
    @Inject
    private static ConnectorPortRegister connectorPortRegister;
    private static Driver driver;

    CommunityEditionEndToEndTest() {
    }

    @BeforeAll
    static void beforeAll() {
        driver = DriverUtils.createDriver(connectorPortRegister);
    }

    @BeforeEach
    void beforeEach() {
        try (Transaction tx = driver.session().beginTransaction();){
            tx.run("MATCH (n) DETACH DELETE n");
            tx.run("CREATE (:Person {name: 'Anna', uid: 0, age: 30})").consume();
            tx.run("CREATE (:Person {name: 'Bob',  uid: 1, age: 40})").consume();
            tx.commit();
        }
    }

    @AfterAll
    static void afterAll() {
        driver.close();
    }

    @Test
    void testUse() {
        CommunityEditionEndToEndTest.doTestUse("neo4j");
        CommunityEditionEndToEndTest.doTestUse("system");
    }

    @Test
    void testSystemCommandRouting() {
        CommunityEditionEndToEndTest.execute("neo4j", session -> session.run("CREATE USER foo SET PASSWORD 'password'").consume());
        List result = CommunityEditionEndToEndTest.execute("neo4j", session -> session.run("SHOW USERS").list()).stream().map(r -> r.get("user").asString()).collect(Collectors.toList());
        Assertions.assertThat(result).contains((Object[])new String[]{"foo"});
    }

    @Test
    void testSchemaCommand() {
        CommunityEditionEndToEndTest.doTestSchemaCommands("neo4j");
        CommunityEditionEndToEndTest.doTestSchemaCommands("system");
    }

    @Test
    void testWriteInReadModeShouldFail() {
        ClientException ex = (ClientException)org.junit.jupiter.api.Assertions.assertThrows(ClientException.class, () -> {
            try (Session session = driver.session(SessionConfig.builder().withDefaultAccessMode(AccessMode.READ).build());){
                String query = Strings.joinAsLines((String[])new String[]{"CREATE (n:Test)", "RETURN n"});
                session.run(query).list();
            }
        });
        Assertions.assertThat((String)ex.getMessage()).containsIgnoringCase((CharSequence)"Writing in read access mode not allowed");
    }

    @Test
    void testNoRollbackOnStatementFailure() {
        DependencyResolver dependencyResolver = graphDatabase.getDependencyResolver();
        TransactionManager transactionManager = (TransactionManager)dependencyResolver.resolveDependency(TransactionManager.class);
        FabricExecutor fabricExecutor = (FabricExecutor)dependencyResolver.resolveDependency(FabricExecutor.class);
        NormalizedDatabaseName databaseName = new NormalizedDatabaseName("neo4j");
        NamedDatabaseId databaseId = DatabaseIdFactory.from((String)databaseName.name(), (UUID)UUID.randomUUID());
        DatabaseReferenceImpl.Internal databaseRef = new DatabaseReferenceImpl.Internal(databaseName, databaseId, true);
        FabricTransactionInfo transactionInfo = new FabricTransactionInfo(org.neo4j.bolt.protocol.common.message.AccessMode.READ, LoginContext.AUTH_DISABLED, ClientConnectionInfo.EMBEDDED_CONNECTION, (DatabaseReference)databaseRef, false, Duration.ZERO, Map.of(), new RoutingContext(false, Map.of()), QueryExecutionConfiguration.DEFAULT_CONFIG);
        TransactionBookmarkManager bookmarkManager = (TransactionBookmarkManager)Mockito.mock(TransactionBookmarkManager.class);
        FabricTransaction tx1 = transactionManager.begin(transactionInfo, bookmarkManager);
        FabricTransaction tx2 = transactionManager.begin(transactionInfo, bookmarkManager);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)transactionManager.getOpenTransactions().size());
        String query1 = Strings.joinAsLines((String[])new String[]{"USE neo4j", "RETURN 1/0 AS res"});
        org.junit.jupiter.api.Assertions.assertThrows(ArithmeticException.class, () -> fabricExecutor.run(tx1, query1, MapValue.EMPTY).records().collectList().block());
        String query2 = Strings.joinAsLines((String[])new String[]{"USE neo4j", "UNWIND [1, 0] AS a", "RETURN 1/a AS res"});
        org.junit.jupiter.api.Assertions.assertThrows(ArithmeticException.class, () -> fabricExecutor.run(tx2, query2, MapValue.EMPTY).records().collectList().block());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)tx1.getReasonIfTerminated().isPresent());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)tx2.getReasonIfTerminated().isPresent());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)transactionManager.getOpenTransactions().isEmpty());
        tx1.rollback();
        tx2.rollback();
    }

    private static void doTestUse(String database) {
        List result = CommunityEditionEndToEndTest.execute(database, session -> session.run("USE neo4j MATCH (n) RETURN n.name AS name").list()).stream().map(r -> r.get("name").asString()).collect(Collectors.toList());
        Assertions.assertThat(result).contains((Object[])new String[]{"Anna", "Bob"});
    }

    private static void doTestSchemaCommands(String database) {
        CommunityEditionEndToEndTest.execute(database, session -> session.run("USE neo4j CREATE INDEX myIndex FOR (n:Person) ON (n.name)").consume());
        List result = CommunityEditionEndToEndTest.execute(database, session -> session.run("USE neo4j SHOW INDEXES YIELD name RETURN name").list()).stream().map(r -> r.get("name").asString()).collect(Collectors.toList());
        Assertions.assertThat(result).contains((Object[])new String[]{"myIndex"});
        CommunityEditionEndToEndTest.execute(database, session -> session.run("USE neo4j DROP INDEX myIndex").consume());
    }

    private static <T> T execute(String database, Function<Session, T> workload) {
        try (Session session = driver.session(SessionConfig.forDatabase((String)database));){
            T t = workload.apply(session);
            return t;
        }
    }
}

