/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.cypher.internal.compiler.helpers.SignatureResolver;
import org.neo4j.cypher.internal.planner.spi.ProcedureSignatureResolver;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.fabric.eval.Catalog;
import org.neo4j.fabric.planning.FabricPlanner;
import org.neo4j.fabric.planning.QueryType;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.api.procedure.ProcedureView;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DefaultFileSystemExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectorySupportExtension;
import org.neo4j.test.utils.TestDirectory;
import org.neo4j.values.virtual.MapValue;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@ExtendWith(value={DefaultFileSystemExtension.class, TestDirectorySupportExtension.class})
class SecurityProcedureQueryTypeTest {
    @Inject
    static TestDirectory testDirectory;
    private static FabricPlanner planner;
    private static DatabaseManagementService databaseManagementService;
    private static ProcedureSignatureResolver signatures;

    SecurityProcedureQueryTypeTest() {
    }

    @BeforeAll
    static void beforeAll() {
        databaseManagementService = new TestDatabaseManagementServiceBuilder(testDirectory.homePath()).setConfig(GraphDatabaseSettings.auth_enabled, (Object)true).setConfig(GraphDatabaseInternalSettings.query_router_new_stack, (Object)false).build();
        DependencyResolver dependencyResolver = ((GraphDatabaseFacade)databaseManagementService.database("system")).getDependencyResolver();
        planner = (FabricPlanner)dependencyResolver.resolveDependency(FabricPlanner.class);
        signatures = SignatureResolver.from((ProcedureView)((GlobalProcedures)dependencyResolver.resolveDependency(GlobalProcedures.class)).getCurrentView());
    }

    @AfterAll
    static void afterAll() {
        databaseManagementService.shutdown();
    }

    @Test
    void showCurrentUserShouldBeReadQueryType() {
        FabricPlanner.PlannerInstance instance = planner.instance(signatures, "CALL dbms.showCurrentUser()", MapValue.EMPTY, "system", Catalog.empty());
        Assertions.assertThat((Object)instance.plan().queryType()).isEqualTo((Object)QueryType.READ());
    }
}

