/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DefaultFileSystemExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectorySupportExtension;
import org.neo4j.test.utils.TestDirectory;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@ExtendWith(value={DefaultFileSystemExtension.class, TestDirectorySupportExtension.class})
class SecurityProcedureQueryTypeTest {
    @Inject
    static TestDirectory testDirectory;
    private static DatabaseManagementService databaseManagementService;

    SecurityProcedureQueryTypeTest() {
    }

    @BeforeAll
    static void beforeAll() {
        databaseManagementService = new TestDatabaseManagementServiceBuilder(testDirectory.homePath()).setConfig(GraphDatabaseSettings.auth_enabled, (Object)true).build();
    }

    @AfterAll
    static void afterAll() {
        databaseManagementService.shutdown();
    }

    @Test
    void showCurrentUserShouldBeReadQueryType() {
        Assertions.assertThat((boolean)databaseManagementService.database("system").beginTx().execute("CALL dbms.showCurrentUser()").getQueryExecutionType().canUpdateData()).isFalse();
    }
}

