/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.OtherThread;
import org.neo4j.test.extension.OtherThreadExtension;

@ImpermanentDbmsExtension
@ExtendWith(value={OtherThreadExtension.class})
public class NestedIndexReadersIT {
    private static final int ENTITIES_PER_ID = 3;
    private static final int IDS = 5;
    private static final String TOKEN = "Token";
    private static final String KEY = "key";
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private OtherThread t2;

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void shouldReadCorrectResultsFromMultipleNestedReaders(EntityControl<?> entityControl) {
        this.createIndex(entityControl);
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < 3; ++i) {
                NestedIndexReadersIT.createRoundOfEntities(tx, entityControl);
            }
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            ArrayList iterators = new ArrayList();
            for (int id = 0; id < 5; ++id) {
                iterators.add(entityControl.findEntities(tx, TOKEN, KEY, id));
            }
            for (int i = 0; i < 3; ++i) {
                NestedIndexReadersIT.assertRoundOfEntities(iterators, entityControl);
            }
            for (ResourceIterator resourceIterator : iterators) {
                org.junit.jupiter.api.Assertions.assertFalse((boolean)resourceIterator.hasNext());
                resourceIterator.close();
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void shouldReadCorrectResultsFromMultipleNestedReadersWhenConcurrentWriteHappens(EntityControl<?> entityControl) throws Exception {
        int i;
        this.createIndex(entityControl);
        try (Transaction tx = this.db.beginTx();){
            for (int id = 0; id < 5; ++id) {
                for (i = 0; i < 3; ++i) {
                    entityControl.createEntity(tx, TOKEN, KEY, id);
                }
            }
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            ArrayList iterators = new ArrayList();
            for (int id = 0; id < 5; ++id) {
                iterators.add(entityControl.findEntities(tx, TOKEN, KEY, id));
            }
            for (i = 0; i < 3; ++i) {
                NestedIndexReadersIT.assertRoundOfEntities(iterators, entityControl);
                if (i % 2 != 1) continue;
                this.t2.execute(this.entityCreator(entityControl)).get();
            }
            NestedIndexReadersIT.assertRoundOfEntities(iterators, entityControl);
            for (ResourceIterator resourceIterator : iterators) {
                org.junit.jupiter.api.Assertions.assertFalse((boolean)resourceIterator.hasNext());
                resourceIterator.close();
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private static void createRoundOfEntities(Transaction tx, EntityControl<?> entityControl) {
        for (int id = 0; id < 5; ++id) {
            entityControl.createEntity(tx, TOKEN, KEY, id);
        }
    }

    private static void assertRoundOfEntities(List<ResourceIterator<?>> iterators, EntityControl<?> entityControl) {
        for (int id = 0; id < 5; ++id) {
            entityControl.assertEntity(iterators.get(id), TOKEN, KEY, id);
        }
    }

    private Callable<Void> entityCreator(EntityControl<?> entityControl) {
        return () -> {
            try (Transaction tx = this.db.beginTx();){
                NestedIndexReadersIT.createRoundOfEntities(tx, entityControl);
                tx.commit();
            }
            return null;
        };
    }

    private void createIndex(EntityControl<?> entityControl) {
        try (Transaction tx = this.db.beginTx();){
            entityControl.createIndex(tx, TOKEN, KEY);
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(30L, TimeUnit.SECONDS);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    static Stream<Arguments> parameters() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{new EntityControl<Node>(){

            @Override
            public ResourceIterator<Node> findEntities(Transaction tx, String token, String key, Object value) {
                return tx.findNodes(Label.label((String)token), NestedIndexReadersIT.KEY, value);
            }

            @Override
            public void assertEntity(ResourceIterator<?> reader, String token, String key, Object value) {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.hasNext());
                Node node = (Node)reader.next();
                org.junit.jupiter.api.Assertions.assertTrue((boolean)node.hasLabel(Label.label((String)token)));
                org.junit.jupiter.api.Assertions.assertEquals((Object)value, (Object)node.getProperty(key), (String)("Expected node " + String.valueOf(node) + " (returned by index reader) to have 'id' property w/ value " + String.valueOf(value)));
            }

            @Override
            public void createEntity(Transaction tx, String token, String key, Object value) {
                tx.createNode(new Label[]{Label.label((String)token)}).setProperty(key, value);
            }

            @Override
            public void createIndex(Transaction tx, String token, String key) {
                tx.schema().indexFor(Label.label((String)token)).on(key).create();
            }

            public String toString() {
                return "NODE";
            }
        }}), Arguments.arguments((Object[])new Object[]{new EntityControl<Relationship>(){

            @Override
            public ResourceIterator<Relationship> findEntities(Transaction tx, String token, String key, Object value) {
                return tx.findRelationships(RelationshipType.withName((String)token), NestedIndexReadersIT.KEY, value);
            }

            @Override
            public void assertEntity(ResourceIterator<?> reader, String token, String key, Object value) {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.hasNext());
                Relationship rel = (Relationship)reader.next();
                Assertions.assertThat((Object)rel.getType()).isEqualTo((Object)RelationshipType.withName((String)token));
                org.junit.jupiter.api.Assertions.assertEquals((Object)value, (Object)rel.getProperty(key), (String)("Expected rel " + String.valueOf(rel) + " (returned by index reader) to have 'id' property w/ value " + String.valueOf(value)));
            }

            @Override
            public void createEntity(Transaction tx, String token, String key, Object value) {
                Node from = tx.createNode();
                Node to = tx.createNode();
                from.createRelationshipTo(to, RelationshipType.withName((String)token)).setProperty(key, value);
            }

            @Override
            public void createIndex(Transaction tx, String token, String key) {
                tx.schema().indexFor(RelationshipType.withName((String)token)).on(key).create();
            }

            public String toString() {
                return "RELATIONSHIP";
            }
        }}));
    }

    static interface EntityControl<T extends Entity> {
        public ResourceIterator<T> findEntities(Transaction var1, String var2, String var3, Object var4);

        public void assertEntity(ResourceIterator<?> var1, String var2, String var3, Object var4);

        public void createEntity(Transaction var1, String var2, String var3, Object var4);

        public void createIndex(Transaction var1, String var2, String var3);
    }
}

