/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index;

import java.io.IOException;
import java.nio.file.Files;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.commons.lang3.mutable.MutableInt;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.layout.CommonDatabaseStores;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;

@Neo4jLayoutExtension
class IndexSamplingIntegrationTest {
    @Inject
    private Neo4jLayout layout;
    private static final String TOKEN = "Person";
    private final String property = "name";
    private final String schemaName = "schema_name";
    private final long entities = 1000L;
    private final String[] names = new String[]{"Neo4j", "Neo", "Graph", "Apa"};

    IndexSamplingIntegrationTest() {
    }

    @ParameterizedTest
    @EnumSource(value=Entity.class)
    void shouldSampleNotUniqueIndex(Entity entity) throws Throwable {
        MutableInt deletions = new MutableInt();
        this.populateDatabaseThenTriggerIndexResamplingOnNextStartup(db -> {
            int i;
            try (Transaction tx = db.beginTx();){
                entity.createIndex(tx, "schema_name", TOKEN, "name");
                tx.commit();
            }
            tx = db.beginTx();
            try {
                tx.schema().awaitIndexOnline("schema_name", 1L, TimeUnit.MINUTES);
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
            tx = db.beginTx();
            try {
                i = 0;
                while ((long)i < 1000L) {
                    entity.createEntity(tx, TOKEN, "name", this.names[i % this.names.length]);
                    ++i;
                }
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
            tx = db.beginTx();
            try {
                i = 0;
                while ((long)i < 100L) {
                    entity.deleteFirstFound(tx, TOKEN, "name", this.names[i % this.names.length]);
                    deletions.increment();
                    ++i;
                }
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        });
        IndexSample indexSample = this.fetchIndexSamplingValues();
        int deletedNodes = deletions.intValue();
        ((AbstractLongAssert)Assertions.assertThat((long)indexSample.uniqueValues()).as("Unique values", new Object[0])).isEqualTo((long)this.names.length);
        ((AbstractLongAssert)Assertions.assertThat((long)indexSample.sampleSize()).as("Sample size", new Object[0])).isGreaterThanOrEqualTo(1000L - (long)deletedNodes).isLessThanOrEqualTo(1000L);
        ((AbstractLongAssert)Assertions.assertThat((long)indexSample.updates()).as("Updates", new Object[0])).isEqualTo(0L);
        ((AbstractLongAssert)Assertions.assertThat((long)indexSample.indexSize()).as("Index size", new Object[0])).isEqualTo(1000L - (long)deletedNodes);
    }

    @ParameterizedTest
    @EnumSource(value=Entity.class)
    void shouldSampleUniqueIndex(Entity entity) throws Throwable {
        MutableInt deletions = new MutableInt();
        this.populateDatabaseThenTriggerIndexResamplingOnNextStartup(db -> {
            int i;
            try (Transaction tx = db.beginTx();){
                entity.createConstraint(tx, "schema_name", TOKEN, "name");
                tx.commit();
            }
            tx = db.beginTx();
            try {
                i = 0;
                while ((long)i < 1000L) {
                    entity.createEntity(tx, TOKEN, "name", "" + i);
                    ++i;
                }
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
            tx = db.beginTx();
            try {
                i = 0;
                while ((long)i < 1000L) {
                    if (i % 10 == 0) {
                        entity.deleteFirstFound(tx, TOKEN, "name", "" + i);
                        deletions.increment();
                    }
                    ++i;
                }
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        });
        IndexSample indexSample = this.fetchIndexSamplingValues();
        int deletedNodes = deletions.intValue();
        ((AbstractLongAssert)Assertions.assertThat((long)indexSample.uniqueValues()).as("Unique values", new Object[0])).isEqualTo(1000L - (long)deletedNodes);
        ((AbstractLongAssert)Assertions.assertThat((long)indexSample.sampleSize()).as("Sample size", new Object[0])).isEqualTo(1000L - (long)deletedNodes);
        ((AbstractLongAssert)Assertions.assertThat((long)indexSample.updates()).as("Updates", new Object[0])).isEqualTo(0L);
        ((AbstractLongAssert)Assertions.assertThat((long)indexSample.indexSize()).as("Index size", new Object[0])).isEqualTo(1000L - (long)deletedNodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateDatabaseThenTriggerIndexResamplingOnNextStartup(Consumer<GraphDatabaseService> consumer) throws IOException {
        DatabaseLayout databaseLayout;
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.layout).build();
        try {
            GraphDatabaseService db = managementService.database("neo4j");
            consumer.accept(db);
            databaseLayout = ((GraphDatabaseAPI)db).databaseLayout();
        }
        finally {
            managementService.shutdown();
        }
        this.triggerIndexResamplingOnNextStartup(databaseLayout);
    }

    private IndexDescriptor indexId(KernelTransaction tx) {
        return tx.schemaRead().indexGetForName("schema_name");
    }

    private IndexSample fetchIndexSamplingValues() throws IndexNotFoundKernelException, TransactionFailureException {
        DatabaseManagementService managementService = null;
        try {
            IndexSample indexSample;
            block10: {
                managementService = new TestDatabaseManagementServiceBuilder(this.layout).build();
                GraphDatabaseService db = managementService.database("neo4j");
                GraphDatabaseAPI api = (GraphDatabaseAPI)db;
                Kernel kernel = (Kernel)api.getDependencyResolver().resolveDependency(Kernel.class);
                KernelTransaction tx = kernel.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);
                try {
                    indexSample = tx.schemaRead().indexSample(this.indexId(tx));
                    if (tx == null) break block10;
                }
                catch (Throwable throwable) {
                    if (tx != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                tx.close();
            }
            return indexSample;
        }
        finally {
            if (managementService != null) {
                managementService.shutdown();
            }
        }
    }

    private void triggerIndexResamplingOnNextStartup(DatabaseLayout layout) throws IOException {
        Files.delete(layout.pathForStore(CommonDatabaseStores.INDEX_STATISTICS));
    }

    private static enum Entity {
        NODE{

            @Override
            void createIndex(Transaction tx, String schemaName, String token, String property) {
                tx.schema().indexFor(Label.label((String)token)).on(property).withName(schemaName).create();
            }

            @Override
            void createConstraint(Transaction tx, String schemaName, String token, String property) {
                tx.schema().constraintFor(Label.label((String)token)).assertPropertyIsUnique(property).withName(schemaName).create();
            }

            @Override
            void createEntity(Transaction tx, String token, String property, String value) {
                tx.createNode(new Label[]{Label.label((String)token)}).setProperty(property, (Object)value);
            }

            @Override
            void deleteFirstFound(Transaction tx, String token, String property, String value) {
                try (ResourceIterator nodes = tx.findNodes(Label.label((String)token), property, (Object)value);){
                    ((Node)nodes.next()).delete();
                }
            }
        }
        ,
        RELATIONSHIP{

            @Override
            void createIndex(Transaction tx, String schemaName, String token, String property) {
                tx.schema().indexFor(RelationshipType.withName((String)token)).on(property).withName(schemaName).create();
            }

            @Override
            void createConstraint(Transaction tx, String schemaName, String token, String property) {
                tx.schema().constraintFor(RelationshipType.withName((String)token)).assertPropertyIsUnique(property).withName(schemaName).create();
            }

            @Override
            void createEntity(Transaction tx, String token, String property, String value) {
                Node from = tx.createNode();
                Node to = tx.createNode();
                from.createRelationshipTo(to, RelationshipType.withName((String)token)).setProperty(property, (Object)value);
            }

            @Override
            void deleteFirstFound(Transaction tx, String token, String property, String value) {
                try (ResourceIterator rels = tx.findRelationships(RelationshipType.withName((String)token), property, (Object)value);){
                    ((Relationship)rels.next()).delete();
                }
            }
        };


        abstract void createIndex(Transaction var1, String var2, String var3, String var4);

        abstract void createConstraint(Transaction var1, String var2, String var3, String var4);

        abstract void createEntity(Transaction var1, String var2, String var3, String var4);

        abstract void deleteFirstFound(Transaction var1, String var2, String var3, String var4);
    }
}

