/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index;

import java.util.Set;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.configuration.DatabaseConfig;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.WriteOperationsNotAllowedException;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@TestDirectoryExtension
class IndexWritesAfterTemporarilyReadOnlyIT {
    @Inject
    private TestDirectory directory;
    private final Label label = Label.label((String)"Tag");
    private final String key = "key";
    private final String indexName = "Bob";

    IndexWritesAfterTemporarilyReadOnlyIT() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="{0}")
    @MethodSource(value={"indexTypes"})
    void shouldAllowWritesAfterTemporarilyReadOnlyDuringStartup(IndexType indexType, Value value) throws KernelException {
        Assumptions.assumeThat((Comparable)indexType).isNotEqualTo((Object)IndexType.LOOKUP);
        this.createIndexInIsolatedDbms(indexType);
        DatabaseManagementService dbms = this.dbmsBuilder().setConfig(GraphDatabaseSettings.read_only_databases, Set.of("neo4j")).build();
        try {
            long nodeId;
            GraphDatabaseAPI db = (GraphDatabaseAPI)dbms.database("neo4j");
            try (Transaction tx = db.beginTx();){
                Assertions.assertThatThrownBy(() -> ((Transaction)tx).createNode()).isInstanceOf(WriteOperationsNotAllowedException.class);
            }
            ((DatabaseConfig)db.getDependencyResolver().resolveDependency(DatabaseConfig.class)).set(GraphDatabaseSettings.read_only_databases, Set.of());
            try (Transaction tx = db.beginTx();){
                Node node = tx.createNode(new Label[]{this.label});
                node.setProperty("key", value.asObjectCopy());
                nodeId = node.getId();
                tx.commit();
            }
            try (InternalTransaction itx = db.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);
                 NodeValueIndexCursor cursor = itx.kernelTransaction().cursors().allocateNodeValueIndexCursor(CursorContext.NULL_CONTEXT, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
                KernelTransaction ktx = itx.kernelTransaction();
                IndexDescriptor index = ktx.schemaRead().indexGetForName("Bob");
                IndexReadSession session = ktx.dataRead().indexReadSession(index);
                int keyId = ktx.tokenRead().propertyKey("key");
                ktx.dataRead().nodeIndexSeek(ktx.queryContext(), session, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{this.query(indexType, keyId, value)});
                Assertions.assertThat((boolean)cursor.next()).isTrue();
                Assertions.assertThat((long)cursor.nodeReference()).isEqualTo(nodeId);
                Assertions.assertThat((boolean)cursor.next()).isFalse();
            }
        }
        finally {
            dbms.shutdown();
        }
    }

    private PropertyIndexQuery query(IndexType indexType, int keyId, Value value) {
        return switch (indexType) {
            case IndexType.TEXT, IndexType.RANGE -> PropertyIndexQuery.exact((int)keyId, (Object)value);
            case IndexType.FULLTEXT -> PropertyIndexQuery.fulltextSearch((String)((TextValue)value).stringValue());
            case IndexType.POINT -> {
                PointValue pointValue = (PointValue)value;
                yield PropertyIndexQuery.boundingBox((int)keyId, (PointValue)pointValue, (PointValue)pointValue);
            }
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(indexType));
        };
    }

    private static Stream<Arguments> indexTypes() {
        TextValue plainStringValue = Values.stringValue((String)"abc");
        return Stream.of(Arguments.arguments((Object[])new Object[]{IndexType.RANGE, plainStringValue}), Arguments.arguments((Object[])new Object[]{IndexType.TEXT, plainStringValue}), Arguments.arguments((Object[])new Object[]{IndexType.FULLTEXT, plainStringValue}), Arguments.arguments((Object[])new Object[]{IndexType.POINT, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS_84, (double[])new double[]{2.0, 2.0})}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndexInIsolatedDbms(IndexType indexType) {
        DatabaseManagementService dbms = this.dbmsBuilder().build();
        try {
            GraphDatabaseService db = dbms.database("neo4j");
            try (Transaction tx = db.beginTx();){
                tx.schema().indexFor(this.label).on("key").withIndexType(indexType).withName("Bob").create();
                tx.commit();
            }
        }
        finally {
            dbms.shutdown();
        }
    }

    private TestDatabaseManagementServiceBuilder dbmsBuilder() {
        return new TestDatabaseManagementServiceBuilder(this.directory.homePath());
    }
}

