/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.tracking;

import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexSampler;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.index.schema.PartitionedValueSeek;
import org.neo4j.values.storable.Value;

public class TrackingIndexReader
implements ValueIndexReader {
    private final ValueIndexReader delegate;
    private final AtomicLong closeReadersCounter;

    TrackingIndexReader(ValueIndexReader delegate, AtomicLong closeReadersCounter) {
        this.delegate = delegate;
        this.closeReadersCounter = closeReadersCounter;
    }

    public long countIndexedEntities(long entityId, CursorContext cursorContext, int[] propertyKeyIds, Value ... propertyValues) {
        return this.delegate.countIndexedEntities(entityId, cursorContext, propertyKeyIds, propertyValues);
    }

    public IndexSampler createSampler() {
        return this.delegate.createSampler();
    }

    public void query(IndexProgressor.EntityValueClient client, QueryContext context, CursorContext cursorContext, IndexQueryConstraints constraints, PropertyIndexQuery ... query) throws IndexNotApplicableKernelException {
        this.delegate.query(client, context, cursorContext, constraints, query);
    }

    public PartitionedValueSeek valueSeek(int desiredNumberOfPartitions, QueryContext context, PropertyIndexQuery ... query) throws IndexNotApplicableKernelException {
        return this.delegate.valueSeek(desiredNumberOfPartitions, context, query);
    }

    public void close() {
        this.delegate.close();
        this.closeReadersCounter.incrementAndGet();
    }
}

