/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractFloatAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.set.MutableSet;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.neo4j.common.EntityType;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.FulltextSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.IndexSetting;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.id.DefaultIdGeneratorFactory;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.recordstorage.RecordStorageEngineFactory;
import org.neo4j.internal.recordstorage.SchemaStorage;
import org.neo4j.internal.recordstorage.StoreTokens;
import org.neo4j.internal.schema.AllIndexProviderDescriptors;
import org.neo4j.internal.schema.FulltextSchemaDescriptor;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.FixedVersionContextSupplier;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.impl.muninn.StandalonePageCacheFactory;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.impl.fulltext.BrokenAnalyzerProvider;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexProceduresUtil;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexSettingsKeys;
import org.neo4j.kernel.api.impl.fulltext.FulltextProceduresTest;
import org.neo4j.kernel.api.impl.fulltext.LuceneFulltextTestSupport;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.impl.api.KernelImpl;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.TransactionImpl;
import org.neo4j.kernel.impl.newapi.ExtendedNodeValueIndexCursorAdapter;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.impl.store.DynamicAllocatorProvider;
import org.neo4j.kernel.impl.store.DynamicAllocatorProviders;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.cursor.CachedStoreCursors;
import org.neo4j.kernel.impl.transaction.log.LogTailLogVersionsMetadata;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.StoreIdGenerator;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.util.IdUpdateListener;
import org.neo4j.test.extension.DbmsController;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.token.TokenHolders;
import org.neo4j.values.ElementIdMapper;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@DbmsExtension
class FulltextIndexProviderTest {
    private static final String NAME = "fulltext";
    @Inject
    DbmsController controller;
    @Inject
    GraphDatabaseAPI db;
    @Inject
    KernelImpl kernel;
    @Inject
    FileSystemAbstraction fileSystem;
    private Node node1;
    private Node node2;
    private int labelIdHej;
    private int labelIdHa;
    private int labelIdHe;
    private int propIdHej;
    private int propIdHa;
    private int propIdHe;
    private int propIdHo;
    private String firstNodeId;
    private String firstRelationshipId;
    private final Label hejLabel = Label.label((String)"hej");
    private final Label haLabel = Label.label((String)"ha");
    private final Label heLabel = Label.label((String)"he");
    private final RelationshipType hejType = RelationshipType.withName((String)"hej");

    FulltextIndexProviderTest() {
    }

    @BeforeEach
    void prepDB() {
        try (Transaction transaction = this.db.beginTx();){
            this.node1 = transaction.createNode(new Label[]{this.hejLabel, this.haLabel, this.heLabel});
            this.node1.setProperty("hej", (Object)"value");
            this.node1.setProperty("ha", (Object)"value1");
            this.node1.setProperty("he", (Object)"value2");
            this.node1.setProperty("ho", (Object)"value3");
            this.firstNodeId = this.node1.getElementId();
            this.node2 = transaction.createNode();
            Relationship rel = this.node1.createRelationshipTo(this.node2, this.hejType);
            rel.setProperty("hej", (Object)"valuuu");
            rel.setProperty("ha", (Object)"value1");
            rel.setProperty("he", (Object)"value2");
            rel.setProperty("ho", (Object)"value3");
            this.firstRelationshipId = rel.getElementId();
            transaction.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            TokenRead tokenRead = FulltextIndexProviderTest.tokenRead(tx);
            this.labelIdHej = tokenRead.nodeLabel(this.hejLabel.name());
            this.labelIdHa = tokenRead.nodeLabel(this.haLabel.name());
            this.labelIdHe = tokenRead.nodeLabel(this.heLabel.name());
            this.propIdHej = tokenRead.propertyKey("hej");
            this.propIdHa = tokenRead.propertyKey("ha");
            this.propIdHe = tokenRead.propertyKey("he");
            this.propIdHo = tokenRead.propertyKey("ho");
            tx.commit();
        }
    }

    @Test
    void createFulltextIndex() throws Exception {
        IndexDescriptor fulltextIndex = this.createIndex(new int[]{this.labelIdHej, this.labelIdHa, this.labelIdHe}, new int[]{this.propIdHej, this.propIdHa, this.propIdHe});
        try (KernelTransactionImplementation transaction = this.getKernelTransaction();){
            IndexDescriptor descriptor = transaction.schemaRead().indexGetForName(NAME);
            Assertions.assertThat((Object)fulltextIndex.schema()).isEqualTo((Object)descriptor.schema());
        }
    }

    @Test
    void shouldHaveAReasonableDirectoryStructure() throws Exception {
        this.createIndex(new int[]{this.labelIdHej, this.labelIdHa, this.labelIdHe}, new int[]{this.propIdHej, this.propIdHa, this.propIdHe});
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexesOnline(1L, TimeUnit.HOURS);
            tx.commit();
        }
        try (KernelTransactionImplementation transaction = this.getKernelTransaction();){
            IndexDescriptor descriptor = transaction.schemaRead().indexGetForName(NAME);
            Path indexDir = Path.of(this.db.databaseLayout().databaseDirectory().toAbsolutePath().toString(), "schema", "index", descriptor.getIndexProvider().name(), "" + descriptor.getId());
            List<Path> listFiles = List.of(Objects.requireNonNull(FileUtils.listPaths((Path)indexDir)));
            Assertions.assertThat(listFiles).contains((Object[])new Path[]{indexDir.resolve("failure-message"), indexDir.resolve("1"), indexDir.resolve(String.valueOf(indexDir.getFileName()) + ".tx")});
        }
    }

    @Test
    void createAndRetainFulltextIndex() throws Exception {
        IndexDescriptor fulltextIndex = this.createIndex(new int[]{this.labelIdHej, this.labelIdHa, this.labelIdHe}, new int[]{this.propIdHej, this.propIdHa, this.propIdHe});
        this.controller.restartDbms();
        this.verifyThatFulltextIndexIsPresent(fulltextIndex);
    }

    @Test
    void createAndRetainRelationshipFulltextIndex() throws Exception {
        IndexDescriptor indexReference;
        try (KernelTransactionImplementation transaction = this.getKernelTransaction();){
            FulltextSchemaDescriptor schema = SchemaDescriptors.fulltext((EntityType)EntityType.RELATIONSHIP, (int[])new int[]{this.labelIdHej, this.labelIdHa, this.labelIdHe}, (int[])new int[]{this.propIdHej, this.propIdHa, this.propIdHe, this.propIdHo});
            IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)AllIndexProviderDescriptors.FULLTEXT_DESCRIPTOR).withIndexType(IndexType.FULLTEXT).withName(NAME);
            indexReference = transaction.schemaWrite().indexCreate(prototype);
            transaction.commit();
        }
        this.await(indexReference);
        this.controller.restartDbms();
        this.verifyThatFulltextIndexIsPresent(indexReference);
    }

    @Test
    void createAndQueryFulltextIndex() throws Exception {
        IndexDescriptor indexReference = this.createIndex(new int[]{this.labelIdHej, this.labelIdHa, this.labelIdHe}, new int[]{this.propIdHej, this.propIdHa, this.propIdHe, this.propIdHo});
        this.await(indexReference);
        String thirdNodeId = this.createTheThirdNode();
        this.verifyNodeData(thirdNodeId);
        this.controller.restartDbms();
        this.verifyNodeData(thirdNodeId);
    }

    @Test
    void createAndQueryFulltextRelationshipIndex() throws Exception {
        String secondRelId;
        IndexDescriptor indexReference;
        try (KernelTransactionImplementation transaction = this.getKernelTransaction();){
            FulltextSchemaDescriptor schema = SchemaDescriptors.fulltext((EntityType)EntityType.RELATIONSHIP, (int[])new int[]{this.labelIdHej, this.labelIdHa, this.labelIdHe}, (int[])new int[]{this.propIdHej, this.propIdHa, this.propIdHe, this.propIdHo});
            IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)AllIndexProviderDescriptors.FULLTEXT_DESCRIPTOR).withIndexType(IndexType.FULLTEXT).withName(NAME);
            indexReference = transaction.schemaWrite().indexCreate(prototype);
            transaction.commit();
        }
        this.await(indexReference);
        try (Transaction transaction = this.db.beginTx();){
            Relationship ho = transaction.getNodeByElementId(this.node1.getElementId()).createRelationshipTo(transaction.getNodeByElementId(this.node2.getElementId()), RelationshipType.withName((String)"ho"));
            secondRelId = ho.getElementId();
            ho.setProperty("hej", (Object)"villa");
            ho.setProperty("ho", (Object)"value3");
            transaction.commit();
        }
        this.verifyRelationshipData(secondRelId);
        this.controller.restartDbms();
        this.verifyRelationshipData(secondRelId);
    }

    @Test
    void multiTokenFulltextIndexesMustShowUpInSchemaGetIndexes() {
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s", "nodeIndex", FulltextIndexProceduresUtil.asNodeLabelStr((String[])new String[]{"Label1", "Label2"}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{"prop1", "prop2"}))).close();
            tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s", "relIndex", FulltextIndexProceduresUtil.asRelationshipTypeStr((String[])new String[]{"RelType1", "RelType2"}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{"prop1", "prop2"}))).close();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            for (IndexDefinition index : tx.schema().getIndexes()) {
                if (index.getIndexType() == org.neo4j.graphdb.schema.IndexType.LOOKUP) continue;
                Assertions.assertThat((boolean)index.isConstraintIndex()).isFalse();
                Assertions.assertThat((boolean)index.isMultiTokenIndex()).isTrue();
                Assertions.assertThat((boolean)index.isCompositeIndex()).isTrue();
                if (index.isNodeIndex()) {
                    Assertions.assertThat((boolean)index.isRelationshipIndex()).isFalse();
                    Assertions.assertThat((Iterable)index.getLabels()).contains((Object[])new Label[]{Label.label((String)"Label1"), Label.label((String)"Label2")});
                    Assertions.assertThatThrownBy(() -> ((IndexDefinition)index).getRelationshipTypes()).isInstanceOf(IllegalStateException.class);
                    continue;
                }
                Assertions.assertThat((boolean)index.isRelationshipIndex()).isTrue();
                Assertions.assertThat((Iterable)index.getRelationshipTypes()).contains((Object[])new RelationshipType[]{RelationshipType.withName((String)"RelType1"), RelationshipType.withName((String)"RelType2")});
                Assertions.assertThatThrownBy(() -> ((IndexDefinition)index).getLabels()).isInstanceOf(IllegalStateException.class);
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void awaitIndexesOnlineMustWorkOnFulltextIndexes() {
        String prop1 = "prop1";
        String prop2 = "prop2";
        String prop3 = "prop3";
        String val1 = "foo foo";
        String val2 = "bar bar";
        String val3 = "baz baz";
        Label label1 = Label.label((String)"FirstLabel");
        Label label2 = Label.label((String)"SecondLabel");
        Label label3 = Label.label((String)"ThirdLabel");
        RelationshipType relType1 = RelationshipType.withName((String)"FirstRelType");
        RelationshipType relType2 = RelationshipType.withName((String)"SecondRelType");
        RelationshipType relType3 = RelationshipType.withName((String)"ThirdRelType");
        MutableSet nodes1 = Sets.mutable.empty();
        MutableSet nodes2 = Sets.mutable.empty();
        MutableSet nodes3 = Sets.mutable.empty();
        MutableSet rels1 = Sets.mutable.empty();
        MutableSet rels2 = Sets.mutable.empty();
        MutableSet rels3 = Sets.mutable.empty();
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < 100; ++i) {
                Node node1 = tx.createNode(new Label[]{label1});
                node1.setProperty(prop1, (Object)val1);
                nodes1.add((Object)node1.getElementId());
                Relationship rel1 = node1.createRelationshipTo(node1, relType1);
                rel1.setProperty(prop1, (Object)val1);
                rels1.add((Object)rel1.getElementId());
                Node node2 = tx.createNode(new Label[]{label2});
                node2.setProperty(prop2, (Object)val2);
                nodes2.add((Object)node2.getElementId());
                Relationship rel2 = node1.createRelationshipTo(node2, relType2);
                rel2.setProperty(prop2, (Object)val2);
                rels2.add((Object)rel2.getElementId());
                Node node3 = tx.createNode(new Label[]{label3});
                node3.setProperty(prop3, (Object)val3);
                nodes3.add((Object)node3.getElementId());
                Relationship rel3 = node1.createRelationshipTo(node3, relType3);
                rel3.setProperty(prop3, (Object)val3);
                rels3.add((Object)rel3.getElementId());
            }
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s", "nodeIndex", FulltextIndexProceduresUtil.asNodeLabelStr((String[])new String[]{label1.name(), label2.name(), label3.name()}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{prop1, prop2, prop3}))).close();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(30L, TimeUnit.SECONDS);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodeIndex", "foo", (Set<String>)nodes1);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodeIndex", "bar", (Set<String>)nodes2);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodeIndex", "baz", (Set<String>)nodes3);
        tx = this.db.beginTx();
        try {
            tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s", "relIndex", FulltextIndexProceduresUtil.asRelationshipTypeStr((String[])new String[]{relType1.name(), relType2.name(), relType3.name()}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{prop1, prop2, prop3}))).close();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(30L, TimeUnit.SECONDS);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "relIndex", "foo", (Set<String>)rels1);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "relIndex", "bar", (Set<String>)rels2);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "relIndex", "baz", (Set<String>)rels3);
    }

    @Test
    void queryingWithIndexProgressorMustProvideScore() throws Exception {
        String nodeId = this.createTheThirdNode();
        IndexDescriptor index = this.createIndex(new int[]{this.labelIdHej, this.labelIdHa, this.labelIdHe}, new int[]{this.propIdHej, this.propIdHa, this.propIdHe, this.propIdHo});
        this.await(index);
        final ArrayList acceptedEntities = new ArrayList();
        try (Transaction tx = this.db.beginTx();){
            ElementIdMapper idMapper = ((TransactionImpl)tx).elementIdMapper();
            KernelTransaction ktx = LuceneFulltextTestSupport.kernelTransaction(tx);
            ExtendedNodeValueIndexCursorAdapter cursor = new ExtendedNodeValueIndexCursorAdapter(this){
                private long nodeReference;
                private IndexProgressor progressor;

                public long nodeReference() {
                    return this.nodeReference;
                }

                public boolean next() {
                    return this.progressor.next();
                }

                public void initializeQuery(IndexDescriptor descriptor, IndexProgressor progressor, boolean indexIncludesTransactionState, boolean needStoreFilter, IndexQueryConstraints constraints, PropertyIndexQuery ... query) {
                    this.progressor = progressor;
                }

                public boolean acceptEntity(long reference, float score, Value ... values) {
                    this.nodeReference = reference;
                    ((AbstractFloatAssert)Assertions.assertThat((float)score).as("score should not be NaN", new Object[0])).isNotNaN();
                    ((AbstractFloatAssert)Assertions.assertThat((float)score).as("score must be positive", new Object[0])).isGreaterThan(0.0f);
                    acceptedEntities.add("reference = " + reference + ", score = " + score + ", " + Arrays.toString(values));
                    return true;
                }
            };
            Read read = ktx.dataRead();
            IndexReadSession indexSession = ktx.dataRead().indexReadSession(index);
            read.nodeIndexSeek(ktx.queryContext(), indexSession, (NodeValueIndexCursor)cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.fulltextSearch((String)"hej:\"villa\"")});
            int counter = 0;
            while (cursor.next()) {
                Assertions.assertThat((String)idMapper.nodeElementId(cursor.nodeReference())).isEqualTo(nodeId);
                ++counter;
            }
            Assertions.assertThat((int)counter).isEqualTo(1);
            Assertions.assertThat((int)acceptedEntities.size()).isEqualTo(1);
            acceptedEntities.clear();
        }
    }

    @Test
    void validateMustThrowIfSchemaIsNotFulltext() throws Exception {
        try (KernelTransactionImplementation transaction = this.getKernelTransaction();){
            int[] propertyIds = new int[]{this.propIdHa};
            LabelSchemaDescriptor schema = SchemaDescriptors.forLabel((int)this.labelIdHa, (int[])propertyIds);
            IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)schema).withIndexType(IndexType.FULLTEXT).withName(NAME);
            SchemaWrite schemaWrite = transaction.schemaWrite();
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> schemaWrite.indexCreate(prototype)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("schema is not a full-text index schema");
        }
    }

    @Test
    void indexWithUnknownAnalyzerWillBeMarkedAsFailedOnStartup() throws Exception {
        long indexId;
        Assumptions.assumeThat((Object)((StorageEngineFactory)this.db.getDependencyResolver().resolveDependency(StorageEngineFactory.class))).isInstanceOf(RecordStorageEngineFactory.class);
        try (KernelTransactionImplementation transaction = this.getKernelTransaction();){
            int[] propertyIds = new int[]{this.propIdHa};
            FulltextSchemaDescriptor schema = SchemaDescriptors.fulltext((EntityType)EntityType.NODE, (int[])new int[]{this.labelIdHa}, (int[])propertyIds);
            IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)schema).withIndexType(IndexType.FULLTEXT).withName(NAME);
            SchemaWrite schemaWrite = transaction.schemaWrite();
            IndexDescriptor index = schemaWrite.indexCreate(prototype);
            indexId = index.getId();
            transaction.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexesOnline(30L, TimeUnit.SECONDS);
            tx.commit();
        }
        this.controller.restartDbms(builder -> {
            PageCacheTracer cacheTracer = PageCacheTracer.NULL;
            CursorContextFactory contextFactory = new CursorContextFactory(cacheTracer, FixedVersionContextSupplier.EMPTY_CONTEXT_SUPPLIER);
            RecordDatabaseLayout databaseLayout = RecordDatabaseLayout.of((Config)Config.defaults((Setting)GraphDatabaseSettings.neo4j_home, (Object)builder.getHomeDirectory()));
            DefaultIdGeneratorFactory idGenFactory = new DefaultIdGeneratorFactory(this.fileSystem, RecoveryCleanupWorkCollector.ignore(), cacheTracer, databaseLayout.getDatabaseName());
            try (JobScheduler scheduler = JobSchedulerFactory.createInitialisedScheduler();
                 PageCache pageCache = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)this.fileSystem, (JobScheduler)scheduler, (PageCacheTracer)cacheTracer, (MuninnPageCache.Configuration)MuninnPageCache.config((int)100));){
                StoreFactory factory = new StoreFactory((DatabaseLayout)databaseLayout, Config.defaults(), (IdGeneratorFactory)idGenFactory, pageCache, cacheTracer, this.fileSystem, (InternalLogProvider)NullLogProvider.getInstance(), contextFactory, false, LogTailLogVersionsMetadata.EMPTY_LOG_TAIL, StoreIdGenerator.UNIQUE_ID);
                CursorContext cursorContext = CursorContext.NULL_CONTEXT;
                try (NeoStores neoStores = factory.openAllNeoStores();
                     CachedStoreCursors storeCursors = new CachedStoreCursors(neoStores, cursorContext);){
                    TokenHolders tokens = StoreTokens.readOnlyTokenHolders((NeoStores)neoStores, (StoreCursors)storeCursors, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
                    DynamicAllocatorProvider allocatorProvider = DynamicAllocatorProviders.nonTransactionalAllocator((NeoStores)neoStores);
                    SchemaStore schemaStore = neoStores.getSchemaStore();
                    SchemaStorage storage = new SchemaStorage(schemaStore, tokens);
                    IndexDescriptor index = (IndexDescriptor)storage.loadSingleSchemaRule(indexId, (StoreCursors)storeCursors, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
                    HashMap indexConfigMap = new HashMap(index.getIndexConfig().asMap());
                    for (Map.Entry entry : indexConfigMap.entrySet()) {
                        if (!((String)entry.getKey()).contains("analyzer")) continue;
                        entry.setValue(Values.stringValue((String)"bla-bla-lyzer"));
                    }
                    index = index.withIndexConfig(IndexConfig.with(indexConfigMap));
                    storage.writeSchemaRule((SchemaRule)index, IdUpdateListener.DIRECT, allocatorProvider, cursorContext, (MemoryTracker)EmptyMemoryTracker.INSTANCE, (StoreCursors)storeCursors);
                    schemaStore.flush(FileFlushEvent.NULL, cursorContext);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return builder;
        });
        tx = this.db.beginTx();
        try {
            IndexDefinition index = tx.schema().getIndexByName(NAME);
            Schema.IndexState indexState = tx.schema().getIndexState(index);
            Assertions.assertThat((Comparable)indexState).isEqualTo((Object)Schema.IndexState.FAILED);
            String indexFailure = tx.schema().getIndexFailure(index);
            Assertions.assertThat((String)indexFailure).contains(new CharSequence[]{"bla-bla-lyzer"});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.schema().getIndexByName(NAME).drop();
            Assertions.assertThatThrownBy(() -> tx.schema().getIndexByName(NAME)).isInstanceOf(IllegalArgumentException.class);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            Assertions.assertThatThrownBy(() -> tx.schema().getIndexByName(NAME)).isInstanceOf(IllegalArgumentException.class);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.controller.restartDbms();
        tx = this.db.beginTx();
        try {
            Assertions.assertThatThrownBy(() -> tx.schema().getIndexByName(NAME)).isInstanceOf(IllegalArgumentException.class);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ResourceLock(value="BrokenAnalyzerProvider")
    @Test
    void indexWithAnalyzerThatThrowsWillNotBeCreated() {
        Schema.IndexState indexState;
        IndexDefinition index;
        IndexCreator creator;
        BrokenAnalyzerProvider.shouldThrow = true;
        BrokenAnalyzerProvider.shouldReturnNull = false;
        try (Transaction tx = this.db.beginTx();){
            creator = tx.schema().indexFor(Label.label((String)"Label")).withIndexType(org.neo4j.graphdb.schema.IndexType.FULLTEXT).withIndexConfiguration(Map.of(IndexSetting.fulltext_Analyzer(), "broken-analyzer")).on("prop").withName(NAME);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((IndexCreator)creator).create()).isInstanceOf(RuntimeException.class)).hasMessageContaining("boom");
            BrokenAnalyzerProvider.shouldThrow = false;
            creator.create();
            BrokenAnalyzerProvider.shouldThrow = true;
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> tx.schema().awaitIndexOnline(NAME, 10L, TimeUnit.SECONDS)).isInstanceOf(IllegalStateException.class)).hasMessageContaining("FAILED");
            index = tx.schema().getIndexByName(NAME);
            Assertions.assertThat((Comparable)tx.schema().getIndexState(index)).isEqualTo((Object)Schema.IndexState.FAILED);
            index.drop();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        BrokenAnalyzerProvider.shouldThrow = false;
        tx = this.db.beginTx();
        try {
            creator = tx.schema().indexFor(Label.label((String)"Label")).withIndexType(org.neo4j.graphdb.schema.IndexType.FULLTEXT).withIndexConfiguration(Map.of(IndexSetting.fulltext_Analyzer(), "broken-analyzer")).on("prop").withName(NAME);
            creator.create();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexOnline(NAME, 1L, TimeUnit.MINUTES);
            index = tx.schema().getIndexByName(NAME);
            indexState = tx.schema().getIndexState(index);
            Assertions.assertThat((Comparable)indexState).isEqualTo((Object)Schema.IndexState.ONLINE);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.controller.restartDbms();
        tx = this.db.beginTx();
        try {
            index = tx.schema().getIndexByName(NAME);
            indexState = tx.schema().getIndexState(index);
            Assertions.assertThat((Comparable)indexState).isEqualTo((Object)Schema.IndexState.ONLINE);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ResourceLock(value="BrokenAnalyzerProvider")
    @Test
    void indexWithAnalyzerThatReturnsNullWillNotBeCreated() {
        Schema.IndexState indexState;
        IndexDefinition index;
        IndexCreator creator;
        BrokenAnalyzerProvider.shouldThrow = false;
        BrokenAnalyzerProvider.shouldReturnNull = true;
        try (Transaction tx = this.db.beginTx();){
            creator = tx.schema().indexFor(Label.label((String)"Label")).withIndexType(org.neo4j.graphdb.schema.IndexType.FULLTEXT).withIndexConfiguration(Map.of(IndexSetting.fulltext_Analyzer(), "broken-analyzer")).on("prop").withName(NAME);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((IndexCreator)creator).create()).isInstanceOf(NullPointerException.class)).hasMessageContaining("null");
            BrokenAnalyzerProvider.shouldReturnNull = false;
            creator.create();
            BrokenAnalyzerProvider.shouldReturnNull = true;
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> tx.schema().awaitIndexOnline(NAME, 1L, TimeUnit.MINUTES)).isInstanceOf(IllegalStateException.class)).hasMessageContaining("FAILED");
            index = tx.schema().getIndexByName(NAME);
            Assertions.assertThat((Comparable)tx.schema().getIndexState(index)).isEqualTo((Object)Schema.IndexState.FAILED);
            index.drop();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        BrokenAnalyzerProvider.shouldReturnNull = false;
        tx = this.db.beginTx();
        try {
            creator = tx.schema().indexFor(Label.label((String)"Label")).withIndexType(org.neo4j.graphdb.schema.IndexType.FULLTEXT).withIndexConfiguration(Map.of(IndexSetting.fulltext_Analyzer(), "broken-analyzer")).on("prop").withName(NAME);
            creator.create();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexOnline(NAME, 1L, TimeUnit.MINUTES);
            index = tx.schema().getIndexByName(NAME);
            indexState = tx.schema().getIndexState(index);
            Assertions.assertThat((Comparable)indexState).isEqualTo((Object)Schema.IndexState.ONLINE);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.controller.restartDbms();
        tx = this.db.beginTx();
        try {
            index = tx.schema().getIndexByName(NAME);
            indexState = tx.schema().getIndexState(index);
            Assertions.assertThat((Comparable)indexState).isEqualTo((Object)Schema.IndexState.ONLINE);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ResourceLock(value="BrokenAnalyzerProvider")
    @Test
    void indexWithAnalyzerProviderThatThrowsAnExceptionOnStartupWillBeMarkedAsFailedOnStartup() {
        Schema.IndexState indexState;
        IndexDefinition index;
        BrokenAnalyzerProvider.shouldThrow = false;
        BrokenAnalyzerProvider.shouldReturnNull = false;
        try (Transaction tx = this.db.beginTx();){
            IndexCreator creator = tx.schema().indexFor(Label.label((String)"Label")).withIndexType(org.neo4j.graphdb.schema.IndexType.FULLTEXT).withIndexConfiguration(Map.of(IndexSetting.fulltext_Analyzer(), "broken-analyzer")).on("prop").withName(NAME);
            creator.create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexOnline(NAME, 1L, TimeUnit.MINUTES);
            index = tx.schema().getIndexByName(NAME);
            indexState = tx.schema().getIndexState(index);
            Assertions.assertThat((Comparable)indexState).isEqualTo((Object)Schema.IndexState.ONLINE);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        BrokenAnalyzerProvider.shouldThrow = true;
        this.controller.restartDbms();
        tx = this.db.beginTx();
        try {
            index = tx.schema().getIndexByName(NAME);
            indexState = tx.schema().getIndexState(index);
            Assertions.assertThat((Comparable)indexState).isEqualTo((Object)Schema.IndexState.FAILED);
            String indexFailure = tx.schema().getIndexFailure(index);
            Assertions.assertThat((String)indexFailure).contains(new CharSequence[]{"boom"});
            index.drop();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            Assertions.assertThatThrownBy(() -> tx.schema().getIndexByName(NAME)).isInstanceOf(IllegalArgumentException.class);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ResourceLock(value="BrokenAnalyzerProvider")
    @Test
    void indexWithAnalyzerProviderThatReturnsNullWillBeMarkedAsFailedOnStartup() {
        Schema.IndexState indexState;
        IndexDefinition index;
        BrokenAnalyzerProvider.shouldThrow = false;
        BrokenAnalyzerProvider.shouldReturnNull = false;
        try (Transaction tx = this.db.beginTx();){
            IndexCreator creator = tx.schema().indexFor(Label.label((String)"Label")).withIndexType(org.neo4j.graphdb.schema.IndexType.FULLTEXT).withIndexConfiguration(Map.of(IndexSetting.fulltext_Analyzer(), "broken-analyzer")).on("prop").withName(NAME);
            creator.create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexOnline(NAME, 1L, TimeUnit.MINUTES);
            index = tx.schema().getIndexByName(NAME);
            indexState = tx.schema().getIndexState(index);
            Assertions.assertThat((Comparable)indexState).isEqualTo((Object)Schema.IndexState.ONLINE);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        BrokenAnalyzerProvider.shouldReturnNull = true;
        this.controller.restartDbms();
        tx = this.db.beginTx();
        try {
            index = tx.schema().getIndexByName(NAME);
            indexState = tx.schema().getIndexState(index);
            Assertions.assertThat((Comparable)indexState).isEqualTo((Object)Schema.IndexState.FAILED);
            String indexFailure = tx.schema().getIndexFailure(index);
            Assertions.assertThat((String)indexFailure).contains(new CharSequence[]{"null"});
            index.drop();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            Assertions.assertThatThrownBy(() -> tx.schema().getIndexByName(NAME)).isInstanceOf(IllegalArgumentException.class);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private static TokenRead tokenRead(Transaction tx) {
        return ((InternalTransaction)tx).kernelTransaction().tokenRead();
    }

    private KernelTransactionImplementation getKernelTransaction() {
        try {
            return (KernelTransactionImplementation)this.kernel.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);
        }
        catch (TransactionFailureException e) {
            throw new RuntimeException("oops");
        }
    }

    private IndexDescriptor createIndex(int[] entityTokens, int[] propertyIds) throws KernelException {
        return this.createIndex(entityTokens, propertyIds, (String)FulltextSettings.fulltext_default_analyzer.defaultValue());
    }

    private IndexDescriptor createIndex(int[] entityTokens, int[] propertyIds, String analyzer) throws KernelException {
        return this.createIndex(entityTokens, propertyIds, analyzer, EntityType.NODE);
    }

    private IndexDescriptor createIndex(int[] entityTokens, int[] propertyIds, String analyzer, EntityType entityType) throws KernelException {
        return this.createIndex(entityTokens, propertyIds, analyzer, entityType, false);
    }

    private IndexDescriptor createIndex(int[] entityTokens, int[] propertyIds, String analyzer, EntityType entityType, boolean eventuallyConsistent) throws KernelException {
        IndexDescriptor fulltext;
        try (KernelTransactionImplementation transaction = this.getKernelTransaction();){
            FulltextSchemaDescriptor schema = SchemaDescriptors.fulltext((EntityType)entityType, (int[])entityTokens, (int[])propertyIds);
            IndexConfig config = IndexConfig.with((String)FulltextIndexSettingsKeys.ANALYZER, (Value)Values.stringValue((String)analyzer)).withIfAbsent(FulltextIndexSettingsKeys.EVENTUALLY_CONSISTENT, Values.of((Object)eventuallyConsistent));
            IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)AllIndexProviderDescriptors.FULLTEXT_DESCRIPTOR).withIndexType(IndexType.FULLTEXT).withName(NAME).withIndexConfig(config);
            fulltext = transaction.schemaWrite().indexCreate(prototype);
            transaction.commit();
        }
        return fulltext;
    }

    private void verifyThatFulltextIndexIsPresent(IndexDescriptor fulltextIndexDescriptor) throws TransactionFailureException {
        try (KernelTransactionImplementation transaction = this.getKernelTransaction();){
            IndexDescriptor descriptor = transaction.schemaRead().indexGetForName(NAME);
            Assertions.assertThat((Object)descriptor.schema()).isEqualTo((Object)fulltextIndexDescriptor.schema());
            Assertions.assertThat((boolean)descriptor.isUnique()).isEqualTo(fulltextIndexDescriptor.isUnique());
        }
    }

    private String createTheThirdNode() {
        String nodeId;
        try (Transaction transaction = this.db.beginTx();){
            Node hej = transaction.createNode(new Label[]{this.hejLabel});
            nodeId = hej.getElementId();
            hej.setProperty("hej", (Object)"villa");
            hej.setProperty("ho", (Object)"value3");
            transaction.commit();
        }
        return nodeId;
    }

    private void verifyNodeData(String thirdNodeId) throws Exception {
        try (Transaction tx = this.db.beginTx();){
            ElementIdMapper idMapper = ((TransactionImpl)tx).elementIdMapper();
            KernelTransaction ktx = LuceneFulltextTestSupport.kernelTransaction(tx);
            IndexReadSession index = ktx.dataRead().indexReadSession(ktx.schemaRead().indexGetForName(NAME));
            try (NodeValueIndexCursor cursor = ktx.cursors().allocateNodeValueIndexCursor(ktx.cursorContext(), ktx.memoryTracker());){
                this.assertIndexedNodes(idMapper, ktx, index, cursor, "value", this.firstNodeId);
                this.assertIndexedNodes(idMapper, ktx, index, cursor, "villa", thirdNodeId);
                this.assertIndexedNodes(idMapper, ktx, index, cursor, "value3", this.firstNodeId, thirdNodeId);
            }
            tx.commit();
        }
    }

    private void assertIndexedNodes(ElementIdMapper idMapper, KernelTransaction ktx, IndexReadSession index, NodeValueIndexCursor cursor, String query, String ... nodeIds) throws KernelException {
        ktx.dataRead().nodeIndexSeek(ktx.queryContext(), index, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.fulltextSearch((String)query)});
        HashSet<String> found = new HashSet<String>();
        while (cursor.next()) {
            found.add(idMapper.nodeElementId(cursor.nodeReference()));
        }
        Assertions.assertThat(found).containsExactlyInAnyOrder((Object[])nodeIds);
    }

    private void verifyRelationshipData(String secondRelId) throws Exception {
        try (Transaction tx = this.db.beginTx();){
            ElementIdMapper idMapper = ((TransactionImpl)tx).elementIdMapper();
            KernelTransaction ktx = LuceneFulltextTestSupport.kernelTransaction(tx);
            IndexDescriptor index = ktx.schemaRead().indexGetForName(NAME);
            IndexReadSession indexReadSession = ktx.dataRead().indexReadSession(index);
            try (RelationshipValueIndexCursor cursor = ktx.cursors().allocateRelationshipValueIndexCursor(ktx.cursorContext(), ktx.memoryTracker());){
                this.assertIndexedRelationships(idMapper, ktx, indexReadSession, cursor, "valuuu", this.firstRelationshipId);
                this.assertIndexedRelationships(idMapper, ktx, indexReadSession, cursor, "villa", secondRelId);
                this.assertIndexedRelationships(idMapper, ktx, indexReadSession, cursor, "value3", this.firstRelationshipId, secondRelId);
            }
            tx.commit();
        }
    }

    private void assertIndexedRelationships(ElementIdMapper idMapper, KernelTransaction ktx, IndexReadSession indexReadSession, RelationshipValueIndexCursor cursor, String query, String ... relationshipIds) throws KernelException {
        ktx.dataRead().relationshipIndexSeek(ktx.queryContext(), indexReadSession, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.fulltextSearch((String)query)});
        HashSet<String> found = new HashSet<String>();
        while (cursor.next()) {
            found.add(idMapper.relationshipElementId(cursor.relationshipReference()));
        }
        Assertions.assertThat(found).isEqualTo((Object)Iterators.asSet((Object[])relationshipIds));
    }

    private void await(IndexDescriptor index) {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexOnline(index.getName(), 1L, TimeUnit.MINUTES);
        }
    }
}

