/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.schema.AllIndexProviderDescriptors;
import org.neo4j.internal.schema.FulltextSchemaDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.kernel.api.exceptions.schema.RepeatedLabelInSchemaException;
import org.neo4j.kernel.api.exceptions.schema.RepeatedPropertyInSchemaException;
import org.neo4j.kernel.api.exceptions.schema.RepeatedRelationshipTypeInSchemaException;
import org.neo4j.kernel.impl.api.index.IndexProviderNotFoundException;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;

public class IndexCreateIT
extends KernelIntegrationTest {
    private static final IndexCreator INDEX_CREATOR = (schemaWrite, schema, provider, name) -> schemaWrite.indexCreate(IndexPrototype.forSchema((SchemaDescriptor)schema).withIndexProvider(schemaWrite.indexProviderByName(provider)).withName(name));
    private static final IndexCreator UNIQUE_CONSTRAINT_CREATOR = (schemaWrite, schema, provider, name) -> schemaWrite.uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)schemaWrite.indexProviderByName(provider)).withName(name));

    @ParameterizedTest
    @EnumSource(value=EntityType.class)
    void shouldCreateIndexWithSpecificExistingProviderName(EntityType entityType) throws KernelException {
        this.shouldCreateWithSpecificExistingProviderName(INDEX_CREATOR, entityType);
    }

    @ParameterizedTest
    @EnumSource(value=EntityType.class)
    void shouldCreateUniquePropertyConstraintWithSpecificExistingProviderName(EntityType entityType) throws KernelException {
        this.shouldCreateWithSpecificExistingProviderName(UNIQUE_CONSTRAINT_CREATOR, entityType);
    }

    @ParameterizedTest
    @EnumSource(value=EntityType.class)
    void shouldFailCreateIndexWithNonExistentProviderName(EntityType entityType) throws KernelException {
        this.shouldFailWithNonExistentProviderName(INDEX_CREATOR, entityType);
    }

    @ParameterizedTest
    @EnumSource(value=EntityType.class)
    void shouldFailCreateUniquePropertyConstraintWithNonExistentProviderName(EntityType entityType) throws KernelException {
        this.shouldFailWithNonExistentProviderName(UNIQUE_CONSTRAINT_CREATOR, entityType);
    }

    @Test
    void shouldFailCreateIndexWithDuplicateLabels() throws KernelException {
        TokenWrite tokenWrite = this.tokenWriteInNewTransaction();
        int labelId0 = tokenWrite.labelGetOrCreateForName("Label0");
        int labelId1 = tokenWrite.labelGetOrCreateForName("Label1");
        int labelId2 = tokenWrite.labelGetOrCreateForName("Label2");
        int labelId3 = tokenWrite.labelGetOrCreateForName("Label3");
        int propId = tokenWrite.propertyKeyGetOrCreateForName("property");
        this.commit();
        SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
        FulltextSchemaDescriptor descriptor = SchemaDescriptors.fulltext((org.neo4j.common.EntityType)org.neo4j.common.EntityType.NODE, (int[])new int[]{labelId0, labelId1, labelId2, labelId1, labelId3}, (int[])new int[]{propId});
        RepeatedLabelInSchemaException e = (RepeatedLabelInSchemaException)org.junit.jupiter.api.Assertions.assertThrows(RepeatedLabelInSchemaException.class, () -> schemaWrite.indexCreate(IndexPrototype.forSchema((SchemaDescriptor)descriptor)));
        Assertions.assertThat((String)e.gqlStatus()).isEqualTo("22N76");
        Assertions.assertThat((String)e.statusDescription()).isEqualTo("error: data exception - index contains duplicated tokens. The index specified by '(:Label0:Label1:Label2:Label1:Label3 {property})' includes a label, relationship type, or property key with name 'Label1' more than once.");
    }

    @Test
    void shouldFailCreateIndexWithDuplicateRelationshipTypes() throws KernelException {
        TokenWrite tokenWrite = this.tokenWriteInNewTransaction();
        int relTypeId0 = tokenWrite.relationshipTypeGetOrCreateForName("RELATIONSHIP0");
        int relTypeId1 = tokenWrite.relationshipTypeGetOrCreateForName("RELATIONSHIP1");
        int relTypeId2 = tokenWrite.relationshipTypeGetOrCreateForName("RELATIONSHIP2");
        int relTypeId3 = tokenWrite.relationshipTypeGetOrCreateForName("RELATIONSHIP3");
        int propId = tokenWrite.propertyKeyGetOrCreateForName("property");
        this.commit();
        SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
        FulltextSchemaDescriptor descriptor = SchemaDescriptors.fulltext((org.neo4j.common.EntityType)org.neo4j.common.EntityType.RELATIONSHIP, (int[])new int[]{relTypeId0, relTypeId1, relTypeId2, relTypeId1, relTypeId3}, (int[])new int[]{propId});
        RepeatedRelationshipTypeInSchemaException e = (RepeatedRelationshipTypeInSchemaException)org.junit.jupiter.api.Assertions.assertThrows(RepeatedRelationshipTypeInSchemaException.class, () -> schemaWrite.indexCreate(IndexPrototype.forSchema((SchemaDescriptor)descriptor)));
        Assertions.assertThat((String)e.gqlStatus()).isEqualTo("22N76");
        Assertions.assertThat((String)e.statusDescription()).isEqualTo("error: data exception - index contains duplicated tokens. The index specified by '()-[:RELATIONSHIP0:RELATIONSHIP1:RELATIONSHIP2:RELATIONSHIP1:RELATIONSHIP3 {property}]-()' includes a label, relationship type, or property key with name 'RELATIONSHIP1' more than once.");
    }

    @Test
    void shouldFailCreateIndexWithDuplicateProperties() throws KernelException {
        TokenWrite tokenWrite = this.tokenWriteInNewTransaction();
        int labelId = tokenWrite.labelGetOrCreateForName("Label");
        int propId0 = tokenWrite.propertyKeyGetOrCreateForName("property0");
        int propId1 = tokenWrite.propertyKeyGetOrCreateForName("property1");
        int propId2 = tokenWrite.propertyKeyGetOrCreateForName("property2");
        int propId3 = tokenWrite.propertyKeyGetOrCreateForName("property3");
        this.commit();
        SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
        FulltextSchemaDescriptor descriptor = SchemaDescriptors.fulltext((org.neo4j.common.EntityType)org.neo4j.common.EntityType.NODE, (int[])new int[]{labelId}, (int[])new int[]{propId0, propId1, propId2, propId1, propId3});
        RepeatedPropertyInSchemaException e = (RepeatedPropertyInSchemaException)org.junit.jupiter.api.Assertions.assertThrows(RepeatedPropertyInSchemaException.class, () -> schemaWrite.indexCreate(IndexPrototype.forSchema((SchemaDescriptor)descriptor)));
        Assertions.assertThat((String)e.gqlStatus()).isEqualTo("22N76");
        Assertions.assertThat((String)e.statusDescription()).isEqualTo("error: data exception - index contains duplicated tokens. The index specified by '(:Label {property0, property1, property2, property1, property3})' includes a label, relationship type, or property key with name 'property1' more than once.");
    }

    protected void shouldFailWithNonExistentProviderName(IndexCreator creator, EntityType entityType) throws KernelException {
        TokenWrite tokenWrite = this.tokenWriteInNewTransaction();
        int entityTokenId = entityType.entityTokenGetOrCreate(tokenWrite);
        int propId = tokenWrite.propertyKeyGetOrCreateForName("property");
        this.commit();
        SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
        org.junit.jupiter.api.Assertions.assertThrows(IndexProviderNotFoundException.class, () -> creator.create(schemaWrite, entityType.createSchemaDescriptor(entityTokenId, propId), "something-completely-different", "index name"));
    }

    protected void shouldCreateWithSpecificExistingProviderName(IndexCreator creator, EntityType entityType) throws KernelException {
        TokenWrite tokenWrite = this.tokenWriteInNewTransaction();
        int entityTokenId = entityType.entityTokenGetOrCreate(tokenWrite);
        int propId = tokenWrite.propertyKeyGetOrCreateForName("property");
        this.commit();
        SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
        SchemaDescriptor descriptor = entityType.createSchemaDescriptor(entityTokenId, propId);
        String provider = AllIndexProviderDescriptors.RANGE_DESCRIPTOR.name();
        String indexName = "index-0";
        creator.create(schemaWrite, descriptor, provider, indexName);
        IndexDescriptor index = this.transaction.kernelTransaction().schemaRead().indexGetForName(indexName);
        this.commit();
        org.junit.jupiter.api.Assertions.assertEquals((Object)provider, (Object)this.indexingService.getIndexProxy(index).getDescriptor().getIndexProvider().name());
    }

    protected static interface IndexCreator {
        public void create(SchemaWrite var1, SchemaDescriptor var2, String var3, String var4) throws KernelException;
    }

    protected static enum EntityType implements EntityControl
    {
        NODE{

            @Override
            public int entityTokenGetOrCreate(TokenWrite tokenWrite) throws KernelException {
                return tokenWrite.labelGetOrCreateForName("Label0");
            }

            @Override
            public SchemaDescriptor createSchemaDescriptor(int entityToken, int propertyKey) {
                return SchemaDescriptors.forLabel((int)entityToken, (int[])new int[]{propertyKey});
            }
        }
        ,
        RELATIONSHIP{

            @Override
            public int entityTokenGetOrCreate(TokenWrite tokenWrite) throws KernelException {
                return tokenWrite.relationshipTypeGetOrCreateForName("Type0");
            }

            @Override
            public SchemaDescriptor createSchemaDescriptor(int entityToken, int propertyKey) {
                return SchemaDescriptors.forRelType((int)entityToken, (int[])new int[]{propertyKey});
            }
        };

    }

    static interface EntityControl {
        public int entityTokenGetOrCreate(TokenWrite var1) throws KernelException;

        public SchemaDescriptor createSchemaDescriptor(int var1, int var2);
    }
}

