/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.kernel.availability.AvailabilityListener;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
class ShutdownOnIndexUpdateIT {
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private Database database;
    private static final String UNIQUE_PROPERTY_NAME = "uniquePropertyName";
    private static final AtomicLong indexProvider = new AtomicLong();
    private static final Label CONSTRAINT_INDEX_LABEL = Label.label((String)"ConstraintIndexLabel");

    ShutdownOnIndexUpdateIT() {
    }

    @Test
    void shutdownWhileFinishingTransactionWithIndexUpdates() {
        ShutdownOnIndexUpdateIT.createConstraint((GraphDatabaseService)this.db);
        ShutdownOnIndexUpdateIT.waitIndexesOnline((GraphDatabaseService)this.db);
        try (Transaction transaction = this.db.beginTx();){
            Node node = transaction.createNode(new Label[]{CONSTRAINT_INDEX_LABEL});
            node.setProperty(UNIQUE_PROPERTY_NAME, (Object)indexProvider.getAndIncrement());
            DatabaseAvailabilityGuard availabilityGuard = this.database.getDatabaseAvailabilityGuard();
            TransactionCloseListener closeListener = new TransactionCloseListener(transaction);
            availabilityGuard.addListener((AvailabilityListener)closeListener);
            this.database.stop();
            Assertions.assertTrue((boolean)closeListener.isTransactionClosed(), (String)"Transaction should be closed and no exception should be thrown.");
        }
    }

    private static void waitIndexesOnline(GraphDatabaseService database) {
        try (Transaction tx = database.beginTx();){
            tx.schema().awaitIndexesOnline(5L, TimeUnit.MINUTES);
        }
    }

    private static void createConstraint(GraphDatabaseService database) {
        try (Transaction transaction = database.beginTx();){
            Schema schema = transaction.schema();
            schema.constraintFor(CONSTRAINT_INDEX_LABEL).assertPropertyIsUnique(UNIQUE_PROPERTY_NAME).create();
            transaction.commit();
        }
    }

    private static class TransactionCloseListener
    implements AvailabilityListener {
        private final Transaction transaction;
        private boolean transactionClosed;

        TransactionCloseListener(Transaction transaction) {
            this.transaction = transaction;
        }

        public void unavailable() {
            this.transaction.commit();
            this.transactionClosed = true;
        }

        boolean isTransactionClosed() {
            return this.transactionClosed;
        }
    }
}

