/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.lucene;

import java.nio.file.Path;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.neo4j.common.EntityType;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.IndexingTestUtil;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.api.exceptions.schema.IndexBrokenKernelException;
import org.neo4j.kernel.api.exceptions.schema.UnableToValidateConstraintException;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.impl.coreapi.TransactionImpl;
import org.neo4j.kernel.impl.index.schema.AbstractIndexProviderFactory;
import org.neo4j.kernel.impl.index.schema.BuiltInDelegatingIndexProviderFactory;
import org.neo4j.kernel.impl.index.schema.FailingNativeIndexProviderFactory;
import org.neo4j.kernel.impl.index.schema.RangeIndexProviderFactory;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
class ConstraintIndexFailureIT {
    @Inject
    private TestDirectory directory;

    ConstraintIndexFailureIT() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=EntityType.class)
    void shouldFailToValidateConstraintsIfUnderlyingIndexIsFailed(EntityType entityType) throws Exception {
        TransactionImpl tx;
        Path dir = this.directory.homePath();
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(dir).addExtension((ExtensionFactory)new BuiltInDelegatingIndexProviderFactory((AbstractIndexProviderFactory)new RangeIndexProviderFactory(), FailingNativeIndexProviderFactory.DESCRIPTOR)).setConfig(GraphDatabaseInternalSettings.always_use_latest_index_provider, (Object)false).build();
        GraphDatabaseService db = managementService.database("neo4j");
        try {
            tx = (TransactionImpl)db.beginTx();
            try {
                this.createConstraint(entityType, tx);
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        finally {
            managementService.shutdown();
        }
        FileUtils.deleteDirectory((Path)IndexDirectoryStructure.baseSchemaIndexFolder((Path)dir));
        managementService = new TestDatabaseManagementServiceBuilder(dir).addExtension((ExtensionFactory)new FailingNativeIndexProviderFactory(new FailingNativeIndexProviderFactory.FailureType[]{FailingNativeIndexProviderFactory.FailureType.INITIAL_STATE})).build();
        db = managementService.database("neo4j");
        try {
            tx = db.beginTx();
            try {
                ConstraintViolationException e = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> this.lambda$shouldFailToValidateConstraintsIfUnderlyingIndexIsFailed$0(entityType, (Transaction)tx));
                Throwable cause = e.getCause();
                Assertions.assertThat((Throwable)cause).isInstanceOf(UnableToValidateConstraintException.class);
                Assertions.assertThat((Throwable)cause.getCause()).isInstanceOf(IndexBrokenKernelException.class);
                IndexBrokenKernelException causeCause = (IndexBrokenKernelException)cause.getCause();
                ((AbstractStringAssert)Assertions.assertThat((String)causeCause.getMessage()).contains(new CharSequence[]{"The index is in a failed state:"})).contains(new CharSequence[]{"Override initial state as failed"});
                Assertions.assertThat((String)causeCause.gqlStatus()).isEqualTo("51N62");
                Assertions.assertThat((String)causeCause.statusDescription()).contains(new CharSequence[]{"error: system configuration or operation exception - index is in a failed state. Unable to use index", "because it is in a failed state. See logs for more information."});
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        finally {
            managementService.shutdown();
        }
    }

    private void createConstraint(EntityType entityType, TransactionImpl tx) throws KernelException {
        switch (entityType) {
            case NODE: {
                IndexingTestUtil.createNodePropUniqueConstraintWithSpecifiedProvider((TransactionImpl)tx, (IndexProviderDescriptor)FailingNativeIndexProviderFactory.DESCRIPTOR, (Label)Label.label((String)"Label1"), (String)"key1");
                break;
            }
            case RELATIONSHIP: {
                IndexingTestUtil.createRelPropUniqueConstraintWithSpecifiedProvider((TransactionImpl)tx, (IndexProviderDescriptor)FailingNativeIndexProviderFactory.DESCRIPTOR, (RelationshipType)RelationshipType.withName((String)"Type1"), (String)"key1");
            }
        }
    }

    private void createData(EntityType entityType, Transaction tx) {
        switch (entityType) {
            case NODE: {
                tx.createNode(new Label[]{Label.label((String)"Label1")}).setProperty("key1", (Object)"value1");
                break;
            }
            case RELATIONSHIP: {
                Node node = tx.createNode();
                node.createRelationshipTo(node, RelationshipType.withName((String)"Type1")).setProperty("key1", (Object)"value1");
            }
        }
    }

    private /* synthetic */ void lambda$shouldFailToValidateConstraintsIfUnderlyingIndexIsFailed$0(EntityType entityType, Transaction tx) throws Throwable {
        this.createData(entityType, tx);
    }
}

