/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.recovery;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Random;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.neo4j.common.DependencyResolver;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.DatabaseFlushEvent;
import org.neo4j.kernel.impl.transaction.log.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointerImpl;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotateEvents;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
public class UniqueIndexRecoveryTest {
    @Inject
    private TestDirectory storeDir;
    private static final String PROPERTY_KEY = "key";
    private static final String PROPERTY_VALUE = "value";
    private static final Label LABEL = Label.label((String)"label");
    private GraphDatabaseAPI db;
    private DatabaseManagementService managementService;

    private void setupDatabase() {
        this.db = (GraphDatabaseAPI)this.newDb();
    }

    @AfterEach
    void after() {
        this.managementService.shutdown();
    }

    @Test
    void shouldRecoverCreationOfUniquenessConstraintFollowedByDeletionOfThatSameConstraint() throws Exception {
        this.setupDatabase();
        this.createUniqueConstraint();
        this.dropConstraints();
        this.restart(UniqueIndexRecoveryTest.snapshot(this.storeDir.absolutePath()));
        try (Transaction tx = this.db.beginTx();){
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.schema().getConstraints(LABEL).iterator().hasNext());
            tx.commit();
        }
    }

    @Test
    void shouldRecoverWhenCommandsTemporarilyViolateConstraints() throws Exception {
        this.setupDatabase();
        Node unLabeledNode = this.createUnLabeledNodeWithProperty();
        Node labeledNode = this.createLabeledNode();
        this.createUniqueConstraint();
        this.rotateLogAndCheckPoint();
        this.setPropertyOnLabeledNode(labeledNode);
        this.deletePropertyOnLabeledNode(labeledNode);
        this.addLabelToUnLabeledNode(unLabeledNode);
        this.flushAll();
        this.restart(UniqueIndexRecoveryTest.snapshot(this.storeDir.absolutePath()));
        try (Transaction tx = this.db.beginTx();){
            Assertions.assertThat((Object)tx.findNode(LABEL, PROPERTY_KEY, (Object)PROPERTY_VALUE)).isEqualTo((Object)unLabeledNode);
            tx.commit();
        }
    }

    private void restart(Path newStore) {
        this.managementService.shutdown();
        this.managementService = new TestDatabaseManagementServiceBuilder(newStore).build();
        this.db = (GraphDatabaseAPI)this.managementService.database("neo4j");
    }

    private GraphDatabaseService newDb() {
        this.managementService = new TestDatabaseManagementServiceBuilder(this.storeDir.absolutePath()).build();
        return this.managementService.database("neo4j");
    }

    private static Path snapshot(Path path) throws IOException {
        Path snapshotDir = path.resolve("snapshot-" + new Random().nextInt());
        FileUtils.copyDirectory((Path)path, (Path)snapshotDir, pathName -> {
            String subPath = pathName.toAbsolutePath().toString().substring(path.toString().length() + 1);
            return !"store_lock".equals(subPath) && !subPath.endsWith("write.lock");
        });
        return snapshotDir;
    }

    private void addLabelToUnLabeledNode(Node unLabeledNode) {
        try (Transaction tx = this.db.beginTx();){
            tx.getNodeById(unLabeledNode.getId()).addLabel(LABEL);
            tx.commit();
        }
    }

    private void setPropertyOnLabeledNode(Node labeledNode) {
        try (Transaction tx = this.db.beginTx();){
            tx.getNodeById(labeledNode.getId()).setProperty(PROPERTY_KEY, (Object)PROPERTY_VALUE);
            tx.commit();
        }
    }

    private void deletePropertyOnLabeledNode(Node labeledNode) {
        try (Transaction tx = this.db.beginTx();){
            tx.getNodeById(labeledNode.getId()).removeProperty(PROPERTY_KEY);
            tx.commit();
        }
    }

    private void createUniqueConstraint() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().constraintFor(LABEL).assertPropertyIsUnique(PROPERTY_KEY).create();
            tx.commit();
        }
    }

    private Node createLabeledNode() {
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode(new Label[]{LABEL});
            tx.commit();
            Node node2 = node;
            return node2;
        }
    }

    private Node createUnLabeledNodeWithProperty() {
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            node.setProperty(PROPERTY_KEY, (Object)PROPERTY_VALUE);
            tx.commit();
            Node node2 = node;
            return node2;
        }
    }

    private void dropConstraints() {
        try (Transaction tx = this.db.beginTx();){
            for (ConstraintDefinition constraint : tx.schema().getConstraints(LABEL)) {
                constraint.drop();
            }
            tx.commit();
        }
    }

    private void rotateLogAndCheckPoint() throws IOException {
        DependencyResolver resolver = this.db.getDependencyResolver();
        ((LogFiles)resolver.resolveDependency(LogFiles.class)).getLogFile().getLogRotation().rotateLogFile((LogRotateEvents)LogAppendEvent.NULL);
        ((CheckPointer)resolver.resolveDependency(CheckPointer.class)).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
    }

    private void flushAll() throws IOException {
        ((CheckPointerImpl.ForceOperation)this.db.getDependencyResolver().resolveDependency(CheckPointerImpl.ForceOperation.class)).flushAndForce(DatabaseFlushEvent.NULL, CursorContext.NULL_CONTEXT);
    }
}

