/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.UncloseableDelegatingFileSystemAbstraction;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@EphemeralTestDirectoryExtension
public class SchemaIndexAcceptanceTest {
    @Inject
    private EphemeralFileSystemAbstraction fs;
    @Inject
    private TestDirectory testDirectory;
    private GraphDatabaseService db;
    private final Label label = Label.label((String)"PERSON");
    private final String propertyKey = "key";
    private DatabaseManagementService managementService;

    @BeforeEach
    void before() {
        this.db = this.newDb(this.fs);
    }

    @AfterEach
    void after() {
        this.managementService.shutdown();
    }

    @Test
    void creatingIndexOnExistingDataBuildsIndexWhichWillBeOnlineNextStartup() {
        Node node3;
        Node node2;
        Node node1;
        try (Transaction tx = this.db.beginTx();){
            node1 = SchemaIndexAcceptanceTest.createNode(tx, this.label, "name", "One");
            node2 = SchemaIndexAcceptanceTest.createNode(tx, this.label, "name", "Two");
            node3 = SchemaIndexAcceptanceTest.createNode(tx, this.label, "name", "Three");
            tx.commit();
        }
        SchemaIndexAcceptanceTest.createIndex(this.db, this.label, "key");
        this.restart();
        try (Transaction transaction = this.db.beginTx();){
            Assertions.assertThat(SchemaIndexAcceptanceTest.findNodesByLabelAndProperty(this.label, "name", "One", transaction)).containsOnly((Object[])new Node[]{node1});
            Assertions.assertThat(SchemaIndexAcceptanceTest.findNodesByLabelAndProperty(this.label, "name", "Two", transaction)).containsOnly((Object[])new Node[]{node2});
            Assertions.assertThat(SchemaIndexAcceptanceTest.findNodesByLabelAndProperty(this.label, "name", "Three", transaction)).containsOnly((Object[])new Node[]{node3});
        }
    }

    @Test
    void shouldIndexArrays() {
        Node node1;
        long[] arrayPropertyValue = new long[]{42L, 23L, 87L};
        SchemaIndexAcceptanceTest.createIndex(this.db, this.label, "key");
        try (Transaction tx = this.db.beginTx();){
            node1 = SchemaIndexAcceptanceTest.createNode(tx, this.label, "key", arrayPropertyValue);
            tx.commit();
        }
        this.restart();
        tx = this.db.beginTx();
        try {
            Assertions.assertThat(SchemaIndexAcceptanceTest.getIndexes(tx, this.label)).extracting(i -> tx.schema().getIndexState(i)).containsOnly((Object[])new Schema.IndexState[]{Schema.IndexState.ONLINE});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction transaction = this.db.beginTx();){
            Assertions.assertThat(SchemaIndexAcceptanceTest.findNodesByLabelAndProperty(this.label, "key", arrayPropertyValue, transaction)).containsOnly((Object[])new Node[]{node1});
            Assertions.assertThat(SchemaIndexAcceptanceTest.findNodesByLabelAndProperty(this.label, "key", new long[]{42L, 23L}, transaction)).isEmpty();
            Assertions.assertThat(SchemaIndexAcceptanceTest.findNodesByLabelAndProperty(this.label, "key", Arrays.toString(arrayPropertyValue), transaction)).isEmpty();
            transaction.commit();
        }
    }

    @Test
    void shouldIndexStringArrays() {
        Node node1;
        Object[] arrayPropertyValue = new String[]{"A, B", "C"};
        SchemaIndexAcceptanceTest.createIndex(this.db, this.label, "key");
        try (Transaction tx = this.db.beginTx();){
            node1 = SchemaIndexAcceptanceTest.createNode(tx, this.label, "key", arrayPropertyValue);
            tx.commit();
        }
        this.restart();
        tx = this.db.beginTx();
        try {
            Assertions.assertThat(SchemaIndexAcceptanceTest.getIndexes(tx, this.label)).extracting(i -> tx.schema().getIndexState(i)).containsOnly((Object[])new Schema.IndexState[]{Schema.IndexState.ONLINE});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction transaction = this.db.beginTx();){
            Assertions.assertThat(SchemaIndexAcceptanceTest.findNodesByLabelAndProperty(this.label, "key", arrayPropertyValue, transaction)).containsOnly((Object[])new Node[]{node1});
            Assertions.assertThat(SchemaIndexAcceptanceTest.findNodesByLabelAndProperty(this.label, "key", new String[]{"A", "B, C"}, transaction)).isEmpty();
            Assertions.assertThat(SchemaIndexAcceptanceTest.findNodesByLabelAndProperty(this.label, "key", Arrays.toString(arrayPropertyValue), transaction)).isEmpty();
        }
    }

    @Test
    void shouldIndexArraysPostPopulation() {
        Node node1;
        long[] arrayPropertyValue = new long[]{42L, 23L, 87L};
        try (Transaction tx = this.db.beginTx();){
            node1 = SchemaIndexAcceptanceTest.createNode(tx, this.label, "key", arrayPropertyValue);
            tx.commit();
        }
        SchemaIndexAcceptanceTest.createIndex(this.db, this.label, "key");
        this.restart();
        tx = this.db.beginTx();
        try {
            Assertions.assertThat(SchemaIndexAcceptanceTest.getIndexes(tx, this.label)).extracting(i -> tx.schema().getIndexState(i)).containsOnly((Object[])new Schema.IndexState[]{Schema.IndexState.ONLINE});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction transaction = this.db.beginTx();){
            Assertions.assertThat(SchemaIndexAcceptanceTest.findNodesByLabelAndProperty(this.label, "key", arrayPropertyValue, transaction)).containsOnly((Object[])new Node[]{node1});
            Assertions.assertThat(SchemaIndexAcceptanceTest.findNodesByLabelAndProperty(this.label, "key", new long[]{42L, 23L}, transaction)).isEmpty();
            Assertions.assertThat(SchemaIndexAcceptanceTest.findNodesByLabelAndProperty(this.label, "key", Arrays.toString(arrayPropertyValue), transaction)).isEmpty();
        }
    }

    @Test
    void recoveryAfterCreateAndDropIndex() {
        IndexDefinition indexDefinition = SchemaIndexAcceptanceTest.createIndex(this.db, this.label, "key");
        this.createSomeData(this.label, "key");
        SchemaIndexAcceptanceTest.doStuff(this.db, this.label, "key");
        this.dropIndex(indexDefinition);
        SchemaIndexAcceptanceTest.doStuff(this.db, this.label, "key");
        this.crashAndRestart();
        try (Transaction transaction = this.db.beginTx();){
            Assertions.assertThat(SchemaIndexAcceptanceTest.getIndexes(transaction, this.label)).isEmpty();
        }
    }

    private GraphDatabaseService newDb(EphemeralFileSystemAbstraction fileSystemAbstraction) {
        this.managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath()).setFileSystem((FileSystemAbstraction)new UncloseableDelegatingFileSystemAbstraction((FileSystemAbstraction)fileSystemAbstraction)).build();
        return this.managementService.database("neo4j");
    }

    private void crashAndRestart() {
        EphemeralFileSystemAbstraction crashSnapshot = this.fs.snapshot();
        this.managementService.shutdown();
        this.db = this.newDb(crashSnapshot);
    }

    private void restart() {
        this.managementService.shutdown();
        this.db = this.newDb(this.fs);
    }

    private static Node createNode(Transaction tx, Label label, Object ... properties) {
        Node node = tx.createNode(new Label[]{label});
        for (Map.Entry property : MapUtil.map((Object[])properties).entrySet()) {
            node.setProperty((String)property.getKey(), property.getValue());
        }
        return node;
    }

    private void dropIndex(IndexDefinition indexDefinition) {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().getIndexByName(indexDefinition.getName()).drop();
            tx.commit();
        }
    }

    private static void doStuff(GraphDatabaseService db, Label label, String propertyKey) {
        try (Transaction tx = db.beginTx();
             ResourceIterator nodes = tx.findNodes(label, propertyKey, (Object)3323);){
            for (Node node : Iterators.loop((Iterator)nodes)) {
                Iterables.count((Iterable)node.getLabels());
            }
        }
    }

    private void createSomeData(Label label, String propertyKey) {
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode(new Label[]{label});
            node.setProperty(propertyKey, (Object)"yeah");
            tx.commit();
        }
    }

    private static List<Node> findNodesByLabelAndProperty(Label label, String propertyName, Object value, Transaction transaction) {
        return Iterators.asList((Iterator)transaction.findNodes(label, propertyName, value));
    }

    private static Iterable<IndexDefinition> getIndexes(Transaction transaction, Label label) {
        return transaction.schema().getIndexes(label);
    }

    private static IndexDefinition createIndex(GraphDatabaseService db, Label label, String property) {
        IndexDefinition indexDefinition;
        try (Transaction tx = db.beginTx();){
            indexDefinition = tx.schema().indexFor(label).on(property).create();
            tx.commit();
        }
        tx = db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        return indexDefinition;
    }
}

