/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import org.neo4j.internal.schema.AllIndexProviderDescriptors;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.kernel.api.impl.schema.StringLengthIndexValidationIT;
import org.neo4j.test.RandomSupport;

public class TrigramIndexStringLengthIndexValidationIT
extends StringLengthIndexValidationIT {
    @Override
    protected int getSingleKeySizeLimit(int payloadSize) {
        return 32766;
    }

    @Override
    protected String getString(RandomSupport random, int keySize) {
        return random.nextAlphaNumericString(keySize, keySize);
    }

    @Override
    protected IndexType getIndexType() {
        return IndexType.TEXT;
    }

    @Override
    protected IndexProviderDescriptor getIndexProvider() {
        return AllIndexProviderDescriptors.TEXT_V2_DESCRIPTOR;
    }

    @Override
    protected String expectedPopulationFailureCauseMessage(long indexId, String elementId) {
        return String.format("Property value is too large to index, please see index documentation for limitations. Index: Index( id=%d, name='coolName', type='TEXT', schema=(:LABEL_ONE {largeString}), indexProvider='text-2.0' ), element id: %s", indexId, elementId);
    }
}

