/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.fulltext;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.set.MutableSet;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.params.provider.Arguments;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.IndexMonitor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexProceduresUtil;
import org.neo4j.kernel.api.impl.schema.fulltext.FulltextIndexSettingsKeys;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.monitoring.Monitors;
import org.neo4j.test.Barrier;
import org.neo4j.test.GraphDatabaseServiceCleaner;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsController;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@DbmsExtension(configurationCallback="configure")
class FulltextProceduresTestSupport {
    static final String SCORE = "score";
    static final String NODE = "node";
    static final String RELATIONSHIP = "relationship";
    static final String DESCARTES_MEDITATIONES = "/meditationes--rene-descartes--public-domain.txt";
    static final Label LABEL = Label.label((String)"Label");
    static final RelationshipType REL = RelationshipType.withName((String)"REL");
    static final String PROP = "prop";
    static final String PROP2 = "prop2";
    static final String EVENTUALLY_CONSISTENT_OPTIONS = "{`fulltext.eventually_consistent`: true}";
    static final String QUERY_NODES = "CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")";
    static final String QUERY_RELS = "CALL db.index.fulltext.queryRelationships(\"%s\", \"%s\")";
    static final String DEFAULT_NODE_IDX_NAME = "nodes";
    static final String DEFAULT_REL_IDX_NAME = "rels";
    @Inject
    GraphDatabaseAPI db;
    @Inject
    DbmsController controller;
    AtomicBoolean trapPopulation;
    Barrier.Control populationScanFinished;

    FulltextProceduresTestSupport() {
    }

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        Monitors monitors = new Monitors();
        IndexMonitor.MonitorAdapter trappingMonitor = new IndexMonitor.MonitorAdapter(){

            public void indexPopulationScanComplete(IndexDescriptor[] indexDescriptors) {
                if (FulltextProceduresTestSupport.this.trapPopulation.get()) {
                    FulltextProceduresTestSupport.this.populationScanFinished.reached();
                }
            }
        };
        monitors.addMonitorListener((Object)trappingMonitor, new String[0]);
        builder.setMonitors(monitors);
    }

    @BeforeEach
    void beforeEach() {
        this.trapPopulation = new AtomicBoolean();
        this.populationScanFinished = new Barrier.Control();
        GraphDatabaseServiceCleaner.cleanDatabaseContent((GraphDatabaseService)this.db);
    }

    static void assertNoIndexSeeks(Result result) {
        Assertions.assertThat((long)result.stream().count()).isEqualTo(1L);
        String planDescription = result.getExecutionPlanDescription().toString();
        Assertions.assertThat((String)planDescription).contains(new CharSequence[]{"NodeByLabel"});
        Assertions.assertThat((String)planDescription).doesNotContain(new CharSequence[]{"IndexSeek"});
    }

    void restartDatabase() {
        this.controller.restartDbms(this.db.databaseName());
    }

    void awaitIndexesOnline() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexesOnline(1L, TimeUnit.HOURS);
            tx.commit();
        }
    }

    static void assertQueryFindsIdsInOrder(GraphDatabaseService db, boolean queryNodes, String index, String query, String ... ids) {
        try (Transaction tx = db.beginTx();){
            FulltextProceduresTestSupport.assertQueryFindsIdsInOrder(tx, queryNodes, index, query, ids);
            tx.commit();
        }
    }

    static void assertQueryFindsIdsInOrder(Transaction tx, boolean queryNodes, String index, String query, String ... ids) {
        String queryCall = queryNodes ? QUERY_NODES : QUERY_RELS;
        Result result = tx.execute(String.format(queryCall, index, query));
        int num = 0;
        Double score = Double.MAX_VALUE;
        while (result.hasNext()) {
            Map entry = result.next();
            String nextId = ((Entity)entry.get(queryNodes ? NODE : RELATIONSHIP)).getElementId();
            Double nextScore = (Double)entry.get(SCORE);
            Assertions.assertThat((Double)nextScore).isLessThanOrEqualTo(score);
            score = nextScore;
            if (num < ids.length) {
                org.junit.jupiter.api.Assertions.assertEquals((Object)ids[num], (Object)nextId, (String)String.format("Result returned id %s, expected %s", nextId, ids[num]));
            } else {
                org.junit.jupiter.api.Assertions.fail((String)String.format("Result returned id %s, which is beyond the number of ids (%d) that were expected.", nextId, ids.length));
            }
            ++num;
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)ids.length, (int)num, (String)"Number of results differ from expected");
    }

    static void assertQueryFindsIds(GraphDatabaseService db, boolean queryNodes, String index, String query, Set<String> ids) {
        ids = Sets.mutable.withAll(ids);
        String queryCall = queryNodes ? QUERY_NODES : QUERY_RELS;
        String[] expectedIds = (String[])ids.toArray(String[]::new);
        MutableSet actualIds = Sets.mutable.empty();
        try (Transaction tx = db.beginTx();){
            Function<String, Entity> getEntity = queryNodes ? arg_0 -> ((Transaction)tx).getNodeByElementId(arg_0) : arg_0 -> ((Transaction)tx).getRelationshipByElementId(arg_0);
            Result result = tx.execute(String.format(queryCall, index, query));
            Double score = Double.MAX_VALUE;
            while (result.hasNext()) {
                Map entry = result.next();
                String nextId = ((Entity)entry.get(queryNodes ? NODE : RELATIONSHIP)).getElementId();
                Double nextScore = (Double)entry.get(SCORE);
                Assertions.assertThat((Double)nextScore).isLessThanOrEqualTo(score);
                score = nextScore;
                actualIds.add((Object)nextId);
                if (ids.remove(nextId)) continue;
                String msg = "This id was not expected: " + nextId;
                FulltextProceduresTestSupport.failQuery(getEntity, index, query, (Set<String>)ids, expectedIds, (MutableSet<String>)actualIds, msg);
            }
            if (!ids.isEmpty()) {
                String msg = "Not all expected ids were found: " + String.valueOf(ids);
                FulltextProceduresTestSupport.failQuery(getEntity, index, query, (Set<String>)ids, expectedIds, (MutableSet<String>)actualIds, msg);
            }
            tx.commit();
        }
    }

    static void failQuery(Function<String, Entity> getEntity, String index, String query, Set<String> ids, String[] expectedIds, MutableSet<String> actualIds, String msg) {
        Entity entity;
        StringBuilder message = new StringBuilder(msg).append('\n');
        for (String id : ids) {
            entity = getEntity.apply(id);
            message.append('\t').append(entity).append(entity.getAllProperties()).append('\n');
        }
        message.append("for query: '").append(query).append("'\nin index: ").append(index).append('\n');
        message.append("all expected ids: ").append(Arrays.toString(expectedIds)).append('\n');
        message.append("actual ids: ").append(actualIds);
        for (String id : actualIds) {
            entity = getEntity.apply(id);
            message.append("\n\t").append(entity).append(entity.getAllProperties());
        }
        org.junit.jupiter.api.Assertions.fail((String)message.toString());
    }

    static List<Value> generateRandomNonStringValues() {
        Predicate<Value> nonString = v -> v.valueGroup() != ValueGroup.TEXT && v.valueGroup() != ValueGroup.TEXT_ARRAY;
        return FulltextProceduresTestSupport.generateRandomValues(nonString);
    }

    static List<Value> generateRandomSimpleValues() {
        EnumSet<ValueGroup> simpleTypes = EnumSet.of(ValueGroup.BOOLEAN, ValueGroup.BOOLEAN_ARRAY, ValueGroup.NUMBER, ValueGroup.NUMBER_ARRAY);
        return FulltextProceduresTestSupport.generateRandomValues(v -> simpleTypes.contains(v.valueGroup()));
    }

    static List<Value> generateRandomValues(Predicate<Value> predicate) {
        int valuesToGenerate = 1000;
        RandomValues generator = RandomValues.create();
        ArrayList<Value> values = new ArrayList<Value>(valuesToGenerate);
        for (int i = 0; i < valuesToGenerate; ++i) {
            Value value;
            while (!predicate.test(value = generator.nextValue())) {
            }
            values.add(value);
        }
        return values;
    }

    void createIndexAndWait(EntityUtil entityUtil) {
        try (Transaction tx = this.db.beginTx();){
            entityUtil.createIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
    }

    void createCompositeIndexAndWait(EntityUtil entityUtil) {
        try (Transaction tx = this.db.beginTx();){
            entityUtil.createCompositeIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
    }

    static void createSimpleRelationshipIndex(Transaction tx) {
        tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s", DEFAULT_REL_IDX_NAME, FulltextIndexProceduresUtil.asRelationshipTypeStr((String[])new String[]{REL.name()}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{PROP}))).close();
    }

    static void createSimpleNodesIndex(Transaction tx) {
        tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s", DEFAULT_NODE_IDX_NAME, FulltextIndexProceduresUtil.asNodeLabelStr((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{PROP}))).close();
    }

    static Stream<Arguments> entityTypeProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{new NodeUtil()}), Arguments.of((Object[])new Object[]{new RelationshipUtil()}));
    }

    static interface EntityUtil {
        public void createIndex(Transaction var1);

        public void createIndexWithAnalyzer(Transaction var1, String var2);

        public void createCompositeIndex(Transaction var1);

        public String createEntityWithProperty(Transaction var1, Object var2);

        public String createEntityWithProperties(Transaction var1, Object var2, Object var3);

        public String createEntity(Transaction var1);

        public void assertQueryFindsIdsInOrder(Transaction var1, String var2, String ... var3);

        public void assertQueryFindsIds(GraphDatabaseAPI var1, String var2, Set<String> var3);

        default public void assertQueryFindsIdsInOrder(GraphDatabaseAPI db, String query, String ... ids) {
            try (Transaction tx = db.beginTx();){
                this.assertQueryFindsIdsInOrder(tx, query, ids);
                tx.commit();
            }
        }

        public void deleteEntity(Transaction var1, String var2);

        public void dropIndex(Transaction var1);

        public Result queryIndex(Transaction var1, String var2);

        public ResourceIterator<Entity> queryIndexWithOptions(Transaction var1, String var2, String var3);

        public Entity getEntity(Transaction var1, String var2);
    }

    static class NodeUtil
    implements EntityUtil {
        NodeUtil() {
        }

        @Override
        public void createIndex(Transaction tx) {
            FulltextProceduresTestSupport.createSimpleNodesIndex(tx);
        }

        @Override
        public void createIndexWithAnalyzer(Transaction tx, String analyzer) {
            tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s OPTIONS {indexConfig: %s}", FulltextProceduresTestSupport.DEFAULT_NODE_IDX_NAME, FulltextIndexProceduresUtil.asNodeLabelStr((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{FulltextProceduresTestSupport.PROP}), "{`" + FulltextIndexSettingsKeys.ANALYZER + "`: \"" + analyzer + "\"}")).close();
        }

        @Override
        public void createCompositeIndex(Transaction tx) {
            tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s", FulltextProceduresTestSupport.DEFAULT_NODE_IDX_NAME, FulltextIndexProceduresUtil.asNodeLabelStr((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{FulltextProceduresTestSupport.PROP, FulltextProceduresTestSupport.PROP2}))).close();
        }

        @Override
        public String createEntityWithProperty(Transaction tx, Object propertyValue) {
            Node node = tx.createNode(new Label[]{LABEL});
            node.setProperty(FulltextProceduresTestSupport.PROP, propertyValue);
            return node.getElementId();
        }

        @Override
        public String createEntityWithProperties(Transaction tx, Object propertyValue, Object property2Value) {
            Node node = tx.createNode(new Label[]{LABEL});
            node.setProperty(FulltextProceduresTestSupport.PROP, propertyValue);
            node.setProperty(FulltextProceduresTestSupport.PROP2, property2Value);
            return node.getElementId();
        }

        @Override
        public String createEntity(Transaction tx) {
            return tx.createNode(new Label[]{LABEL}).getElementId();
        }

        @Override
        public void assertQueryFindsIdsInOrder(Transaction tx, String query, String ... ids) {
            FulltextProceduresTestSupport.assertQueryFindsIdsInOrder(tx, true, FulltextProceduresTestSupport.DEFAULT_NODE_IDX_NAME, query, ids);
        }

        @Override
        public void assertQueryFindsIds(GraphDatabaseAPI db, String query, Set<String> ids) {
            FulltextProceduresTestSupport.assertQueryFindsIds((GraphDatabaseService)db, true, FulltextProceduresTestSupport.DEFAULT_NODE_IDX_NAME, query, ids);
        }

        @Override
        public void deleteEntity(Transaction tx, String entityId) {
            tx.getNodeByElementId(entityId).delete();
        }

        @Override
        public void dropIndex(Transaction tx) {
            tx.execute(String.format("DROP INDEX `%s`", FulltextProceduresTestSupport.DEFAULT_NODE_IDX_NAME));
        }

        @Override
        public Result queryIndex(Transaction tx, String query) {
            return tx.execute(String.format(FulltextProceduresTestSupport.QUERY_NODES, FulltextProceduresTestSupport.DEFAULT_NODE_IDX_NAME, query));
        }

        @Override
        public ResourceIterator<Entity> queryIndexWithOptions(Transaction tx, String query, String options) {
            return tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\", %s )", FulltextProceduresTestSupport.DEFAULT_NODE_IDX_NAME, query, options)).columnAs(FulltextProceduresTestSupport.NODE);
        }

        @Override
        public Entity getEntity(Transaction tx, String id) {
            return tx.getNodeByElementId(id);
        }

        public String toString() {
            return "For node";
        }
    }

    static class RelationshipUtil
    implements EntityUtil {
        RelationshipUtil() {
        }

        @Override
        public void createIndex(Transaction tx) {
            FulltextProceduresTestSupport.createSimpleRelationshipIndex(tx);
        }

        @Override
        public void createIndexWithAnalyzer(Transaction tx, String analyzer) {
            tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s OPTIONS {indexConfig: %s}", FulltextProceduresTestSupport.DEFAULT_REL_IDX_NAME, FulltextIndexProceduresUtil.asRelationshipTypeStr((String[])new String[]{REL.name()}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{FulltextProceduresTestSupport.PROP}), "{`" + FulltextIndexSettingsKeys.ANALYZER + "`: \"" + analyzer + "\"}")).close();
        }

        @Override
        public void createCompositeIndex(Transaction tx) {
            tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s", FulltextProceduresTestSupport.DEFAULT_REL_IDX_NAME, FulltextIndexProceduresUtil.asRelationshipTypeStr((String[])new String[]{REL.name()}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{FulltextProceduresTestSupport.PROP, FulltextProceduresTestSupport.PROP2}))).close();
        }

        @Override
        public String createEntityWithProperty(Transaction tx, Object propertyValue) {
            Node node = tx.createNode();
            Relationship rel = node.createRelationshipTo(node, REL);
            rel.setProperty(FulltextProceduresTestSupport.PROP, propertyValue);
            return rel.getElementId();
        }

        @Override
        public String createEntityWithProperties(Transaction tx, Object propertyValue, Object property2Value) {
            Node node = tx.createNode();
            Relationship rel = node.createRelationshipTo(node, REL);
            rel.setProperty(FulltextProceduresTestSupport.PROP, propertyValue);
            rel.setProperty(FulltextProceduresTestSupport.PROP2, property2Value);
            return rel.getElementId();
        }

        @Override
        public String createEntity(Transaction tx) {
            Node node = tx.createNode();
            return node.createRelationshipTo(node, REL).getElementId();
        }

        @Override
        public void assertQueryFindsIdsInOrder(Transaction tx, String query, String ... ids) {
            FulltextProceduresTestSupport.assertQueryFindsIdsInOrder(tx, false, FulltextProceduresTestSupport.DEFAULT_REL_IDX_NAME, query, ids);
        }

        @Override
        public void assertQueryFindsIds(GraphDatabaseAPI db, String query, Set<String> ids) {
            FulltextProceduresTestSupport.assertQueryFindsIds((GraphDatabaseService)db, false, FulltextProceduresTestSupport.DEFAULT_REL_IDX_NAME, query, ids);
        }

        @Override
        public void deleteEntity(Transaction tx, String entityId) {
            tx.getRelationshipByElementId(entityId).delete();
        }

        @Override
        public void dropIndex(Transaction tx) {
            tx.execute(String.format("DROP INDEX `%s`", FulltextProceduresTestSupport.DEFAULT_REL_IDX_NAME));
        }

        @Override
        public Result queryIndex(Transaction tx, String query) {
            return tx.execute(String.format(FulltextProceduresTestSupport.QUERY_RELS, FulltextProceduresTestSupport.DEFAULT_REL_IDX_NAME, query));
        }

        @Override
        public ResourceIterator<Entity> queryIndexWithOptions(Transaction tx, String query, String options) {
            return tx.execute(String.format("CALL db.index.fulltext.queryRelationships(\"%s\", \"%s\", %s )", FulltextProceduresTestSupport.DEFAULT_REL_IDX_NAME, query, options)).columnAs(FulltextProceduresTestSupport.RELATIONSHIP);
        }

        @Override
        public Entity getEntity(Transaction tx, String id) {
            return tx.getRelationshipByElementId(id);
        }

        public String toString() {
            return "For relationship";
        }
    }
}

