/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Iterator;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestSupport;

public abstract class ConstraintTestBase<G extends KernelAPIWriteTestSupport>
extends KernelAPIWriteTestBase<G> {
    abstract SchemaDescriptor schemaDescriptor(int var1, int ... var2);

    abstract ConstraintDescriptor uniqueConstraintDescriptor(int var1, int ... var2);

    abstract ConstraintDefinition createConstraint(Schema var1, String var2, String var3);

    abstract int entityTokenId(TokenWrite var1, String var2) throws KernelException;

    abstract Iterator<ConstraintDescriptor> getConstraintsByEntityToken(SchemaRead var1, int var2);

    @BeforeEach
    public void setup() {
        try (Transaction tx = this.graphDb.beginTx();){
            for (ConstraintDefinition definition : tx.schema().getConstraints()) {
                definition.drop();
            }
            tx.commit();
        }
    }

    @Test
    void shouldFindConstraintsBySchema() throws Exception {
        this.addConstraints("FOO", "prop");
        try (KernelTransaction tx = this.beginTransaction();){
            int token = this.entityTokenId(tx.tokenWrite(), "FOO");
            int prop = tx.tokenWrite().propertyKeyGetOrCreateForName("prop");
            SchemaDescriptor descriptor = this.schemaDescriptor(token, prop);
            List constraints = Iterators.asList((Iterator)tx.schemaRead().constraintsGetForSchema(descriptor));
            Assertions.assertThat((List)constraints).hasSize(1);
            Assertions.assertThat((int)((ConstraintDescriptor)constraints.get(0)).schema().getPropertyId()).isEqualTo(prop);
        }
    }

    @Test
    void shouldFindConstraintsByEntityToken() throws Exception {
        this.addConstraints("FOO", "prop1", "FOO", "prop2");
        try (KernelTransaction tx = this.beginTransaction();){
            int entityToken = this.entityTokenId(tx.tokenWrite(), "FOO");
            List constraints = Iterators.asList(this.getConstraintsByEntityToken(tx.schemaRead(), entityToken));
            Assertions.assertThat((List)constraints).hasSize(2);
        }
    }

    @Test
    void shouldBeAbleCheckExistenceOfConstraints() throws Exception {
        try (Transaction tx = this.graphDb.beginTx();){
            this.createConstraint(tx.schema(), "FOO", "prop1");
            ConstraintDefinition dropped = this.createConstraint(tx.schema(), "FOO", "prop2");
            dropped.drop();
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            int entityToken = this.entityTokenId(tx.tokenWrite(), "FOO");
            int prop1 = tx.tokenWrite().propertyKeyGetOrCreateForName("prop1");
            int prop2 = tx.tokenWrite().propertyKeyGetOrCreateForName("prop2");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)tx.schemaRead().constraintExists(this.uniqueConstraintDescriptor(entityToken, prop1)));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.schemaRead().constraintExists(this.uniqueConstraintDescriptor(entityToken, prop2)));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldFindAllConstraints() throws Exception {
        this.addConstraints("FOO", "prop1", "BAR", "prop2", "BAZ", "prop3");
        try (KernelTransaction tx = this.beginTransaction();){
            List constraints = Iterators.asList((Iterator)tx.schemaRead().constraintsGetAll());
            Assertions.assertThat((List)constraints).hasSize(3);
        }
    }

    void addConstraints(String ... entityTokenAndProps) {
        assert (entityTokenAndProps.length % 2 == 0);
        try (Transaction tx = this.graphDb.beginTx();){
            for (int i = 0; i < entityTokenAndProps.length; i += 2) {
                this.createConstraint(tx.schema(), entityTokenAndProps[i], entityTokenAndProps[i + 1]);
            }
            tx.commit();
        }
    }
}

