/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.common.EntityType;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.FulltextSchemaDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.schema.RepeatedLabelInSchemaException;
import org.neo4j.kernel.api.exceptions.schema.RepeatedPropertyInSchemaException;
import org.neo4j.kernel.impl.newapi.ConstraintTestBase;
import org.neo4j.kernel.impl.newapi.WriteTestSupport;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class NodeConstraintTest
extends ConstraintTestBase<WriteTestSupport> {
    public WriteTestSupport newTestSupport() {
        return new WriteTestSupport();
    }

    LabelSchemaDescriptor schemaDescriptor(int tokenId, int ... propertyIds) {
        return SchemaDescriptors.forLabel((int)tokenId, (int[])propertyIds);
    }

    @Override
    ConstraintDescriptor uniqueConstraintDescriptor(int tokenId, int ... propertyIds) {
        return ConstraintDescriptorFactory.uniqueForLabel((int)tokenId, (int[])propertyIds);
    }

    @Override
    ConstraintDefinition createConstraint(Schema schema, String entityToken, String propertyKey) {
        return schema.constraintFor(Label.label((String)entityToken)).assertPropertyIsUnique(propertyKey).create();
    }

    @Override
    int entityTokenId(TokenWrite tokenWrite, String entityToken) throws KernelException {
        return tokenWrite.labelGetOrCreateForName(entityToken);
    }

    @Override
    Iterator<ConstraintDescriptor> getConstraintsByEntityToken(SchemaRead schemaRead, int entityTokenId) {
        return schemaRead.constraintsGetForLabel(entityTokenId);
    }

    @Test
    void shouldCheckUniquenessWhenAddingLabel() throws Exception {
        int label;
        long nodeNotConflicting;
        long nodeConflicting;
        this.addConstraints("FOO", "prop");
        try (Transaction tx = this.graphDb.beginTx();){
            Node conflict = tx.createNode();
            conflict.setProperty("prop", (Object)1337);
            nodeConflicting = conflict.getId();
            Node ok = tx.createNode();
            ok.setProperty("prop", (Object)42);
            nodeNotConflicting = ok.getId();
            Node existing = tx.createNode();
            existing.addLabel(Label.label((String)"FOO"));
            existing.setProperty("prop", (Object)1337);
            tx.commit();
        }
        try (KernelTransaction tx = this.beginTransaction();){
            label = tx.tokenWrite().labelGetOrCreateForName("FOO");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)tx.dataWrite().nodeAddLabel(nodeNotConflicting, label));
            org.junit.jupiter.api.Assertions.assertThrows(ConstraintValidationException.class, () -> tx.dataWrite().nodeAddLabel(nodeConflicting, label));
            tx.commit();
        }
        tx = this.beginTransaction();
        try (NodeCursor nodeCursor = tx.cursors().allocateNodeCursor(tx.cursorContext());){
            tx.dataRead().singleNode(nodeNotConflicting, nodeCursor);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)nodeCursor.next());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)nodeCursor.labels().contains(label));
            tx.dataRead().singleNode(nodeConflicting, nodeCursor);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)nodeCursor.next());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)nodeCursor.labels().contains(label));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldCheckUniquenessWhenAddingProperties() throws Exception {
        int property;
        long nodeNotConflicting;
        long nodeConflicting;
        this.addConstraints("FOO", "prop");
        try (Transaction tx = this.graphDb.beginTx();){
            Node conflict = tx.createNode();
            conflict.addLabel(Label.label((String)"FOO"));
            nodeConflicting = conflict.getId();
            Node ok = tx.createNode();
            ok.addLabel(Label.label((String)"BAR"));
            nodeNotConflicting = ok.getId();
            Node existing = tx.createNode();
            existing.addLabel(Label.label((String)"FOO"));
            existing.setProperty("prop", (Object)1337);
            tx.commit();
        }
        try (KernelTransaction tx = this.beginTransaction();){
            property = tx.tokenWrite().propertyKeyGetOrCreateForName("prop");
            tx.dataWrite().nodeSetProperty(nodeNotConflicting, property, (Value)Values.intValue((int)1337));
            org.junit.jupiter.api.Assertions.assertThrows(ConstraintValidationException.class, () -> tx.dataWrite().nodeSetProperty(nodeConflicting, property, (Value)Values.intValue((int)1337)));
            tx.commit();
        }
        tx = this.beginTransaction();
        try (NodeCursor nodeCursor = tx.cursors().allocateNodeCursor(tx.cursorContext());
             PropertyCursor propertyCursor = tx.cursors().allocatePropertyCursor(tx.cursorContext(), tx.memoryTracker());){
            tx.dataRead().singleNode(nodeNotConflicting, nodeCursor);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)nodeCursor.next());
            nodeCursor.properties(propertyCursor, PropertySelection.selection((int)property));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)propertyCursor.next());
            tx.dataRead().singleNode(nodeConflicting, nodeCursor);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)nodeCursor.next());
            nodeCursor.properties(propertyCursor, PropertySelection.selection((int)property));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)propertyCursor.next());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldFailCreateConstraintWithDuplicateLabels() throws KernelException {
        int propId;
        int labelId3;
        int labelId2;
        int labelId1;
        int labelId0;
        try (KernelTransaction tx = this.beginTransaction();){
            labelId0 = tx.tokenWrite().labelGetOrCreateForName("Label0");
            labelId1 = tx.tokenWrite().labelGetOrCreateForName("Label1");
            labelId2 = tx.tokenWrite().labelGetOrCreateForName("Label2");
            labelId3 = tx.tokenWrite().labelGetOrCreateForName("Label3");
            propId = tx.tokenWrite().propertyKeyGetOrCreateForName("property");
            tx.commit();
        }
        FulltextSchemaDescriptor descriptor = SchemaDescriptors.fulltext((EntityType)EntityType.NODE, (int[])new int[]{labelId0, labelId1, labelId2, labelId1, labelId3}, (int[])new int[]{propId});
        try (KernelTransaction tx = this.beginTransaction();){
            RepeatedLabelInSchemaException e = (RepeatedLabelInSchemaException)org.junit.jupiter.api.Assertions.assertThrows(RepeatedLabelInSchemaException.class, () -> tx.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.forSchema((SchemaDescriptor)descriptor)));
            Assertions.assertThat((String)e.gqlStatus()).isEqualTo("22N75");
            Assertions.assertThat((String)e.statusDescription()).isEqualTo("error: data exception - constraint contains duplicated tokens. The constraint specified by '(:Label0:Label1:Label2:Label1:Label3 {property})' includes a label, relationship type, or property key with name 'Label1' more than once.");
        }
    }

    @Test
    void shouldFailCreateConstraintWithDuplicateProperties() throws KernelException {
        int propId3;
        int propId2;
        int propId1;
        int propId0;
        int labelId;
        try (KernelTransaction tx = this.beginTransaction();){
            labelId = tx.tokenWrite().labelGetOrCreateForName("Label");
            propId0 = tx.tokenWrite().propertyKeyGetOrCreateForName("property0");
            propId1 = tx.tokenWrite().propertyKeyGetOrCreateForName("property1");
            propId2 = tx.tokenWrite().propertyKeyGetOrCreateForName("property2");
            propId3 = tx.tokenWrite().propertyKeyGetOrCreateForName("property3");
            tx.commit();
        }
        FulltextSchemaDescriptor descriptor = SchemaDescriptors.fulltext((EntityType)EntityType.NODE, (int[])new int[]{labelId}, (int[])new int[]{propId0, propId1, propId2, propId1, propId3});
        try (KernelTransaction tx = this.beginTransaction();){
            RepeatedPropertyInSchemaException e = (RepeatedPropertyInSchemaException)org.junit.jupiter.api.Assertions.assertThrows(RepeatedPropertyInSchemaException.class, () -> tx.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.forSchema((SchemaDescriptor)descriptor)));
            Assertions.assertThat((String)e.gqlStatus()).isEqualTo("22N75");
            Assertions.assertThat((String)e.statusDescription()).isEqualTo("error: data exception - constraint contains duplicated tokens. The constraint specified by '(:Label {property0, property1, property2, property1, property3})' includes a label, relationship type, or property key with name 'property1' more than once.");
        }
    }
}

