/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.common.EntityType;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.FulltextSchemaDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.schema.RepeatedPropertyInSchemaException;
import org.neo4j.kernel.api.exceptions.schema.RepeatedRelationshipTypeInSchemaException;
import org.neo4j.kernel.impl.newapi.ConstraintTestBase;
import org.neo4j.kernel.impl.newapi.WriteTestSupport;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class RelationshipConstraintTest
extends ConstraintTestBase<WriteTestSupport> {
    public WriteTestSupport newTestSupport() {
        return new WriteTestSupport();
    }

    @Override
    SchemaDescriptor schemaDescriptor(int tokenId, int ... propertyIds) {
        return SchemaDescriptors.forRelType((int)tokenId, (int[])propertyIds);
    }

    @Override
    ConstraintDescriptor uniqueConstraintDescriptor(int tokenId, int ... propertyIds) {
        return ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)this.schemaDescriptor(tokenId, propertyIds));
    }

    @Override
    ConstraintDefinition createConstraint(Schema schema, String entityToken, String propertyKey) {
        return schema.constraintFor(RelationshipType.withName((String)entityToken)).assertPropertyIsUnique(propertyKey).create();
    }

    @Override
    int entityTokenId(TokenWrite tokenWrite, String entityToken) throws KernelException {
        return tokenWrite.relationshipTypeGetOrCreateForName(entityToken);
    }

    @Override
    Iterator<ConstraintDescriptor> getConstraintsByEntityToken(SchemaRead schemaRead, int entityTokenId) {
        return schemaRead.constraintsGetForRelationshipType(entityTokenId);
    }

    @Test
    void shouldCheckUniquenessWhenAddingProperties() throws Exception {
        int property;
        long notConflicting;
        long conflicting;
        this.addConstraints("FOO", "prop");
        try (Transaction tx = this.graphDb.beginTx();){
            Node node = tx.createNode();
            RelationshipType type = RelationshipType.withName((String)"FOO");
            Relationship conflict = node.createRelationshipTo(node, type);
            conflicting = conflict.getId();
            Node node2 = tx.createNode();
            Relationship ok = node.createRelationshipTo(node2, RelationshipType.withName((String)"BAR"));
            notConflicting = ok.getId();
            Relationship existing = node.createRelationshipTo(node2, type);
            existing.setProperty("prop", (Object)1337);
            tx.commit();
        }
        try (KernelTransaction tx = this.beginTransaction();){
            property = tx.tokenWrite().propertyKeyGetOrCreateForName("prop");
            tx.dataWrite().relationshipSetProperty(notConflicting, property, (Value)Values.intValue((int)1337));
            org.junit.jupiter.api.Assertions.assertThrows(ConstraintValidationException.class, () -> tx.dataWrite().relationshipSetProperty(conflicting, property, (Value)Values.intValue((int)1337)));
            tx.commit();
        }
        tx = this.beginTransaction();
        try (RelationshipScanCursor relCursor = tx.cursors().allocateRelationshipScanCursor(tx.cursorContext());
             PropertyCursor propertyCursor = tx.cursors().allocatePropertyCursor(tx.cursorContext(), tx.memoryTracker());){
            tx.dataRead().singleRelationship(notConflicting, relCursor);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)relCursor.next());
            relCursor.properties(propertyCursor, PropertySelection.selection((int)property));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)propertyCursor.next());
            org.junit.jupiter.api.Assertions.assertEquals((Object)propertyCursor.propertyValue(), (Object)Values.intValue((int)1337));
            tx.dataRead().singleRelationship(conflicting, relCursor);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)relCursor.next());
            relCursor.properties(propertyCursor, PropertySelection.selection((int)property));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)propertyCursor.next());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldFailCreateConstraintWithDuplicateLabels() throws KernelException {
        int propId;
        int relTypeId3;
        int relTypeId2;
        int relTypeId1;
        int relTypeId0;
        try (KernelTransaction tx = this.beginTransaction();){
            relTypeId0 = tx.tokenWrite().relationshipTypeGetOrCreateForName("RELATIONSHIP0");
            relTypeId1 = tx.tokenWrite().relationshipTypeGetOrCreateForName("RELATIONSHIP1");
            relTypeId2 = tx.tokenWrite().relationshipTypeGetOrCreateForName("RELATIONSHIP2");
            relTypeId3 = tx.tokenWrite().relationshipTypeGetOrCreateForName("RELATIONSHIP3");
            propId = tx.tokenWrite().propertyKeyGetOrCreateForName("property");
            tx.commit();
        }
        FulltextSchemaDescriptor descriptor = SchemaDescriptors.fulltext((EntityType)EntityType.RELATIONSHIP, (int[])new int[]{relTypeId0, relTypeId1, relTypeId2, relTypeId1, relTypeId3}, (int[])new int[]{propId});
        try (KernelTransaction tx = this.beginTransaction();){
            RepeatedRelationshipTypeInSchemaException e = (RepeatedRelationshipTypeInSchemaException)org.junit.jupiter.api.Assertions.assertThrows(RepeatedRelationshipTypeInSchemaException.class, () -> tx.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.forSchema((SchemaDescriptor)descriptor)));
            Assertions.assertThat((String)e.gqlStatus()).isEqualTo("22N75");
            Assertions.assertThat((String)e.statusDescription()).isEqualTo("error: data exception - constraint contains duplicated tokens. The constraint specified by '()-[:RELATIONSHIP0:RELATIONSHIP1:RELATIONSHIP2:RELATIONSHIP1:RELATIONSHIP3 {property}]-()' includes a label, relationship type, or property key with name 'RELATIONSHIP1' more than once.");
        }
    }

    @Test
    void shouldFailCreateConstraintWithDuplicateProperties() throws KernelException {
        int propId3;
        int propId2;
        int propId1;
        int propId0;
        int relTypeId;
        try (KernelTransaction tx = this.beginTransaction();){
            relTypeId = tx.tokenWrite().relationshipTypeGetOrCreateForName("RELATIONSHIP");
            propId0 = tx.tokenWrite().propertyKeyGetOrCreateForName("property0");
            propId1 = tx.tokenWrite().propertyKeyGetOrCreateForName("property1");
            propId2 = tx.tokenWrite().propertyKeyGetOrCreateForName("property2");
            propId3 = tx.tokenWrite().propertyKeyGetOrCreateForName("property3");
            tx.commit();
        }
        FulltextSchemaDescriptor descriptor = SchemaDescriptors.fulltext((EntityType)EntityType.RELATIONSHIP, (int[])new int[]{relTypeId}, (int[])new int[]{propId0, propId1, propId2, propId1, propId3});
        try (KernelTransaction tx = this.beginTransaction();){
            RepeatedPropertyInSchemaException e = (RepeatedPropertyInSchemaException)org.junit.jupiter.api.Assertions.assertThrows(RepeatedPropertyInSchemaException.class, () -> tx.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.forSchema((SchemaDescriptor)descriptor)));
            Assertions.assertThat((String)e.gqlStatus()).isEqualTo("22N75");
            Assertions.assertThat((String)e.statusDescription()).isEqualTo("error: data exception - constraint contains duplicated tokens. The constraint specified by '()-[:RELATIONSHIP {property0, property1, property2, property1, property3}]-()' includes a label, relationship type, or property key with name 'property1' more than once.");
        }
    }
}

