/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.schema;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.LongFunction;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AutoCloseableSoftAssertions;
import org.assertj.core.api.LongAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.batchimport.api.Configuration;
import org.neo4j.batchimport.api.IndexImporterFactory;
import org.neo4j.batchimport.api.InputIterable;
import org.neo4j.batchimport.api.Monitor;
import org.neo4j.batchimport.api.input.Collector;
import org.neo4j.batchimport.api.input.IdType;
import org.neo4j.batchimport.api.input.Input;
import org.neo4j.batchimport.api.input.InputEntityVisitor;
import org.neo4j.batchimport.api.input.PropertySizeCalculator;
import org.neo4j.batchimport.api.input.ReadableGroups;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.SettingValueParsers;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.schema.AnyTokens;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.internal.batchimport.DefaultAdditionalIds;
import org.neo4j.internal.batchimport.GeneratingInputIterator;
import org.neo4j.internal.batchimport.ParallelBatchImporter;
import org.neo4j.internal.batchimport.RandomsStates;
import org.neo4j.internal.batchimport.input.BadCollector;
import org.neo4j.internal.batchimport.staging.ExecutionMonitor;
import org.neo4j.internal.helpers.TimeUtil;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.index.schema.IndexImporterFactoryImpl;
import org.neo4j.kernel.impl.transaction.log.EmptyLogTailMetadata;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogInitializer;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.NullLogService;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.scheduler.ThreadPoolJobScheduler;
import org.neo4j.test.utils.TestDirectory;
import org.neo4j.values.storable.RandomValues;

@ExtendWith(value={RandomExtension.class})
@TestDirectoryExtension
class MultipleIndexPopulationStressIT {
    private static final String[] TOKENS = new String[]{"One", "Two", "Three", "Four"};
    private ExecutorService executor;
    @Inject
    private RandomSupport random;
    @Inject
    private TestDirectory directory;
    @Inject
    private DefaultFileSystemAbstraction fileSystemAbstraction;
    private boolean expectingNLI = true;
    private boolean expectingRTI = true;

    MultipleIndexPopulationStressIT() {
    }

    @AfterEach
    public void tearDown() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    @Test
    public void populateMultipleIndexWithSeveralNodesMultiThreaded() throws Exception {
        this.prepareAndRunTest(10L, 0L, TimeUnit.SECONDS.toMillis(5L), (Integer)GraphDatabaseInternalSettings.index_population_queue_threshold.defaultValue());
    }

    @Test
    public void populateMultipleIndexWithSeveralRelationshipsMultiThreaded() throws Exception {
        this.prepareAndRunTest(10L, 10L, TimeUnit.SECONDS.toMillis(5L), (Integer)GraphDatabaseInternalSettings.index_population_queue_threshold.defaultValue());
    }

    @Test
    public void populateMultipleIndexWithSeveralDenseNodesMultiThreaded() throws Exception {
        this.prepareAndRunTest(10L, 1000L, TimeUnit.SECONDS.toMillis(5L), (Integer)GraphDatabaseInternalSettings.index_population_queue_threshold.defaultValue());
    }

    @Test
    public void shouldPopulateMultipleIndexPopulatorsUnderStressMultiThreaded() throws Exception {
        int concurrentUpdatesQueueFlushThreshold = this.random.nextInt(100, 5000);
        this.readConfigAndRunTest(concurrentUpdatesQueueFlushThreshold);
    }

    private void readConfigAndRunTest(int concurrentUpdatesQueueFlushThreshold) throws Exception {
        long nodeCount = SettingValueParsers.parseLongWithUnit((String)System.getProperty(this.getClass().getName() + ".nodes", "200k"));
        long relCount = SettingValueParsers.parseLongWithUnit((String)System.getProperty(this.getClass().getName() + ".relationships", "200k"));
        long duration = (Long)TimeUtil.parseTimeMillis.apply(System.getProperty(this.getClass().getName() + ".duration", "5s"));
        this.prepareAndRunTest(nodeCount, relCount, duration, concurrentUpdatesQueueFlushThreshold);
    }

    private void prepareAndRunTest(long nodeCount, long relCount, long durationMillis, int concurrentUpdatesQueueFlushThreshold) throws Exception {
        this.createRandomData(nodeCount, relCount);
        if (this.random.nextBoolean()) {
            this.dropIndexes();
        }
        long endTime = System.currentTimeMillis() + durationMillis;
        while (System.currentTimeMillis() < endTime) {
            this.runTest(nodeCount, relCount, concurrentUpdatesQueueFlushThreshold);
        }
    }

    private void runTest(long nodeCount, long relCount, int concurrentUpdatesQueueFlushThreshold) throws Exception {
        this.populateDbAndIndexes(nodeCount, relCount);
        Config config = Config.newBuilder().set(GraphDatabaseSettings.neo4j_home, (Object)this.directory.homePath()).set(GraphDatabaseSettings.pagecache_memory, (Object)ByteUnit.mebiBytes((long)8L)).set(GraphDatabaseInternalSettings.index_population_queue_threshold, (Object)concurrentUpdatesQueueFlushThreshold).build();
        ConsistencyCheckService.Result result = new ConsistencyCheckService((DatabaseLayout)RecordDatabaseLayout.of((Config)config)).with(config).runFullConsistencyCheck();
        ((AbstractBooleanAssert)((AbstractBooleanAssert)Assertions.assertThat((boolean)result.isSuccessful()).as("Database consistency", new Object[0])).withFailMessage("%nExpecting database to be consistent, but it was not.%n%s%nDetailed report: '%s'%n", new Object[]{result.summary(), result.reportFile()})).isTrue();
        this.dropIndexes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateDbAndIndexes(long nodeCount, long relCount) throws InterruptedException {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.directory.homePath()).build();
        GraphDatabaseService db = managementService.database("neo4j");
        try {
            try (Transaction tx = db.beginTx();
                 AutoCloseableSoftAssertions softly = new AutoCloseableSoftAssertions();){
                ((LongAssert)softly.assertThat(Iterables.count((Iterable)tx.getAllNodes())).as("Number of nodes", new Object[0])).isEqualTo(nodeCount);
                ((LongAssert)softly.assertThat(Iterables.count((Iterable)tx.getAllRelationships())).as("Number of relationships", new Object[0])).isEqualTo(relCount);
            }
            this.createIndexes(db);
            AtomicBoolean end = new AtomicBoolean();
            this.executor = Executors.newCachedThreadPool();
            for (int i = 0; i < 10; ++i) {
                this.executor.submit(() -> {
                    ChangeRandomEntities changeRandomEntities = new ChangeRandomEntities(db, RandomValues.create(), nodeCount, relCount);
                    while (!end.get()) {
                        changeRandomEntities.node();
                        changeRandomEntities.relationship();
                    }
                });
            }
            while (!MultipleIndexPopulationStressIT.indexesAreOnline(db)) {
                Thread.sleep(100L);
            }
            end.set(true);
            this.executor.shutdown();
            this.executor.awaitTermination(10L, TimeUnit.SECONDS);
            this.executor = null;
        }
        finally {
            managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropIndexes() {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.directory.homePath()).setConfig(GraphDatabaseSettings.pagecache_memory, (Object)ByteUnit.mebiBytes((long)8L)).build();
        GraphDatabaseService db = managementService.database("neo4j");
        try (Transaction tx = db.beginTx();){
            tx.schema().getIndexes().forEach(IndexDefinition::drop);
            tx.commit();
        }
        finally {
            managementService.shutdown();
        }
        this.expectingNLI = false;
        this.expectingRTI = false;
    }

    private static boolean indexesAreOnline(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            block11: for (IndexDefinition index : tx.schema().getIndexes()) {
                switch (tx.schema().getIndexState(index)) {
                    case ONLINE: {
                        continue block11;
                    }
                    case POPULATING: {
                        boolean bl = false;
                        return bl;
                    }
                    case FAILED: {
                        org.junit.jupiter.api.Assertions.fail((String)(String.valueOf(index) + " entered failed state: " + tx.schema().getIndexFailure(index)));
                    }
                }
                throw new UnsupportedOperationException();
            }
            tx.commit();
        }
        return true;
    }

    private void createIndexes(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            this.createTokenIndexes(tx);
            this.createNodePropertyIndexes(tx);
            this.createRelationshipPropertyIndexes(tx);
            tx.commit();
        }
    }

    private void createTokenIndexes(Transaction tx) {
        if (!this.expectingNLI && this.random.nextBoolean()) {
            tx.schema().indexFor(AnyTokens.ANY_LABELS).create();
            this.expectingNLI = true;
        }
        if (!this.expectingRTI && this.random.nextBoolean()) {
            tx.schema().indexFor(AnyTokens.ANY_RELATIONSHIP_TYPES).create();
            this.expectingRTI = true;
        }
    }

    private void createNodePropertyIndexes(Transaction tx) {
        for (String label : (String[])this.random.selection((Object[])TOKENS, 3, 3, false)) {
            for (String propertyKey : (String[])this.random.selection((Object[])TOKENS, 3, 3, false)) {
                tx.schema().indexFor(Label.label((String)label)).on(propertyKey).create();
            }
        }
    }

    private void createRelationshipPropertyIndexes(Transaction tx) {
        for (String type : (String[])this.random.selection((Object[])TOKENS, 3, 3, false)) {
            for (String propertyKey : (String[])this.random.selection((Object[])TOKENS, 3, 3, false)) {
                tx.schema().indexFor(RelationshipType.withName((String)type)).on(propertyKey).create();
            }
        }
    }

    private void createRandomData(long nodeCount, long relCount) throws Exception {
        Config config = Config.defaults((Setting)GraphDatabaseSettings.neo4j_home, (Object)this.directory.homePath());
        try (RandomDataInput input = new RandomDataInput(nodeCount, relCount);
             ThreadPoolJobScheduler jobScheduler = new ThreadPoolJobScheduler();){
            RecordDatabaseLayout layout = RecordDatabaseLayout.of((Config)config);
            IndexImporterFactoryImpl indexImporterFactory = new IndexImporterFactoryImpl();
            ParallelBatchImporter importer = new ParallelBatchImporter((DatabaseLayout)layout, (FileSystemAbstraction)this.fileSystemAbstraction, PageCacheTracer.NULL, Configuration.DEFAULT, (LogService)NullLogService.getInstance(), ExecutionMonitor.INVISIBLE, DefaultAdditionalIds.EMPTY, (LogTailMetadata)new EmptyLogTailMetadata(config), config, Monitor.NO_MONITOR, (JobScheduler)jobScheduler, Collector.EMPTY, TransactionLogInitializer.getLogFilesInitializer(), (IndexImporterFactory)indexImporterFactory, (MemoryTracker)EmptyMemoryTracker.INSTANCE, CursorContextFactory.NULL_CONTEXT_FACTORY);
            importer.doImport((Input)input);
        }
    }

    private class RandomDataInput
    implements Input,
    AutoCloseable {
        private final long nodeCount;
        private final long relCount;
        private final BadCollector badCollector;

        RandomDataInput(long nodeCount, long relCount) {
            this.nodeCount = nodeCount > 0L ? nodeCount : 0L;
            this.relCount = nodeCount > 0L && relCount > 0L ? relCount : 0L;
            this.badCollector = this.createBadCollector();
        }

        public InputIterable nodes(Collector badCollector) {
            return () -> new RandomEntityGenerator(MultipleIndexPopulationStressIT.this, this.nodeCount, (GeneratingInputIterator.Generator<RandomValues>)((GeneratingInputIterator.Generator)(state, visitor, id) -> {
                visitor.id(id);
                visitor.labels((String[])MultipleIndexPopulationStressIT.this.random.selection((Object[])TOKENS, 1, TOKENS.length, false));
                this.properties(visitor);
            }));
        }

        public InputIterable relationships(Collector badCollector) {
            return () -> new RandomEntityGenerator(MultipleIndexPopulationStressIT.this, this.relCount, (GeneratingInputIterator.Generator<RandomValues>)((GeneratingInputIterator.Generator)(state, visitor, id) -> {
                visitor.startId(MultipleIndexPopulationStressIT.this.random.nextLong(this.nodeCount));
                visitor.type((String)MultipleIndexPopulationStressIT.this.random.among((Object[])TOKENS));
                visitor.endId(MultipleIndexPopulationStressIT.this.random.nextLong(this.nodeCount));
                this.properties(visitor);
            }));
        }

        public IdType idType() {
            return IdType.ACTUAL;
        }

        public ReadableGroups groups() {
            return ReadableGroups.EMPTY;
        }

        private void properties(InputEntityVisitor visitor) {
            String[] keys;
            for (String key : keys = (String[])MultipleIndexPopulationStressIT.this.random.randomValues().selection((Object[])TOKENS, 1, TOKENS.length, false)) {
                visitor.property(key, MultipleIndexPopulationStressIT.this.random.nextValueAsObject(), false);
            }
        }

        private BadCollector createBadCollector() {
            try {
                return new BadCollector(MultipleIndexPopulationStressIT.this.fileSystemAbstraction.openAsOutputStream(MultipleIndexPopulationStressIT.this.directory.homePath().resolve("bad"), false), 0L, 0);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public Input.Estimates validateAndEstimate(PropertySizeCalculator valueSizeCalculator) {
            long labelCount = this.nodeCount * (long)TOKENS.length / 2L;
            long nodePropCount = this.nodeCount * (long)TOKENS.length / 2L;
            long nodePropSize = nodePropCount * 8L;
            long relPropCount = this.relCount * (long)TOKENS.length / 2L;
            long relPropSize = relPropCount * 8L;
            return Input.knownEstimates((long)this.nodeCount, (long)this.relCount, (long)nodePropCount, (long)relPropCount, (long)nodePropSize, (long)relPropSize, (long)labelCount);
        }

        @Override
        public void close() {
            this.badCollector.close();
        }
    }

    private static class ChangeRandomEntities {
        private final GraphDatabaseService db;
        private final RandomValues random;
        private final long nodeCount;
        private final long relCount;

        ChangeRandomEntities(GraphDatabaseService db, RandomValues random, long nodeCount, long relCount) {
            this.db = db;
            this.random = random;
            this.nodeCount = nodeCount;
            this.relCount = relCount;
        }

        void node() {
            this.changeRandomEntity(Transaction::getNodeById, this.nodeCount);
        }

        void relationship() {
            this.changeRandomEntity(Transaction::getRelationshipById, this.relCount);
        }

        private void changeRandomEntity(BiFunction<Transaction, Long, Entity> getEntityById, long count) {
            if (count < 1L) {
                return;
            }
            try (Transaction tx = this.db.beginTx();){
                long id = this.random.nextLong(count);
                Entity entity = getEntityById.apply(tx, id);
                Object[] keys = Iterables.asCollection((Iterable)entity.getPropertyKeys()).toArray();
                String key = (String)this.random.among(keys);
                if ((double)this.random.nextFloat() < 0.1) {
                    entity.removeProperty(key);
                } else {
                    entity.setProperty(key, this.random.nextValue().asObject());
                }
                tx.commit();
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
    }

    private class RandomEntityGenerator
    extends GeneratingInputIterator<RandomValues> {
        RandomEntityGenerator(MultipleIndexPopulationStressIT multipleIndexPopulationStressIT, long count, GeneratingInputIterator.Generator<RandomValues> randomsGenerator) {
            super(count, 1000, (LongFunction)new RandomsStates(multipleIndexPopulationStressIT.random.seed()), randomsGenerator, 0L);
        }
    }
}

