/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.RelationshipTypeIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.kernel.api.TokenReadSession;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestBase;
import org.neo4j.kernel.impl.newapi.ReadTestSupport;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;

public class IndexQueryingTest
extends KernelAPIReadTestBase<ReadTestSupport> {
    private static final String NODE_INDEX_NAME = "ftsNodes";
    private static final String REL_INDEX_NAME = "ftsRels";
    protected AssertableLogProvider logProvider = new AssertableLogProvider();

    public ReadTestSupport newTestSupport() {
        return new ReadTestSupport(){

            protected TestDatabaseManagementServiceBuilder newManagementServiceBuilder(Path storeDir) {
                return super.newManagementServiceBuilder(storeDir).setInternalLogProvider((InternalLogProvider)IndexQueryingTest.this.logProvider).useLazyProcedures(false);
            }
        };
    }

    public void createTestGraph(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            tx.execute("CREATE FULLTEXT INDEX %s FOR (n:Label) ON EACH [n.prop]".formatted(NODE_INDEX_NAME)).close();
            tx.execute("CREATE FULLTEXT INDEX %s FOR ()-[r:Type]-() ON EACH [r.prop]".formatted(REL_INDEX_NAME)).close();
            tx.commit();
        }
        tx = db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void nodeIndexSeekMustThrowOnWrongIndexEntityType() throws Exception {
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(REL_INDEX_NAME));
        try (NodeValueIndexCursor cursor = this.cursors.allocateNodeValueIndexCursor(CursorContext.NULL_CONTEXT, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            IndexNotApplicableKernelException e = (IndexNotApplicableKernelException)org.junit.jupiter.api.Assertions.assertThrows(IndexNotApplicableKernelException.class, () -> this.read.nodeIndexSeek(this.tx.queryContext(), index, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.fulltextSearch((String)"search")}));
            Assertions.assertThat((Throwable)e).hasMessageContaining("Node index seek can not be performed on index");
            Assertions.assertThat((String)e.gqlStatus()).isEqualTo("50N15");
            Assertions.assertThat((String)e.statusDescription()).isEqualTo("error: general processing exception - unsupported index operation. The system attempted to execute an unsupported operation on index `%s`. See debug.log for more information.".formatted(REL_INDEX_NAME));
            LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessageWithAll(new String[]{"Node index seek can not be performed on index"}).containsException((Throwable)e);
        }
    }

    @Test
    void partitionedNodeIndexSeekMustThrowOnWrongIndexEntityType() throws Exception {
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(REL_INDEX_NAME));
        IndexNotApplicableKernelException e = (IndexNotApplicableKernelException)org.junit.jupiter.api.Assertions.assertThrows(IndexNotApplicableKernelException.class, () -> this.read.nodeIndexSeek(index, 10, this.tx.queryContext(), new PropertyIndexQuery[]{PropertyIndexQuery.fulltextSearch((String)"search")}));
        Assertions.assertThat((Throwable)e).hasMessageContaining("Node index seek can not be performed on index");
        Assertions.assertThat((String)e.gqlStatus()).isEqualTo("50N15");
        Assertions.assertThat((String)e.statusDescription()).isEqualTo("error: general processing exception - unsupported index operation. The system attempted to execute an unsupported operation on index `%s`. See debug.log for more information.".formatted(REL_INDEX_NAME));
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessageWithAll(new String[]{"Node index seek can not be performed on index"}).containsException((Throwable)e);
    }

    @Test
    void relationshipIndexSeekMustThrowOnWrongIndexEntityType() throws IndexNotFoundKernelException {
        IndexDescriptor index = this.schemaRead.indexGetForName(NODE_INDEX_NAME);
        IndexReadSession indexReadSession = this.read.indexReadSession(index);
        try (RelationshipValueIndexCursor cursor = this.cursors.allocateRelationshipValueIndexCursor(CursorContext.NULL_CONTEXT, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            IndexNotApplicableKernelException e = (IndexNotApplicableKernelException)org.junit.jupiter.api.Assertions.assertThrows(IndexNotApplicableKernelException.class, () -> this.read.relationshipIndexSeek(this.tx.queryContext(), indexReadSession, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.fulltextSearch((String)"search")}));
            Assertions.assertThat((Throwable)e).hasMessageContaining("Relationship index seek can not be performed on index");
            Assertions.assertThat((String)e.gqlStatus()).isEqualTo("50N15");
            Assertions.assertThat((String)e.statusDescription()).isEqualTo("error: general processing exception - unsupported index operation. The system attempted to execute an unsupported operation on index `%s`. See debug.log for more information.".formatted(NODE_INDEX_NAME));
            LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessageWithAll(new String[]{"Relationship index seek can not be performed on index"}).containsException((Throwable)e);
        }
    }

    @Test
    void partitionedRelationshipIndexSeekMustThrowOnWrongIndexEntityType() throws IndexNotFoundKernelException {
        IndexDescriptor index = this.schemaRead.indexGetForName(NODE_INDEX_NAME);
        IndexReadSession indexReadSession = this.read.indexReadSession(index);
        IndexNotApplicableKernelException e = (IndexNotApplicableKernelException)org.junit.jupiter.api.Assertions.assertThrows(IndexNotApplicableKernelException.class, () -> this.read.relationshipIndexSeek(indexReadSession, 10, this.tx.queryContext(), new PropertyIndexQuery[]{PropertyIndexQuery.fulltextSearch((String)"search")}));
        Assertions.assertThat((Throwable)e).hasMessageContaining("Relationship index seek can not be performed on index");
        Assertions.assertThat((String)e.gqlStatus()).isEqualTo("50N15");
        Assertions.assertThat((String)e.statusDescription()).isEqualTo("error: general processing exception - unsupported index operation. The system attempted to execute an unsupported operation on index `%s`. See debug.log for more information.".formatted(NODE_INDEX_NAME));
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessageWithAll(new String[]{"Relationship index seek can not be performed on index"}).containsException((Throwable)e);
    }

    @Test
    void nodeIndexScanMustThrowOnWrongIndexEntityType() throws Exception {
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(REL_INDEX_NAME));
        try (NodeValueIndexCursor cursor = this.cursors.allocateNodeValueIndexCursor(CursorContext.NULL_CONTEXT, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            IndexNotApplicableKernelException e = (IndexNotApplicableKernelException)org.junit.jupiter.api.Assertions.assertThrows(IndexNotApplicableKernelException.class, () -> this.read.nodeIndexScan(index, cursor, IndexQueryConstraints.unconstrained()));
            Assertions.assertThat((Throwable)e).hasMessageContaining("Node index scan can not be performed on index");
            Assertions.assertThat((String)e.gqlStatus()).isEqualTo("50N15");
            Assertions.assertThat((String)e.statusDescription()).isEqualTo("error: general processing exception - unsupported index operation. The system attempted to execute an unsupported operation on index `%s`. See debug.log for more information.".formatted(REL_INDEX_NAME));
            LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessageWithAll(new String[]{"Node index scan can not be performed on index"}).containsException((Throwable)e);
        }
    }

    @Test
    void relationshipIndexScanMustThrowOnWrongIndexEntityType() throws Exception {
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(NODE_INDEX_NAME));
        try (RelationshipValueIndexCursor cursor = this.cursors.allocateRelationshipValueIndexCursor(CursorContext.NULL_CONTEXT, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            IndexNotApplicableKernelException e = (IndexNotApplicableKernelException)org.junit.jupiter.api.Assertions.assertThrows(IndexNotApplicableKernelException.class, () -> this.read.relationshipIndexScan(index, cursor, IndexQueryConstraints.unconstrained()));
            Assertions.assertThat((Throwable)e).hasMessageContaining("Relationship index scan can not be performed on index");
            Assertions.assertThat((String)e.gqlStatus()).isEqualTo("50N15");
            Assertions.assertThat((String)e.statusDescription()).isEqualTo("error: general processing exception - unsupported index operation. The system attempted to execute an unsupported operation on index `%s`. See debug.log for more information.".formatted(NODE_INDEX_NAME));
            LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessageWithAll(new String[]{"Relationship index scan can not be performed on index"}).containsException((Throwable)e);
        }
    }

    @Test
    void nodeLabelIndexScanMustThrowOnWrongIndexEntityType() throws Exception {
        TokenReadSession tokenReadSession = this.read.tokenReadSession((IndexDescriptor)this.schemaRead.index((SchemaDescriptor)SchemaDescriptors.ANY_TOKEN_RELATIONSHIP_SCHEMA_DESCRIPTOR).next());
        try (NodeLabelIndexCursor cursor = this.cursors.allocateNodeLabelIndexCursor(CursorContext.NULL_CONTEXT, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            IndexNotApplicableKernelException e = (IndexNotApplicableKernelException)org.junit.jupiter.api.Assertions.assertThrows(IndexNotApplicableKernelException.class, () -> this.read.nodeLabelScan(tokenReadSession, cursor, IndexQueryConstraints.unconstrained(), new TokenPredicate(1), this.tx.cursorContext()));
            Assertions.assertThat((Throwable)e).hasMessageContaining("Node label index scan can not be performed on index");
            Assertions.assertThat((String)e.gqlStatus()).isEqualTo("50N15");
            Assertions.assertThat((String)e.statusDescription()).contains(new CharSequence[]{"error: general processing exception - unsupported index operation. The system attempted to execute an unsupported operation on index", "See debug.log for more information."});
            LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessageWithAll(new String[]{"Node label index scan can not be performed on index"}).containsException((Throwable)e);
        }
    }

    @Test
    void relationshipTypeIndexScanMustThrowOnWrongIndexEntityType() throws Exception {
        TokenReadSession tokenReadSession = this.read.tokenReadSession((IndexDescriptor)this.schemaRead.index((SchemaDescriptor)SchemaDescriptors.ANY_TOKEN_NODE_SCHEMA_DESCRIPTOR).next());
        try (RelationshipTypeIndexCursor cursor = this.cursors.allocateRelationshipTypeIndexCursor(CursorContext.NULL_CONTEXT, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            IndexNotApplicableKernelException e = (IndexNotApplicableKernelException)org.junit.jupiter.api.Assertions.assertThrows(IndexNotApplicableKernelException.class, () -> this.read.relationshipTypeScan(tokenReadSession, cursor, IndexQueryConstraints.unconstrained(), new TokenPredicate(1), this.tx.cursorContext()));
            Assertions.assertThat((Throwable)e).hasMessageContaining("Relationship type index scan can not be performed on index");
            Assertions.assertThat((String)e.gqlStatus()).isEqualTo("50N15");
            Assertions.assertThat((String)e.statusDescription()).contains(new CharSequence[]{"error: general processing exception - unsupported index operation. The system attempted to execute an unsupported operation on index", "See debug.log for more information."});
            LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessageWithAll(new String[]{"Relationship type index scan can not be performed on index"}).containsException((Throwable)e);
        }
    }
}

