/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import org.neo4j.internal.schema.AllIndexProviderDescriptors;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.kernel.api.impl.schema.StringLengthIndexValidationIT;
import org.neo4j.test.RandomSupport;

public class TextIndexStringLengthIndexValidationIT
extends StringLengthIndexValidationIT {
    @Override
    protected int getSingleKeySizeLimit(int payloadSize) {
        return 32766;
    }

    @Override
    protected String getString(RandomSupport random, int keySize) {
        return random.nextAlphaNumericString(keySize, keySize);
    }

    @Override
    protected IndexType getIndexType() {
        return IndexType.TEXT;
    }

    @Override
    protected IndexProviderDescriptor getIndexProvider() {
        return AllIndexProviderDescriptors.TEXT_V1_DESCRIPTOR;
    }

    @Override
    protected String expectedPopulationFailureCauseMessage(long indexId, String elementId) {
        return "Document contains at least one immense term in field=\"string\" (whose length is longer than the max length 32766), all of which were skipped.";
    }
}

