/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.nio.file.OpenOption;
import java.time.Clock;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.set.ImmutableSet;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.Extensions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.schema.AllIndexProviderDescriptors;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexQuery;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.index.EntityRange;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexUsageStats;
import org.neo4j.kernel.api.index.TokenIndexReader;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.api.schema.SchemaTestUtil;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.DefaultIndexUsageTracking;
import org.neo4j.kernel.impl.index.schema.IndexUsageTracking;
import org.neo4j.kernel.impl.index.schema.PartitionedTokenScan;
import org.neo4j.kernel.impl.transaction.state.StaticIndexProviderMap;
import org.neo4j.kernel.impl.transaction.state.StaticIndexProviderMapFactory;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.NullLogService;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.scheduler.JobSchedulerExtension;
import org.neo4j.storageengine.api.schema.SimpleEntityTokenClient;
import org.neo4j.storageengine.api.schema.SimpleEntityValueClient;
import org.neo4j.test.extension.EphemeralNeo4jLayoutExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.LifeExtension;
import org.neo4j.test.extension.pagecache.EphemeralPageCacheExtension;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;
import org.neo4j.token.CreatingTokenHolder;
import org.neo4j.token.ReadOnlyTokenCreator;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.TokenHolder;
import org.neo4j.values.ElementIdMapper;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Values;

@EphemeralPageCacheExtension
@EphemeralNeo4jLayoutExtension
@Extensions(value={@ExtendWith(value={JobSchedulerExtension.class}), @ExtendWith(value={LifeExtension.class})})
public class IndexAccessorUsageStatsTest {
    private static final long trackedSinceMillis = 10000L;
    private static final long deltaMillis = 5000L;
    private static final long queryCount = 10L;
    @Inject
    PageCache pageCache;
    @Inject
    FileSystemAbstraction fs;
    @Inject
    LifeSupport lifeSupport;
    @Inject
    DatabaseLayout databaseLayout;
    @Inject
    JobScheduler jobScheduler;
    private final FakeClock clock = Clocks.fakeClock((long)10000L, (TimeUnit)TimeUnit.MILLISECONDS);
    private final DefaultIndexUsageTracking usageTracking = new DefaultIndexUsageTracking((Clock)this.clock);
    private final Config config = Config.defaults();
    private final IndexDescriptor descriptor = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)1, (int[])new int[]{1})).withName("testIndex").materialise(1L);
    private final IndexSamplingConfig samplingConfig = new IndexSamplingConfig(this.config);
    private final TokenNameLookup nameLookup = SchemaTestUtil.SIMPLE_NAME_LOOKUP;
    private final ImmutableSet<OpenOption> openOptions = Sets.immutable.empty();
    private final StorageEngineIndexingBehaviour indexingBehaviour = StorageEngineIndexingBehaviour.EMPTY;
    private StaticIndexProviderMap providerMap;

    @BeforeEach
    void instantiateIndexProviderMap() {
        this.providerMap = (StaticIndexProviderMap)this.lifeSupport.add((Lifecycle)this.createIndexProviderMap());
    }

    @ParameterizedTest
    @MethodSource(value={"propertyIndexAccessors"})
    void propertyIndexShouldIncrementUsageCountOnQuery(IndexProviderDescriptor descriptor, PropertyIndexQuery query) throws IndexNotApplicableKernelException, IOException {
        try (IndexAccessor accessor = this.createIndexAccessor(descriptor);
             ValueIndexReader reader = accessor.newValueReader((IndexUsageTracking)this.usageTracking);){
            int i = 0;
            while ((long)i < 10L) {
                this.propertyQuery(reader, this.clock, query);
                ++i;
            }
        }
        IndexUsageStats usageStats = this.usageTracking.getAndReset();
        long expectedLastUsedTime = this.clock.millis();
        this.clock.forward(5000L, TimeUnit.MILLISECONDS);
        IndexAccessorUsageStatsTest.assertUsage(usageStats, expectedLastUsedTime, 10L);
    }

    @ParameterizedTest
    @MethodSource(value={"propertyIndexAccessors"})
    void propertyIndexShouldIncrementUsageCountOnIndexSeek(IndexProviderDescriptor providerDescriptor, PropertyIndexQuery query) throws IOException, IndexNotApplicableKernelException {
        IndexProvider provider = this.providerMap.lookup(providerDescriptor);
        IndexDescriptor completeDescriptor = provider.completeConfiguration(this.descriptor, this.indexingBehaviour);
        org.assertj.core.api.Assumptions.assumeThat((boolean)completeDescriptor.getCapability().supportPartitionedScan(new IndexQuery[]{query})).isTrue();
        try (IndexAccessor indexAccessor = this.createIndexAccessor(providerDescriptor);
             ValueIndexReader reader = indexAccessor.newValueReader((IndexUsageTracking)this.usageTracking);){
            int i = 0;
            while ((long)i < 10L) {
                this.partitionedPropertyQuery(reader, query);
                ++i;
            }
        }
        catch (UnsupportedOperationException e) {
            Assumptions.assumeTrue((boolean)false, (String)"Partitioned index seek is not supported by this reader");
        }
        IndexUsageStats usageStats = this.usageTracking.getAndReset();
        long expectedLastUsedTime = this.clock.millis();
        this.clock.forward(5000L, TimeUnit.MILLISECONDS);
        IndexAccessorUsageStatsTest.assertUsage(usageStats, expectedLastUsedTime, 10L);
    }

    @ParameterizedTest
    @MethodSource(value={"tokenIndexAccessors"})
    void tokenIndexShouldIncrementUsageCountOnQuery(IndexProviderDescriptor providerDescriptor) throws IOException {
        try (IndexAccessor indexAccessor = this.createIndexAccessor(providerDescriptor);
             TokenIndexReader reader = indexAccessor.newTokenReader((IndexUsageTracking)this.usageTracking);){
            int i = 0;
            while ((long)i < 10L) {
                this.tokenQuery(reader, this.clock);
                ++i;
            }
        }
        IndexUsageStats usageStats = this.usageTracking.getAndReset();
        long expectedLastUsedTime = this.clock.millis();
        this.clock.forward(5000L, TimeUnit.MILLISECONDS);
        IndexAccessorUsageStatsTest.assertUsage(usageStats, expectedLastUsedTime, 10L);
    }

    @ParameterizedTest
    @MethodSource(value={"tokenIndexAccessors"})
    void tokenIndexShouldNotIncrementUsageCountOnQueryWithRange(IndexProviderDescriptor providerDescriptor) throws IOException {
        try (IndexAccessor indexAccessor = this.createIndexAccessor(providerDescriptor);
             TokenIndexReader reader = indexAccessor.newTokenReader((IndexUsageTracking)this.usageTracking);){
            int i = 0;
            while ((long)i < 10L) {
                this.tokenQueryWithRange(reader, this.clock);
                ++i;
            }
        }
        IndexUsageStats usageStats = this.usageTracking.getAndReset();
        this.clock.forward(5000L, TimeUnit.MILLISECONDS);
        IndexAccessorUsageStatsTest.assertNoUsage(usageStats);
    }

    @ParameterizedTest
    @MethodSource(value={"tokenIndexAccessors"})
    void tokenIndexShouldIncrementUsageCountOnPartitionedEntityTokenScan(IndexProviderDescriptor providerDescriptor) throws IOException {
        try (IndexAccessor indexAccessor = this.createIndexAccessor(providerDescriptor);
             TokenIndexReader reader = indexAccessor.newTokenReader((IndexUsageTracking)this.usageTracking);){
            int i = 0;
            while ((long)i < 10L) {
                this.partitionedEntityTokenScan(reader, this.clock);
                ++i;
            }
        }
        IndexUsageStats usageStats = this.usageTracking.getAndReset();
        long expectedLastUsedTime = this.clock.millis();
        this.clock.forward(5000L, TimeUnit.MILLISECONDS);
        IndexAccessorUsageStatsTest.assertUsage(usageStats, expectedLastUsedTime, 10L);
    }

    @ParameterizedTest
    @MethodSource(value={"tokenIndexAccessors"})
    void tokenIndexShouldIncrementUsageCountOnPartitionedEntityTokenScanWithLeadingPartition(IndexProviderDescriptor providerDescriptor) throws IOException {
        try (IndexAccessor indexAccessor = this.createIndexAccessor(providerDescriptor);
             TokenIndexReader reader = indexAccessor.newTokenReader((IndexUsageTracking)this.usageTracking);){
            PartitionedTokenScan leadingPartition = reader.entityTokenScan(1, CursorContext.NULL_CONTEXT, new TokenPredicate(1));
            int i = 0;
            while ((long)i < 10L) {
                this.partitionedEntityTokenScanWithLeadingPartition(reader, this.clock, leadingPartition);
                ++i;
            }
        }
        IndexUsageStats usageStats = this.usageTracking.getAndReset();
        long expectedLastUsedTime = this.clock.millis();
        this.clock.forward(5000L, TimeUnit.MILLISECONDS);
        IndexAccessorUsageStatsTest.assertUsage(usageStats, expectedLastUsedTime, 11L);
    }

    private static Stream<Arguments> propertyIndexAccessors() {
        return Stream.of(Arguments.of((Object[])new Object[]{AllIndexProviderDescriptors.RANGE_DESCRIPTOR, PropertyIndexQuery.allEntries()}), Arguments.of((Object[])new Object[]{AllIndexProviderDescriptors.POINT_DESCRIPTOR, PropertyIndexQuery.allEntries()}), Arguments.of((Object[])new Object[]{AllIndexProviderDescriptors.POINT_DESCRIPTOR, PropertyIndexQuery.boundingBox((int)0, (PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.CARTESIAN, (double[])new double[]{1.0, 2.0}), (PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.CARTESIAN, (double[])new double[]{4.0, 5.0}))}), Arguments.of((Object[])new Object[]{AllIndexProviderDescriptors.TEXT_V1_DESCRIPTOR, PropertyIndexQuery.allEntries()}), Arguments.of((Object[])new Object[]{AllIndexProviderDescriptors.TEXT_V2_DESCRIPTOR, PropertyIndexQuery.allEntries()}), Arguments.of((Object[])new Object[]{AllIndexProviderDescriptors.FULLTEXT_DESCRIPTOR, PropertyIndexQuery.fulltextSearch((String)"*")}));
    }

    private static Stream<IndexProviderDescriptor> tokenIndexAccessors() {
        return Stream.of(AllIndexProviderDescriptors.TOKEN_DESCRIPTOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexAccessor createIndexAccessor(IndexProviderDescriptor providerDescriptor) throws IOException {
        IndexProvider provider = this.providerMap.lookup(providerDescriptor);
        IndexDescriptor completeDescriptor = provider.completeConfiguration(this.descriptor, this.indexingBehaviour);
        IndexPopulator populator = provider.getPopulator(completeDescriptor, this.samplingConfig, SchemaTestUtil.defaultHeapBufferFactory(), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.nameLookup, ElementIdMapper.PLACEHOLDER, this.openOptions, this.indexingBehaviour);
        try {
            populator.create();
        }
        finally {
            populator.close(true, CursorContext.NULL_CONTEXT);
        }
        return provider.getOnlineAccessor(completeDescriptor, this.samplingConfig, this.nameLookup, ElementIdMapper.PLACEHOLDER, this.openOptions, this.indexingBehaviour);
    }

    private void tokenQuery(TokenIndexReader reader, FakeClock clock) {
        clock.forward(5000L, TimeUnit.MILLISECONDS);
        try (SimpleEntityTokenClient client = new SimpleEntityTokenClient();){
            reader.query((IndexProgressor.EntityTokenClient)client, IndexQueryConstraints.unconstrained(), new TokenPredicate(1), CursorContext.NULL_CONTEXT);
        }
    }

    private void tokenQueryWithRange(TokenIndexReader reader, FakeClock clock) {
        clock.forward(5000L, TimeUnit.MILLISECONDS);
        try (SimpleEntityTokenClient client = new SimpleEntityTokenClient();){
            reader.query((IndexProgressor.EntityTokenClient)client, IndexQueryConstraints.unconstrained(), new TokenPredicate(1), EntityRange.from((long)5L), CursorContext.NULL_CONTEXT);
        }
    }

    private void partitionedEntityTokenScan(TokenIndexReader reader, FakeClock clock) {
        clock.forward(5000L, TimeUnit.MILLISECONDS);
        reader.entityTokenScan(1, CursorContext.NULL_CONTEXT, new TokenPredicate(1));
    }

    private void partitionedEntityTokenScanWithLeadingPartition(TokenIndexReader reader, FakeClock clock, PartitionedTokenScan leadingPartition) {
        clock.forward(5000L, TimeUnit.MILLISECONDS);
        reader.entityTokenScan(leadingPartition, new TokenPredicate(2));
    }

    private void partitionedPropertyQuery(ValueIndexReader reader, PropertyIndexQuery indexQuery) throws IndexNotApplicableKernelException {
        this.clock.forward(5000L, TimeUnit.MILLISECONDS);
        reader.valueSeek(1, QueryContext.NULL_CONTEXT, new PropertyIndexQuery[]{indexQuery});
    }

    private void propertyQuery(ValueIndexReader reader, FakeClock clock, PropertyIndexQuery query) throws IndexNotApplicableKernelException {
        clock.forward(5000L, TimeUnit.MILLISECONDS);
        try (SimpleEntityValueClient client = new SimpleEntityValueClient();){
            reader.query((IndexProgressor.EntityValueClient)client, QueryContext.NULL_CONTEXT, CursorContext.NULL_CONTEXT, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{query});
        }
    }

    private static void assertUsage(IndexUsageStats usageStats, long expectedLastUsedTime, long expectedQueryCount) {
        Assertions.assertThat((long)usageStats.readCount()).isEqualTo(expectedQueryCount);
        Assertions.assertThat((long)usageStats.lastRead()).isEqualTo(expectedLastUsedTime);
        Assertions.assertThat((long)usageStats.trackedSince()).isEqualTo(10000L);
    }

    private static void assertNoUsage(IndexUsageStats usageStats) {
        Assertions.assertThat((long)usageStats.readCount()).isEqualTo(0L);
        Assertions.assertThat((long)usageStats.lastRead()).isEqualTo(0L);
        Assertions.assertThat((long)usageStats.trackedSince()).isEqualTo(10000L);
    }

    private StaticIndexProviderMap createIndexProviderMap() {
        return StaticIndexProviderMapFactory.create((LifeSupport)this.lifeSupport, (Config)this.config, (PageCache)this.pageCache, (FileSystemAbstraction)this.fs, (LogService)NullLogService.getInstance(), (Monitors)new Monitors(), (DatabaseReadOnlyChecker)DatabaseReadOnlyChecker.writable(), (TopologyGraphDbmsModel.HostedOnMode)TopologyGraphDbmsModel.HostedOnMode.SINGLE, (RecoveryCleanupWorkCollector)RecoveryCleanupWorkCollector.ignore(), (DatabaseLayout)this.databaseLayout, (TokenHolders)IndexAccessorUsageStatsTest.getTokenHolders(), (JobScheduler)this.jobScheduler, (CursorContextFactory)CursorContextFactory.NULL_CONTEXT_FACTORY, (PageCacheTracer)PageCacheTracer.NULL);
    }

    private static TokenHolders getTokenHolders() {
        CreatingTokenHolder propTokenHolder = new CreatingTokenHolder(ReadOnlyTokenCreator.READ_ONLY, "PropertyKey");
        CreatingTokenHolder labelTokenHolder = new CreatingTokenHolder(ReadOnlyTokenCreator.READ_ONLY, "Label");
        CreatingTokenHolder relTypetokenHolder = new CreatingTokenHolder(ReadOnlyTokenCreator.READ_ONLY, "RelationshipType");
        return new TokenHolders((TokenHolder)propTokenHolder, (TokenHolder)labelTokenHolder, (TokenHolder)relTypetokenHolder);
    }
}

