/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.fulltext;

import java.util.Set;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.set.MutableSet;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.FulltextSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexProceduresUtil;
import org.neo4j.kernel.api.impl.schema.fulltext.FulltextProceduresTestSupport;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.util.concurrent.BinaryLatch;

class EventuallyConsistentFulltextProceduresTest
extends FulltextProceduresTestSupport {
    EventuallyConsistentFulltextProceduresTest() {
    }

    @Override
    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        super.configure(builder);
        builder.setConfig(FulltextSettings.eventually_consistent, (Object)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void fulltextIndexesMustBeEventuallyConsistentByDefaultWhenThisIsConfigured() throws InterruptedException {
        String relId;
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s", "nodes", FulltextIndexProceduresUtil.asNodeLabelStr((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{"prop", "otherprop"})));
            tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s", "rels", FulltextIndexProceduresUtil.asRelationshipTypeStr((String[])new String[]{REL.name()}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{"prop"})));
            tx.commit();
        }
        this.awaitIndexesOnline();
        BinaryLatch indexUpdateBlocker = new BinaryLatch();
        ((JobScheduler)this.db.getDependencyResolver().resolveDependency(JobScheduler.class)).schedule(Group.INDEX_UPDATING, JobMonitoringParams.NOT_MONITORED, () -> ((BinaryLatch)indexUpdateBlocker).await());
        MutableSet nodeIds = Sets.mutable.empty();
        try {
            try (Transaction tx = this.db.beginTx();){
                Node node1 = tx.createNode(new Label[]{LABEL});
                node1.setProperty("prop", (Object)"bla bla");
                Node node2 = tx.createNode(new Label[]{LABEL});
                node2.setProperty("otherprop", (Object)"bla bla");
                Relationship relationship = node1.createRelationshipTo(node2, REL);
                relationship.setProperty("prop", (Object)"bla bla");
                nodeIds.add(node1.getElementId());
                nodeIds.add(node2.getElementId());
                relId = relationship.getElementId();
                tx.commit();
            }
            EventuallyConsistentFulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, true, "nodes", "bla", new String[0]);
            EventuallyConsistentFulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, false, "rels", "bla", new String[0]);
        }
        finally {
            Thread.sleep(10L);
            indexUpdateBlocker.release();
        }
        try (Transaction transaction = this.db.beginTx();){
            transaction.execute("CALL db.index.fulltext.awaitEventuallyConsistentIndexRefresh()").close();
            transaction.commit();
        }
        EventuallyConsistentFulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "bla", (Set<String>)nodeIds);
        EventuallyConsistentFulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "bla", (Set<String>)Sets.mutable.of((Object[])new String[]{relId}));
    }
}

