/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.fulltext;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class PartialNodeIndexUpdateIT {
    @Inject
    private GraphDatabaseService database;

    PartialNodeIndexUpdateIT() {
    }

    @Test
    void partialIndexedNodePropertiesUpdate() {
        Label userLabel = Label.label((String)"User");
        try (Transaction transaction = this.database.beginTx();){
            transaction.execute("CREATE FULLTEXT INDEX test FOR (n: Card | " + userLabel.name() + ") ON EACH [n.title, n.plainText, n.username, n.screenName]");
            transaction.commit();
        }
        String value = "asdf";
        try (Transaction transaction = this.database.beginTx();){
            transaction.execute("UNWIND [{_id:48, properties:{screenName:\"asdf\"}}] as row CREATE (n:L1{_id: row._id}) SET n += row.properties SET n:" + userLabel.name());
            transaction.commit();
        }
        transaction = this.database.beginTx();
        try {
            Assertions.assertNotNull((Object)transaction.findNode(userLabel, "screenName", (Object)"asdf"));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }
}

