/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.constraints;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.Future;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintCreator;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.IndexMonitor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.database.DatabaseMonitors;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.locking.forseti.ForsetiClient;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.Barrier;
import org.neo4j.test.LatestVersions;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.token.TokenHolders;

@DbmsExtension
class ConstraintCreationIT {
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private IndexProviderMap indexProviderMap;
    @Inject
    private TokenHolders tokenHolders;
    @Inject
    private IndexingService indexingService;
    @Inject
    private DatabaseMonitors databaseMonitors;
    private static final Label LABEL = Label.label((String)"label1");
    private long indexId;
    private long nbrIndexesOnStart;

    ConstraintCreationIT() {
    }

    @BeforeEach
    void setUp() {
        try (Transaction tx = this.db.beginTx();){
            this.nbrIndexesOnStart = Iterables.count((Iterable)tx.schema().getIndexes());
            this.indexId = this.nbrIndexesOnStart + 1L;
        }
    }

    @Test
    void shouldNotLeaveNativeIndexFilesHangingAroundIfConstraintCreationFails() {
        this.attemptAndFailConstraintCreation();
        Path indexDir = this.indexProviderMap.getDefaultProvider(LatestVersions.LATEST_KERNEL_VERSION).directoryStructure().directoryForIndex(this.indexId);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)Files.exists(indexDir, new LinkOption[0]));
    }

    @Test
    void conflictInValidationShouldNotCrashShowIndexes() throws Exception {
        try (Transaction tx = this.db.beginTx();){
            tx.createNode(new Label[]{LABEL}).setProperty("prop", (Object)true);
            tx.commit();
        }
        int labelId = this.tokenHolders.labelTokens().getIdByName(LABEL.name());
        final Barrier.Control populationDone = new Barrier.Control();
        this.databaseMonitors.addMonitorListener((Object)new IndexMonitor.MonitorAdapter(this){

            public void populationCompleteOn(IndexDescriptor descriptor) {
                populationDone.reached();
            }
        }, new String[0]);
        try (OtherThreadExecutor executor = new OtherThreadExecutor("CreateConstraint");){
            Future future = executor.executeDontWait(() -> {
                try (Transaction tx = this.db.beginTx();){
                    ConstraintCreator creator = tx.schema().constraintFor(LABEL).assertPropertyIsUnique("prop");
                    Assertions.assertThatThrownBy(() -> ((ConstraintCreator)creator).create()).isInstanceOf(ConstraintViolationException.class);
                }
                return null;
            });
            populationDone.await();
            try (InternalTransaction readTx = (InternalTransaction)this.db.beginTx();){
                readTx.kernelTransaction().locks().acquireSharedLabelLock(new long[]{labelId});
                try (InternalTransaction conflictCreationTx = (InternalTransaction)this.db.beginTx();){
                    conflictCreationTx.kernelTransaction().locks().acquireSharedLabelLock(new long[]{labelId});
                    populationDone.release();
                    executor.waitUntilWaiting(details -> details.isAt(ForsetiClient.class, "acquireExclusive"));
                    conflictCreationTx.createNode(new Label[]{LABEL}).setProperty("prop", (Object)true);
                    conflictCreationTx.commit();
                }
                Assertions.assertThatCode(() -> readTx.execute("SHOW INDEXES YIELD *").resultAsString()).doesNotThrowAnyException();
            }
            future.get();
        }
    }

    private void attemptAndFailConstraintCreation() {
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < 2; ++i) {
                Node node1 = tx.createNode(new Label[]{LABEL});
                node1.setProperty("prop", (Object)true);
            }
            tx.commit();
        }
        org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                tx.schema().constraintFor(LABEL).assertPropertyIsUnique("prop").create();
                tx.commit();
            }
        });
        tx = this.db.beginTx();
        try {
            org.junit.jupiter.api.Assertions.assertEquals((long)this.nbrIndexesOnStart, (long)Iterables.count((Iterable)tx.schema().getIndexes()));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }
}

