/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.index.internal.gbptree.DynamicSizeUtil;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.impl.muninn.StandalonePageCacheFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.index.schema.Types;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.TestLabels;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.tags.MultiVersionedTag;
import org.neo4j.test.utils.TestDirectory;
import org.neo4j.values.storable.RandomValuesUtils;

@Neo4jLayoutExtension
@ExtendWith(value={RandomExtension.class})
public class RangeIndexKeySizeValidationIT {
    private static final String[] PROP_KEYS = new String[]{"prop0", "prop1", "prop2", "prop3", "prop4"};
    private static final int PAGE_SIZE_8K = (int)ByteUnit.kibiBytes((long)8L);
    private static final int PAGE_SIZE_16K = (int)ByteUnit.kibiBytes((long)16L);
    private static final int ESTIMATED_OVERHEAD_PER_SLOT = 2;
    private static final int WIGGLE_ROOM = 50;
    @Inject
    private DefaultFileSystemAbstraction fs;
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private Neo4jLayout neo4jLayout;
    @Inject
    private RandomSupport random;
    private DatabaseManagementService dbms;
    private GraphDatabaseAPI db;
    private JobScheduler scheduler;
    private PageCache pageCache;
    private boolean includeVectorTypes = false;

    @AfterEach
    void cleanup() throws Exception {
        if (this.dbms != null) {
            this.dbms.shutdown();
            this.dbms = null;
            this.db = null;
        }
        if (this.scheduler != null) {
            this.scheduler.shutdown();
            this.scheduler = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @MethodSource(value={"payloadSize"})
    @MultiVersionedTag
    void shouldEnforceSizeCapSingleValueSingleType(int pageSize) {
        void var7_9;
        this.startDb(pageSize);
        ArrayList<Object> failureMessages = new ArrayList<Object>();
        NamedDynamicValueGenerator[] dynamicValueGenerators = NamedDynamicValueGenerator.values();
        StringBuilder sb = new StringBuilder();
        NamedDynamicValueGenerator[] namedDynamicValueGeneratorArray = dynamicValueGenerators;
        int n = namedDynamicValueGeneratorArray.length;
        boolean bl = false;
        while (var7_9 < n) {
            NamedDynamicValueGenerator generator = namedDynamicValueGeneratorArray[var7_9];
            if (this.includeVectorTypes || !generator.isVectorType) {
                int expectedMax = generator.expectedMax;
                String propKey = PROP_KEYS[0] + generator.name();
                this.createIndex(propKey);
                BinarySearch binarySearch = new BinarySearch();
                while (!binarySearch.finished()) {
                    Object propValue = generator.dynamicValue(this.random, binarySearch.arrayLength);
                    sb.append(propKey.getClass().getSimpleName()).append("\n====\n");
                    long expectedNodeId = -1L;
                    boolean wasAbleToWrite = true;
                    try (Transaction tx = this.db.beginTx();){
                        Node node = tx.createNode(new Label[]{TestLabels.LABEL_ONE});
                        node.setProperty(propKey, propValue);
                        expectedNodeId = node.getId();
                        tx.commit();
                        sb.append("Testing: ").append(binarySearch.arrayLength).append(" = true").append('\n');
                    }
                    catch (IllegalArgumentException e) {
                        Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Property value is too large to index"});
                        sb.append("Testing: ").append(binarySearch.arrayLength).append(" = ").append(e.getMessage()).append("\n");
                        wasAbleToWrite = false;
                    }
                    this.verifyReadExpected(propKey, propValue, expectedNodeId, wasAbleToWrite);
                    binarySearch.progress(wasAbleToWrite);
                }
                if (expectedMax != binarySearch.longestSuccessful) {
                    failureMessages.add(sb.toString());
                    failureMessages.add(generator.name() + ": expected=" + expectedMax + ", actual=" + binarySearch.longestSuccessful);
                }
            }
            ++var7_9;
        }
        if (!failureMessages.isEmpty()) {
            StringJoiner joiner = new StringJoiner(System.lineSeparator(), "Some value types did not have expected longest successful array. This is a strong indicator that documentation of max limit needs to be updated." + System.lineSeparator(), "");
            for (String string : failureMessages) {
                joiner.add(string);
            }
            org.junit.jupiter.api.Assertions.fail((String)joiner.toString());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"payloadSize"})
    void shouldEnforceSizeCapMixedTypes(int pageSize) {
        this.startDb(pageSize);
        for (int numberOfSlots = 1; numberOfSlots < 5; ++numberOfSlots) {
            String[] propKeys = RangeIndexKeySizeValidationIT.generatePropertyKeys(numberOfSlots);
            this.createIndex(propKeys);
            int keySizeLimit = DynamicSizeUtil.keyValueSizeCapFromPageSize((int)(pageSize - this.calculateReservedBytes()));
            int keySizeLimitPerSlot = keySizeLimit / propKeys.length - 2;
            int wiggleRoomPerSlot = 50 / propKeys.length;
            SuccessAndFail successAndFail = new SuccessAndFail();
            for (int i = 0; i < 1000; ++i) {
                Object[] propValues = this.generatePropertyValues(propKeys, keySizeLimitPerSlot, wiggleRoomPerSlot);
                long expectedNodeId = -1L;
                boolean ableToWrite = true;
                try (Transaction tx = this.db.beginTx();){
                    Node node = tx.createNode(new Label[]{TestLabels.LABEL_ONE});
                    RangeIndexKeySizeValidationIT.setProperties(propKeys, propValues, node);
                    expectedNodeId = node.getId();
                    tx.commit();
                }
                catch (Exception e) {
                    ableToWrite = false;
                }
                successAndFail.ableToWrite(ableToWrite);
                this.verifyReadExpected(propKeys, propValues, expectedNodeId, ableToWrite);
            }
            successAndFail.verifyBothSuccessAndFail();
        }
    }

    private int calculateReservedBytes() {
        return this.pageCache.pageReservedBytes(((StorageEngine)this.db.getDependencyResolver().resolveDependency(StorageEngine.class)).getOpenOptions());
    }

    private static Stream<Integer> payloadSize() {
        return Stream.of(PAGE_SIZE_8K, PAGE_SIZE_16K);
    }

    private static void setProperties(String[] propKeys, Object[] propValues, Node node) {
        for (int propKey = 0; propKey < propKeys.length; ++propKey) {
            node.setProperty(propKeys[propKey], propValues[propKey]);
        }
    }

    private static String[] generatePropertyKeys(int numberOfSlots) {
        String[] propKeys = new String[numberOfSlots];
        for (int i = 0; i < numberOfSlots; ++i) {
            propKeys[i] = PROP_KEYS[i] + "numberOfSlots" + numberOfSlots;
        }
        return propKeys;
    }

    private Object[] generatePropertyValues(String[] propKeys, int keySizeLimitPerSlot, int wiggleRoomPerSlot) {
        Object[] propValues = new Object[propKeys.length];
        ArrayList<NamedDynamicValueGenerator> generators = new ArrayList<NamedDynamicValueGenerator>(Arrays.asList(NamedDynamicValueGenerator.values()));
        if (!this.includeVectorTypes) {
            generators.removeIf(NamedDynamicValueGenerator::isVectorType);
        }
        for (int propKey = 0; propKey < propKeys.length; ++propKey) {
            NamedDynamicValueGenerator among = (NamedDynamicValueGenerator)((Object)this.random.among((Object[])((NamedDynamicValueGenerator[])generators.toArray(NamedDynamicValueGenerator[]::new))));
            propValues[propKey] = among.dynamicValue(this.random, keySizeLimitPerSlot, wiggleRoomPerSlot);
        }
        return propValues;
    }

    private void verifyReadExpected(String propKey, Object propValue, long expectedNodeId, boolean ableToWrite) {
        this.verifyReadExpected(new String[]{propKey}, new Object[]{propValue}, expectedNodeId, ableToWrite);
    }

    private void verifyReadExpected(String[] propKeys, Object[] propValues, long expectedNodeId, boolean ableToWrite) {
        try (Transaction tx = this.db.beginTx();){
            HashMap<String, Object> values = new HashMap<String, Object>();
            for (int propKey = 0; propKey < propKeys.length; ++propKey) {
                values.put(propKeys[propKey], propValues[propKey]);
            }
            try (ResourceIterator nodes = tx.findNodes(TestLabels.LABEL_ONE, values);){
                if (ableToWrite) {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)nodes.hasNext());
                    Node node = (Node)nodes.next();
                    org.junit.jupiter.api.Assertions.assertNotNull((Object)node);
                    org.junit.jupiter.api.Assertions.assertEquals((long)expectedNodeId, (long)node.getId(), (String)"node id");
                } else {
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)nodes.hasNext());
                }
            }
            tx.commit();
        }
    }

    private void createIndex(String ... propKeys) {
        try (Transaction tx = this.db.beginTx();){
            IndexCreator indexCreator = tx.schema().indexFor(TestLabels.LABEL_ONE).withIndexType(IndexType.RANGE);
            for (String propKey : propKeys) {
                indexCreator = indexCreator.on(propKey);
            }
            indexCreator.create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private void startDb(int pageSize) {
        TestDatabaseManagementServiceBuilder builder = new TestDatabaseManagementServiceBuilder(this.neo4jLayout);
        this.scheduler = JobSchedulerFactory.createInitialisedScheduler();
        this.pageCache = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)this.fs, (JobScheduler)this.scheduler, (PageCacheTracer)PageCacheTracer.NULL, (MuninnPageCache.Configuration)MuninnPageCache.config((int)100).pageSize(pageSize));
        builder.setExternalDependencies((DependencyResolver)Dependencies.dependenciesOf((Object)this.pageCache));
        this.dbms = builder.build();
        this.db = (GraphDatabaseAPI)this.dbms.database("neo4j");
        this.includeVectorTypes = RandomValuesUtils.selectStorageEngineDependentConfiguration((GraphDatabaseService)this.db).includeVectorTypes();
    }

    private static enum NamedDynamicValueGenerator {
        string(1, 8164, (random, i) -> random.randomValues().nextAlphaNumericTextValue(i, i).stringValue()),
        byteArray(1, 8163, (random, i) -> random.randomValues().nextByteArrayRaw(i, i)),
        shortArray(2, 4081, (random, i) -> random.randomValues().nextShortArrayRaw(i, i)),
        intArray(4, 2040, (random, i) -> random.randomValues().nextIntArrayRaw(i, i)),
        longArray(8, 1020, (random, i) -> random.randomValues().nextLongArrayRaw(i, i)),
        floatArray(4, 2040, (random, i) -> random.randomValues().nextFloatArrayRaw(i, i)),
        doubleArray(8, 1020, (random, i) -> random.randomValues().nextDoubleArrayRaw(i, i)),
        booleanArray(1, 8164, (random, i) -> random.randomValues().nextBooleanArrayRaw(i, i)),
        charArray(1, 2721, (random, i) -> random.randomValues().nextAlphaNumericTextValue(i, i).stringValue().toCharArray()),
        stringArray1(3, 2721, (random, i) -> random.randomValues().nextAlphaNumericStringArrayRaw(i, i, 1, 1)),
        stringArray10(12, 680, (random, i) -> random.randomValues().nextAlphaNumericStringArrayRaw(i, i, 10, 10)),
        stringArray100(102, 80, (random, i) -> random.randomValues().nextAlphaNumericStringArrayRaw(i, i, 100, 100)),
        stringArray1000(1002, 8, (random, i) -> random.randomValues().nextAlphaNumericStringArrayRaw(i, i, 1000, 1000)),
        dateArray(8, 1020, (random, i) -> random.randomValues().nextDateArrayRaw(i, i)),
        timeArray(12, 680, (random, i) -> random.randomValues().nextTimeArrayRaw(i, i)),
        localTimeArray(8, 1020, (random, i) -> random.randomValues().nextLocalTimeArrayRaw(i, i)),
        dateTimeArray(16, 510, (random, i) -> random.randomValues().nextDateTimeArrayRaw(i, i)),
        localDateTimeArray(12, 680, (random, i) -> random.randomValues().nextLocalDateTimeArrayRaw(i, i)),
        durationArray(28, 291, (random, i) -> random.randomValues().nextDurationArrayRaw(i, i)),
        periodArray(28, 291, (random, i) -> random.randomValues().nextPeriodArrayRaw(i, i)),
        cartesianPointArray(8, 510, (random, i) -> random.randomValues().nextCartesianPointArray(i, i).asObjectCopy()),
        cartesian3DPointArray(8, 340, (random, i) -> random.randomValues().nextCartesian3DPointArray(i, i).asObjectCopy()),
        geographicPointArray(8, 510, (random, i) -> random.randomValues().nextGeographicPointArray(i, i).asObjectCopy()),
        geographic3DPointArray(8, 340, (random, i) -> random.randomValues().nextGeographic3DPointArray(i, i).asObjectCopy()),
        vectorInt16(Types.VECTOR_INT16.elementSize, 4081, (random, i) -> {
            int dim = Math.clamp((long)i, 1, 4096);
            return random.randomValues().nextInt16Vector(dim, dim);
        }, true),
        vectorInt32(Types.VECTOR_INT32.elementSize, 2040, (random, i) -> {
            int dim = Math.clamp((long)i, 1, 4096);
            return random.randomValues().nextInt32Vector(dim, dim);
        }, true),
        vectorInt64(Types.VECTOR_INT64.elementSize, 1020, (random, i) -> {
            int dim = Math.clamp((long)i, 1, 4096);
            return random.randomValues().nextInt64Vector(dim, dim);
        }, true),
        vectorFloat32(Types.VECTOR_FLOAT32.elementSize, 2040, (random, i) -> {
            int dim = Math.clamp((long)i, 1, 4096);
            return random.randomValues().nextFloat32Vector(dim, dim);
        }, true),
        vectorFloat64(Types.VECTOR_FLOAT64.elementSize, 1020, (random, i) -> {
            int dim = Math.clamp((long)i, 1, 4096);
            return random.randomValues().nextFloat64Vector(dim, dim);
        }, true);

        private final int singleArrayEntrySize;
        private final DynamicValueGenerator generator;
        private final int expectedMax;
        private final boolean isVectorType;

        private NamedDynamicValueGenerator(int singleArrayEntrySize, int expectedLongestArrayLength, DynamicValueGenerator generator) {
            this.singleArrayEntrySize = singleArrayEntrySize;
            this.expectedMax = expectedLongestArrayLength;
            this.generator = generator;
            this.isVectorType = false;
        }

        private NamedDynamicValueGenerator(int singleArrayEntrySize, int expectedLongestArrayLength, DynamicValueGenerator generator, boolean isVectorType) {
            this.singleArrayEntrySize = singleArrayEntrySize;
            this.expectedMax = expectedLongestArrayLength;
            this.generator = generator;
            this.isVectorType = isVectorType;
        }

        boolean isVectorType() {
            return this.isVectorType;
        }

        Object dynamicValue(RandomSupport random, int length) {
            return this.generator.dynamicValue(random, length);
        }

        Object dynamicValue(RandomSupport random, int keySizeLimit, int wiggleRoom) {
            int lowLimit = NamedDynamicValueGenerator.lowLimit(keySizeLimit, wiggleRoom, this.singleArrayEntrySize);
            int highLimit = NamedDynamicValueGenerator.highLimit(keySizeLimit, wiggleRoom, this.singleArrayEntrySize);
            return this.dynamicValue(random, random.intBetween(lowLimit, highLimit));
        }

        private static int lowLimit(int keySizeLimit, int wiggleRoom, int singleEntrySize) {
            return (keySizeLimit - wiggleRoom) / singleEntrySize;
        }

        private static int highLimit(int keySizeLimit, int wiggleRoom, int singleEntrySize) {
            return (keySizeLimit + wiggleRoom) / singleEntrySize;
        }

        @FunctionalInterface
        private static interface DynamicValueGenerator {
            public Object dynamicValue(RandomSupport var1, int var2);
        }
    }

    private static class BinarySearch {
        private int longestSuccessful;
        private int minArrayLength;
        private int maxArrayLength = 1;
        private int arrayLength = 1;
        private boolean foundMaxLimit;

        private BinarySearch() {
        }

        boolean finished() {
            return this.arrayLength == this.minArrayLength;
        }

        void progress(boolean wasAbleToWrite) {
            if (wasAbleToWrite) {
                this.longestSuccessful = Math.max(this.arrayLength, this.longestSuccessful);
                if (!this.foundMaxLimit) {
                    this.minArrayLength = this.arrayLength;
                    this.maxArrayLength *= 2;
                    this.arrayLength = this.maxArrayLength;
                } else {
                    this.minArrayLength = this.arrayLength;
                    this.arrayLength = (this.minArrayLength + this.maxArrayLength) / 2;
                }
            } else {
                this.foundMaxLimit = true;
                this.maxArrayLength = this.arrayLength;
                this.arrayLength = (this.minArrayLength + this.maxArrayLength) / 2;
            }
        }
    }

    private static class SuccessAndFail {
        boolean atLeastOneSuccess;
        boolean atLeastOneFail;

        private SuccessAndFail() {
        }

        void ableToWrite(boolean ableToWrite) {
            if (ableToWrite) {
                this.atLeastOneSuccess = true;
            } else {
                this.atLeastOneFail = true;
            }
        }

        void verifyBothSuccessAndFail() {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.atLeastOneSuccess, (String)"not a single successful write, need to adjust parameters");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.atLeastOneFail, (String)"not a single failed write, need to adjust parameters");
        }
    }
}

