/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
class AccidentalUniquenessConstraintViolationIT {
    private static final Label Foo = Label.label((String)"Foo");
    private static final String BAR = "bar";
    @Inject
    private GraphDatabaseService db;

    AccidentalUniquenessConstraintViolationIT() {
    }

    private static Stream<Arguments> parameters() {
        return Stream.of(Arguments.of((Object[])new Object[]{42, 41}), Arguments.of((Object[])new Object[]{"a", "b"}));
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void shouldApplyChangesWithIntermediateConstraintViolations(Object value1, Object value2) {
        String fourtyOneId;
        String fourtyTwoId;
        Node fourtyTwo;
        try (Transaction tx = this.db.beginTx();){
            tx.schema().constraintFor(Foo).assertPropertyIsUnique(BAR).create();
            tx.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            fourtyTwo = tx.createNode(new Label[]{Foo});
            fourtyTwo.setProperty(BAR, value1);
            fourtyTwoId = fourtyTwo.getElementId();
            Node fourtyOne = tx.createNode(new Label[]{Foo});
            fourtyOne.setProperty(BAR, value2);
            fourtyOneId = fourtyOne.getElementId();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.getNodeByElementId(fourtyOneId).delete();
            tx.getNodeByElementId(fourtyTwoId).setProperty(BAR, value2);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            fourtyTwo = tx.getNodeByElementId(fourtyTwoId);
            Assertions.assertEquals((Object)value2, (Object)fourtyTwo.getProperty(BAR));
            Assertions.assertThrows(NotFoundException.class, () -> tx.getNodeByElementId(fourtyOneId).getProperty(BAR));
            Assertions.assertEquals((Object)fourtyTwo, (Object)tx.findNode(Foo, BAR, value2));
            Assertions.assertNull((Object)tx.findNode(Foo, BAR, value1));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }
}

