/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.explicit;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.index.Neo4jTestCase;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class TestMigration {
    @Rule
    public final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();

    @Test
    public void providerGetsFilledInAutomatically() {
        Map correctConfig = MapUtil.stringMap((String[])new String[]{"type", "exact", "provider", "lucene"});
        File storeDir = this.testDirectory.graphDbDir();
        Neo4jTestCase.deleteFileOrDirectory(storeDir);
        GraphDatabaseService graphDb = this.startDatabase(storeDir);
        try (Transaction transaction = graphDb.beginTx();){
            Assert.assertEquals((Object)correctConfig, (Object)graphDb.index().getConfiguration(graphDb.index().forNodes("default")));
            Assert.assertEquals((Object)correctConfig, (Object)graphDb.index().getConfiguration(graphDb.index().forNodes("wo-provider", MapUtil.stringMap((String[])new String[]{"type", "exact"}))));
            Assert.assertEquals((Object)correctConfig, (Object)graphDb.index().getConfiguration(graphDb.index().forNodes("w-provider", MapUtil.stringMap((String[])new String[]{"type", "exact", "provider", "lucene"}))));
            Assert.assertEquals((Object)correctConfig, (Object)graphDb.index().getConfiguration((Index)graphDb.index().forRelationships("default")));
            Assert.assertEquals((Object)correctConfig, (Object)graphDb.index().getConfiguration((Index)graphDb.index().forRelationships("wo-provider", MapUtil.stringMap((String[])new String[]{"type", "exact"}))));
            Assert.assertEquals((Object)correctConfig, (Object)graphDb.index().getConfiguration((Index)graphDb.index().forRelationships("w-provider", MapUtil.stringMap((String[])new String[]{"type", "exact", "provider", "lucene"}))));
            transaction.success();
        }
        graphDb.shutdown();
        this.removeProvidersFromIndexDbFile(storeDir);
        graphDb = this.startDatabase(storeDir);
        var5_5 = null;
        try (Transaction ignored = graphDb.beginTx();){
            Assert.assertEquals((Object)correctConfig, (Object)graphDb.index().getConfiguration(graphDb.index().forNodes("default")));
            Assert.assertEquals((Object)correctConfig, (Object)graphDb.index().getConfiguration(graphDb.index().forNodes("wo-provider", MapUtil.stringMap((String[])new String[]{"type", "exact"}))));
            Assert.assertEquals((Object)correctConfig, (Object)graphDb.index().getConfiguration(graphDb.index().forNodes("w-provider", MapUtil.stringMap((String[])new String[]{"type", "exact", "provider", "lucene"}))));
            Assert.assertEquals((Object)correctConfig, (Object)graphDb.index().getConfiguration((Index)graphDb.index().forRelationships("default")));
            Assert.assertEquals((Object)correctConfig, (Object)graphDb.index().getConfiguration((Index)graphDb.index().forRelationships("wo-provider", MapUtil.stringMap((String[])new String[]{"type", "exact"}))));
            Assert.assertEquals((Object)correctConfig, (Object)graphDb.index().getConfiguration((Index)graphDb.index().forRelationships("w-provider", MapUtil.stringMap((String[])new String[]{"type", "exact", "provider", "lucene"}))));
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        graphDb.shutdown();
        this.removeProvidersFromIndexDbFile(storeDir);
        graphDb = this.startDatabase(storeDir);
        ignored = graphDb.beginTx();
        var5_5 = null;
        try {
            Assert.assertEquals((Object)correctConfig, (Object)graphDb.index().getConfiguration(graphDb.index().forNodes("default")));
            Assert.assertEquals((Object)correctConfig, (Object)graphDb.index().getConfiguration(graphDb.index().forNodes("wo-provider")));
            Assert.assertEquals((Object)correctConfig, (Object)graphDb.index().getConfiguration(graphDb.index().forNodes("w-provider")));
            Assert.assertEquals((Object)correctConfig, (Object)graphDb.index().getConfiguration((Index)graphDb.index().forRelationships("default")));
            Assert.assertEquals((Object)correctConfig, (Object)graphDb.index().getConfiguration((Index)graphDb.index().forRelationships("wo-provider")));
            Assert.assertEquals((Object)correctConfig, (Object)graphDb.index().getConfiguration((Index)graphDb.index().forRelationships("w-provider")));
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (ignored != null) {
                if (var5_5 != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    ignored.close();
                }
            }
        }
        graphDb.shutdown();
    }

    private GraphDatabaseService startDatabase(File storeDir) {
        return new TestGraphDatabaseFactory().newEmbeddedDatabase(storeDir);
    }

    private void removeProvidersFromIndexDbFile(File storeDir) {
        IndexConfigStore indexStore = new IndexConfigStore(storeDir, this.fileSystemRule.get());
        for (Class cls : new Class[]{Node.class, Relationship.class}) {
            for (String name : indexStore.getNames(cls)) {
                HashMap config = indexStore.get(cls, name);
                config = new HashMap(config);
                config.remove("provider");
                indexStore.set(Node.class, name, config);
            }
        }
    }
}

