/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.util.ArrayList;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

@RunWith(value=Parameterized.class)
public class AccidentalUniquenessConstraintViolationIT {
    private static final Label Foo = Label.label((String)"Foo");
    private static final String BAR = "bar";
    @Parameterized.Parameter
    public Object value1;
    @Parameterized.Parameter(value=1)
    public Object value2;
    @Rule
    public final DatabaseRule db = new ImpermanentDatabaseRule();

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        data.add(ArrayUtil.array((Object[])new Integer[]{42, 41}));
        data.add(ArrayUtil.array((Object[])new String[]{"a", "b"}));
        return data;
    }

    @Test
    public void shouldApplyChangesWithIntermediateConstraintViolations() throws Exception {
        Node fourtyOne;
        Node fourtyTwo;
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().constraintFor(Foo).assertPropertyIsUnique(BAR).create();
            tx.success();
        }
        try (Transaction tx = this.db.beginTx();){
            fourtyTwo = this.db.createNode(new Label[]{Foo});
            fourtyTwo.setProperty(BAR, this.value1);
            fourtyOne = this.db.createNode(new Label[]{Foo});
            fourtyOne.setProperty(BAR, this.value2);
            tx.success();
        }
        tx = this.db.beginTx();
        var4_7 = null;
        try {
            fourtyOne.delete();
            fourtyTwo.setProperty(BAR, this.value2);
            tx.success();
        }
        catch (Throwable throwable) {
            var4_7 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_7 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_7.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.db.beginTx();
        var4_7 = null;
        try {
            Assert.assertEquals((Object)this.value2, (Object)fourtyTwo.getProperty(BAR));
            try {
                fourtyOne.getProperty(BAR);
                Assert.fail((String)"Should be deleted");
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            tx.success();
            Assert.assertEquals((Object)fourtyTwo, (Object)this.db.findNode(Foo, BAR, this.value2));
            Assert.assertNull((Object)this.db.findNode(Foo, BAR, this.value1));
        }
        catch (Throwable throwable) {
            var4_7 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_7 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_7.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }
}

