/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;

public class IndexCreateIT
extends KernelIntegrationTest {
    private static final IndexCreator INDEX_CREATOR = (schemaWrite, descriptor, providerName) -> schemaWrite.indexCreate((SchemaDescriptor)descriptor, Optional.of(providerName), Optional.empty());
    private static final IndexCreator UNIQUE_CONSTRAINT_CREATOR = (schemaWrite, descriptor, providerName) -> schemaWrite.uniquePropertyConstraintCreate((SchemaDescriptor)descriptor, Optional.of(providerName));

    @Test
    public void shouldCreateIndexWithSpecificExistingProviderName() throws KernelException {
        this.shouldCreateWithSpecificExistingProviderName(INDEX_CREATOR);
    }

    @Test
    public void shouldCreateUniquePropertyConstraintWithSpecificExistingProviderName() throws KernelException {
        this.shouldCreateWithSpecificExistingProviderName(UNIQUE_CONSTRAINT_CREATOR);
    }

    @Test
    public void shouldFailCreateIndexWithNonExistentProviderName() throws KernelException {
        this.shouldFailWithNonExistentProviderName(INDEX_CREATOR);
    }

    @Test
    public void shouldFailCreateUniquePropertyConstraintWithNonExistentProviderName() throws KernelException {
        this.shouldFailWithNonExistentProviderName(UNIQUE_CONSTRAINT_CREATOR);
    }

    void shouldFailWithNonExistentProviderName(IndexCreator creator) throws KernelException {
        SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
        try {
            creator.create(schemaWrite, (LabelSchemaDescriptor)SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{0}), "something-completely-different");
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    void shouldCreateWithSpecificExistingProviderName(IndexCreator creator) throws KernelException {
        int labelId = 0;
        for (GraphDatabaseSettings.SchemaIndex indexSetting : GraphDatabaseSettings.SchemaIndex.values()) {
            SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
            String provider = indexSetting.providerName();
            org.neo4j.kernel.api.schema.LabelSchemaDescriptor descriptor = SchemaDescriptorFactory.forLabel((int)labelId++, (int[])new int[]{0});
            creator.create(schemaWrite, (LabelSchemaDescriptor)descriptor, provider);
            this.commit();
            Assert.assertEquals((Object)provider, (Object)this.indexingService.getIndexProxy((SchemaDescriptor)descriptor).getDescriptor().providerDescriptor().name());
        }
    }

    static interface IndexCreator {
        public void create(SchemaWrite var1, LabelSchemaDescriptor var2, String var3) throws SchemaKernelException;
    }
}

