/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.test.TestLabels;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.EmbeddedDatabaseRule;
import org.neo4j.test.rule.RandomRule;

public class NativeStringIndexingIT {
    private static final Label LABEL = TestLabels.LABEL_ONE;
    private static final String KEY = "key";
    private static final String KEY2 = "key2";
    @Rule
    public final DatabaseRule db = new EmbeddedDatabaseRule().withSetting(GraphDatabaseSettings.default_schema_provider, GraphDatabaseSettings.SchemaIndex.NATIVE20.providerName());
    @Rule
    public final RandomRule random = new RandomRule();

    @Test
    public void shouldHandleSizesCloseToTheLimit() {
        Node node;
        this.createIndex(KEY);
        HashMap<String, Long> strings = new HashMap<String, Long>();
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < 1000; ++i) {
                String string;
                while (strings.containsKey(string = this.random.nextAlphaNumericString(3000, 4000))) {
                }
                node = this.db.createNode(new Label[]{LABEL});
                node.setProperty(KEY, (Object)string);
                strings.put(string, node.getId());
            }
            tx.success();
        }
        tx = this.db.beginTx();
        var3_3 = null;
        try {
            for (String string : strings.keySet()) {
                node = this.db.findNode(LABEL, KEY, (Object)string);
                Assert.assertEquals((long)((Long)strings.get(string)), (long)node.getId());
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldFailBeforeCommitOnSizesLargerThanLimit() {
        this.createIndex(KEY);
        int length = 5000;
        try {
            try (Transaction tx = this.db.beginTx();){
                this.db.createNode(new Label[]{LABEL}).setProperty(KEY, (Object)this.random.nextAlphaNumericString(length, length));
                tx.success();
            }
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)("Property value bytes length: " + length + " is longer than")));
        }
    }

    @Test
    public void shouldHandleCompositeSizesCloseToTheLimit() throws KernelException {
        Node node;
        this.createIndex(KEY, KEY2);
        int length = 20000;
        String string1 = this.random.nextAlphaNumericString(length, length);
        String string2 = this.random.nextAlphaNumericString(length, length);
        try (Transaction tx = this.db.beginTx();){
            node = this.db.createNode(new Label[]{LABEL});
            node.setProperty(KEY, (Object)string1);
            node.setProperty(KEY2, (Object)string2);
            tx.success();
        }
        tx = this.db.beginTx();
        var6_5 = null;
        try {
            KernelTransaction ktx = ((ThreadToStatementContextBridge)this.db.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class)).getKernelTransactionBoundToThisThread(true);
            int labelId = ktx.tokenRead().nodeLabel(LABEL.name());
            int propertyKeyId1 = ktx.tokenRead().propertyKey(KEY);
            int propertyKeyId2 = ktx.tokenRead().propertyKey(KEY2);
            try (NodeValueIndexCursor cursor = ktx.cursors().allocateNodeValueIndexCursor();){
                ktx.dataRead().nodeIndexSeek((IndexReference)TestIndexDescriptorFactory.forLabel((int)labelId, (int[])new int[]{propertyKeyId1, propertyKeyId2}), cursor, IndexOrder.NONE, new IndexQuery[]{IndexQuery.exact((int)propertyKeyId1, (Object)string1), IndexQuery.exact((int)propertyKeyId2, (Object)string2)});
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertEquals((long)node.getId(), (long)cursor.nodeReference());
                Assert.assertFalse((boolean)cursor.next());
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var6_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var6_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var6_5.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldFailBeforeCommitOnCompositeSizesLargerThanLimit() {
        this.createIndex(KEY, KEY2);
        int length = 50000;
        try {
            try (Transaction tx = this.db.beginTx();){
                Node node = this.db.createNode(new Label[]{LABEL});
                node.setProperty(KEY, (Object)this.random.nextAlphaNumericString(length, length));
                node.setProperty(KEY2, (Object)this.random.nextAlphaNumericString(length, length));
                tx.success();
            }
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)("Property value bytes length: " + length + " is longer than")));
        }
    }

    private void createIndex(String ... keys) {
        try (Transaction tx = this.db.beginTx();){
            IndexCreator indexCreator = this.db.schema().indexFor(LABEL);
            for (String key : keys) {
                indexCreator = indexCreator.on(key);
            }
            indexCreator.create();
            tx.success();
        }
        tx = this.db.beginTx();
        var3_3 = null;
        try {
            this.db.schema().awaitIndexesOnline(10L, TimeUnit.SECONDS);
            tx.success();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }
}

